/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.misc.Debug;
import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class SHA
extends MessageDigestSpi
implements Cloneable {
    private static final int SHA_LENGTH = 20;
    private Hash sha;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.SHA";

    public SHA() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SHA");
        }
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "SHA");
        }
    }

    private SHA(SHA shaold) {
        this.sha = (Hash)shaold.sha.clone();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "SHA", (Object)this.sha);
            debug.exit(16384L, (Object)className, "SHA");
        }
    }

    public void init() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        this.sha = new Hash(544);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineReset");
        }
        this.sha.engineReset();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineReset");
        }
    }

    protected int engineGetDigestLength() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineGetDigestLength");
            debug.exit(16384L, (Object)className, "engineGetDigestLength");
        }
        return 20;
    }

    protected synchronized void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineUpdate", (Object)(" " + b));
        }
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        this.sha.engineUpdate(input, offset, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDigest");
        }
        byte[] result = this.sha.engineDigest();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return result;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineDigest", parms);
        }
        int resultLen = this.sha.engineDigest(buf, offset, len);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return resultLen;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "clone");
        }
        SHA that = null;
        try {
            that = (SHA)super.clone();
            that.sha = (Hash)this.sha.clone();
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone");
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "clone", (Throwable)e);
            }
            return that;
        }
    }
}

