/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.DSAPublicKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.RSAPublicKey;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;

final class Signature {
    private MessageDigest msgdig;
    private PKCS11Session session;
    private PKCS11Object keyObject;
    private boolean isSign;
    private int mechanism;
    private int modSize = 256;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Signature";

    protected Signature(int mechanism) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Signature", (Object)new Integer(mechanism));
        }
        this.mechanism = mechanism;
        this.session = IBMPKCS11Impl.session;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Signature");
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitSign", (Object)privateKey);
        }
        this.isSign = true;
        PrivateKey ppkey = privateKey;
        if (!(privateKey instanceof RSAPrivateKey) && !(privateKey instanceof DSAPrivateKey)) {
            if (privateKey instanceof java.security.interfaces.RSAPrivateKey || privateKey instanceof RSAPrivateCrtKey || privateKey instanceof java.security.interfaces.DSAPrivateKey) {
                KeyFactory kf = null;
                String alg = privateKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                        ppkey = (PKCS11PrivateKey)kf.translateKey(privateKey);
                    }
                    kf = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                    ppkey = (PKCS11PrivateKey)kf.translateKey(privateKey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitSign_1", (Throwable)new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitSign");
                    }
                    throw new InvalidKeyException("Cannot convert private key: " + privateKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitSign_2", (Throwable)new InvalidKeyException("not a PKCS11 DSA or PKCS11 RSA private key"));
                    debug.exit(16384L, (Object)className, "engineInitSign");
                }
                throw new InvalidKeyException("not a DSA or RSA private key: " + privateKey);
            }
        }
        if (ppkey instanceof RSAPrivateKey) {
            this.keyObject = ((RSAPrivateKey)ppkey).getObject();
            this.modSize = ((RSAPrivateKey)ppkey).getModulus().bitLength() / 8 + 10;
        }
        if (ppkey instanceof DSAPrivateKey) {
            this.keyObject = ((DSAPrivateKey)ppkey).getObject();
        }
        this.session.signInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitSign");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineInitVerify", (Object)publicKey);
        }
        this.isSign = false;
        PublicKey ppkey = publicKey;
        if (!(publicKey instanceof RSAPublicKey) && !(publicKey instanceof DSAPublicKey)) {
            if (publicKey instanceof java.security.interfaces.RSAPublicKey || publicKey instanceof java.security.interfaces.DSAPublicKey) {
                KeyFactory kf = null;
                String alg = publicKey.getAlgorithm();
                try {
                    if (alg.equalsIgnoreCase("DSA")) {
                        kf = KeyFactory.getInstance("DSA", "IBMPKCS11Impl");
                        ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                    }
                    kf = KeyFactory.getInstance("RSA", "IBMPKCS11Impl");
                    ppkey = (PKCS11PublicKey)kf.translateKey(publicKey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "engineInitVerify_1", (Throwable)new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage()));
                        debug.exit(16384L, (Object)className, "engineInitVerify");
                    }
                    throw new InvalidKeyException("Cannot convert public key: " + publicKey + " with reason: " + e.getMessage());
                }
            } else {
                if (debug != null) {
                    debug.exception(16384L, (Object)className, "engineInitVerify_2", (Throwable)new InvalidKeyException("not a DSA or RSA public key"));
                    debug.exit(16384L, (Object)className, "engineInitVerify");
                }
                throw new InvalidKeyException("not a DSA or RSA public key: " + publicKey);
            }
        }
        if (ppkey instanceof RSAPublicKey) {
            this.keyObject = ((RSAPublicKey)ppkey).getObject();
        }
        if (ppkey instanceof DSAPublicKey) {
            this.keyObject = ((DSAPublicKey)ppkey).getObject();
        }
        this.session.verifyInit(this.mechanism, null, this.keyObject);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineInitVerify");
        }
    }

    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len)};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (this.isSign) {
            this.session.signUpdate(data, off, len);
        } else {
            this.session.verifyUpdate(data, off, len);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign");
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = this.session.signFinal(outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return signature;
    }

    protected byte[] engineSign(byte[] data, int length) throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineSign", (Object)data, (Object)new Integer(length));
        }
        int size = 0;
        byte[] signature = null;
        byte[] outdata = new byte[this.modSize];
        size = this.session.sign(data, 0, length, outdata, 0);
        signature = new byte[size];
        System.arraycopy(outdata, 0, signature, 0, size);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineSign");
        }
        return signature;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineVerify", (Object)signature);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        try {
            result = this.session.verifyFinal(signature, 0, signature.length);
        }
        catch (PKCS11Exception e) {
            throw new SignatureException("PKCS11 Exception : " + e.getMessage());
        }
        return result;
    }

    protected boolean engineVerify(byte[] signature, byte[] data, int length) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            Object[] parms = new Object[]{signature, data, new Integer(length)};
            debug.entry(16384L, (Object)className, "engineVerify", parms);
            debug.exit(16384L, (Object)className, "engineVerify");
        }
        try {
            result = this.session.verify(data, 0, length, signature, 0, signature.length);
        }
        catch (PKCS11Exception e) {
            throw new SignatureException("PKCS11 Exception : " + e.getMessage());
        }
        return result;
    }
}

