/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.bf.util;

import com.ibm.faces.bf.util.HttpRequestRetrieverInterface;
import com.ibm.faces.bf.util.InvalidKeyException;
import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.Streamer;
import java.util.HashMap;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyNotFoundException;
import javax.servlet.http.HttpServletRequest;

public class ODCContextHelper {
    private static String emitterHashMapKey = "odcEmitterHashMap";
    private static String odcPageContextKey = "odcPageContext";

    public static BaseEmitter getEmitter(FacesContext facesContext, String string) throws InvalidKeyException {
        BaseEmitter baseEmitter = null;
        HashMap hashMap = ODCContextHelper.getEmitterHashmap(facesContext);
        Object v = hashMap.get(string);
        if (v == null) {
            throw new InvalidKeyException("No emitter found with key = " + string);
        }
        baseEmitter = (BaseEmitter)v;
        return baseEmitter;
    }

    public static void setEmitter(FacesContext facesContext, String string, BaseEmitter baseEmitter) {
        HashMap hashMap = ODCContextHelper.getEmitterHashmap(facesContext);
        hashMap.put(string, baseEmitter);
    }

    private static HashMap getEmitterHashmap(FacesContext facesContext) {
        HashMap hashMap = null;
        HttpServletRequest httpServletRequest = (HttpServletRequest)facesContext.getExternalContext().getRequest();
        Object object = httpServletRequest.getAttribute(emitterHashMapKey);
        if (object != null) {
            hashMap = (HashMap)object;
        } else {
            hashMap = new HashMap(10);
            httpServletRequest.setAttribute(emitterHashMapKey, hashMap);
        }
        return hashMap;
    }

    public static PageContext getODCPageContext(FacesContext facesContext) {
        Object object;
        HttpServletRequest httpServletRequest = null;
        String string = Config.getString(Config.PROP_REQUEST_CLASS);
        try {
            object = (HttpRequestRetrieverInterface)Class.forName(string).newInstance();
            httpServletRequest = object.getHttpServletRequest(facesContext);
        }
        catch (InstantiationException instantiationException) {
            Streamer.error.Header().println("Instantiation Exception while creating dynamic HttpRequestRetrieverInterface");
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            Streamer.error.Header().println("IllegalAccessException while creating dynamic HttpRequestRetrieverInterface");
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Streamer.error.Header().println("ClassNotFoundException while creating dynamic HttpRequestRetrieverInterface");
            classNotFoundException.printStackTrace();
        }
        object = (PageContext)httpServletRequest.getAttribute(odcPageContextKey);
        if (object != null) {
            return object;
        }
        PageContext pageContext = new PageContext();
        httpServletRequest.setAttribute(odcPageContextKey, (Object)pageContext);
        return pageContext;
    }

    public static Object getObjectByReference(String string, FacesContext facesContext) throws PropertyNotFoundException {
        Object object = FacesContext.getCurrentInstance().getApplication().createValueBinding("#{" + string + "}").getValue(facesContext);
        if (object == null) {
            throw new PropertyNotFoundException("The EL expression = " + string + " did not resolve to an object.");
        }
        return object;
    }
}

