/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.diff.DiffHandler;
import com.ibm.odcb.jrender.diff.DiffInfo;
import com.ibm.odcb.jrender.misc.Streamer;

public class BaseHandler
implements DiffHandler {
    public void handle(DiffInfo diffInfo) throws DiffException {
        switch (diffInfo.getCrud()) {
            case 'C': {
                this.handleCreate(diffInfo);
                break;
            }
            case 'U': {
                this.handleUpdate(diffInfo);
                break;
            }
            case 'D': {
                this.handleDelete(diffInfo);
                break;
            }
            case 'A': {
                this.handleAdd(diffInfo);
                break;
            }
            case 'R': {
                this.handleRemove(diffInfo);
            }
        }
    }

    protected void handleCreate(DiffInfo diffInfo) throws DiffException {
        Streamer.debug.Header().println("Default do-nothing handler invoked to create a " + diffInfo.getEClassName());
    }

    protected void handleUpdate(DiffInfo diffInfo) throws DiffException {
        Streamer.debug.Header().println("Default do-nothing handler invoked to update a " + diffInfo.getEClassName());
    }

    protected void handleDelete(DiffInfo diffInfo) throws DiffException {
        Streamer.debug.Header().println("Default do-nothing handler invoked to delete a " + diffInfo.getEClassName());
    }

    protected void handleAdd(DiffInfo diffInfo) throws DiffException {
        Streamer.debug.Header().println("Default do-nothing handler invoked to add a " + diffInfo.getEClassName());
    }

    protected void handleRemove(DiffInfo diffInfo) throws DiffException {
        Streamer.debug.Header().println("Default do-nothing handler invoked to remove a " + diffInfo.getEClassName());
    }

    public Object find(DiffInfo diffInfo) throws DiffException {
        return null;
    }

    public String getId(DiffInfo diffInfo, boolean bl) {
        return diffInfo.getEClassName() + ": BaseHandler";
    }
}

