/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.diff.DiffProcessorFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DiffProcessor {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public abstract DiffedObjectsLists handle(Object var1, String var2) throws DiffException;

    public static DiffedObjectsLists Import(Object object, String string, String string2) throws DiffException {
        DiffProcessor diffProcessor = DiffProcessorFactory.getInstance().getDiffProcessor(string2);
        return diffProcessor.handle(object, string);
    }

    public static DiffedObjectsLists getDiffedObjects(Map map) {
        DiffedObjectsLists diffedObjectsLists = new DiffedObjectsLists();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (string.startsWith("CLASS+CREATE==>")) {
                diffedObjectsLists.createdObjects.add(entry.getValue());
                continue;
            }
            if (!string.startsWith("CLASS+DELETE==>")) continue;
            diffedObjectsLists.deletedObjects.add(entry.getValue());
        }
        return diffedObjectsLists;
    }

    public static class DiffedObjectsLists {
        protected List createdObjects = new ArrayList();
        protected List deletedObjects = new ArrayList();

        public List getCreatedObjects() {
            return this.createdObjects;
        }

        public List getDeletedObjects() {
            return this.deletedObjects;
        }
    }
}

