/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff;

import com.ibm.odcb.jrender.diff.DiffProcessor;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DiffProcessorFactory {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static DiffProcessorFactory _Instance;
    protected static Object _Mutex;
    protected Map _DiffProcessors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiffProcessorFactory getInstance() {
        if (_Instance == null) {
            Object object = _Mutex;
            synchronized (object) {
                if (_Instance == null) {
                    _Instance = new DiffProcessorFactory(DiffProcessorFactory.GetDiffProcessors());
                }
            }
        }
        return _Instance;
    }

    public DiffProcessorFactory(Map map) {
        this._DiffProcessors = map;
    }

    protected DiffProcessor getDiffProcessor(String string, String string2) {
        return (DiffProcessor)this._DiffProcessors.get(EClassMap.MakeComplexName(string, string2));
    }

    protected DiffProcessor getDiffProcessor(String string) {
        return (DiffProcessor)this._DiffProcessors.get(string);
    }

    public static HashMap GetDiffProcessors() {
        Streamer.status.println().Header().println("Instanciating the DiffProcessors");
        HashMap<String, DiffProcessor> hashMap = new HashMap<String, DiffProcessor>(57);
        try {
            Iterator iterator = MediatorFactory.getInstance().getUniverse().getEPackageMapsIterator();
            while (iterator.hasNext()) {
                EPackageMap ePackageMap = (EPackageMap)iterator.next();
                EClassMap eClassMap = ePackageMap.getRootEClassMap();
                String string = null;
                DiffProcessor diffProcessor = null;
                String string2 = eClassMap.getClientEcoreName();
                string2 = string2.substring(0, string2.lastIndexOf("/")).replace('/', '.').replace('\\', '.');
                string = string2 + "." + ePackageMap.getName() + "_DiffProcessor";
                try {
                    diffProcessor = (DiffProcessor)ODCClassLoader.getClassInstance(string);
                }
                catch (Exception exception) {
                    Streamer.warning.Header().println("Cannot create an instance of the DiffProcessor '" + string + "'");
                    Streamer.error.Header().printStackTrace(exception);
                }
                Iterator iterator2 = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
                while (iterator2.hasNext()) {
                    EClassMap eClassMap2 = (EClassMap)iterator2.next();
                    String string3 = eClassMap2.getJavaComplexName();
                    Streamer.debug.Header().println("Adding a DiffProcessor '" + string + "' for Key '" + string3 + "'.");
                    hashMap.put(string3, diffProcessor);
                }
            }
        }
        catch (ExportException exportException) {
            Streamer.error.Header().println("Cannot get the EPackageMaps for this universe.");
            Streamer.error.Header().printStackTrace(exportException);
        }
        return hashMap;
    }

    static {
        _Mutex = new Object();
    }
}

