/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff;

import com.ibm.odcb.jrender.diff.BaseHandler;
import com.ibm.odcb.jrender.diff.DiffHandler;
import com.ibm.odcb.jrender.diff.DiffHelper;
import com.ibm.odcb.jrender.diff.DiffInfo;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreEList;

public class DiffTraverser {
    protected EObject diff;
    protected EObject current;
    protected EObject original;
    protected HashMap handlers = new HashMap(7);

    public DiffTraverser(String string, String string2) throws Exception {
        this.diff = (EObject)Mediator.getDiffDataObject(string, string2);
        if (this.diff == null) {
            throw new Exception("The Diff DataObject could not be obtained with the given parameters.  \nPlease validate your modelRootName and theDiffString and try again.");
        }
    }

    public DiffTraverser(EObject eObject) {
        this.diff = eObject;
    }

    public DiffTraverser(DataObject dataObject) {
        this.diff = (EObject)dataObject;
    }

    public void addHandler(String string, DiffHandler diffHandler) {
        this.handlers.put(string, diffHandler);
    }

    public DiffHandler getHandler(String string) {
        return (DiffHandler)this.handlers.get(string);
    }

    public void traverse() throws Exception {
        if (this.diff == null) {
            throw new Exception("Cannot process Diff.  The Diff EObject is null!");
        }
        this.current = (EObject)EMFHelper.getEFeatureValue(this.diff, "Current");
        this.original = (EObject)EMFHelper.getEFeatureValue(this.diff, "Original");
        if (this.current == null) {
            throw new Exception("Diff's 'Current' EFeature cannot be null!");
        }
        this.traverseCurrentDiff();
    }

    public void traverseCurrentDiff() throws Exception {
        EClass eClass = this.current.eClass();
        Iterator iterator = eClass.getEReferences().iterator();
        DiffInfo diffInfo = null;
        ArrayList arrayList = new ArrayList(7);
        while (iterator.hasNext()) {
            EReference eReference = (EReference)iterator.next();
            Object object = this.current.eGet((EStructuralFeature)eReference, true);
            if (object == null) continue;
            if (object instanceof EcoreEList) {
                this.handleEObjects((EcoreEList)object, diffInfo, arrayList, eReference.getName());
                continue;
            }
            if (!(object instanceof EObject)) continue;
            this.handleEObject((EObject)object, diffInfo, arrayList, eReference.getName());
        }
    }

    public void handleEObject(EObject eObject, DiffInfo diffInfo, ArrayList arrayList, String string) throws Exception {
        boolean bl;
        if (eObject == null) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<EObject>(7);
        }
        if (!(bl = arrayList.contains(eObject))) {
            arrayList.add(eObject);
            EClass eClass = eObject.eClass();
            char c = ((Character)EMFHelper.getEFeatureValue(eObject, "ODCstatus")).charValue();
            DiffHandler diffHandler = this.getHandler(eClass.getName());
            String string2 = (String)EMFHelper.getEFeatureValue(eObject, "ODCid");
            if (diffHandler == null) {
                Streamer.warning.Header().println("DiffHandler for '" + eClass.getName() + "' is NULL.  Using the default do-nothing handler instead.  If you made changes to '" + eClass.getName() + "'s' attributes they will not be saved!  If you have assigned handlers for it's references, those will be handled.");
                diffHandler = new BaseHandler();
            }
            EObject eObject2 = c == 'C' ? null : (c == 'D' ? eObject : DiffHelper.getOriginalEObjectByXmiId(this.diff, string2));
            if (c == 'U' && eObject2 == null) {
                throw new Exception("The Original EObject for '" + eClass.getName() + "' with xmi:id '" + string2 + "' IS NULL");
            }
            DiffInfo diffInfo2 = new DiffInfo(eClass.getName(), c, (DataObject)eObject, (DataObject)eObject2, diffInfo, string);
            diffHandler.handle(diffInfo2);
            diffInfo = diffInfo2;
            Iterator iterator = eClass.getEReferences().iterator();
            while (iterator.hasNext()) {
                EReference eReference = (EReference)iterator.next();
                Object object = eObject.eGet((EStructuralFeature)eReference, true);
                if (object == null) continue;
                if (object instanceof EcoreEList) {
                    this.handleEObjects((EcoreEList)object, diffInfo, arrayList, eReference.getName());
                    continue;
                }
                if (!(object instanceof EObject)) continue;
                this.handleEObject((EObject)object, diffInfo, arrayList, eReference.getName());
            }
        }
    }

    public void handleEObjects(EcoreEList ecoreEList, DiffInfo diffInfo, ArrayList arrayList, String string) throws Exception {
        Iterator iterator = ecoreEList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EcoreEList) {
                this.handleEObjects((EcoreEList)e, diffInfo, arrayList, string);
                continue;
            }
            if (!(e instanceof EObject)) continue;
            this.handleEObject((EObject)e, diffInfo, arrayList, string);
        }
    }

    public EObject getCurrent() {
        return this.current;
    }

    public EObject getDiff() {
        return this.diff;
    }

    public HashMap getHandlers() {
        return this.handlers;
    }

    public EObject getOriginal() {
        return this.original;
    }

    public void setHandlers(HashMap hashMap) {
        this.handlers = hashMap;
    }

    public void setCurrent(EObject eObject) {
        this.current = eObject;
    }

    public void setOriginal(EObject eObject) {
        this.original = eObject;
    }
}

