/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff.generators;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.TypesUtil;
import com.ibm.odcb.jrender.utilities.EMapGen;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class DiffHandlerGenerator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MARKER_CLASSUPDATE = "CLASS+UPDATE==>";
    public static final String MARKER_CLASSCREATE = "CLASS+CREATE==>";
    public static final String MARKER_CLASSDELETE = "CLASS+DELETE==>";
    public static final String MARKER_CLIENTSIGNATURE = "CLIENT+SIGNATURE==>";
    protected static final int MEDIATOR_DEBUG_MODE = Config.getInteger(Config.PROP_MEDIATOR_DEBUG_MODE);
    static /* synthetic */ Class class$java$util$Iterator;

    protected static final void GenWarning(Writer writer) {
        try {
            writer.write("//     *********************************************************\n");
            writer.write("//     ** THIS CODE IS GENERATED AND **MUST NOT** BE MODIFIED **\n");
            writer.write("//     *********************************************************\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected final void GenVersionHistory(Writer writer) {
        try {
            writer.write("\n");
            writer.write("\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("//\n");
            DiffHandlerGenerator.GenWarning(writer);
            writer.write("//\n");
            this.PrintVersionHistory(writer);
            writer.write("//\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("\n");
            writer.write("\n");
            DiffHandlerGenerator.GenWarning(writer);
            writer.write("\n");
            writer.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String getDiffHandlerClassName(EClassMap eClassMap) {
        return eClassMap.getEPackageName() + "_" + eClassMap.getExport() + "_DiffHandler";
    }

    public void gen(EClassMap eClassMap, EClassMap eClassMap2, String string, String string2) throws FileNotFoundException, DiffException, ExportException, ClassNotFoundException {
        String string3 = DiffHandlerGenerator.getDiffHandlerClassName(eClassMap2);
        String string4 = string + File.separator + string3 + ".java";
        Streamer.debug.Header().println("FileName =" + string4 + ", and ClassName =" + string3);
        File file = new File(string4);
        if (file.exists()) {
            file.delete();
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string4));
        this.GenVersionHistory(printWriter);
        printWriter.write("package " + string2 + ";\n" + "\n" + "import java.util.Map;\n" + "import java.util.List;\n" + "\n" + "import " + EMFHelper.DataObject_CLASS.getName() + ";\n" + "\n" + "import com.ibm.odcb.jrender.diff.DiffException;\n" + "import com.ibm.odcb.jrender.diff.DiffHandler;\n" + "import com.ibm.odcb.jrender.diff.DiffInfo;\n" + "import com.ibm.odcb.jrender.diff.DiffProcessor;\n" + "import com.ibm.odcb.jrender.mediators.Mediator;\n" + "import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;\n" + "import com.ibm.odcb.jrender.misc.EMFHelper;\n" + "import com.ibm.odcb.jrender.misc.Streamer;\n" + "\n");
        DiffHandlerGenerator.GenWarning(printWriter);
        printWriter.write("\npublic class " + string3 + " implements DiffHandler\n" + " {\n");
        String string5 = eClassMap.getBaseType().replace('$', '.');
        String string6 = eClassMap2.getBaseType().replace('$', '.');
        printWriter.write("   public " + string3 + "(Object Root, Map Env, EClassMap ECM, Mediator M)\n" + "    {\n" + "      _Root = Root;\n" + "      _Env  = Env ;\n" + "      _ECM  = ECM ;\n" + "      _M    = M   ;\n" + "    }\n" + "   protected Object    _Root;\n" + "   protected Mediator  _M   ;\n" + "   protected Map       _Env ;\n" + "   protected EClassMap _ECM ;\n" + "\n" + "\n" + "   public void handle(DiffInfo Diff) throws DiffException, Exception\n" + "    {\n");
        if (MEDIATOR_DEBUG_MODE == 1) {
            printWriter.write("      Streamer.debug.Header().println(this.getClass().getName()+\".handle().\");\n");
        }
        printWriter.write("      " + string6 + " ServerObject = (" + string6 + ") find(Diff);\n" + "      DataObject ClientObject = Diff.getCurrent();\n" + "      String ODCId = ClientObject.getString(\"ODCid\");\n" + "\n" + "      char CRUDFlag = Diff.getCrud();\n" + "      if (CRUDFlag == 'U')\n" + "       {\n" + "         if (ServerObject == null)  // this is an update, so we must find the stock object, otherwise, exception\n" + "          {\n" + "            throw new DiffException(\"Trying to update a '\"+EMFHelper.getEClassName(ClientObject)\n" + "                                   +\"' object we could not find: \"+getId(Diff, true));\n" + "          }\n" + "         if (_Env.get(\"" + MARKER_CLASSUPDATE + string6 + "#\"+ODCId) == null) // not already processed\n" + "          {\n" + "            EMFHelper.validateDataObject(ClientObject);\n" + "            copy(ClientObject, ServerObject, false);\n" + "            SynchOriginal(Diff);\n" + "            _Env.put(\"" + MARKER_CLASSUPDATE + string6 + "#\"+ODCId, ServerObject);\n" + "          }\n" + "        }\n" + "       else if (CRUDFlag == 'C')\n" + "        {\n" + "          // This is a creation, so we beter not have found that object, unless it has been\n" + "          // processed already\n" + DiffHandlerGenerator.OutputCreationCode(eClassMap2, eClassMap, "ServerObject", string6) + "        }\n" + "       else if (CRUDFlag == 'D')\n" + "        { // this is a deletion, so we better have found the object, or have processed it before already\n" + "          if (ServerObject == null || _Env.get(\"" + MARKER_CLASSDELETE + string6 + "#\"+ODCId) != null)\n" + "           {\n" + "             throw new DiffException(\"Trying to delete a '\"+EMFHelper.getEClassName(ClientObject)\n" + "                                    +\"' object we could not find: \"+getId(Diff, true));\n" + "           }\n" + "          _Env.put(\"" + MARKER_CLASSDELETE + string6 + "#\"+ODCId, ServerObject);\n" + "          CRUDFlag = 'R';\n" + "        }\n" + "\n" + "       if (CRUDFlag == 'A')\n" + "        { // this is an Add operation\n" + "          AddRemove(Diff, ServerObject, true);\n" + "        }\n" + "       else if (CRUDFlag == 'R')\n" + "        { // this is a Remove operation\n" + "          AddRemove(Diff, ServerObject, false);\n" + "        }\n" + "    }\n" + "\n" + "\n" + "   public Object find(DiffInfo Diff)\n" + "   throws DiffException, Exception\n" + "    {\n");
        if (eClassMap.getJavaComplexName().equals(eClassMap2.getJavaComplexName())) {
            printWriter.write("     return _Root;\n");
        } else {
            printWriter.write("      // Compute the signature for the client object\n      String ClientObjectSignature;\n      if (Diff.getOriginal() == null)\n       {\n         if (Diff.getCrud() == 'U')\n          {\n            throw new DiffException(\"CURRENT Object '\"+EMFHelper.getEClassName(Diff.getCurrent())\n                                   +\" : \"+getId(Diff, false)+\"' does not have a matching ORIGINAL object. This is expected for Updates.\");\n          }\n         ClientObjectSignature = getClientSignature(Diff.getCurrent());\n       }\n      else\n       {\n         ClientObjectSignature = getClientSignature(Diff.getOriginal());\n       }\n      // A common pattern is to add the same object to multiple places, or add\n      // multiple objects to the same parent. So caching objects on signatures is\n      // important. We check if the object has already been found before.\n      " + string6 + " ServerObject = (" + string6 + ") _Env.get(\"" + MARKER_CLIENTSIGNATURE + "\"+ClientObjectSignature);\n" + "      if (ServerObject != null)\n" + "       return ServerObject;\n" + "      // At this point, we are facing a new object, so we need to search for it. Let's get the parent\n" + "      // object, find the DiffHandler for its class, and call the find method on it.\n" + DiffHandlerGenerator.OutputParentFinderCode("      ", "Object", eClassMap2, eClassMap, true));
            if (MEDIATOR_DEBUG_MODE == 1) {
                printWriter.write("      Streamer.debug.Header().println(\"Searching for object with signature '\"+ClientObjectSignature+\"'.\");\n");
            }
            printWriter.write(DiffHandlerGenerator.OutputFindCode(eClassMap2, "ServerObject", string6) + "      if (ServerObject != null)\n" + "       {\n");
            if (MEDIATOR_DEBUG_MODE == 1) {
                printWriter.write("      Streamer.debug.Header().println(\"        Found object with signature '\"+ClientObjectSignature+\"'.\");\n");
            }
            printWriter.write("         _Env.put(\"CLIENT+SIGNATURE==>\"+ClientObjectSignature, ServerObject);\n       }\n      return ServerObject;\n");
        }
        printWriter.write("    }\n\n\n   public static void copy(DataObject ClientObject, " + string6 + " ServerObject, boolean Create)\n" + "    throws DiffException, Exception\n" + "     {\n" + DiffHandlerGenerator.OutputSetters(eClassMap2) + "     }\n" + "\n" + "\n" + "   // After synching the server object, we need to synch the Original object in the Diff. Why? The server copy has been updated.\n" + "   // If this object is part of the primary key for another object in the Diff, then suddenly, the Original copy will have outdated\n" + "   // values. So we need to make sure that Original and Server objects are always equivalent\n" + "   public void SynchOriginal(DiffInfo Diff)\n" + "    throws DiffException\n" + "     {\n" + "       DataObject Current  = Diff.getCurrent ();\n" + "       DataObject Original = Diff.getOriginal();\n" + DiffHandlerGenerator.OutputSynch(eClassMap2) + "     }\n" + "\n" + "\n" + "   public String getClientSignature(DataObject Obj)\n" + "    {\n" + "      if (Obj == null) return \"\";\n" + "      if (EMFHelper.getEClassName(Obj).equals(\"" + eClassMap2.getExport() + "\") == false)\n" + "          {\n" + "            Streamer.error.Header().println(\"DiffHandler.getSignature for '" + eClassMap2.getEClass().getName() + "' called for DataObject of type '\"+EMFHelper.getEClassName(Obj)+\"'\")\n" + "                                   .println(\"Please make sure that the ecore and emap are defined correctly.\"); \n" + "          }\n" + "      StringBuffer SigStr = new StringBuffer();\n" + "      _ECM.getKeySignature(SigStr, Obj, 0, null);\n" + "      return \"CLIENT_MODEL`" + eClassMap2.getJavaComplexName() + "\"+SigStr.toString();\n" + "    }\n" + "\n" + "   public String getSignature(Object ServerObject)\n" + "    {\n" + "      return _M.getSignature(ServerObject, \"CLIENT_MODEL\", true, 0);\n" + "    }\n" + "\n" + "   public String getId(DiffInfo Diff, boolean Original)\n" + "    {\n" + "      StringBuffer Str = new StringBuffer();\n" + "      Str.append(Diff.getEClassName()).append(\": \");\n" + "      DataObject ClientObject = Original ? Diff.getOriginal() : Diff.getCurrent();\n" + "      if (ClientObject == null)\n" + "       {\n" + "         Str.append(\"null\");\n" + "       }\n" + "      else\n" + "       {\n" + DiffHandlerGenerator.OutputGetIdCode("         ", eClassMap2) + "       }\n" + "      return Str.toString();\n" + "    }\n" + "\n" + "   public void AddRemove(DiffInfo Diff, " + string6 + " ServerObject, boolean Add)\n" + "   throws DiffException, Exception\n" + "    {\n" + DiffHandlerGenerator.OutputParentFinderCode("      ", "Object", eClassMap2, eClassMap, false) + DiffHandlerGenerator.OutputAddRemoveCode(eClassMap2) + "    }\n" + " }\n");
        printWriter.close();
    }

    public static String OutputCreationCode(EClassMap eClassMap, EClassMap eClassMap2, String string, String string2) throws DiffException {
        String string3 = "";
        if (!TypesUtil.isInstantiable(eClassMap.getBaseTypeClass()) && eClassMap.getBaseTypeClass() != EMFHelper.DataObject_CLASS) {
            string3 = string3 + "          throw new DiffException(\"Cannot create a new instance of a non concrete class '" + eClassMap.getBaseTypeClass().getName() + "'.\");\n";
        } else {
            string3 = "          if (ServerObject != null && _Env.get(\"CLASS+CREATE==>" + string2 + "#\"+ODCId) == null)\n" + "           {\n" + "             throw new DiffException(\"Trying to create a new '\"+EMFHelper.getEClassName(ClientObject)\n" + "                                    +\"' object, but it already exists: \"+getId(Diff, true));\n" + "           }\n";
            if (eClassMap.getBaseTypeClass() == EMFHelper.DataObject_CLASS) {
                Object object;
                Object object2;
                Iterator iterator = eClassMap.getUniverse().getEClassMapsIterator();
                boolean bl = false;
                boolean bl2 = false;
                block0: while (iterator.hasNext() && !bl) {
                    object2 = (EClassMap)iterator.next();
                    object = ((EClassMap)object2).getEFeatureMapIterator();
                    while (object.hasNext() && !bl && !eClassMap2.getECoreComplexName().equals(((EClassMap)object2).getECoreComplexName())) {
                        EFeatureMap eFeatureMap = (EFeatureMap)object.next();
                        if (eFeatureMap.getReferenceMap() == null || !eFeatureMap.getReferenceMap().getEPackageName().equals(eClassMap.getEPackageName()) || !eFeatureMap.getReferenceMap().getECoreComplexName().equals(eClassMap.getECoreComplexName()) || !eFeatureMap.isContainment()) continue;
                        bl = true;
                        continue block0;
                    }
                }
                if (!bl) {
                    object2 = eClassMap2.getEFeatureMapIterator();
                    while (object2.hasNext() && !bl) {
                        object = (EFeatureMap)object2.next();
                        if (((EFeatureMap)object).getReferenceMap() == null || !((EFeatureMap)object).getReferenceMap().getEPackageName().equals(eClassMap.getEPackageName()) || !((EFeatureMap)object).getReferenceMap().getECoreComplexName().equals(eClassMap.getECoreComplexName()) || !((EFeatureMap)object).isContainment()) continue;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    string3 = string3 + "          //'Create' is not possible for this object as there is no containing parent or root reference\n          throw new DiffException(\"Could not find suitable parent for new object. There must exist a containing parent or root reference.\");\n";
                    return string3;
                }
                string3 = string3 + DiffHandlerGenerator.OutputParentFinderCode("          ", "DataObject", eClassMap, eClassMap2, false);
                string3 = bl2 ? string3 + "          //Create new project as child of root; Either parent is root or root is container\n          " + string + " = ((DataObject)_Root).createDataObject(_ECM.getEClassName());\n" : string3 + "          //Create new project as child of parent; Parent is container          " + string + " = ParentServerObject.createDataObject(Diff.getPropertyName());\n";
            } else {
                string3 = string3 + "          " + string + " = new " + string2 + "();\n";
            }
            string3 = string3 + "          EMFHelper.validateDataObject(ClientObject);\n          copy(ClientObject, ServerObject, true);\n          _Env.put(\"CLASS+CREATE==>" + string2 + "#\"+ODCId, ServerObject);\n" + "          CRUDFlag = 'A';\n";
        }
        return string3;
    }

    public static String OutputSetters(EClassMap eClassMap) throws DiffException, ClassNotFoundException {
        Iterator iterator = eClassMap.getEFeatureMapIterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
            if (eFeatureMap.getSetter() == null) continue;
            String string = EMapGen.FindProperty(eFeatureMap.getEFeature(), EMFHelper.DataObject_CLASS, null, true);
            string = "ClientObject." + EFeatureMap.CleanupGetterSetter(string);
            if (eFeatureMap.isReference()) continue;
            if (eFeatureMap.isMany()) {
                if (TypesUtil.isArrayOfBasicJavaType(eFeatureMap.getGetterType(), true)) {
                    string = "com.ibm.odcb.jrender.misc.ListUtil.to_" + TypesUtil.getShortJavaTypeFromArrayType(eFeatureMap.getGetterType()) + "Array(" + string + ")";
                } else if (TypesUtil.isArrayOfBasicJavaType(eFeatureMap.getGetterType(), false)) {
                    string = "(" + TypesUtil.getShortJavaTypeFromArrayType(eFeatureMap.getGetterType()) + "[])" + string + ".toArray()";
                } else if (!TypesUtil.isGeneralListNoArrays(eFeatureMap.getGetterType())) {
                    String string2 = "Unexpected type '" + eFeatureMap.getGetterType() + "' for property '" + eFeatureMap.getParentMapping().getEClassName() + "." + eFeatureMap.getEFeatureName() + "'. Expected a general list of basic Java type (int, Boolean, String...).";
                    Streamer.error.Header().println(string2);
                    throw new DiffException(string2);
                }
            } else if (!TypesUtil.isPrimitiveJavaType(eFeatureMap.getGetterType())) {
                string = "(" + eFeatureMap.getGetterType() + ")" + "ClientObject.get(\"" + eFeatureMap.getEFeatureName() + "\")";
            }
            if (TypesUtil.isPrimitiveJavaType(eFeatureMap.getGetterType()) && eFeatureMap.getGetterType() == Boolean.TYPE.getName()) {
                stringBuffer.append(eFeatureMap.isID() ? "  // Primary attribute\n" : "\n").append("       ").append("ServerObject.").append(eFeatureMap.MergeSetterCode(string)).append(";\n");
                continue;
            }
            stringBuffer.append("       if (ClientObject.isSet(\"" + eFeatureMap.getEFeatureName() + "\") == true)").append(eFeatureMap.isID() ? "  // Primary attribute\n" : "\n").append("        ").append("ServerObject.").append(eFeatureMap.MergeSetterCode(string)).append(";\n");
        }
        return stringBuffer.toString();
    }

    public static String OutputSynch(EClassMap eClassMap) {
        Iterator iterator = eClassMap.getEFeatureMapIterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
            if (eFeatureMap.getSetter() == null || eFeatureMap.isReference() || !eFeatureMap.isID()) continue;
            stringBuffer.append("       if (Current.isSet(\"" + eFeatureMap.getEFeatureName() + "\") == true)\n").append("        ").append("Original.set(\"" + eFeatureMap.getEFeatureName() + "\", Current.get(\"" + eFeatureMap.getEFeatureName() + "\"));\n");
        }
        return stringBuffer.toString();
    }

    public void PrintVersionHistory(Writer writer) throws IOException {
        writer.write("//  JWL 1.1.1, Auto-generated DiffHandlers");
    }

    public static String OutputFindCode(EClassMap eClassMap, String string, String string2) throws ClassNotFoundException, DiffException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = eClassMap.getUniverse().getEClassMapsIterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            EClassMap eClassMap2 = (EClassMap)iterator.next();
            Iterator iterator2 = eClassMap2.getEFeatureMapIterator();
            boolean bl2 = false;
            boolean bl3 = true;
            while (iterator2.hasNext()) {
                String string3;
                EFeatureMap eFeatureMap = (EFeatureMap)iterator2.next();
                if (eFeatureMap.getReferenceMap() == null || !eFeatureMap.getReferenceMap().getEPackageName().equals(eClassMap.getEPackageName()) || !eFeatureMap.getReferenceMap().getECoreComplexName().equals(eClassMap.getECoreComplexName())) continue;
                if (!bl2) {
                    string3 = eClassMap2.getBaseType().replace('$', '.');
                    stringBuffer.append(bl ? "      " : "      else\n").append("if (EMFHelper.getEClassName(ParentClientObject).equals(\"").append(eFeatureMap.getParentMapping().getExport()).append("\") == true)\n").append("       {\n").append("         ").append(string3).append(" PSO = (").append(string3).append(") ParentServerObject;\n");
                }
                stringBuffer.append(bl3 ? "         " : "         else ").append("if (Diff.getPropertyName().equals(\"").append(eFeatureMap.getEFeatureName()).append("\") == true)\n").append("          {\n");
                if (!eFeatureMap.isMany()) {
                    stringBuffer.append("            if (ClientObjectSignature.equals(getSignature(PSO.").append(EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter())).append(")) == true)\n").append("             ServerObject = (" + string2 + ")PSO.").append(EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter())).append(";\n");
                } else {
                    string3 = eFeatureMap.getGetterType();
                    if (TypesUtil.isArray(string3)) {
                        stringBuffer.append("            ").append(string2).append("[] SOs = (").append(string2).append("[]) PSO.").append(EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter())).append(";\n").append("            for (int i = 0; i < SOs.length; ++i)\n").append("             {\n").append("               " + string2 + " SO = SOs[i];\n").append("               Sig = getSignature(SO);\n");
                        if (MEDIATOR_DEBUG_MODE == 1) {
                            stringBuffer.append("               Streamer.debug.Header().println(\"     Checking object with signature '\"+Sig+\"'.\");\n");
                        }
                        stringBuffer.append("               if (ClientObjectSignature.equals(Sig) == true)\n").append("                {\n").append("                  ServerObject = SO;\n").append("                  break;\n").append("                }\n").append("             }\n");
                    } else if (TypesUtil.isGeneralListNoArrays(string3)) {
                        stringBuffer.append("            java.util.Iterator I = PSO.").append(EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter()));
                        if (!string3.equals((class$java$util$Iterator == null ? DiffHandlerGenerator.class$("java.util.Iterator") : class$java$util$Iterator).getName())) {
                            stringBuffer.append(".iterator()");
                        }
                        stringBuffer.append(";\n").append("            while (I.hasNext() == true)\n").append("             {\n").append("               " + string2 + " SO = (" + string2 + ") I.next();\n").append("               Sig = getSignature(SO);\n");
                        if (MEDIATOR_DEBUG_MODE == 1) {
                            stringBuffer.append("               Streamer.debug.Header().println(\"     Checking object with signature '\"+Sig+\"'.\");");
                        }
                        stringBuffer.append("               if (ClientObjectSignature.equals(Sig) == true)\n").append("                ServerObject = SO;\n").append("             }\n");
                    } else {
                        String string4 = "The Reference '" + eFeatureMap.getParentMapping().getEClassName() + "." + eFeatureMap.getEFeatureName() + "' of type '" + eFeatureMap.getGetterType() + "' is neither an array of a supported collection (Collection, List, Iterator).";
                        Streamer.error.Header().println(string4);
                        throw new DiffException(string4);
                    }
                }
                stringBuffer.append("          }\n");
                bl = false;
                bl3 = false;
                bl2 = true;
            }
            if (!bl2) continue;
            stringBuffer.append("       } // EClassName == " + eClassMap.getExport() + "\n");
        }
        return stringBuffer.toString();
    }

    public static String OutputParentFinderCode(String string, String string2, EClassMap eClassMap, EClassMap eClassMap2, boolean bl) {
        String string3 = string + string2 + " ParentServerObject = null;\n" + string + "String Sig = null;\n" + string + "DataObject ParentClientObject = null;\n" + string + "if (ParentDiff == null)\n" + string + "{\n";
        string3 = bl ? (eClassMap.getBaseType().equals(EMFHelper.DataObject_CLASS.getName()) ? string3 + string + "  if ((((org.eclipse.emf.ecore.EObject)_Root).eClass().getEPackage().getName()+\"_\"+EMFHelper.getEClassName((" + EMFHelper.DataObject_CLASS.getName() + ")_Root)).equals(\"" + eClassMap.getExport() + "\"))\n" + string + "  {\n" + string + "    Sig = getSignature(_Root);\n" + string + "    if (ClientObjectSignature.equals(Sig))\n" + string + "\t    return _Root;\n" + string + "    else\n" + string + "      return null;\n" + string + "  }\n" + string + "  else\n" + string + "    throw new DiffException(\"Could not match the runtime root type '\"+EMFHelper.getEClassName((" + EMFHelper.DataObject_CLASS.getName() + ")_Root)+\"' with the expected type '" + eClassMap.getExport() + "'\");\n" : string3 + string + "  if (_Root instanceof " + eClassMap.getBaseType().replace('$', '.') + ")\n" + string + "  {\n" + string + "    Sig = getSignature(_Root);\n" + string + "    if (ClientObjectSignature.equals(Sig))\n" + string + "\t    return _Root;\n" + string + "    else\n" + string + "      return null;\n" + string + "  }\n" + string + "  else\n" + string + "    throw new DiffException(\"Could not match the runtime root type '\"+_Root.getClass().getName()+\"' with the expected type '" + eClassMap.getBaseType() + "'\");\n") : string3 + string + "  throw new DiffException(\"Trying to create/add a root Object which is not supported\");\n";
        string3 = string3 + string + "}\n" + string + "else\n" + string + "{\n";
        String string4 = string + "DiffInfo ParentDiff = Diff.getParent();\n" + string3 + string + "  ParentClientObject = ParentDiff.getCurrent();\n" + string + "  DiffHandler DH = (DiffHandler) _Env.get(\"" + "DIFF+HANDLER==>" + "\"+ParentDiff.getEClassName());\n" + string + "  if (DH == null)\n" + string + "   {\n" + string + "     throw new DiffException(\"Cannot locate the DiffHandler for client EClass '\"+ParentDiff.getEClassName()+\"'.\");\n" + string + "   }\n" + string + "  ParentServerObject = (" + string2 + ") DH.find(ParentDiff);\n" + string + "  if (ParentServerObject == null)\n" + string + "   {\n" + string + "     throw new DiffException(\"Cannot find the parent server object '\"+DH.getId(ParentDiff, true)+\"' for '\"+getId(Diff, true)+\"'.\");\n" + string + "   }\n" + string + "}\n";
        return string4;
    }

    public static String OutputAddRemoveCode(EClassMap eClassMap) throws DiffException, ClassNotFoundException {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = eClassMap.getUniverse().getEClassMapsIterator();
        boolean bl = true;
        stringBuffer.append("      String ParentClientObjectEClassName = EMFHelper.getEClassName(ParentClientObject);\n").append("      String PropertyName = Diff.getPropertyName();\n");
        while (iterator.hasNext()) {
            EClassMap eClassMap2 = (EClassMap)iterator.next();
            Iterator iterator2 = eClassMap2.getEFeatureMapIterator();
            boolean bl2 = false;
            boolean bl3 = true;
            while (iterator2.hasNext()) {
                String string;
                EFeatureMap eFeatureMap = (EFeatureMap)iterator2.next();
                if (eFeatureMap.getReferenceMap() == null || !eFeatureMap.getReferenceMap().getECoreComplexName().equals(eClassMap.getECoreComplexName()) || eFeatureMap.getSetter() == null) continue;
                if (!bl2) {
                    string = eClassMap2.getBaseType().replace('$', '.');
                    stringBuffer.append(bl ? "      " : "      else ").append("if (ParentClientObjectEClassName.equals(\"").append(eFeatureMap.getParentMapping().getExport()).append("\") == true)\n").append("       {\n").append("         ").append(string).append(" PSO = (").append(string).append(") ParentServerObject;\n");
                }
                stringBuffer.append(bl3 ? "         " : "         else ").append("if (PropertyName.equals(\"").append(eFeatureMap.getEFeatureName()).append("\") == true)\n").append("          {\n");
                if (!eFeatureMap.isMany()) {
                    stringBuffer.append("            if (Add == true)\n").append("             PSO.").append(eFeatureMap.MergeSetterCode("ServerObject")).append(";\n").append("            else\n").append("             PSO.").append(eFeatureMap.MergeSetterCode("null")).append(";\n");
                } else {
                    string = eFeatureMap.getGetterType();
                    if (TypesUtil.isArray(string)) {
                        stringBuffer.append("            " + TypesUtil.getComplexJavaTypeFromArrayType(eFeatureMap.getGetterType()) + "\n").append("                Old = PSO." + EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter()) + ",\n").append("                New = new " + TypesUtil.getBaseJavaTypeFromArrayType(eFeatureMap.getGetterType()) + "[Old.length+(Add==true?1:-1)];\n").append("            int j = 0;\n").append("            for (int i = 0; i < Old.length; ++i)\n").append("             {\n").append("               " + eClassMap.getBaseType() + " O = Old[i];\n").append("               if (Add == true || ServerObject != O)\n").append("                {\n").append("                  New[j] = O;\n").append("                  ++j;\n").append("                }\n").append("             }\n").append("            if (Add == true)\n").append("             New[j] = ServerObject;\n").append("            PSO.").append(eFeatureMap.MergeSetterCode("New")).append(";\n");
                    } else if (string.equals((class$java$util$Iterator == null ? DiffHandlerGenerator.class$("java.util.Iterator") : class$java$util$Iterator).getName())) {
                        stringBuffer.append("            List L = com.ibm.odcb.jrender.misc.ListUtil.toList(PSO." + EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter()) + ");\n").append("            if (Add == true)\n").append("             L.add(ServerObject);\n").append("            else\n").append("             L.remove(ServerObject);\n").append("            PSO.").append(eFeatureMap.MergeSetterCode("L.iterator()")).append(";\n");
                    } else if (TypesUtil.isGeneralListNoArrays(string)) {
                        stringBuffer.append("            " + string + " L = PSO." + EFeatureMap.CleanupGetterSetter(eFeatureMap.getGetter()) + ";\n").append("            if (Add == true)\n").append("             L.add(ServerObject);\n").append("            else\n");
                        if (eClassMap.getBaseTypeClass() != EMFHelper.DataObject_CLASS) {
                            stringBuffer.append("             L.remove(ServerObject);\n").append("            PSO.").append(eFeatureMap.MergeSetterCode("L")).append(";\n");
                        } else {
                            stringBuffer.append("\t\t\tServerObject.delete();\n");
                        }
                    } else {
                        String string2 = "The Reference '" + eFeatureMap.getParentMapping().getEClassName() + "." + eFeatureMap.getEFeatureName() + "' of type '" + eFeatureMap.getGetterType() + "' is neither an array of a supported collection (Collection, List, Iterator).";
                        Streamer.error.Header().println(string2);
                        throw new DiffException(string2);
                    }
                }
                stringBuffer.append("          }\n");
                bl = false;
                bl3 = false;
                bl2 = true;
            }
            if (!bl2) continue;
            stringBuffer.append("       } // EClassName == " + eClassMap.getExport() + "\n");
        }
        if (!bl) {
            stringBuffer.append("      else\n").append("       {\n").append("         throw new DiffException(\"Failed adding/removing an object '" + eClassMap.getEClassName() + "' to/from '\"+ParentClientObjectEClassName+\".\"+PropertyName+\"': the parent class or property do not exist.\");\n").append("       }\n");
        }
        return stringBuffer.toString();
    }

    public static String OutputGetIdCode(String string, EClassMap eClassMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = eClassMap.getEFeatureMapIterator();
        while (iterator.hasNext()) {
            EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
            if (!eFeatureMap.isID() || eFeatureMap.isReference() || eFeatureMap.isMany()) continue;
            stringBuffer.append(string).append("Str.append(\"" + eFeatureMap.getEFeatureName() + "\").append(\"=\").append(ClientObject.get(\"" + eFeatureMap.getEFeatureName() + "\")).append(\";\");\n");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

