/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.diff.generators;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.diff.generators.DiffHandlerGenerator;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class DiffProcessorGenerator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MARKER_DIFFHANDLER = "DIFF+HANDLER==>";

    protected static final void GenWarning(Writer writer) {
        try {
            writer.write("//     *********************************************************\n");
            writer.write("//     ** THIS CODE IS GENERATED AND **MUST NOT** BE MODIFIED **\n");
            writer.write("//     *********************************************************\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected final void GenVersionHistory(Writer writer) {
        try {
            writer.write("\n");
            writer.write("\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("//\n");
            DiffProcessorGenerator.GenWarning(writer);
            writer.write("//\n");
            this.PrintVersionHistory(writer);
            writer.write("//\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("////////////////////////////////////////////////////////////////////////////////////////////////////\n");
            writer.write("\n");
            writer.write("\n");
            DiffProcessorGenerator.GenWarning(writer);
            writer.write("\n");
            writer.write("\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void gen(EPackageMap ePackageMap, String string, String string2) throws FileNotFoundException, DiffException, ExportException {
        String string3 = ePackageMap.getName() + "_DiffProcessor";
        String string4 = string + File.separator + string3 + ".java";
        Streamer.debug.Header().println("FileName =" + string4 + ", and ClassName =" + string3);
        File file = new File(string4);
        if (file.exists()) {
            file.delete();
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string4));
        this.GenVersionHistory(printWriter);
        printWriter.write("package " + string2 + ";\n" + "\n" + "import java.util.HashMap;\n" + "import java.util.Map;\n" + "import java.util.List;\n" + "\n" + "import com.ibm.odcb.jrender.diff.DiffProcessor;\n" + "import com.ibm.odcb.jrender.diff.DiffException;\n" + "import com.ibm.odcb.jrender.diff.DiffHandler;\n" + "import com.ibm.odcb.jrender.diff.DiffTraverser;\n" + "import com.ibm.odcb.jrender.mediators.ExportException;\n" + "import com.ibm.odcb.jrender.mediators.Mediator;\n" + "import com.ibm.odcb.jrender.mediators.MediatorFactory;\n" + "import com.ibm.odcb.jrender.mediators.gen.generators.Object_to_WDO4JS_as_JS_compact;\n" + "import com.ibm.odcb.jrender.misc.Streamer;\n" + "\n");
        String string5 = ePackageMap.getRootEClassMap().getBaseType().replace('$', '.');
        if (string5.equals(EMFHelper.DataObject_CLASS.getName())) {
            printWriter.write("import " + string5 + ";\n\n");
        }
        DiffProcessorGenerator.GenWarning(printWriter);
        printWriter.write("\npublic class " + string3 + " extends DiffProcessor\n" + " {\n" + "   public " + string3 + "()\n" + "    {\n" + "    }\n" + "\n" + "   protected Map _DiffHandlers = new HashMap(7);" + "\n" + "\n" + "   public DiffedObjectsLists handle(Object RootObject, String DiffStr)\n" + "   throws DiffException\n" + "    {\n" + "      try\n" + "       {\n" + "         Streamer.debug.Header().println(\" = = = = = = = = =  Diffing '" + ePackageMap.getName() + "'  = = = = = = = = = \");\n" + "         Streamer.trace.Header().println(DiffStr);\n" + "         HashMap Env = new HashMap(101);\n" + "         DiffTraverser DT = new DiffTraverser(\"" + ePackageMap.getName() + "_" + ePackageMap.getRootEClassMapName() + "\", DiffStr);\n" + "         DiffHandler DH;\n");
        Iterator iterator = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
        while (iterator.hasNext()) {
            EClassMap eClassMap = (EClassMap)iterator.next();
            String string6 = ePackageMap.getName() + "_" + eClassMap.getEClassName();
            printWriter.write("         DH = new " + DiffHandlerGenerator.getDiffHandlerClassName(eClassMap) + "\n" + "                     ( (" + string5 + ")RootObject, Env,\n" + "                        Mediator.getEClassMapForJavaComplexName(\"" + eClassMap.getJavaComplexName() + "\"),\n" + "                        MediatorFactory.getMediator_OnlyUseIfYouKnowWhatYouAreDoing(\"" + eClassMap.getJavaComplexName() + "\", Object_to_WDO4JS_as_JS_compact._KEY)\n" + "                       );\n" + "         Env.put(\"" + MARKER_DIFFHANDLER + string6 + "\", DH);\n" + "         DT.addHandler(\"" + string6 + "\", DH);\n");
        }
        printWriter.print("         DT.traverse();\n         return getDiffedObjects(Env);\n       }\n      catch (ExportException e)\n       {\n         throw new DiffException(e.getMessage());\n       }\n      catch (Exception e)\n       {\n         Streamer.error.Header().printStackTrace(e);\n       }\n     return null;\n    }\n }\n");
        printWriter.close();
    }

    public void PrintVersionHistory(Writer writer) {
    }
}

