/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.emitters.ClientConverterHelper;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.InvalidParameterException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Locale;

public class DatePickerEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String STYLE_SHORT = "short";
    private static final String STYLE_MEDIUM = "medium";
    private static final String STYLE_LONG = "long";
    private static final String STYLE_FULL = "full";
    private static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    private static final String DEFAULT_BUTTON_BORDER = "-1";
    private static final String DEFAULT_BASE_YEAR_OFFSET = "80";
    private static final String DATETYPE_DATE = "date";
    private static final boolean RENDER_AS_JSFDATEPICKER_ONLY = false;
    Locale locale = Locale.US;
    String inputTextId = null;
    String pattern;
    String dateStyle;
    String timeStyle = null;
    String type = "date";
    String firstDay;
    String buttonBorder;
    boolean required = false;
    String cSSPrefix = null;
    String btnColor = null;

    public DatePickerEmitter() {
        super("ODCDatePicker");
    }

    public void Init(String string) throws InvalidParameterException {
        this.Init(string, null, null, null, null, null, null, null, null, null, false);
    }

    public void Init(String string, Locale locale, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl) throws InvalidParameterException {
        Streamer.trace.Header().println("Entering DatePickeremitter.Init()");
        if (string == null || string.equals("")) {
            Streamer.error.Header().print("The id for inputtext field is either null or empty.");
            throw new InvalidParameterException("The id for inputtext field is either null or empty.");
        }
        this.inputTextId = string;
        if (locale != null) {
            this.locale = locale;
        }
        this.pattern = string2;
        if (string3 != null && !string3.equals("")) {
            this.type = string3;
        }
        this.dateStyle = string4;
        this.timeStyle = string5;
        this.firstDay = string6;
        this.buttonBorder = string7;
        this.cSSPrefix = string8;
        this.btnColor = string9;
        this.required = bl;
        Streamer.trace.Header().println("Exiting DatePickeremitter.Init()");
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering DatePickeremitter.Export()");
        writer.write("<script type=\"text/javascript\">");
        writer.write("\n");
        Writer writer2 = writer;
        String string = null;
        Calendar calendar = Calendar.getInstance(this.locale);
        int n = calendar.getFirstDayOfWeek();
        --n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.inputTextId;
        String string3 = ClientConverterHelper.getJsDateConverterString(this.pattern, this.type, this.dateStyle, this.timeStyle, this.locale);
        stringBuffer.append("hX_4.addConverter(\"" + string2 + "\", " + string3 + ");");
        if (null != string2) {
            writer2.write("\n");
            writer2.write(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        if (this.required) {
            string = "true";
        }
        String string4 = this.getNumericAttribute("first-day-of-week:", this.firstDay, new Integer(n).toString(), new Integer(0), new Integer(6));
        String string5 = this.getNumericAttribute("button-border:", this.buttonBorder, DEFAULT_BUTTON_BORDER, new Integer(-1), new Integer(3));
        writer2.write("\nhX_4.addComponent(\"" + this.inputTextId + "\", new " + "hX_4" + ".JSFDatePicker(");
        if (null != string2) {
            writer2.write("\"converter:" + string2 + "\"");
        }
        if (this.cSSPrefix != null && this.cSSPrefix != "") {
            writer2.write(", \"CSS-prefix:" + this.cSSPrefix + "\"");
        }
        if (this.btnColor != null && this.btnColor != "") {
            writer2.write(", \"button-color:" + this.btnColor + "\"");
        }
        if (string != null && string != "") {
            writer2.write(", \"required:" + string + "\"");
        }
        writer2.write(", \"" + string4 + "\"");
        writer2.write(", \"" + string5 + "\"");
        writer2.write("));\n");
        writer2.write("</script>");
        writer.write("\n");
        Streamer.trace.Header().println("Exiting DatePickeremitter.Export()");
    }

    private String getNumericAttribute(String string, String string2, String string3, Integer n, Integer n2) {
        String string4 = string2;
        if (string4 == null || string4 == "") {
            string4 = string3;
        } else {
            try {
                int n3 = Integer.parseInt(string4);
                if (n != null && n3 < n) {
                    string4 = string3;
                } else if (n2 != null && n3 > n2) {
                    string4 = string3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string4 = string3;
            }
        }
        string4 = string + string4;
        return string4;
    }
}

