/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class EventSelectAndActivateEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _sourceControl;
    protected String _eventName;
    protected String _eClassName;
    protected Map _targetEmitterMap = new Hashtable();
    protected BaseEmitter _sourceEmitter;

    public EventSelectAndActivateEmitter() {
        super("ODCEventSelectAndActivateHandler");
    }

    public EventSelectAndActivateEmitter(BaseEmitter baseEmitter, String string, String string2, BaseEmitter baseEmitter2, String string3) {
        super("ODCEventSelectAndActivateHandler");
        this.Init(baseEmitter, string, string2, baseEmitter2, string3);
    }

    public EventSelectAndActivateEmitter(BaseEmitter baseEmitter, String string, String string2) {
        super("ODCEventSelectAndActivateHandler");
        this.Init(baseEmitter, string, string2);
    }

    public void Init(BaseEmitter baseEmitter, String string, String string2) {
        this._sourceEmitter = baseEmitter;
        this._sourceControl = baseEmitter.CONTROL_VAR + baseEmitter.getExportID();
        this._eventName = string;
        this._eClassName = string2;
    }

    public void Init(BaseEmitter baseEmitter, String string, String string2, BaseEmitter baseEmitter2, String string3) {
        this._sourceEmitter = baseEmitter;
        this._sourceControl = baseEmitter.CONTROL_VAR + baseEmitter.getExportID();
        this._eventName = string;
        this._eClassName = string2;
        this.addTargetEmitter(baseEmitter2, string3);
    }

    public void addTargetEmitter(BaseEmitter baseEmitter, String string) {
        String string2 = baseEmitter.ADAPTER_VAR + baseEmitter.getExportID();
        if (string == null) {
            string = "";
        }
        this._targetEmitterMap.put(string2, string);
    }

    public void setSourceEmitter(BaseEmitter baseEmitter) {
        this._sourceEmitter = baseEmitter;
        this._sourceControl = baseEmitter.CONTROL_VAR + baseEmitter.getExportID();
    }

    public void setSourceControl(String string) {
        this._sourceControl = string;
    }

    public void setEventName(String string) {
        this._eventName = string;
    }

    public void setEClassName(String string) {
        this._eClassName = string;
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering EventSelectAndActivate Emitter...");
        String string = this.constructTargetAdapterArrayString();
        writer.write("<script type=\"text/javascript\">");
        writer.write("\n");
        String string2 = "func" + pageContext.NextInstanceCount();
        writer.write("function " + string2 + "(thisObj, thisEvent){\n");
        writer.write("SelectAndActivateEventHandler(thisEvent," + string + ");");
        writer.write("\n");
        writer.write("}\n");
        writer.write(this._sourceControl + ".addHandler(\"" + this._eventName + "\",\"" + string2 + "\",\"" + this._eClassName + "\");");
        writer.write("\n");
        writer.write("</script>");
        Streamer.trace.Header().println("Exiting EventSelectAndActivate Emitter...");
    }

    protected String constructTargetAdapterArrayString() {
        String string = "[";
        Iterator iterator = this._targetEmitterMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)this._targetEmitterMap.get(string2);
            String string4 = !string3.equals("") ? "[" + string2 + ",\"" + string3 + "\"]" : string2;
            string = n != 0 ? string.concat(", " + string4) : string.concat(string4);
            ++n;
        }
        string = string.concat("]");
        Streamer.debug.Header().println("EventSelectAndActivateEmitter --> adapterArrayString: " + string);
        return string;
    }
}

