/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class GraphDrawEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    StringBuffer seriesNames = new StringBuffer();
    StringBuffer attNames = new StringBuffer();
    StringBuffer ops = new StringBuffer();
    private String id;
    private String modelName;
    private String eObjectId;
    private String eReferenceName;
    private String width;
    private String height;
    private String firstChart;
    private boolean showPie;
    private boolean showBar;
    private boolean showLine;
    private String yAxisDivisions;
    private String title;
    private String xAxisTitle;
    private String yAxisTitle;
    private boolean showLegend;
    private boolean showLabel;
    private boolean splitYAxis;
    private boolean grouped;
    private ArrayList seriesList = new ArrayList();
    private String labelAttributeName;
    private boolean showHBar;
    private boolean showHLine;
    private boolean showVLine;
    private String styleClass;
    private String labelFormat = "STRING";
    private String dataFormat = "STRING";
    private String labelConverterScript = "\"\"";
    private String dataConverterScript = "\"\"";
    private String LABEL_ATTRIBUTE_PARAM = "labelAttributeName";
    private String SERIES_NAMES_PARAM = "dataSeriesNames";
    private String VALUE_ATTRIBUTES_PARAM = "dataAttributeNames";
    private String GROUP_OPS_PARAM = "groupOperations";
    private String LABEL_FORMAT_PARAM = "labelFormat";
    private String DATA_FORMAT_PARAM = "dataFormat";
    private String LABEL_CONVERTER_PARAM = "labelConverter";
    private String DATA_CONVERTER_PARAM = "dataConverter";
    private String CHART_TITLE_PARAM = "chartTitle";
    private String X_AXIS_TITLE_PARAM = "xAxisTitle";
    private String Y_AXIS_TITLE_PARAM = "yAxisTitle";
    private String SHOW_LEGEND_PARAM = "showLegend";
    private String SHOW_LABEL_PARAM = "showLabel";
    private String SHOW_PIE_PARAM = "showPie";
    private String SHOW_BAR_PARAM = "showBar";
    private String SHOW_LINE_PARAM = "showLine";
    private String FIRST_CHART_PARAM = "defaultChartType";
    private String Y_AXIS_DIVISIONS_PARAM = "yAxisDivisions";
    private String SPLIT_Y_AXIS_PARAM = "splitYAxis";
    private String GROUPED_PARAM = "grouped";
    private String PIE_CHART_BUTTON_LABEL_PARAM = "lblPie";
    private String BAR_CHART_BUTTON_LABEL_PARAM = "lblBar";
    private String LINE_CHART_BUTTON_LABEL_PARAM = "lblLine";
    private String SHARE_TOOLTIP_LABEL_PARAM = "tooltipShare";
    private String SERIES_TOOLTIP_LABEL_PARAM = "tooltipSeries";
    private String LABEL_TOOLTIP_LABEL_PARAM = "tooltipLabel";
    private String VALUE_TOOLTIP_LABEL_PARAM = "tooltipValue";
    private String PIE_ERROR_MSG_PARAM = "msgPieChartError";
    private String SHOW_ALL_COMBO_OPTION_PARAM = "lblShowAll";
    private String PIE_CHART_BUTTON_LABEL_KEY = "chartdraw_lblPie";
    private String BAR_CHART_BUTTON_LABEL_KEY = "chartdraw_lblBar";
    private String LINE_CHART_BUTTON_LABEL_KEY = "chartdraw_lblLine";
    private String SHARE_TOOLTIP_LABEL_KEY = "chartdraw_tooltipShare";
    private String SERIES_TOOLTIP_LABEL_KEY = "chartdraw_tooltipSeries";
    private String LABEL_TOOLTIP_LABEL_KEY = "chartdraw_tooltipLabel";
    private String VALUE_TOOLTIP_LABEL_KEY = "chartdraw_tooltipValue";
    private String PIE_ERROR_MSG_KEY = "chartdraw_msgPieChartError";
    private String SHOW_ALL_COMBO_OPTION_KEY = "chartdraw_lblShowAll";
    public static final String DATA_PREFIX = "data";
    public static final String LABEL_PREFIX = "label";
    public static final String NO_FORMAT = "STRING";
    public static final String DATETIME_FORMAT = "DATETIME";
    public static final String NUMBER_FORMAT = "NUMBER";
    public static final String MASK_FORMAT = "MASK";
    public static final String SHOW_H_BAR_PARAM = "showHorizontalLinesBar";
    public static final String SHOW_H_LINE_PARAM = "showHorizontalLinesLine";
    public static final String SHOW_V_LINE_PARAM = "showVerticalLinesLine";
    public static final String STYLE_CLASS_PARAM = "styleClass";

    public GraphDrawEmitter() {
        super("ODCGraphDraw");
    }

    public GraphDrawEmitter(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, String string8, String string9, String string10, String string11, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string12) {
        super("ODCGraphDraw");
        this.Init(string, string2, string3, string4, string5, string6, string7, bl, bl2, bl3, string8, string9, string10, string11, bl4, bl5, bl6, bl7, bl8, bl9, string12);
    }

    public void Init(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2, boolean bl3, String string8, String string9, String string10, String string11, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string12) {
        this.id = string;
        this.modelName = string2;
        this.eObjectId = string3;
        this.eReferenceName = string4;
        this.width = string5;
        this.height = string6;
        this.firstChart = string7;
        this.showPie = bl;
        this.showBar = bl2;
        this.showLine = bl3;
        this.yAxisDivisions = string8;
        if (this.yAxisDivisions == null || this.yAxisDivisions.equalsIgnoreCase("auto")) {
            Streamer.debug.Header().println("Setting the auto option for y axis divisions " + this.yAxisDivisions);
            this.yAxisDivisions = "-1";
        }
        this.title = string9;
        this.xAxisTitle = string10;
        this.yAxisTitle = string11;
        this.showLegend = bl4;
        this.splitYAxis = bl5;
        this.showLabel = bl6;
        this.showHBar = bl7;
        this.showHLine = bl8;
        this.showVLine = bl9;
        this.styleClass = string12;
        Streamer.debug.Header().println("Initialized GraphDrawEmitter with these parameters \nid = " + string + " ," + "modelName = " + string2 + " ," + "eObjectId = " + string3 + " ," + "eReferenceName = " + string4 + " ," + "width = " + string5 + " ," + "height = " + string6 + " ," + "firstChart = " + string7 + " ," + "showPie = " + bl + " ," + "showBar = " + bl2 + " ," + "showLine = " + bl3 + " ," + "yAxisDivisions = " + string8 + " ," + "title = " + string9 + " ," + "xAxisTitle = " + string10 + " ," + "yAxisTitle = " + string11 + " ," + "showLegend = " + bl4 + " ," + "splitYAxis = " + bl5 + " ," + "showHBar = " + bl7 + " ," + "showHLine = " + bl8 + " ," + "showVLine = " + bl9 + " ," + "styleClass = " + string12);
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        boolean bl;
        Streamer.trace.Header().println("Entering GraphDrawEmitter...");
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("ODCProgressBar.startRenderControl(graphdraw);\n");
        writer.write("</script>\n");
        this._varIndex = pageContext.NextInstanceCount();
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        boolean bl2 = bl = pageContext.getContextVariable("DEBUG_MODE") == "YES";
        if (!BaseEmitter.TestGuard(pageContext, "GRAPH_JS_FLAG")) {
            if (bl) {
                writer.write("\n<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/graphdraw/graphdrawcontrol.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/graphdraw/graphdrawadapter.js") + "\"></script>");
                Streamer.trace.Header().println("Included graphdraw JS control and adapter files...");
            } else {
                writer.write("<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_graphdraw_c.js") + "\"></script>");
                writer.write("\n");
                Streamer.trace.Header().println("Included compressed graphdraw JS file...");
            }
        }
        writer.write("<div style=\"position: absolute; top:0px;left:0px; width:0px; height:0px; overflow:hidden\" id=\"" + this.ADAPTER_VAR + this._varIndex + "_AccessibleText\"></div>");
        writer.write("<object id=\"" + this.CONTROL_VAR + this._varIndex + "Chart\" type=\"application/x-shockwave-flash\" data=\"" + uRLRewriter.Rewrite("jsl/graphdraw/emfChart2.swf") + "\" width=\"" + this.width + "\" height=\"" + this.height + "\">");
        writer.write("\n");
        writer.write("<param name=\"movie\" value=\"" + uRLRewriter.Rewrite("jsl/graphdraw/emfChart2.swf") + "\" />");
        writer.write("\n");
        writer.write("\n");
        writer.write("</object>");
        writer.write("\n");
        writer.write("<script type=\"text/javascript\">");
        writer.write("var " + this.CONTROL_VAR + this._varIndex + " = new GraphDrawControl();");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".chartObj = window.document." + this.CONTROL_VAR + this._varIndex + "Chart;");
        writer.write("\n");
        writer.write("var " + this.ADAPTER_VAR + this._varIndex + " = new GraphDrawAdapter(" + this.CONTROL_VAR + this._varIndex + ");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".parentEObject = findEObjectByXMIID(WDO4JSModelRoot_" + this.modelName + ".Root, \"" + this.eObjectId + "\");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".propertyName = \"" + this.eReferenceName + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.LABEL_ATTRIBUTE_PARAM + " = \"" + this.labelAttributeName + "\";");
        writer.write("\n");
        this.processDataSeries();
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SERIES_NAMES_PARAM + " = new Array(" + this.seriesNames.toString() + ");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.VALUE_ATTRIBUTES_PARAM + " = new Array(" + this.attNames.toString() + ");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.GROUP_OPS_PARAM + " = new Array(" + this.ops.toString() + ");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.LABEL_FORMAT_PARAM + " = \"" + this.labelFormat + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.DATA_FORMAT_PARAM + "  = \"" + this.dataFormat + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.LABEL_CONVERTER_PARAM + " = " + this.labelConverterScript + ";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.DATA_CONVERTER_PARAM + " = " + this.dataConverterScript + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.CHART_TITLE_PARAM + " = \"" + this.title + "\";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.X_AXIS_TITLE_PARAM + " = \"" + this.xAxisTitle + "\";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.Y_AXIS_TITLE_PARAM + " = \"" + this.yAxisTitle + "\";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_LEGEND_PARAM + " = " + this.showLegend + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_LABEL_PARAM + " = " + this.showLabel + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_PIE_PARAM + " = " + this.showPie + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_BAR_PARAM + " = " + this.showBar + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_LINE_PARAM + " = " + this.showLine + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.FIRST_CHART_PARAM + " = \"" + this.firstChart + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.Y_AXIS_DIVISIONS_PARAM + " = " + this.yAxisDivisions + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SPLIT_Y_AXIS_PARAM + " = " + this.splitYAxis + ";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + "." + this.GROUPED_PARAM + " = " + this.grouped + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + SHOW_H_BAR_PARAM + " = " + this.showHBar + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + SHOW_H_LINE_PARAM + " = " + this.showHLine + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + SHOW_V_LINE_PARAM + " = " + this.showVLine + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + STYLE_CLASS_PARAM + " = \"" + this.styleClass + "\";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.PIE_CHART_BUTTON_LABEL_PARAM + " = " + this.PIE_CHART_BUTTON_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.BAR_CHART_BUTTON_LABEL_PARAM + " = " + this.BAR_CHART_BUTTON_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.LINE_CHART_BUTTON_LABEL_PARAM + " = " + this.LINE_CHART_BUTTON_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHARE_TOOLTIP_LABEL_PARAM + " = " + this.SHARE_TOOLTIP_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SERIES_TOOLTIP_LABEL_PARAM + " = " + this.SERIES_TOOLTIP_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.LABEL_TOOLTIP_LABEL_PARAM + " = " + this.LABEL_TOOLTIP_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.VALUE_TOOLTIP_LABEL_PARAM + " = " + this.VALUE_TOOLTIP_LABEL_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.PIE_ERROR_MSG_PARAM + " = " + this.PIE_ERROR_MSG_KEY + ";");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + "." + this.SHOW_ALL_COMBO_OPTION_PARAM + " = " + this.SHOW_ALL_COMBO_OPTION_KEY + ";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".accessibleTextContainer = document.getElementById(\"" + this.ADAPTER_VAR + this._varIndex + "_AccessibleText\");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".bind();");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".ShowGraph();");
        writer.write("\n");
        writer.write("</script>");
        writer.write("\n");
        writer.write("<script type=\"text/javascript\">\n");
        writer.write("ODCProgressBar.endRenderControl(graphdraw);\n");
        writer.write("</script>\n");
        Streamer.trace.Header().println("Exiting GraphDrawEmitter...");
    }

    public void setShowLabel(boolean bl) {
        this.showLabel = bl;
    }

    public void setLabelAttributeName(String string) {
        this.labelAttributeName = string;
    }

    public void setGrouped(boolean bl) {
        this.grouped = bl;
    }

    public void addDataSeries(String string, String string2, String string3, String string4) {
        DataSeries dataSeries = new DataSeries(string, string2, string3, string4);
        this.seriesList.add(dataSeries);
    }

    private void processDataSeries() {
        int n = 0;
        while (n < this.seriesList.size()) {
            DataSeries dataSeries = (DataSeries)this.seriesList.get(n);
            String string = dataSeries.getGroupOperation();
            if (string == null || string.equals("")) {
                string = "None";
            }
            if (n == 0) {
                this.seriesNames = this.seriesNames.append("\"").append(dataSeries.getSeriesName()).append("\"");
                this.attNames = this.attNames.append("\"").append(dataSeries.getAttributeName()).append("\"");
                this.ops = this.ops.append("\"").append(string).append("\"");
            } else {
                this.seriesNames = this.seriesNames.append(",\"").append(dataSeries.getSeriesName()).append("\"");
                this.attNames = this.attNames.append(",\"").append(dataSeries.getAttributeName()).append("\"");
                this.ops = this.ops.append(",\"").append(string).append("\"");
            }
            ++n;
        }
    }

    public void setLabelConverterScript(String string) {
        this.labelConverterScript = string;
        if (this.labelConverterScript.equals("")) {
            this.labelConverterScript = "\"\"";
        }
    }

    public void setDataConverterScript(String string) {
        this.dataConverterScript = string;
        if (this.dataConverterScript.equals("")) {
            this.dataConverterScript = "\"\"";
        }
    }

    public void setLabelFormat(String string) {
        this.labelFormat = string;
    }

    public void setDataFormat(String string) {
        this.dataFormat = string;
    }

    protected class DataSeries {
        private String id;
        private String seriesName;
        private String attributeName;
        private String groupOperation;

        public DataSeries(String string, String string2, String string3, String string4) {
            this.id = string;
            this.seriesName = string2;
            this.attributeName = string3;
            this.groupOperation = string4;
        }

        public String getId() {
            return this.id;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getGroupOperation() {
            if (this.groupOperation != null) {
                this.groupOperation = this.groupOperation.toUpperCase();
            }
            return this.groupOperation;
        }
    }
}

