/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.NLResourceManager;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;

public class InitializationEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static int LOG_LEVEL_NONE = -1;
    public static int LOG_LEVEL_ERROR = 0;
    public static int LOG_LEVEL_WARNING = 1;
    public static int LOG_LEVEL_INFO = 2;
    public static int LOG_LEVEL_DEBUG = 3;
    protected final boolean _DefaultClientDebugMode = Config.getInteger(Config.PROP_CLIENT_DEBUG_MODE) == 1;
    protected final String _DefaultClientLocale = Config.getString(Config.PROP_CLIENT_LOCALE);
    protected final int _DefaultClientLogLevel = Config.getInteger(Config.PROP_CLIENT_LOG_LEVEL);
    protected final boolean _ShowProgressBar = Config.getInteger(Config.PROP_PROGRESSBAR) == 1;
    protected String _Locale;
    protected boolean _DebugMode;
    protected int _LogLevel;
    protected URLRewriter _Rewriter;
    protected String _baseURL;
    private static int isPortal = -1;
    public static final String _ID_ODCB_INIT_FLAG = "ODCB_INIT_FLAG";
    public static final String _ID_DEBUG_MODE = "DEBUG_MODE";
    public static final String _ID_URL_REWRITER = "URL_REWRITER";
    public static final String _ID_URL_PREFIX = "URL_PREFIX";
    public static final String _ID_URL_POSTFIX = "URL_POSTFIX";
    public static final String DEBUG_YES = "YES";
    public static final String _ID_CLIENT_LOCALE = "CLIENT_LOCALE";
    public static final String _ID_LOG_LEVEL = "LOG_LEVEL";

    public InitializationEmitter(URLRewriter uRLRewriter, String string, int n) {
        this.Init(uRLRewriter, string, n);
        if (isPortal == -1) {
            String string2 = Config.getString(Config.PROP_REQUEST_CLASS);
            isPortal = string2.equals("com.ibm.faces.bf.util.HttpRequestRetrieverForServlet") ? 0 : 1;
        }
    }

    public InitializationEmitter(boolean bl, int n, String string, URLRewriter uRLRewriter, String string2, int n2) {
        this.Init(bl, n, string, uRLRewriter, string2, n2);
    }

    public void Init(URLRewriter uRLRewriter, String string, int n) {
        this.Init(this._DefaultClientDebugMode, this._DefaultClientLogLevel, this._DefaultClientLocale, uRLRewriter, string, n);
    }

    public void Init(boolean bl, int n, String string, URLRewriter uRLRewriter, String string2, int n2) {
        this._DebugMode = bl;
        this.setLocale(string);
        this._LogLevel = n;
        this._Rewriter = uRLRewriter;
        this._baseURL = string2 == null ? null : "http://" + string2 + ":" + n2;
        Streamer.debug.Header().println("DebugMode: " + this._DebugMode);
        Streamer.debug.Header().println("LOG_LEVEL: " + this._LogLevel);
        Streamer.debug.Header().println("LOCALE: " + this._Locale);
        Streamer.debug.Header().println("Base URL: " + this._baseURL);
    }

    public void setLocale(String string) {
        this._Locale = string;
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering InitializationEmitter export...");
        if (BaseEmitter.TestGuard(pageContext, _ID_ODCB_INIT_FLAG)) {
            return;
        }
        Streamer.trace.Header().println("Executing initialization emitter...");
        if (!BaseEmitter.TestGuard(pageContext, "NL_JS_FLAG")) {
            String string;
            try {
                string = NLResourceManager.getFile(this._baseURL, this._Rewriter.Rewrite("jsl/OdysseyMessage"), "jsl/OdysseyMessage", this._Locale);
                Streamer.debug.Header().println("odc Message file path --> " + string);
                writer.write("<script type=\"text/javascript\" src=\"" + string + "\"></script>");
                writer.write("\n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Streamer.error.Header().printStackTrace(exception);
            }
            try {
                string = NLResourceManager.getFile(this._baseURL, this._Rewriter.Rewrite("jsl/odcSessionControllerMessage"), "jsl/odcSessionControllerMessage", this._Locale);
                Streamer.debug.Header().println("odc Controller file path --> " + string);
                writer.write("<script type=\"text/javascript\" src=\"" + string + "\"></script>");
                writer.write("\n");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Streamer.error.Header().printStackTrace(exception);
            }
        }
        if (!BaseEmitter.TestGuard(pageContext, "CORE_JS_FLAG")) {
            if (this._DebugMode) {
                pageContext.addContextVariable(_ID_DEBUG_MODE, DEBUG_YES);
                writer.write("\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/jslUtil.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/logger.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/detectBrowser.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/converter/maskconverter.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/ODCRegistry.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/genericEventHandler.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/odcSessionController.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/progressbar.js") + "\"></script>");
                writer.write("\n");
                Streamer.trace.Header().println("Included individual core JS files...");
            } else {
                writer.write("<script type=\"text/javascript\" src=\"" + this._Rewriter.Rewrite("jsl/jsl_core_c.js") + "\"></script>");
                writer.write("\n");
                Streamer.trace.Header().println("Included compressed core JS file...");
            }
            this.printProgressBar(writer, pageContext);
        }
        String string = this._Rewriter.Rewrite("jsl_css/x.css");
        writer.write("<script type=\"text/javascript\">");
        String string2 = "getURLPrefix(\"" + string + "\",\"" + "jsl_css/x.css" + "\")";
        String string3 = "getURLPostfix(\"" + string + "\",\"" + "jsl_css/x.css" + "\")";
        writer.write("Log.setLogLevel(" + this._LogLevel + "); Log.setURLRewriter(" + string2 + ", " + string3 + "); \n" + " var URL_REWRITER_PREFIX = " + string2 + "; var URL_REWRITER_POSTFIX= " + string3 + "; var ODCPORTAL=" + isPortal + "; var PAGE_LOCALE = \"" + this._Locale + "\"; \n" + "</script>");
        writer.write("\n");
        pageContext.addContextVariable(_ID_URL_REWRITER, this._Rewriter);
        pageContext.addContextVariable(_ID_CLIENT_LOCALE, this._Locale);
        pageContext.addContextVariable(_ID_LOG_LEVEL, String.valueOf(this._LogLevel));
        Streamer.trace.Header().println("Exiting InitializationEmitter export...");
    }

    private void printProgressBar(Writer writer, PageContext pageContext) throws IOException {
        if (this._ShowProgressBar) {
            writer.write("<script type=\"text/javascript\">\n");
            writer.write("ODCProgressBar.setVisible();\n");
            String string = "holder" + pageContext.NextInstanceCount();
            writer.write("var " + string + " = new ColorHolder(ODCProgressBar.getRow());\n");
            writer.write("setInterval(\"" + string + ".changeColor()\", 350);\n");
            writer.write("if(window.addEventListener)\n");
            writer.write("window.addEventListener('load',function(){ODCProgressBar.hide();} ,false);\n");
            writer.write("else\n");
            writer.write("window.attachEvent(\"onload\", function(){ODCProgressBar.hide();});\n");
            writer.write("</script>\n");
        }
    }
}

