/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.IOException;
import java.io.Writer;

public class InputTextEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final int _defaultRows = 10;
    protected final int _defaultCols = 20;
    protected boolean _TextArea;
    protected String _modelName;
    protected String _eObjectID;
    protected String _eAttributeName;
    protected int _rows = 10;
    protected int _cols = 20;

    public InputTextEmitter() {
        super("ODCInputText");
    }

    public void Init(String string, String string2, String string3) {
        this._TextArea = false;
        this._modelName = string;
        this._eObjectID = string2;
        this._eAttributeName = string3;
    }

    public void Init(String string, String string2, String string3, int n, int n2) {
        this._TextArea = true;
        this._modelName = string;
        this._eObjectID = string2;
        this._eAttributeName = string3;
        this._rows = n;
        this._cols = n2;
    }

    public void setTextArea(boolean bl) {
        this._TextArea = bl;
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public void setEObjectID(String string) {
        this._eObjectID = string;
    }

    public void setEAttributeName(String string) {
        this._eAttributeName = string;
    }

    public void setRows(int n) {
        this._rows = n;
    }

    public void setCols(int n) {
        this._cols = n;
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering InputTextEmitter export...");
        this._varIndex = pageContext.NextInstanceCount();
        if (this._TextArea) {
            writer.write("<textarea id=\"" + this.CONTROL_VAR + this._varIndex + "\" cols=\"" + this._cols + "\"  rows=\"" + this._rows + "\" /></textarea>");
            writer.write("\n");
        } else {
            writer.write("<input type=\"text\" id=\"" + this.CONTROL_VAR + this._varIndex + "\" />");
            writer.write("\n");
        }
        writer.write("<script type=\"text/javascript\">");
        writer.write("\n");
        writer.write("var " + this.ADAPTER_VAR + this._varIndex + " = new PropertyBinder(findEObjectByXMIID(WDO4JSModelRoot_" + this._modelName + ".Root,'" + this._eObjectID + "')" + ",'" + this._eAttributeName + "'" + ",document.getElementById('" + this.CONTROL_VAR + this._varIndex + "')" + ",'value', 'onchange');");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".DataBind();");
        writer.write("\n");
        writer.write("</script>");
        writer.write("\n");
        Streamer.trace.Header().println("Exiting InputTextEmitter export...");
    }
}

