/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.StringUtil;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class SelectEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final int _defaultSize = 1;
    protected final int _defaultMultipleFlag = 0;
    protected String _modelName;
    protected String _eObjectID;
    protected String _eReferenceName;
    protected String _eAttributeName;
    protected String _callBackFunction;
    protected int _size = 1;
    protected int _multipleFlag = 0;
    protected ArrayList _optionValueList = new ArrayList();
    protected ArrayList _optionTextList = new ArrayList();
    protected String _originalValueString = "";
    protected String _originalTextString = "";

    public SelectEmitter() {
        super("ODCSelect");
    }

    public SelectEmitter(String string, String string2, String string3, String string4, int n, String string5, int n2, ArrayList arrayList, ArrayList arrayList2) {
        super("ODCSelect");
        this.Init(string, string2, string3, string4, n, n2, string5, arrayList, arrayList2);
    }

    public SelectEmitter(String string, String string2, String string3, String string4, String string5, ArrayList arrayList, ArrayList arrayList2) {
        super("ODCSelect");
        this.Init(string, string2, string3, string4, 1, 0, string5, arrayList, arrayList2);
    }

    public void Init(String string, String string2, String string3, String string4, int n, int n2, String string5, ArrayList arrayList, ArrayList arrayList2) {
        this._modelName = string;
        this._eObjectID = string2;
        this._eReferenceName = string3;
        this._eAttributeName = string4;
        this._size = n;
        this._multipleFlag = n2;
        this._callBackFunction = string5;
        this._optionValueList = arrayList;
        this._optionTextList = arrayList2;
        Streamer.debug.Header().println("In SelectEmitter --> \nmodelName: " + this._modelName + "\n" + "eObjectId: " + this._eObjectID + "\n" + "eReferenceName: " + this._eReferenceName + "\n" + "eAttributeName: " + this._eAttributeName + "\n" + "size: " + this._size + "\n" + "multipleFlag: " + this._multipleFlag + "\n" + "callBackFunction: " + this._callBackFunction + "\n");
    }

    public void setModelName(String string) {
        this._modelName = string;
    }

    public void setEObjectID(String string) {
        this._eObjectID = string;
    }

    public void setEAttributeName(String string) {
        this._eAttributeName = string;
    }

    public void setEReferenceName(String string) {
        this._eReferenceName = string;
    }

    public void setCallBackFunction(String string) {
        this._callBackFunction = string;
    }

    public void setSize(int n) {
        this._size = n;
    }

    public void setMultipleFlag(int n) {
        this._multipleFlag = n;
    }

    public void addSelectOption(String string, String string2) {
        this._optionValueList.add(string);
        this._optionTextList.add(string2);
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        boolean bl;
        Streamer.trace.Header().println("Entering SelectEmitter export...");
        this._varIndex = pageContext.NextInstanceCount();
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        boolean bl2 = bl = pageContext.getContextVariable("DEBUG_MODE") == "YES";
        if (!BaseEmitter.TestGuard(pageContext, "SELECT_JS_FLAG")) {
            if (bl) {
                writer.write("\n<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/select/selectcontrol.js") + "\"></script>" + "\n<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/select/selectadapter.js") + "\"></script>");
                Streamer.trace.Header().println("Included select JS control and adapter files...");
            } else {
                writer.write("<script type=\"text/javascript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_select_c.js") + "\"></script>");
                writer.write("\n");
                Streamer.trace.Header().println("Included compressed select JS file...");
            }
        }
        if (this._multipleFlag == 0) {
            writer.write("<select size=\"" + this._size + "\" id=\"" + this.HTML_ELEMENT + this._varIndex + "\" name=\"" + this.HTML_ELEMENT + this._varIndex + "\"");
        } else {
            writer.write("<select multiple=\"multiple\" size=\"" + this._size + " id=\"" + this.HTML_ELEMENT + this._varIndex + "\" name=\"" + this.HTML_ELEMENT + this._varIndex + "\"");
        }
        if (this._callBackFunction != null) {
            writer.write(" onclick=\"" + this._callBackFunction + "(this)\"");
        }
        writer.write(" >");
        writer.write("\n");
        int n = this._optionValueList.size();
        if (n != 0) {
            this.buildOriginalOptionStrings(n);
        }
        writer.write("</select>");
        writer.write("\n");
        writer.write("<script type=\"text/javascript\">");
        writer.write("\n");
        writer.write("\n");
        writer.write("var " + this.CONTROL_VAR + this._varIndex + " = new SelectControl();");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".selectObj = window.document.getElementById(\"" + this.HTML_ELEMENT + this._varIndex + "\");");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".originalValueArray = [" + this._originalValueString + "];");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".originalTextArray = [" + this._originalTextString + "];");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".setOriginalOptions();");
        writer.write("\n");
        writer.write("var " + this.ADAPTER_VAR + this._varIndex + " = new SelectAdapter(" + this.CONTROL_VAR + this._varIndex + ");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".attributeName = \"" + this._eAttributeName + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".parentEObject = findEObjectByXMIID(WDO4JSModelRoot_" + this._modelName + ".Root, \"" + this._eObjectID + "\");");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".propertyName = \"" + this._eReferenceName + "\";");
        writer.write("\n");
        writer.write(this.ADAPTER_VAR + this._varIndex + ".bind();");
        writer.write("\n");
        writer.write(this.CONTROL_VAR + this._varIndex + ".updateControl();");
        writer.write("\n");
        writer.write("</script>");
        writer.write("\n");
        Streamer.trace.Header().println("Exiting SelectEmitter export...");
    }

    public void buildOriginalOptionStrings(int n) {
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                this._originalValueString = this._originalValueString.concat(",");
                this._originalTextString = this._originalTextString.concat(",");
            }
            this._originalValueString = this._originalValueString.concat(this.buildQuotedString((String)this._optionValueList.get(n2)));
            this._originalTextString = this._originalTextString.concat(this.buildQuotedString((String)this._optionTextList.get(n2)));
            ++n2;
        }
    }

    protected String buildQuotedString(String string) {
        String string2 = string;
        string2 = StringUtil.QuoteDoubleAndEscape(string2, true);
        string2 = string2.substring(1, string2.length() - 2).concat(string2.substring(string2.length() - 1));
        return string2;
    }
}

