/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.GenericSDO4JSMediator;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.MappingsCompiler;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.mediators.gen.generators.Generator;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.utilities.EMapGen;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class GenericSDO4JSMediatorGen {
    private String clientEcorename;
    private DataObject obj;
    private WDO4JSMappings universe;
    private EPackage pkg;
    private EPackageMap epm;
    private static final String RELATIVE_EMAP_FILEPATH = "com/ibm/dynwdo4jsmediators/";

    public GenericSDO4JSMediatorGen(DataObject dataObject) {
        this.obj = dataObject;
    }

    public void gen() {
        Streamer.trace.Header().println("Enter GenericMediator.gen()");
        try {
            Streamer.status.Header().println("GM.gen(): Getting current Universe");
            this.universe = MediatorFactory.getInstance().getUniverse();
            Streamer.status.Header().println("GM.gen(): Loading Ecore for the DataObject into the current Universe");
            this.loadEcore();
            Streamer.status.Header().println("GM.gen(): Creating and Loading an identity EMap for the DataObject into the current Universe");
            this.loadEMap();
            Streamer.status.Header().println("GM.gen(): Verifying the Universe");
            boolean bl = this.universe.Verify();
            if (bl) {
                Streamer.status.Header().println("GM.gen(): Creating and Loading Client Ecore for the DataObject into the current Universe");
                this.loadClientEcore();
                Streamer.status.Header().println("GM.gen(): Exporting Schema for the DataObject");
                this.registerMediators();
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
        }
        Streamer.trace.Header().println("Exit GenericMediator.gen()");
    }

    private void loadClientEcore() {
        String string = MappingsCompiler.createClientEcore(this.epm);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        MappingsCompiler.cacheClientEcore(this.epm, this.clientEcorename, byteArrayInputStream, this.universe);
    }

    private void loadEMap() {
        Object object;
        Map map = EMapGen.initParams(null, this.pkg);
        HashMap hashMap = EMapGen.createEClassMaps(this.pkg, map, RELATIVE_EMAP_FILEPATH + this.pkg.getName() + ".emap", null);
        if (hashMap.values().iterator().hasNext()) {
            object = (EClassMap)hashMap.values().iterator().next();
            this.clientEcorename = ((EClassMap)object).getClientEcoreName();
            this.epm = new EPackageMap(this.pkg.getName());
            this.epm.setRootEClassMapName(EMFHelper.getEClassName(this.obj));
            this.epm.setEMapResourceName(((EClassMap)object).getSourceEmapName());
            this.epm.setEMapXMLFileName(((EClassMap)object).getXMLFileSource());
            this.universe.addEPackageMap(this.epm, false);
            this.epm.setUniverse(this.universe);
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            EClassMap eClassMap = (EClassMap)object.next();
            this.universe.addEClassMap(this.epm, eClassMap, true);
        }
    }

    private void loadEcore() {
        EClass eClass = ((EObject)this.obj).eClass();
        this.pkg = eClass.getEPackage();
        this.universe.addEPackage(this.pkg, true);
    }

    private void registerMediators() {
        Iterator iterator = this.universe.getEClassMapsForEPackageIterator(this.epm.getName());
        while (iterator.hasNext()) {
            EClassMap eClassMap = (EClassMap)iterator.next();
            try {
                int n = 0;
                while (n < Generator.MEDIATOR_KEYS.length) {
                    String string = MediatorFactory.GenTypeKey(eClassMap.getJavaComplexName(), Generator.GENS[n].getIdentifier());
                    Streamer.debug.Header().println("Adding GenericSDO4JSMediator for Key '" + string + "'.");
                    MediatorFactory.getInstance().addMediator(string, new GenericSDO4JSMediator(eClassMap));
                    ++n;
                }
            }
            catch (Exception exception) {
                Streamer.error.Header().printStackTrace(exception);
            }
        }
    }

    public static boolean isGenericSDO4JSMediatorNeeded(String string, Object object) throws ExportException {
        MediatorFactory mediatorFactory;
        Mediator mediator;
        boolean bl = false;
        if (object instanceof DataObject && (mediator = (mediatorFactory = MediatorFactory.getInstance()).getMediator(string)) == null) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
    }
}

