/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.AlreadyOutputException;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.StringUtil;
import commonj.sdo.DataObject;
import java.io.ByteArrayInputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class Mediator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String _MEDIATOR_SEPERATOR = "`";
    protected String _VarBaseName;
    protected String _ArrayVarDelimiter;

    public Mediator(String string, String string2) {
        this._VarBaseName = string;
        this._ArrayVarDelimiter = string2;
    }

    public abstract String getSignature(Object var1, String var2, boolean var3, int var4);

    public abstract void Export(Writer var1, PageContext var2, Object var3) throws ExportException;

    public abstract void Export(Writer var1, PageContext var2, Object var3, String var4, boolean var5) throws ExportException;

    public abstract void ExportXMILoader(Writer var1, PageContext var2) throws ExportException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ExportSchema(Writer writer, PageContext pageContext, String string, String string2, Object object) throws ExportException {
        PageContext pageContext2 = pageContext;
        synchronized (pageContext2) {
            pageContext.setModelName(string2);
            Mediator.ExportSchema(writer, pageContext, string, object);
        }
    }

    protected static void ExportSchema(Writer writer, PageContext pageContext, String string, Object object) throws ExportException {
        MediatorFactory mediatorFactory = MediatorFactory.getInstance();
        Mediator mediator = mediatorFactory.getMediator(string);
        if (mediator == null) {
            throw new ExportException("WDO4JS Mediator for '" + string + "' not found");
        }
        if (pageContext.AddSchemaExport(string)) {
            pageContext.addExportedModelName(string, pageContext.getLastModelName());
            pageContext.ExportSchema(writer, mediator, object);
        } else if (!pageContext.getExportedModelName(string).equals(pageContext.getLastModelName())) {
            pageContext.setSchemaExportName(pageContext.getExportedModelName(string));
            pageContext.ExportXMILoader(writer, mediator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ExportData(Writer writer, PageContext pageContext, Object object, String string, boolean bl) throws ExportException {
        String string2;
        if (object == null) {
            return "null";
        }
        MediatorFactory mediatorFactory = MediatorFactory.getInstance();
        Mediator mediator = mediatorFactory.getMediator(string);
        if (mediator == null) {
            throw new ExportException("WDO4JS Mediator for  '" + string + "' not found");
        }
        try {
            PageContext pageContext2 = pageContext;
            synchronized (pageContext2) {
                string2 = pageContext.AddInstanceExport(object, mediator, bl, pageContext.getLastModelName());
                pageContext.ExportData(writer, object, string2, mediator, bl);
            }
        }
        catch (AlreadyOutputException alreadyOutputException) {
            string2 = alreadyOutputException.getMessage();
        }
        return string2;
    }

    public static EClassMap getEClassMapForJavaComplexName(String string, String string2) throws ExportException {
        return Mediator.getEClassMapForJavaComplexName(EClassMap.MakeComplexName(string, string2));
    }

    public static EClassMap getEClassMapForJavaComplexName(String string) throws ExportException {
        EClassMap eClassMap = MediatorFactory.getInstance().getUniverse().getEClassMapByJavaComplexName(string);
        if (eClassMap == null) {
            throw new ExportException("EClassMap for '" + string + "' not found");
        }
        return eClassMap;
    }

    public static String getExportID(PageContext pageContext, Object object, String string, String string2) throws ExportException {
        MediatorFactory mediatorFactory = MediatorFactory.getInstance();
        Mediator mediator = mediatorFactory.getMediator(string);
        if (mediator == null) {
            throw new ExportException("WDO4JS Mediator for  '" + string + "' not found");
        }
        return pageContext.getInstanceExport(object, mediator, string2);
    }

    protected static void ExportData(Writer writer, PageContext pageContext, Collection collection, String string, boolean bl) throws ExportException {
        Mediator.ExportData(writer, pageContext, collection == null ? null : collection.iterator(), string, bl);
    }

    protected static void ExportData(Writer writer, PageContext pageContext, Object[] objectArray, String string, boolean bl) throws ExportException {
        Mediator.ExportData(writer, pageContext, objectArray == null ? null : Arrays.asList(objectArray).iterator(), string, bl);
    }

    /*
     * Unable to fully structure code
     */
    protected static void ExportData(Writer var0, PageContext var1_1, Iterator var2_2, String var3_3, boolean var4_4) throws ExportException {
        var1_1.PushArrayType(var3_3);
        if (var2_2 == null) {
            return;
        }
        var5_5 = MediatorFactory.getInstance();
        var6_6 = var5_5.getMediator(var3_3);
        if (var6_6 != null) ** GOTO lbl16
        throw new ExportException("WDO4JS Mediator for class '" + var3_3 + "' not found");
lbl-1000:
        // 1 sources

        {
            try {
                var8_8 = var2_2.next();
                var7_7 = var1_1.AddInstanceExport(var8_8, var6_6, var4_4, var1_1.getLastModelName());
                var1_1.ExportData(var0, var8_8, var7_7, var6_6, var4_4);
            }
            catch (AlreadyOutputException var8_9) {
                var7_7 = var8_9.getMessage();
            }
            var1_1.PushArrayVar(var3_3, var7_7, var6_6._ArrayVarDelimiter);
lbl16:
            // 2 sources

            ** while (var2_2.hasNext())
        }
lbl17:
        // 1 sources

    }

    public static String FormatBasicTypeOutput(Object object, char c) {
        if (object == null) {
            return "null";
        }
        if (c == 'D') {
            return "" + ((Date)object).getTime();
        }
        if (c == 'C') {
            return "'" + object + "'";
        }
        if (c == 'S' || c == ' ') {
            return StringUtil.QuoteDoubleAndEscape(object.toString(), false);
        }
        return object.toString();
    }

    public static String constructArrayString(Iterator iterator, char c) {
        if (iterator == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        while (iterator.hasNext()) {
            stringBuffer.append(",").append(Mediator.FormatBasicTypeOutput(iterator.next(), c));
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(Collection collection, char c) {
        return collection == null ? "null" : Mediator.constructArrayString(collection.iterator(), c);
    }

    public static String constructArrayString(Object[] objectArray, char c) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(",").append(Mediator.FormatBasicTypeOutput(objectArray[n], c));
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        if (cArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(cArray.length * 2 + 2);
        int n = 0;
        while (n < cArray.length) {
            stringBuffer.append(",'").append(cArray[n]).append("'");
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(blArray.length * 2 + 2);
        int n = 0;
        while (n < blArray.length) {
            stringBuffer.append(",").append(blArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        if (dArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 2 + 2);
        int n = 0;
        while (n < dArray.length) {
            stringBuffer.append(",").append(dArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        if (fArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(fArray.length * 2 + 2);
        int n = 0;
        while (n < fArray.length) {
            stringBuffer.append(",").append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(nArray.length * 2 + 2);
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(",").append(nArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(lArray.length * 2 + 2);
        int n = 0;
        while (n < lArray.length) {
            stringBuffer.append(",").append(lArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        if (sArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(sArray.length * 2 + 2);
        int n = 0;
        while (n < sArray.length) {
            stringBuffer.append(",").append(sArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2 + 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(",").append(byArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        stringBuffer.setCharAt(0, '[');
        return stringBuffer.toString();
    }

    public static String constructArrayStringAsXMI(String string, Iterator iterator) {
        String string2 = "";
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string3 = "" + e;
            if (e instanceof String && (string3 = StringUtil.QuoteDoubleAndEscape(string3, true)).length() > 3) {
                string3 = string3.substring(2, string3.length() - 2);
            }
            string2 = string2.concat("\n<" + string + ">" + string3 + "</" + string + ">");
        }
        return string2;
    }

    public static String constructArrayStringAsXMI(String string, Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        String string2 = "";
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            String string3 = "" + object;
            if (object instanceof String && (string3 = StringUtil.QuoteDoubleAndEscape(string3, true)).length() > 3) {
                string3 = string3.substring(2, string3.length() - 2);
            }
            string2 = string2.concat("\n<" + string + ">" + string3 + "</" + string + ">");
            ++n;
        }
        return string2;
    }

    public static DataObject getDiffDataObject(String string, String string2) throws ExportException {
        DataObject dataObject = null;
        try {
            EClassMap eClassMap = MediatorFactory.getInstance().getUniverse().getEClassMapByExport(string);
            if (eClassMap == null) {
                throw new ExportException("EClassMap for exported class '" + string + "' not found.");
            }
            EPackageMap ePackageMap = MediatorFactory.getInstance().getUniverse().getEPackageMap(eClassMap.getEPackageName());
            if (ePackageMap == null) {
                throw new ExportException("Client Resource for EClassMap with export '" + string + "' in EPackage '" + eClassMap.getEPackageName() + "' not found.");
            }
            Resource resource = ePackageMap.getClientECoreResource();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            dataObject = EMFHelper.loadDataObject(byteArrayInputStream, (EPackage)resource.getContents().get(0));
        }
        catch (Exception exception) {
            throw new ExportException(exception.toString());
        }
        return dataObject;
    }
}

