/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.AlreadyOutputException;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.misc.IntWrapper;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PageContext {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _ModelName;
    protected String _SchemaExportName;
    protected HashMap _ExportedModelNames = new HashMap();
    protected boolean exportDateEDataType = false;
    protected int _SchemaExportCount = 0;
    protected int _DataExportCount = -1;
    protected ArrayList _ExportedSchemas = new ArrayList(10);
    protected IntWrapper _InstanceCount = new IntWrapper(0);
    protected HashMap _ExportedInstances = new HashMap(500);
    protected ArrayList _ArrayInstances = new ArrayList(20);
    protected int _ArrayInstanceIndex = -1;
    protected HashMap _ContextVariables = new HashMap();
    protected ArrayList _ExportedSchemaList = new ArrayList(10);
    protected int _TotalSchemasToExport = 0;
    protected boolean _DiffExported = false;

    public boolean isExportDateEDataType() {
        return this.exportDateEDataType;
    }

    public void setExportDateEDataType(boolean bl) {
        this.exportDateEDataType = bl;
    }

    public String getExportedModelName(String string) {
        return (String)this._ExportedModelNames.get(string);
    }

    public void addExportedModelName(String string, String string2) {
        this._ExportedModelNames.put(string, string2);
    }

    public String getSchemaExportName() {
        return this._SchemaExportName;
    }

    public void setSchemaExportName(String string) {
        this._SchemaExportName = string;
    }

    public void setModelName(String string) throws ExportException {
        if (this._SchemaExportCount != 0) {
            throw new ExportException("Trying to set a model name '" + string + "' in the middle of a model export '" + this._ModelName + "'. Model names can only be set before a model is exported.");
        }
        this._ModelName = string;
    }

    public String getLastModelName() {
        return this._ModelName;
    }

    public boolean isFirstSchemaExport() {
        return this._SchemaExportCount == 1;
    }

    public void ExportSchema(Writer writer, Mediator mediator, Object object) throws ExportException {
        if (this._ModelName == null) {
            throw new ExportException("Trying to export a model without a name. PageContext.setModel() was not called properly.");
        }
        ++this._SchemaExportCount;
        if (this.isFirstSchemaExport()) {
            this._SchemaExportName = this._ModelName;
        }
        mediator.Export(writer, this, object);
        --this._SchemaExportCount;
    }

    public boolean isFirstDataExport() {
        return this._DataExportCount == 0;
    }

    public void ExportData(Writer writer, Object object, String string, Mediator mediator, boolean bl) throws ExportException {
        ++this._DataExportCount;
        if (mediator == null) {
            throw new ExportException("Export called with a null Mediator !!!");
        }
        mediator.Export(writer, this, object, string, bl);
        --this._DataExportCount;
    }

    public void ExportXMILoader(Writer writer, Mediator mediator) throws ExportException {
        if (this._ModelName == null) {
            throw new ExportException("Trying to export a model without a name. PageContext.setModel() was not called properly.");
        }
        ++this._SchemaExportCount;
        mediator.ExportXMILoader(writer, this);
        --this._SchemaExportCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddSchemaExport(String string) {
        ArrayList arrayList = this._ExportedSchemas;
        synchronized (arrayList) {
            int n = 0;
            while (n < this._ExportedSchemas.size()) {
                String string2 = (String)this._ExportedSchemas.get(n);
                if (string.equals(string2)) {
                    return false;
                }
                ++n;
            }
            this._ExportedSchemas.add(string);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int NextInstanceCount() {
        IntWrapper intWrapper = this._InstanceCount;
        synchronized (intWrapper) {
            this._InstanceCount.increment();
            return this._InstanceCount.getValue();
        }
    }

    public String AddInstanceExport(Object object, Mediator mediator, boolean bl, String string) throws AlreadyOutputException {
        String string2 = mediator.getSignature(object, string, true, 0);
        String string3 = this.getInstanceExport(string2);
        if (string3 != null) {
            throw new AlreadyOutputException(string3);
        }
        string3 = (bl ? mediator._VarBaseName : "_") + this.NextInstanceCount();
        this._ExportedInstances.put(string2, string3);
        return string3;
    }

    public String getInstanceExport(Object object, Mediator mediator, String string) {
        return (String)this._ExportedInstances.get(mediator.getSignature(object, string, true, 0));
    }

    public String getInstanceExport(String string) {
        return (String)this._ExportedInstances.get(string);
    }

    public void PushArrayType(String string) {
        ArrayInstanceSpec arrayInstanceSpec;
        ++this._ArrayInstanceIndex;
        if (this._ArrayInstanceIndex >= this._ArrayInstances.size()) {
            this._ArrayInstances.add(null);
        }
        if ((arrayInstanceSpec = (ArrayInstanceSpec)this._ArrayInstances.get(this._ArrayInstanceIndex)) == null) {
            arrayInstanceSpec = new ArrayInstanceSpec(string);
            this._ArrayInstances.add(this._ArrayInstanceIndex, arrayInstanceSpec);
        } else {
            arrayInstanceSpec.Init(string);
        }
    }

    public void PushArrayVar(String string, String string2, String string3) throws ExportException {
        int n = this._ArrayInstanceIndex;
        while (n >= 0) {
            ArrayInstanceSpec arrayInstanceSpec = (ArrayInstanceSpec)this._ArrayInstances.get(n);
            if (arrayInstanceSpec._ElementType.equals(string)) {
                if (arrayInstanceSpec._ElementVar == null) {
                    arrayInstanceSpec._ElementVar = new StringBuffer(127);
                }
                arrayInstanceSpec._ElementVar.append(string3).append(string2);
                return;
            }
            --n;
        }
        throw new ExportException("Cannot find an array definition of type '" + string + "' to add the variable '" + string2 + "' to.");
    }

    public String PopArrayVar(String string) {
        int n = this._ArrayInstanceIndex;
        while (n >= 0) {
            ArrayInstanceSpec arrayInstanceSpec = (ArrayInstanceSpec)this._ArrayInstances.get(n);
            if (arrayInstanceSpec._ElementType.equals(string)) {
                --this._ArrayInstanceIndex;
                if (arrayInstanceSpec._ElementVar != null && arrayInstanceSpec._ElementVar.length() != 0) {
                    return arrayInstanceSpec._ElementVar.substring(1);
                }
                return "";
            }
            --n;
        }
        return null;
    }

    public Object addContextVariable(String string, Object object) {
        Object object2 = this._ContextVariables.put(string, object);
        return object2 != null ? this._ContextVariables.put(string, object2) : null;
    }

    public Object getContextVariable(String string) {
        return this._ContextVariables.get(string);
    }

    public Object RemoveContextVariable(String string) {
        return this._ContextVariables.remove(string);
    }

    public void addToExportedSchemaList(String string) {
        this._ExportedSchemaList.add(string);
        --this._TotalSchemasToExport;
    }

    public boolean isSchemaExported(String string) {
        return this._ExportedSchemaList.contains(string);
    }

    public Iterator getExportedSchemaListIterator() {
        return this._ExportedSchemaList.iterator();
    }

    public int getExportedSchemaCount() {
        return this._ExportedSchemaList.size();
    }

    public int getTotalSchemasToExport() {
        return this._TotalSchemasToExport;
    }

    public void setTotalSchemasToExport(int n) {
        this._TotalSchemasToExport = n;
    }

    public boolean isDiffExported() {
        return this._DiffExported;
    }

    public void setDiffExported(boolean bl) {
        this._DiffExported = bl;
    }

    protected static class ArrayInstanceSpec {
        public String _ElementType;
        public StringBuffer _ElementVar;

        public ArrayInstanceSpec(String string) {
            this.Init(string);
        }

        public void Init(String string) {
            this._ElementType = string;
            this._ElementVar = null;
        }
    }
}

