/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen;

import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.Streamer;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EcoreLoader {
    protected WDO4JSMappings _Universe;

    public EcoreLoader(WDO4JSMappings wDO4JSMappings) {
        this._Universe = wDO4JSMappings;
    }

    public boolean load(String string) {
        boolean bl = true;
        Resource resource = EMFHelper.getResourceFromStream(string);
        if (resource != null) {
            EPackage ePackage = (EPackage)resource.getContents().get(0);
            this._Universe.addEPackage(ePackage, true);
        } else {
            Streamer.error.Header().println(string + ": the ecore loading failed");
            bl = false;
        }
        return bl;
    }

    public boolean load(URI uRI) {
        boolean bl = true;
        try {
            EMFHelper.initSDO();
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = EMFHelper.load((ResourceSet)resourceSetImpl, uRI);
            EPackage ePackage = (EPackage)resource.getContents().get(0);
            this._Universe.addEPackage(ePackage, false);
        }
        catch (Exception exception) {
            Streamer.error.Header().println("ecore loading failed");
            Streamer.error.Header().printStackTrace(exception);
            return false;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "";
            try {
                string = stringArray[0];
            }
            catch (Exception exception) {
                System.out.println("Error parsing arguments!  No ecore filename found.");
                return;
            }
            URI uRI = URI.createFileURI((String)string);
            WDO4JSMappings wDO4JSMappings = new WDO4JSMappings();
            EcoreLoader ecoreLoader = new EcoreLoader(wDO4JSMappings);
            boolean bl = ecoreLoader.load(uRI);
            Streamer.status.Header().println("Finished loading ecore: OK=" + bl);
            Iterator iterator = wDO4JSMappings.getEClassesIterator();
            Streamer.status.Header().println("The following EClasses were added:");
            while (iterator.hasNext()) {
                Iterator iterator2;
                EClass eClass = (EClass)iterator.next();
                Streamer.status.Header().println(eClass.getEPackage().getName() + "`" + eClass.getName());
                Iterator iterator3 = eClass.getEAttributes().iterator();
                while (iterator3.hasNext()) {
                    iterator2 = (EAttribute)iterator3.next();
                    Streamer.status.Header().println("  - EAttribute: " + iterator2.getName());
                    Streamer.status.Header().println("         eType: " + iterator2.getEType());
                }
                iterator2 = eClass.getEReferences().iterator();
                while (iterator2.hasNext()) {
                    EReference eReference = (EReference)iterator2.next();
                    Streamer.status.Header().println("  - EReference: " + eReference.getName());
                    Streamer.status.Header().println("         eType: " + eReference.getEType());
                }
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Error loading ecore:");
            exception.printStackTrace();
        }
    }
}

