/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen;

import com.ibm.odcb.jrender.diff.DiffException;
import com.ibm.odcb.jrender.diff.generators.DiffHandlerGenerator;
import com.ibm.odcb.jrender.diff.generators.DiffProcessorGenerator;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.mediators.gen.generators.Generator;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Iterator;

public class MappingGen {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String getFileNameWithoutExtention(String string) {
        int n = string.lastIndexOf(".emap");
        int n2 = string.lastIndexOf(File.separatorChar, n);
        return string.substring(n2 + 1, n);
    }

    public boolean GenMediators(WDO4JSMappings wDO4JSMappings, String string, boolean bl) throws FileNotFoundException, ExportException, DiffException, ClassNotFoundException {
        Generator.Init();
        DiffHandlerGenerator diffHandlerGenerator = new DiffHandlerGenerator();
        DiffProcessorGenerator diffProcessorGenerator = new DiffProcessorGenerator();
        Iterator iterator = wDO4JSMappings.getEPackageMapsIterator();
        while (iterator.hasNext()) {
            EPackageMap ePackageMap = (EPackageMap)iterator.next();
            if (string != null && !string.equals(ePackageMap.getName())) continue;
            Streamer.status.Header().println("Generating mediators for EPackage '" + ePackageMap.getName() + "'.");
            Iterator iterator2 = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
            while (iterator2.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator2.next();
                Streamer.status.Header().println("Generating mediators for EClass '" + eClassMap.getJavaComplexName() + "'/'" + eClassMap.getExport() + "'.");
                String string2 = eClassMap.getXMLFileSource().substring(0, eClassMap.getXMLFileSource().lastIndexOf(".emap"));
                new File(string2).mkdir();
                String string3 = eClassMap.getSourceEmapName().substring(0, eClassMap.getSourceEmapName().lastIndexOf(".emap")).replace('/', '.');
                int n = 0;
                while (n < Generator.MEDIATOR_KEYS.length) {
                    Generator generator = Generator.getGenerator(Generator.MEDIATOR_KEYS[n]);
                    generator.genMediator(eClassMap, string2, string3, bl);
                    ++n;
                }
                if (ePackageMap.getRootEClassMap() != null) {
                    diffHandlerGenerator.gen(ePackageMap.getRootEClassMapTransformed(), eClassMap, string2, string3);
                    diffProcessorGenerator.gen(ePackageMap, string2, string3);
                    continue;
                }
                Streamer.warning.Header().println("RootEClass was not found for EPackage " + ePackageMap.getName() + ".  DiffHandlers will not be generated for this EPackage.  To generate Diffhandlers, add the \"root_eclass_name\" property to the EMap file, then regenerate Mediators.");
            }
        }
        return true;
    }
}

