/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen;

import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.EcoreLoader;
import com.ibm.odcb.jrender.mediators.gen.MappingGen;
import com.ibm.odcb.jrender.mediators.gen.MappingsParser;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.mediators.gen.generators.ClientECoreGenerator;
import com.ibm.odcb.jrender.mediators.gen.generators.Generator;
import com.ibm.odcb.jrender.misc.CompilerUtil;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class MappingsCompiler {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected MappingGen _G;
    protected WDO4JSMappings _Universe = new WDO4JSMappings();
    protected EcoreLoader _ELoader;
    protected MappingsParser _Xml;
    protected boolean _VerificationStatus = false;
    protected boolean _GenerationStatus = false;
    protected boolean _ComplilationStatus = false;
    protected String _BaseSourcePath;
    protected String _BaseBuildPath;
    protected String _CompilerCommandLine;

    public boolean cacheClientEcores() {
        Streamer.status.println().Header().println("Caching Client Ecore Resources");
        try {
            Iterator iterator = this._Universe.getEPackageMapsIterator();
            while (iterator.hasNext()) {
                EPackageMap ePackageMap = (EPackageMap)iterator.next();
                Iterator iterator2 = this._Universe.getEClassMapsForEPackageIterator(ePackageMap.getName());
                String string = null;
                InputStream inputStream = null;
                if (!iterator2.hasNext()) continue;
                EClassMap eClassMap = (EClassMap)iterator2.next();
                string = eClassMap.getClientEcoreName();
                inputStream = ODCClassLoader.getResourceAsStream(string);
                MappingsCompiler.cacheClientEcore(ePackageMap, string, inputStream, this._Universe);
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Caching of Some Client Ecore Resources Failed");
            Streamer.error.Header().printStackTrace(exception);
            return false;
        }
        Streamer.status.println().Header().println("Finished Caching Client Ecore Resources");
        return true;
    }

    public boolean createClientEcores() {
        boolean bl = true;
        Streamer.status.println().Header().println("Generating Client Ecore Files");
        Iterator iterator = this._Universe.getEPackageMapsIterator();
        while (iterator.hasNext()) {
            PrintWriter printWriter = null;
            EPackageMap ePackageMap = (EPackageMap)iterator.next();
            String string = null;
            try {
                Iterator iterator2 = this._Universe.getEClassMapsForEPackageIterator(ePackageMap.getName());
                if (iterator2.hasNext()) {
                    EClassMap eClassMap = (EClassMap)iterator2.next();
                    string = eClassMap.getClientEcoreName();
                    String string2 = MappingsCompiler.MakeFullPathForResource(this._BaseSourcePath, string);
                    File file = new File(string2);
                    new File(file.getParent()).mkdir();
                    printWriter = new PrintWriter(new FileOutputStream(file));
                    Streamer.debug.Header().println("Generating file " + string2);
                    String string3 = MappingsCompiler.createClientEcore(ePackageMap);
                    printWriter.write(string3);
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                bl = this.copyClientEcoreToBuildPath(string);
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                bl = false;
                Streamer.error.Header().println("Some client Ecore File generation failed");
                Streamer.error.Header().printStackTrace(exception);
            }
        }
        Streamer.status.Header().println("Finished Generating Client Ecore Files");
        return bl;
    }

    public MappingsCompiler(String string, String string2, String string3) {
        this._BaseSourcePath = string;
        this._BaseBuildPath = string2;
        this._CompilerCommandLine = string3;
    }

    public boolean init() {
        this._G = new MappingGen();
        this._Xml = new MappingsParser(this._Universe);
        this._ELoader = new EcoreLoader(this._Universe);
        return true;
    }

    public WDO4JSMappings getUniverse() {
        return this._Universe;
    }

    public boolean PrepareTheUniverse() throws Exception {
        boolean bl = true;
        bl = this.loadEcores();
        bl = this.parseMappings();
        return bl;
    }

    public boolean loadEcores() throws Exception {
        boolean bl = true;
        String string = Config.getString(Config.PROP_ECORE_FILES);
        if (string == null || string.length() == 0) {
            Streamer.warning.Header().println("The config property: ECORE_FILES_PROPERTY is either not set or does not contain any ecore file names");
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().replace('\\', '/');
            if (!string2.endsWith(".ecore")) {
                String string3 = "The resource '" + string2 + "' listed in the ECORE_FILES property is not a proper ecore file. It does not end in '.ecore'.";
                Streamer.error.Header().println(string3);
                throw new Exception(string3);
            }
            bl = this._ELoader.load(string2);
        }
        Streamer.status.Header().println("All .ecore files were processed.");
        if (!bl) {
            Streamer.error.Header().println("Some .ecore files failed.");
        }
        return bl;
    }

    public boolean parseMappings() throws Exception {
        boolean bl = true;
        String string = Config.getString(Config.PROP_EMAP_FILES);
        if (string == null || string.length() == 0) {
            Streamer.warning.Header().println("The config property: EMAP_FILES_PROPERTY is either not set or does not contain any emap file names");
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().replace('\\', '/');
            if (!string2.endsWith(".emap")) {
                object = "The resource '" + string2 + "' listed in the EMAP_FILES property is not a proper emap file. It does not end in '.emap'.";
                Streamer.error.Header().println((String)object);
                throw new Exception((String)object);
            }
            object = ODCClassLoader.getResourceAsStream(string2);
            if (object != null) {
                Streamer.status.Header().println("Parsing EMap file: " + string2);
                this._Xml.setXmlFileSource(MappingsCompiler.MakeFullPathForResource(this._BaseSourcePath, string2));
                this._Xml.setSourceEmapName(string2);
                bl = this._Xml.parse((InputStream)object);
                Streamer.status.Header().println("Finished Parsing EMap file: " + string2 + (bl ? " without any errors" : ".  There were some errors."));
                ((InputStream)object).close();
                continue;
            }
            Streamer.error.Header().println("Error while getting InputStream for '" + string2 + "'.  Please make sure that the file name and location is correct and the file exists.  The filename is case sensitive.");
        }
        Streamer.status.Header().println("All .emap files were processed.");
        if (!bl) {
            Streamer.error.Header().println("Some .emap files failed.");
        }
        return bl;
    }

    public boolean VerifyTheUniverse() throws Exception {
        this._VerificationStatus = false;
        if (!this._Universe.Verify()) {
            Streamer.error.println().Header().println("Some Ecore/Mappings failed verification.");
        } else {
            this._VerificationStatus = true;
        }
        return this._VerificationStatus;
    }

    public boolean getVerificationStatus() {
        return this._VerificationStatus;
    }

    public boolean CompileTheUniverse(boolean bl, String string, boolean bl2) throws Exception {
        this._GenerationStatus = false;
        this._ComplilationStatus = false;
        Streamer.status.println().Header().println("Generating mediators now.");
        if (!this._G.GenMediators(this._Universe, string, bl2)) {
            Streamer.error.Header().println("Some generations failed.");
            return false;
        }
        this._GenerationStatus = true;
        if (!bl) {
            Streamer.status.println().Header().println("Skipping the compilation phase. Mediators have been generated, but not compiled.");
            return true;
        }
        Iterator iterator = this._Universe.getEClassMapsIterator();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Streamer.status.println().Header().println("Compiling the mediators now.");
        while (iterator.hasNext()) {
            String[] stringArray;
            EClassMap eClassMap = (EClassMap)iterator.next();
            String string2 = eClassMap.getXMLFileSource();
            if (string2 == null || string2.trim().length() == 0) {
                Streamer.error.Header().println("Could not obtain the XMLFileSource of EClassMap '" + eClassMap.getExport() + "'");
                return false;
            }
            if (hashMap.put(string2 = string2.substring(0, string2.lastIndexOf(".emap")), string2) != null || CompilerUtil.Compile(string2, this._BaseBuildPath, stringArray = new String[]{"*.java"}, this._CompilerCommandLine)) continue;
            Streamer.error.Header().println("Could not compile the generated mediators in " + stringArray[0]).Header().println("This is a severe error!");
            return false;
        }
        this._ComplilationStatus = true;
        return true;
    }

    public boolean getGenerationStatus() {
        return this._GenerationStatus;
    }

    public boolean getCompilationStatus() {
        return this._ComplilationStatus;
    }

    public HashMap GetMediators() {
        Streamer.status.println().Header().println("Instanciating the WDO4JS mediators");
        HashMap<String, Mediator> hashMap = new HashMap<String, Mediator>(57);
        Iterator iterator = this._Universe.getEClassMapsIterator();
        while (iterator.hasNext()) {
            EClassMap eClassMap = (EClassMap)iterator.next();
            String string = null;
            String string2 = null;
            try {
                int n = 0;
                while (n < Generator.MEDIATOR_KEYS.length) {
                    string2 = MediatorFactory.GenTypeKey(eClassMap.getJavaComplexName(), Generator.GENS[n].getIdentifier());
                    String string3 = eClassMap.getClientEcoreName();
                    string3 = string3.substring(0, string3.lastIndexOf("/")).replace('/', '.');
                    string = string3 + "." + eClassMap.getEPackageName() + "_" + eClassMap.getExport() + Generator.GENS[n].getIdentifier();
                    Object object = ODCClassLoader.getClassInstance(string);
                    Streamer.debug.Header().println(object.getClass().getName());
                    Mediator mediator = (Mediator)ODCClassLoader.getClassInstance(string);
                    Streamer.debug.Header().println("Adding a mediator '" + string + "' for Key '" + string2 + "'.");
                    hashMap.put(string2, mediator);
                    ++n;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Streamer.warning.Header().println("Cannot create an instance of the WDO4JS Mediator '" + string + "' for Key '" + string2 + "'.");
            }
            catch (Exception exception) {
                Streamer.error.Header().println("Cannot create an instance of the WDO4JS Mediator for '" + string + "'.");
                Streamer.error.Header().printStackTrace(exception);
            }
        }
        return hashMap;
    }

    public static String createClientEcore(EPackageMap ePackageMap) {
        StringBuffer stringBuffer = new StringBuffer();
        Streamer.status.println().Header().println("Generating Client Ecore String");
        String string = null;
        try {
            boolean bl = true;
            Iterator iterator = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
            while (iterator.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator.next();
                if (bl) {
                    string = eClassMap.getClientEcoreName();
                    Streamer.debug.Header().println("Generating Client Ecore: " + string);
                    ClientECoreGenerator.genIntro(stringBuffer, eClassMap, "", "\n", "\"");
                    ClientECoreGenerator.genDateEDataType(stringBuffer, "", "\n", "\"", "WDODate");
                    bl = false;
                }
                ClientECoreGenerator.genEClassifier(stringBuffer, eClassMap, "", "\n", "\"");
            }
            iterator = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
            ClientECoreGenerator.genOutro(stringBuffer, iterator, "", "\n", "\"");
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Client Ecore String generation failed");
            Streamer.error.Header().printStackTrace(exception);
        }
        Streamer.status.Header().println("Finished Generating Client Ecore String");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean copyClientEcoreToBuildPath(String string) {
        block15: {
            String string2;
            String string3;
            if (string != null && !(string3 = MappingsCompiler.MakeFullPathForResource(this._BaseSourcePath, string)).equals(string2 = MappingsCompiler.MakeFullPathForResource(this._BaseBuildPath, string))) {
                Streamer.debug.Header().println("Copying client ecore file '" + string3 + "' to build path '" + string2 + "'");
                String string4 = EMFHelper.ReadFileIntoString(string3);
                FileWriter fileWriter = null;
                fileWriter = new FileWriter(string2);
                fileWriter.write(string4);
                fileWriter.close();
                Object var9_6 = null;
                try {
                    if (fileWriter != null) {
                        fileWriter.close();
                    }
                    break block15;
                }
                catch (IOException iOException) {}
                break block15;
                {
                    catch (IOException iOException) {
                        try {
                            if (fileWriter != null) {
                                fileWriter.close();
                            }
                        }
                        catch (IOException iOException2) {
                        }
                        Object var9_7 = null;
                        try {
                            if (fileWriter != null) {
                                fileWriter.close();
                            }
                            break block15;
                        }
                        catch (IOException iOException3) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return true;
    }

    public static boolean cacheClientEcore(EPackageMap ePackageMap, String string, InputStream inputStream, WDO4JSMappings wDO4JSMappings) {
        Streamer.status.println().Header().println("Caching Client Ecore Resource: " + string);
        try {
            if (inputStream == null) {
                Streamer.error.Header().println("Input Stream for resource '" + string + "' is null");
                return false;
            }
            Resource resource = EMFHelper.getResource(inputStream, URI.createURI((String)string));
            Streamer.status.println().Header().println("Got Resource for Client Ecore '" + string + "': " + resource);
            if (resource == null) {
                Streamer.error.Header().println("Loading of Client Ecore Resource'" + string + "' Failed.  The Resource is NULL.");
                return false;
            }
            Streamer.status.println().Header().println("Caching Client Ecore Resource '" + string + "'");
            EMFHelper.initPackagesForDataObject(resource);
            ePackageMap.setClientECoreResource(resource);
            wDO4JSMappings.addClientEcoreResource(resource);
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Caching of Client Ecore Resource for '" + string + "' Failed");
            Streamer.error.Header().printStackTrace(exception);
            return false;
        }
        Streamer.status.println().Header().println("Finished Caching Client Ecore Resources");
        return true;
    }

    public static String MakeFullPathForResource(String string, String string2) {
        if (string == null) {
            string = File.separator;
        } else if (!(string = string.replace(File.separatorChar == '\\' ? (char)'/' : '\\', File.separatorChar)).endsWith(File.separator)) {
            string = string + File.separatorChar;
        }
        return string + string2.replace(File.separatorChar == '\\' ? (char)'/' : '\\', File.separatorChar);
    }

    protected static class DiffFileFilter
    implements FileFilter {
        protected DiffFileFilter() {
        }

        public boolean accept(File file) {
            return file.getPath().endsWith(".diff");
        }
    }

    protected static class EcoreFileFilter
    implements FileFilter {
        protected EcoreFileFilter() {
        }

        public boolean accept(File file) {
            return file.getPath().endsWith(".ecore");
        }
    }

    protected static class Toto
    implements FileFilter {
        protected Toto() {
        }

        public boolean accept(File file) {
            return file.getPath().endsWith(".emap");
        }
    }
}

