/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen;

import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.IntWrapper;
import com.ibm.odcb.jrender.misc.Streamer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class WDO4JSMappings {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Map _EPackagesByNames = new HashMap(7);
    protected Map _EPackageMapsByName = new HashMap(7);
    protected Map _EClassesByEPackageAndEClassNames = new HashMap(7);
    protected Map _EClassMapsByExport = new HashMap(7);
    protected Map _EClassMapsByJavaComplexName = new HashMap(7);
    protected Map _EClassMapsByECoreComplexName = new HashMap(7);
    protected IntWrapper _Error = new IntWrapper(0);
    protected ResourceSet clientEcoreResSet = new ResourceSetImpl();
    protected static final String _ESEPARATOR = "`";

    public int getError() {
        return this._Error.getValue();
    }

    public EClassMap getEClassMapByExport(String string) {
        return (EClassMap)this._EClassMapsByExport.get(string);
    }

    public EClassMap getEClassMapByJavaComplexName(String string) {
        return (EClassMap)this._EClassMapsByJavaComplexName.get(string);
    }

    public EClassMap getEClassMapByJavaComplexName(String string, String string2) {
        return this.getEClassMapByJavaComplexName(EClassMap.MakeComplexName(string, string2));
    }

    public EClassMap getEClassMapByEPackageAndECoreComplexName(String string, String string2) {
        return (EClassMap)this._EClassMapsByECoreComplexName.get(WDO4JSMappings.MakeMapName(string, string2));
    }

    public EClassMap getEClassMapByEPackageAndECoreComplexName(String string, String string2, String string3) {
        return this.getEClassMapByEPackageAndECoreComplexName(string, EClassMap.MakeComplexName(string2, string3));
    }

    public EClassifier getEClassifier(String string, String string2) {
        return (EClassifier)this._EClassesByEPackageAndEClassNames.get(WDO4JSMappings.MakeMapName(string, string2));
    }

    public EPackageMap getEPackageMap(String string) {
        return (EPackageMap)this._EPackageMapsByName.get(string);
    }

    public Iterator getEClassMapsForEPackageIterator(String string) {
        EPackageMap ePackageMap = (EPackageMap)this._EPackageMapsByName.get(string);
        return ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
    }

    public Iterator getEClassMapsIterator() {
        return this._EClassMapsByJavaComplexName.values().iterator();
    }

    public Iterator getEPackageMapsIterator() {
        return this._EPackageMapsByName.values().iterator();
    }

    public Iterator getEClassesIterator() {
        return this._EClassesByEPackageAndEClassNames.values().iterator();
    }

    public Iterator getEPackagesIterator() {
        return this._EPackagesByNames.values().iterator();
    }

    public boolean addEPackage(EPackage ePackage, boolean bl) {
        EPackage ePackage2 = (EPackage)this._EPackagesByNames.get(ePackage.getName());
        if (ePackage2 != null) {
            if (!bl) {
                Streamer.error.Header().println("EPackage '" + ePackage.getName() + "' already exists. Cannot add.");
                return false;
            }
            this.removeEPackageMap(ePackage2.getName());
        }
        this._EPackagesByNames.put(ePackage.getName(), ePackage);
        Iterator iterator = ePackage.getEClassifiers().iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            if (this.addEClass(eClass, bl)) continue;
            this.removeEPackage(ePackage.getName());
            return false;
        }
        return true;
    }

    public boolean addEClass(EClass eClass, boolean bl) {
        EClass eClass2 = (EClass)this._EClassesByEPackageAndEClassNames.get(WDO4JSMappings.MakeMapName((EClassifier)eClass));
        if (eClass2 != null && !bl) {
            Streamer.error.Header().println("Adding an EClass with a duplicate Complex name '" + WDO4JSMappings.MakeMapName((EClassifier)eClass) + "'.");
            return false;
        }
        this._EClassesByEPackageAndEClassNames.put(WDO4JSMappings.MakeMapName((EClassifier)eClass), eClass);
        return true;
    }

    public boolean addEPackageMap(EPackageMap ePackageMap, boolean bl) {
        EPackageMap ePackageMap2 = (EPackageMap)this._EPackageMapsByName.get(ePackageMap.getName());
        if (ePackageMap2 != null) {
            if (!bl) {
                Streamer.error.Header().println("EPackageMap '" + ePackageMap.getName() + "' already exists. Cannot add.");
                return false;
            }
            this.removeEPackageMap(ePackageMap2.getName());
        }
        this._EPackageMapsByName.put(ePackageMap.getName(), ePackageMap);
        ePackageMap.setUniverse(this);
        Iterator iterator = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
        while (iterator.hasNext()) {
            EClassMap eClassMap = (EClassMap)iterator.next();
            if (this.addEClassMap(eClassMap, bl)) continue;
            this.removeEPackageMap(ePackageMap.getName());
            return false;
        }
        return true;
    }

    public boolean addEClassMap(EPackageMap ePackageMap, EClassMap eClassMap, boolean bl) {
        if (!eClassMap.getEPackageName().equals(ePackageMap.getName())) {
            Streamer.error.Header().println("Adding EClassMap '" + eClassMap.getJavaComplexName() + "' to EPackageMap '" + ePackageMap.getName() + "', but EClassMap is from EPackageMap '" + eClassMap.getEPackageName() + ".");
            return false;
        }
        EClassMap eClassMap2 = (EClassMap)ePackageMap.getEClassMapsByJavaComplexName().get(eClassMap.getJavaComplexName());
        if (eClassMap2 != null && !bl) {
            Streamer.error.Header().println("Adding an EClassMap '" + eClassMap.getJavaComplexName() + "' that already exists in EPackageMap '" + ePackageMap.getName() + "'.");
            return false;
        }
        ePackageMap.getEClassMapsByJavaComplexName().put(eClassMap.getJavaComplexName(), eClassMap);
        return this.addEClassMap(eClassMap, bl);
    }

    public boolean addEClassMap(EClassMap eClassMap, boolean bl) {
        EClassMap eClassMap2 = (EClassMap)this._EClassMapsByExport.get(eClassMap.getExport());
        if (eClassMap2 != null && !bl) {
            Streamer.error.Header().println("Adding a mapping with a duplicate Export name '" + eClassMap.getExport() + "'.");
            return false;
        }
        this._EClassMapsByExport.put(eClassMap.getExport(), eClassMap);
        eClassMap2 = (EClassMap)this._EClassMapsByJavaComplexName.get(eClassMap.getJavaComplexName());
        if (eClassMap2 != null && !bl) {
            Streamer.error.Header().println("Adding a mapping with a duplicate Complex Java name '" + eClassMap.getJavaComplexName() + "'.");
            return false;
        }
        this._EClassMapsByJavaComplexName.put(eClassMap.getJavaComplexName(), eClassMap);
        String string = WDO4JSMappings.MakeMapName(eClassMap.getEPackageName(), eClassMap.getECoreComplexName());
        eClassMap2 = (EClassMap)this._EClassMapsByECoreComplexName.get(string);
        if (eClassMap2 != null && !bl) {
            Streamer.error.Header().println("Adding a mapping with a duplicate Complex ECore name '" + string + "'.");
            return false;
        }
        this._EClassMapsByECoreComplexName.put(string, eClassMap);
        eClassMap.setUniverse(this);
        return true;
    }

    public void removeEPackage(String string) {
        EPackage ePackage = (EPackage)this._EPackagesByNames.remove(string);
        if (ePackage != null) {
            Iterator iterator = ePackage.getEClassifiers().iterator();
            while (iterator.hasNext()) {
                EClass eClass = (EClass)iterator.next();
                this.removeEClass(eClass);
            }
        }
    }

    public void removeEClass(EClass eClass) {
        this._EClassesByEPackageAndEClassNames.remove(WDO4JSMappings.MakeMapName((EClassifier)eClass));
    }

    public void removeEPackageMap(String string) {
        EPackageMap ePackageMap = (EPackageMap)this._EPackageMapsByName.remove(string);
        if (ePackageMap != null) {
            Iterator iterator = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
            while (iterator.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator.next();
                this.removeEClassMap(ePackageMap, eClassMap);
            }
        }
    }

    public void removeEClassMap(EClassMap eClassMap) {
        EPackageMap ePackageMap = (EPackageMap)this._EPackageMapsByName.get(eClassMap.getEPackageName());
        this.removeEClassMap(ePackageMap, eClassMap);
    }

    protected void removeEClassMap(EPackageMap ePackageMap, EClassMap eClassMap) {
        ePackageMap.getEClassMapsByJavaComplexName().remove(eClassMap.getJavaComplexName());
        this._EClassMapsByExport.remove(eClassMap.getExport());
        this._EClassMapsByJavaComplexName.remove(eClassMap.getJavaComplexName());
        this._EClassMapsByECoreComplexName.remove(WDO4JSMappings.MakeMapName(eClassMap.getEPackageName(), eClassMap.getECoreComplexName()));
        this.removeEClass(eClassMap.getEClass());
    }

    public void PrintEClassMapByEcoreName() {
        Streamer.debug.Header().println("Printing the list of EClasses in the ECoreName map");
        Iterator iterator = this._EPackageMapsByName.values().iterator();
        while (iterator.hasNext()) {
            EPackageMap ePackageMap = (EPackageMap)iterator.next();
            Streamer.debug.Header().println("EPackageMap: " + ePackageMap.getName());
            Iterator iterator2 = ePackageMap.getEClassMapsByJavaComplexName().values().iterator();
            while (iterator2.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator2.next();
                Streamer.debug.Header().println("   EClassMap: " + eClassMap.getJavaComplexName() + " / " + eClassMap.getECoreComplexName() + " / " + eClassMap.getExport());
            }
        }
    }

    public boolean Verify() {
        boolean bl = true;
        Iterator iterator = this._EPackageMapsByName.values().iterator();
        while (iterator.hasNext()) {
            EPackageMap ePackageMap = (EPackageMap)iterator.next();
            Streamer.status.println().Header().println("Verifying Mappings for EPackage " + ePackageMap.getName() + ".");
            if (ePackageMap.Verify(this._Error)) continue;
            Streamer.error.Header().println("Mappings for " + ePackageMap.getName() + " failed verification.");
            bl = false;
        }
        if (!bl) {
            Streamer.error.println().Header().println("The universe verification failed with " + this._Error.getValue() + " errors.");
        }
        return bl;
    }

    public static String MakeMapName(EClassifier eClassifier) {
        return WDO4JSMappings.MakeMapName(eClassifier.getEPackage().getName(), eClassifier.getName());
    }

    public static String MakeMapName(String string, String string2) {
        return string + _ESEPARATOR + string2;
    }

    public ResourceSet getClientEcoreResSet() {
        return this.clientEcoreResSet;
    }

    public void setClientEcoreResSet(ResourceSet resourceSet) {
        this.clientEcoreResSet = resourceSet;
    }

    public void addClientEcoreResource(Resource resource) {
        this.clientEcoreResSet.getResources().add((Object)resource);
    }
}

