/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen.generators;

import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.StringUtil;
import com.ibm.odcb.jrender.misc.TypesUtil;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;

public class FeatureExporter {
    protected EClassMap eClassMap;
    protected Object data;
    protected String eAttributesSchema = "";
    protected String eReferencesSchema = "";
    protected String eAttributesData;
    protected String eReferencesData;
    protected HashMap referenceTypes;
    protected final int MEDIATOR_DEBUG_MODE = Config.getInteger(Config.PROP_MEDIATOR_DEBUG_MODE);
    protected final String HEADER = this.MEDIATOR_DEBUG_MODE == 1 ? "\n                +\"\\n    ," : "\n                +\",";

    public FeatureExporter(EClassMap eClassMap) {
        this.eClassMap = eClassMap;
    }

    public FeatureExporter(EClassMap eClassMap, Object object) {
        this.eClassMap = eClassMap;
        this.data = object;
    }

    public void createSchemaString() {
        Iterator iterator = this.eClassMap.getEFeatureMapIterator();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("[[\"xmi:id\",\"id\",0]");
        StringBuffer stringBuffer2 = new StringBuffer(128);
        this.referenceTypes = new HashMap(17);
        while (iterator.hasNext()) {
            EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
            if (eFeatureMap.isCalculateAttribute()) {
                stringBuffer.append(",[\"" + eFeatureMap.getExport() + "\",\"" + eFeatureMap.getCalculatedType() + "\",1," + StringUtil.QuoteDoubleAndEscape(eFeatureMap.getCalculateExpression(), true) + "," + (eFeatureMap.isID() ? 1 : 0) + "]");
                continue;
            }
            String string = TypesUtil.getSimplifiedTypeFromJavaType(eFeatureMap.getGetterType());
            Streamer.debug.Header().println("Found type '" + string + "' for '" + eFeatureMap.getGetter() + "' from '" + this.eClassMap.getExport() + "'.");
            if (string != null) {
                stringBuffer.append(",[\"" + eFeatureMap.getExport() + "\",\"" + string + "\",0," + (eFeatureMap.getEFeature() == null ? 0 : eFeatureMap.getEFeature().getLowerBound()) + "," + (eFeatureMap.getEFeature() == null ? 1 : eFeatureMap.getEFeature().getUpperBound()) + "," + (eFeatureMap.isID() ? 1 : 0) + "]");
                continue;
            }
            EClassMap eClassMap = eFeatureMap.getReferenceMap();
            if (eClassMap != null) {
                this.referenceTypes.put(eClassMap, eFeatureMap);
                stringBuffer2.append(",[\"" + eFeatureMap.getExport() + "\"," + eClassMap.getExport() + "Class," + (eFeatureMap.getEFeature() == null ? 0 : eFeatureMap.getEFeature().getLowerBound()) + "," + (eFeatureMap.getEFeature() == null ? 1 : eFeatureMap.getEFeature().getUpperBound()) + "," + (eFeatureMap.isContainment() ? 1 : 0) + "," + (eFeatureMap.isID() ? 1 : 0) + "]");
                continue;
            }
            boolean bl = true;
            EClassifier eClassifier = eFeatureMap.getEFeature().getEType();
            if (eClassifier instanceof EDataType && (string = TypesUtil.getSimplifiedTypeFromJavaType(eFeatureMap.getGetterType())) != null && string.equals("date")) {
                stringBuffer.append(",[\"" + eFeatureMap.getExport() + "\",\"" + string + "\",0," + (eFeatureMap.getEFeature() == null ? 0 : eFeatureMap.getEFeature().getLowerBound()) + "," + (eFeatureMap.getEFeature() == null ? 1 : eFeatureMap.getEFeature().getUpperBound()) + "," + (eFeatureMap.isID() ? 1 : 0) + "]");
                bl = false;
            }
            if (!bl) continue;
            stringBuffer.append(",[\"" + eFeatureMap.getExport() + "\",\"" + "string" + "\",0," + (eFeatureMap.getEFeature() == null ? 0 : eFeatureMap.getEFeature().getLowerBound()) + "," + (eFeatureMap.getEFeature() == null ? 1 : eFeatureMap.getEFeature().getUpperBound()) + "," + (eFeatureMap.isID() ? 1 : 0) + "]");
        }
        this.eAttributesSchema = "A(" + this.eClassMap.getExport() + "Class," + stringBuffer.toString() + "]);\n";
        if (stringBuffer2.length() != 0) {
            stringBuffer2.setCharAt(0, '[');
            this.eReferencesSchema = "R(" + this.eClassMap.getExport() + "Class," + stringBuffer2.toString() + "]);\n";
        }
    }

    public static void main(String[] stringArray) {
    }

    public String getEAttributesSchema() {
        return this.eAttributesSchema;
    }

    public String getEReferencesSchema() {
        return this.eReferencesSchema;
    }

    public HashMap getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setEAttributesSchema(String string) {
        this.eAttributesSchema = string;
    }

    public void setEReferencesSchema(String string) {
        this.eReferencesSchema = string;
    }

    public void setReferenceTypes(HashMap hashMap) {
        this.referenceTypes = hashMap;
    }

    public Object getData() {
        return this.data;
    }

    public EClassMap getEClassMap() {
        return this.eClassMap;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public void setEClassMap(EClassMap eClassMap) {
        this.eClassMap = eClassMap;
    }
}

