/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.Streamer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class AsynchBufferedInputStream
extends Thread {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected BufferedInputStream _In;
    protected OutputStream _Out;
    protected final int _SleepTime;
    protected final int _BufferSize;

    public AsynchBufferedInputStream(int n, int n2) {
        this._SleepTime = n;
        this._BufferSize = n2;
    }

    public void Init(BufferedInputStream bufferedInputStream, OutputStream outputStream) {
        this._In = bufferedInputStream;
        this._Out = outputStream;
    }

    public void run() {
        Streamer.StartThread();
        Streamer.debug.Header().println("AsynchBufferedInputStream starting");
        byte[] byArray = new byte[this._BufferSize];
        try {
            int n;
            while ((n = this._In.read(byArray, 0, this._BufferSize)) != -1) {
                this._Out.write(byArray, 0, n);
                try {
                    Streamer.trace.Header().print("AsynchBufferedInputStream read ").print(this._BufferSize).print(" bytes: ").printSubstring(byArray, 0, this._BufferSize);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
                Thread.sleep(this._SleepTime);
            }
        }
        catch (InterruptedException interruptedException) {
            Streamer.error.Header().printStackTrace(interruptedException);
        }
        catch (IOException iOException) {
            Streamer.error.Header().printStackTrace(iOException);
        }
        Streamer.debug.Header().println("AsynchBufferedInputStream ending");
        Streamer.EndThread();
    }
}

