/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.StringUtil;
import com.ibm.odcb.jrender.misc.TypesUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassGraphWalker {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public String _RootClassName;
    public Map _Mappings;
    public Map _IncludesExcludes;
    public boolean _Include;
    public Map _VisitedClasses = new HashMap(17);
    public Walker _W;
    public int _Level;
    public static final String CLASS_FLAG = "C";
    public static final String PROPERTY_FLAG = "P";
    static /* synthetic */ Class class$java$lang$Object;

    public ClassGraphWalker(String string, Map map, boolean bl, Map map2) {
        this._RootClassName = string;
        this._Mappings = map;
        this._Include = bl;
        this._IncludesExcludes = map2;
        if (this._IncludesExcludes == null) {
            this._IncludesExcludes = new HashMap();
            this._Include = false;
        } else if (this._IncludesExcludes.size() == 0 && this._Include) {
            this._Include = false;
        }
    }

    public void Walk(Walker walker) throws Exception {
        this._W = walker;
        Class clazz = ODCClassLoader.getClass(this._RootClassName);
        this._W.Begin(clazz);
        this.WalkInternal(this._RootClassName.substring(this._RootClassName.lastIndexOf(46) + 1), clazz, 0);
        this._W.End(clazz);
    }

    public final boolean isIn(String string, String string2) {
        boolean bl;
        String string3 = (String)this._IncludesExcludes.get(string);
        boolean bl2 = bl = string3 != null && string3.equals(string2);
        return this._Include ? bl : !bl;
    }

    public boolean WalkInternal(String string, Class clazz, int n) throws Exception {
        if (!this.isIn(clazz.getName(), CLASS_FLAG)) {
            Streamer.debug.Header().println("Class " + clazz.getName() + " is excluded from the ECore.");
            return false;
        }
        if (this._VisitedClasses.put(clazz.getName(), clazz) != null) {
            return true;
        }
        if (this._VisitedClasses.put("!!!" + clazz.getName(), clazz) != null) {
            return false;
        }
        this._W.ProcessClassBegin(string, clazz, n);
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        boolean bl = false;
        int n2 = 0;
        while (n2 < propertyDescriptorArray.length) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (propertyDescriptor.getPropertyType() != null) {
                bl = this.ProcessProperty(propertyDescriptor.getName(), propertyDescriptor.getPropertyType().getName(), propertyDescriptor.getWriteMethod() == null, bl, string, n, clazz);
            }
            ++n2;
        }
        if (!this._W.ProcessClassEnd(string, clazz, bl, n)) {
            this._VisitedClasses.remove(clazz.getName());
            this._VisitedClasses.put("!!!" + clazz.getName(), clazz);
            return false;
        }
        return true;
    }

    public boolean ProcessProperty(String string, String string2, boolean bl, boolean bl2, String string3, int n, Class clazz) throws Exception {
        if (!TypesUtil.isValidProperty(string)) {
            return bl2;
        }
        if (!this.isIn(string2, CLASS_FLAG)) {
            Streamer.debug.Header().println("Class " + string2 + " is excluded from the ECore.");
            return bl2;
        }
        String string4 = clazz.getName() + "." + string;
        if (!this.isIn(string4, PROPERTY_FLAG)) {
            Streamer.debug.Header().println("Property " + string4 + " is excluded from the ECore.");
            return bl2;
        }
        if (TypesUtil.isBasicJavaType(string2)) {
            if (this._W.ProcessBasicProperty(string3 + '.' + string, clazz, string, string2, false, bl, n)) {
                bl2 = true;
            }
        } else if (TypesUtil.isArrayOfBasicJavaType(string2)) {
            if ((string2 = TypesUtil.getJavaTypeFromArrayType(string2)) != null && this._W.ProcessBasicProperty(string3 + '.' + string, clazz, string, string2, true, bl, n)) {
                bl2 = true;
            }
        } else if (TypesUtil.isArrayOfNonPrimitiveJavaType(string2)) {
            string2 = string2.substring(2, string2.length() - 1);
            boolean bl3 = this.WalkInternal(string3 + '.' + string, ODCClassLoader.getClass(string2), n + 1);
            if (this._W.ProcessComplexProperty(string3 + '.' + string, clazz, string, string2, true, bl, bl3, n)) {
                bl2 = true;
            }
        } else if (TypesUtil.isJavaObjectType(string2, true)) {
            String string5 = (String)this._Mappings.get(string4);
            if (string5 != null && !TypesUtil.isJavaObjectType(string5, true)) {
                bl2 = this.ProcessProperty(string, string2.equals((class$java$lang$Object == null ? (class$java$lang$Object = ClassGraphWalker.class$("java.lang.Object")) : class$java$lang$Object).getName()) ? string5 : "[L" + string5 + ";", bl, bl2, string3, n, clazz);
            } else {
                Streamer.warning.Header().println("Property '" + string + "' of type '" + string2 + "' doesn't have an explicit type mapping. We will treat it as a basic String. If this is not a basic type or a complex type with an appropriate toString() method, then the internal Java object signature will be output.");
                bl2 = this.ProcessProperty(string, string2.equals((class$java$lang$Object == null ? (class$java$lang$Object = ClassGraphWalker.class$("java.lang.Object")) : class$java$lang$Object).getName()) ? "java.lang.String" : "[Ljava.lang.String;", bl, bl2, string3, n, clazz);
            }
        } else if (TypesUtil.isGeneralListNoArrays(string2)) {
            String string6 = (String)this._Mappings.get(string4);
            if (string6 != null) {
                if (TypesUtil.isBasicJavaType(string6)) {
                    if (this._W.ProcessBasicProperty(string3 + '.' + string, clazz, string, string6, true, bl, n)) {
                        bl2 = true;
                    }
                } else {
                    boolean bl4 = this.WalkInternal(string3 + '.' + string, ODCClassLoader.getClass(string6), n + 1);
                    if (this._W.ProcessComplexProperty(string3 + '.' + string, clazz, string, string6, true, bl, bl4, n)) {
                        bl2 = true;
                    }
                }
            } else {
                Streamer.warning.Header().println("Property '" + string + "' of type '" + string2 + "' doesn't have an explicit type mapping. This property will be skipped as a result because we do not know what type it really is.");
            }
        } else {
            boolean bl5 = this.WalkInternal(string3 + '.' + string, ODCClassLoader.getClass(string2), n + 1);
            if (this._W.ProcessComplexProperty(string3 + '.' + string, clazz, string, string2, false, bl, bl5, n)) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        Streamer.setLogLevel(3);
        try {
            TestWalker testWalker = new TestWalker();
            ClassGraphWalker classGraphWalker = new ClassGraphWalker("com.ibm.odcb.jrender.misc.ClassGraphWalker$Test", new HashMap(), false, new HashMap());
            classGraphWalker.Walk(testWalker);
            Streamer.Separator();
            classGraphWalker = new ClassGraphWalker("java.lang.Class", new HashMap(), false, new HashMap());
            classGraphWalker.Walk(testWalker);
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
        }
        Streamer.status.println().Header().println("test done");
        Streamer.EndThread();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test {
        public char[] getCharArray() {
            return new char[10];
        }

        public boolean[] getBooleanArray() {
            return new boolean[10];
        }

        public double[] getDoubleArray() {
            return new double[10];
        }

        public float[] getFloatArray() {
            return new float[10];
        }

        public int[] getIntArray() {
            return new int[10];
        }

        public long[] getLongArray() {
            return new long[10];
        }

        public short[] getShortArray() {
            return new short[10];
        }

        public byte[] getByteArray() {
            return new byte[10];
        }

        public Byte[] getByteObjectArray() {
            return new Byte[10];
        }

        public String[] getStringArray() {
            return new String[10];
        }

        public Iterator getStringIterator() {
            return new ArrayList().iterator();
        }

        public ArrayList getStringArrayList() {
            return new ArrayList();
        }

        public List getStringList() {
            return new ArrayList();
        }

        public Collection getStringCollection() {
            return new ArrayList();
        }
    }

    public static class TestWalker
    implements Walker {
        public boolean Begin(Class clazz) {
            return true;
        }

        public boolean ProcessClassBegin(String string, Class clazz, int n) {
            Streamer.debug.println(clazz.getName());
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                String string2 = methodArray[n2].getName();
                Streamer.debug.print("|_ " + string2 + "(");
                Class<?>[] classArray = methodArray[n2].getParameterTypes();
                int n3 = 0;
                while (n3 < classArray.length) {
                    if (n3 != 0) {
                        Streamer.debug.print(", ");
                    }
                    Streamer.debug.print(classArray[n3].getName());
                    ++n3;
                }
                Streamer.debug.println(")");
                ++n2;
            }
            return true;
        }

        public boolean ProcessBasicProperty(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2, int n) {
            Streamer.debug.Header().println(StringUtil._PADS[n] + StringUtil._PADS[n] + " > " + string + " (" + string2 + "#" + string3 + (bl ? "[])" : ")"));
            return true;
        }

        public boolean ProcessComplexProperty(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n) {
            Streamer.debug.Header().println(StringUtil._PADS[n] + StringUtil._PADS[n] + " > " + string + " (" + string2 + "#" + string3 + (bl ? "[])" : ")"));
            return true;
        }

        public boolean ProcessClassEnd(String string, Class clazz, boolean bl, int n) {
            return true;
        }

        public boolean End(Class clazz) {
            return true;
        }
    }

    public static interface Walker {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

        public boolean Begin(Class var1) throws Exception;

        public boolean ProcessClassBegin(String var1, Class var2, int var3) throws Exception;

        public boolean ProcessBasicProperty(String var1, Class var2, String var3, String var4, boolean var5, boolean var6, int var7) throws Exception;

        public boolean ProcessComplexProperty(String var1, Class var2, String var3, String var4, boolean var5, boolean var6, boolean var7, int var8) throws Exception;

        public boolean ProcessClassEnd(String var1, Class var2, boolean var3, int var4) throws Exception;

        public boolean End(Class var1) throws Exception;
    }
}

