/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.ProcessExecution;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.FileNotFoundException;

public class CompilerUtil {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static String CLASSPATH = null;

    public static boolean Compile(String[] stringArray, String string) {
        if (CLASSPATH == null) {
            CLASSPATH = System.getProperty("java.class.path");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string);
        stringBuffer.append(" -nowarn -classpath \"").append(CLASSPATH).append("\"");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        Streamer.status.Header().println("Executing the program: " + stringBuffer);
        int n2 = ProcessExecution.Exec(stringBuffer.toString(), "Compiler errors", 50, 1024, 2048);
        if (n2 != 0) {
            Streamer.error.Header().println("Cannot execute the program '" + stringBuffer.toString() + "'.").Header().println("Please check your path/configuration.");
        }
        return n2 == 0;
    }

    public static boolean Compile(String string, String string2, String[] stringArray, String string3) {
        boolean bl;
        boolean bl2 = string == null || string.trim().equals("");
        boolean bl3 = bl = string2 == null || string2.trim().equals("");
        if (bl2 && bl) {
            return CompilerUtil.Compile(stringArray, string3);
        }
        if (CLASSPATH == null) {
            CLASSPATH = System.getProperty("java.class.path");
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(string3);
        stringBuffer.append(" -nowarn -classpath \"").append(CLASSPATH).append("\"");
        if (string2.endsWith("\\")) {
            string2 = string2.substring(0, string2.lastIndexOf(92));
        }
        stringBuffer.append(" -d \"" + string2 + "\"");
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        Streamer.status.Header().println("Executing the program: " + stringBuffer);
        if (bl2) {
            return ProcessExecution.Exec(stringBuffer.toString(), "Compiler errors", 50, 1024, 2048) == 0;
        }
        File file = new File(string);
        int n2 = ProcessExecution.Exec(stringBuffer.toString(), null, file, "Compiler errors", 50, 1024, 2048);
        if (n2 == -666) {
            Streamer.error.Header().println("Cannot execute the program '" + stringBuffer.toString() + "'.").Header().println("Please check your path/configuration.");
            throw new Error("Cannot execute the program '" + stringBuffer.toString() + "'.");
        }
        return n2 == 0;
    }

    public static void CreatePath(String string) {
        File file = new File(string);
        file.mkdirs();
    }

    public static boolean CheckUpToDate(String string, File file) throws Exception {
        File file2 = new File(string);
        return CompilerUtil.CheckUpToDate(file2, file);
    }

    public static boolean CheckUpToDate(File file, String string) throws Exception {
        File file2 = new File(string);
        return CompilerUtil.CheckUpToDate(file, file2);
    }

    public static boolean CheckUpToDate(String string, String string2) throws Exception {
        File file = new File(string);
        File file2 = new File(string2);
        return CompilerUtil.CheckUpToDate(file, file2);
    }

    public static boolean CheckUpToDate(File file, File file2) throws Exception {
        long l = file.lastModified();
        long l2 = file2.lastModified();
        if (l == 0L) {
            Streamer.status.Header().println("File " + file.getAbsolutePath() + " cannot be found");
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (l > l2) {
            Streamer.debug.Header().println("The base file " + file.getAbsolutePath() + " has changed after the check file " + file2.getAbsolutePath());
            return false;
        }
        Streamer.debug.Header().println("The check file " + file2.getAbsolutePath() + " is up to date");
        return true;
    }
}

