/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.TypesUtil;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.impl.SDOFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class EMFHelper {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String VERSION = "JWL 1.1.1, SDO";
    public static final Class DataObject_CLASS = class$commonj$sdo$DataObject == null ? (class$commonj$sdo$DataObject = EMFHelper.class$("commonj.sdo.DataObject")) : class$commonj$sdo$DataObject;
    public static final String SDO_DATAGRAPH_ROOTNAME = "DataGraphRoot";
    public static final String WDO_DATAGRAPH_ROOTNAME = "RootDataObject";
    static /* synthetic */ Class class$commonj$sdo$DataObject;
    static /* synthetic */ Class class$java$lang$String;

    public static void SaveEPackageToECore(EPackage ePackage, String string, String string2) {
        Streamer.status.Header().println();
        Streamer.status.Header().println();
        Streamer.status.Header().println("---- SAVING AN EPACKAGE TO " + string + string2 + " --------------------------------------");
        Streamer.status.Header().println("Creating an XMI Resource");
        XMIResourceImpl xMIResourceImpl = new XMIResourceImpl(URI.createFileURI((String)(string + string2)));
        Streamer.status.Header().println("Adding the EPackage '" + ePackage.getName() + "' to the resource's contents");
        xMIResourceImpl.getContents().add((Object)ePackage);
        try {
            Streamer.status.Header().println("Setting the XMI encoding style to 'compact'.");
            Map map = xMIResourceImpl.getDefaultSaveOptions();
            map.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            map.put("ENCODING", "UTF-8");
            Streamer.status.Header().println("Saving");
            xMIResourceImpl.save(map);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        Streamer.status.Header().println("...D.O.N.E..........................................................................");
    }

    public static Resource load(ResourceSet resourceSet, URI uRI) {
        Resource resource = resourceSet.getResource(uRI, true);
        EMFHelper.initPackages(resource);
        return resource;
    }

    public static EPackage getEPackageFromStream(String string) {
        Resource resource = EMFHelper.getResourceFromStream(string);
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        return ePackage;
    }

    public static Resource getResource(InputStream inputStream, URI uRI) {
        Resource resource = null;
        try {
            EMFHelper.initSDO();
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            resource = resourceSetImpl.createResource(uRI);
            resource.load(inputStream, null);
        }
        catch (Exception exception) {
            Streamer.error.Header().println("ecore loading failed");
            Streamer.error.Header().printStackTrace(exception);
        }
        return resource;
    }

    public static Resource getResourceFromStream(String string) {
        Resource resource;
        block3: {
            resource = null;
            try {
                InputStream inputStream = ODCClassLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    Streamer.status.Header().println("Loading resource: " + string);
                    resource = EMFHelper.getResource(inputStream, URI.createURI((String)string));
                    inputStream.close();
                    Streamer.status.Header().println("Finished Loading resource: " + string + " without any errors.");
                    break block3;
                }
                Streamer.error.Header().println("Could not get InputStream for '" + string + "'.  Please make sure that the resource exists.");
            }
            catch (IOException iOException) {
                Streamer.error.Header().println("Error Loading resource: " + string);
                Streamer.error.Header().printStackTrace(iOException);
            }
        }
        return resource;
    }

    public static Vector propertyResourceName() {
        Vector<String> vector;
        block3: {
            vector = new Vector<String>();
            try {
                String string = Config.getString(Config.PROP_SYSTEM_ECORE_FILES, null);
                if (string == null) break block3;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                Object var3_4 = null;
                boolean bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
            }
            catch (MissingResourceException missingResourceException) {
                Streamer.error.Header().print("Missing Resource Exception: SYSTEM_ECORE_FILES");
            }
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initLoadExternalEcoreFile() {
        try {
            Vector vector = EMFHelper.propertyResourceName();
            if (vector == null) return;
            if (vector.isEmpty()) {
                return;
            }
            while (true) {
                if (vector.isEmpty()) {
                    return;
                }
                String string = vector.firstElement().toString();
                InputStream inputStream = ODCClassLoader.getResourceAsStream(string);
                if (inputStream != null) {
                    ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                    Resource resource = resourceSetImpl.createResource(URI.createURI((String)string));
                    resource.load(inputStream, null);
                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                    EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    inputStream.close();
                }
                vector.removeElement(string);
            }
        }
        catch (IOException iOException) {
            Streamer.error.Header().printStackTrace(iOException);
            return;
        }
    }

    public static void InitWDO() {
        EMFHelper.initSDO();
    }

    public static void initSDO() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new XMIResourceFactoryImpl());
        EcoreFactory ecoreFactory = EcoreFactory.eINSTANCE;
        EcorePackage ecorePackage = EcorePackage.eINSTANCE;
        EMFHelper.initLoadExternalEcoreFile();
        SDOFactory sDOFactory = SDOFactory.eINSTANCE;
    }

    public static void initPackage(EPackage ePackage) {
        ePackage.setEFactoryInstance((EFactory)new SDOFactoryImpl());
    }

    public static void initPackageForDataObject(EPackage ePackage) {
        ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
    }

    public static void initPackages(Resource resource) {
        Object object = EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        if (object != null) {
            EMFHelper.initPackage((EPackage)object);
        }
    }

    public static void initPackagesForDataObject(Resource resource) {
        Object object = EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        if (object != null) {
            EMFHelper.initPackage((EPackage)object);
        }
    }

    public static String ReadFileIntoString(String string) {
        String string2 = null;
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            StringBuffer stringBuffer = new StringBuffer(512);
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3).append("\n");
            }
            string2 = stringBuffer.toString();
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return string2;
    }

    public static void PrintPackage(EPackage ePackage) {
        System.out.println();
        System.out.println();
        System.out.println("---- PRINTING OUT AN EPACKAGE --------------------------------------");
        System.out.println("EPackage: Name=" + ePackage.getName() + ";");
        System.out.println();
        EList eList = ePackage.getEClassifiers();
        int n = 0;
        while (n < eList.size()) {
            EClass eClass = (EClass)eList.get(n);
            System.out.println("EClass: Name=" + eClass.getName() + ";");
            int n2 = 0;
            while (n2 < eClass.getEAllAttributes().size()) {
                EAttribute eAttribute = (EAttribute)eClass.getEAllAttributes().get(n2);
                System.out.println("  EAttribute: Name=" + eAttribute.getName() + "; LowerBound=" + eAttribute.getLowerBound() + "; UpperBound=" + eAttribute.getUpperBound() + ";");
                ++n2;
            }
            int n3 = 0;
            while (n3 < eClass.getEAllReferences().size()) {
                EReference eReference = (EReference)eClass.getEAllReferences().get(n3);
                System.out.println("  EReference: Name=" + eReference.getName() + "; Type=" + TypesUtil.getRealETypeName(eReference.getEType()) + "; LowerBound=" + eReference.getLowerBound() + "; UpperBound=" + eReference.getUpperBound() + "; Containment=" + eReference.isContainment() + ";");
                ++n3;
            }
            System.out.println();
            ++n;
        }
        System.out.println("...D.O.N.E..........................................................................");
    }

    public static void saveEPackageToECore(EPackage ePackage, String string, String string2, boolean bl) {
        if (!bl) {
            EMFHelper.SaveEPackageToECore(ePackage, string, string2);
        } else {
            PrintWriter printWriter = null;
            try {
                Streamer.status.Header().println("---- SAVING WDO EPACKAGE TO " + string + string2 + " --------------------------------------");
                StringBuffer stringBuffer = new StringBuffer("");
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<ecore:EPackage\n").append("  xmi:version=\"2.0\"\n").append("  xmlns:xmi=\"http://www.omg.org/XMI\"\n").append("  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("  xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"\n").append("  name=\"" + ePackage.getName() + "\"\n").append("  nsURI=\"" + ePackage.getNsURI() + "\"\n").append("  nsPrefix=\"" + ePackage.getNsPrefix() + "\" >\n");
                Iterator iterator = ePackage.getEClassifiers().iterator();
                Streamer.status.Header().println("Iterating through EClasses");
                while (iterator.hasNext()) {
                    String string3;
                    Iterator iterator2;
                    EClass eClass = (EClass)iterator.next();
                    if (eClass.getName().equals(SDO_DATAGRAPH_ROOTNAME)) {
                        stringBuffer.append("  <eClassifiers xsi:type=\"ecore:EClass\" name=\"RootDataObject\" >\n");
                    } else {
                        stringBuffer.append("  <eClassifiers xsi:type=\"ecore:EClass\" name=\"" + eClass.getName() + "\" >\n");
                    }
                    Iterator iterator3 = eClass.getEAttributes().iterator();
                    Streamer.status.Header().println("Iterating through EAttributes");
                    while (iterator3.hasNext()) {
                        iterator2 = (EAttribute)iterator3.next();
                        string3 = TypesUtil.getFullEType(iterator2.getEType().getName(), true);
                        stringBuffer.append("    <eAttributes name=\"" + iterator2.getName() + "\" eType=\"" + string3 + "\" lowerBound=\"" + iterator2.getLowerBound() + "\" upperBound=\"" + iterator2.getUpperBound() + "\" changeable=\"" + iterator2.isChangeable() + "\" unique=\"" + iterator2.isUnique() + "\"  />\n");
                    }
                    iterator2 = eClass.getEReferences().iterator();
                    Streamer.status.Header().println("Iterating through EReferences");
                    while (iterator2.hasNext()) {
                        string3 = (EReference)iterator2.next();
                        String string4 = TypesUtil.getFullEType(string3.getEType().getName(), true);
                        stringBuffer.append("    <eReferences name=\"" + string3.getName() + "\" eType=\"" + string4 + "\" lowerBound=\"" + string3.getLowerBound() + "\" upperBound=\"" + string3.getUpperBound() + "\" containment=\"" + string3.isContainment() + "\" changeable=\"" + string3.isChangeable() + "\" unique=\"" + string3.isUnique() + "\" />\n");
                    }
                    stringBuffer.append("  </eClassifiers>\n");
                }
                stringBuffer.append("</ecore:EPackage>\n");
                Streamer.status.Header().println("Writing the ecore to file" + string + string2);
                printWriter = new PrintWriter(new FileOutputStream(string + string2));
                printWriter.write(stringBuffer.toString());
                printWriter.flush();
                printWriter.close();
                Streamer.status.Header().println("---DONE---");
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                Streamer.error.Header().println("An Error occured when saving the wdo package to ecore file.");
                Streamer.error.Header().printStackTrace(exception);
            }
        }
    }

    public static EPackage LoadEPackageFromECore(String string, String string2) {
        Streamer.status.Header().println();
        Streamer.status.Header().println();
        Streamer.status.Header().println("---- LOADING AN EPACKAGE FROM " + string + string2 + " --------------------------------------");
        Streamer.status.Header().println("Creating an XMI Resource");
        XMIResourceImpl xMIResourceImpl = new XMIResourceImpl(URI.createFileURI((String)(string + string2)));
        try {
            Streamer.status.Header().println("Setting the XMI encoding style to 'compact'.");
            Map map = xMIResourceImpl.getDefaultLoadOptions();
            map.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            map.put("ENCODING", "UTF-8");
            Streamer.status.Header().println("Loading");
            xMIResourceImpl.load(map);
            Streamer.status.Header().println("Getting the EPackage from the resource's contents");
            EPackage ePackage = (EPackage)xMIResourceImpl.getContents().get(0);
            Streamer.status.Header().println("Initializing the EPackage '" + ePackage.getName() + "' for WDO features");
            EMFHelper.initPackage(ePackage);
            Streamer.status.Header().println("...D.O.N.E..........................................................................");
            return ePackage;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            Streamer.error.Header().println("...E.R.R.O.R.........................................................................");
            return null;
        }
    }

    public static void printEObject(EObject eObject, String string, String string2, ArrayList arrayList) {
        try {
            boolean bl;
            if (arrayList == null) {
                arrayList = new ArrayList<EObject>();
            }
            if (!(bl = arrayList.contains(eObject))) {
                Object object;
                EAttribute eAttribute;
                arrayList.add(eObject);
                EClass eClass = eObject.eClass();
                System.out.print(string2 + "<" + string);
                Iterator iterator = eClass.getEAttributes().iterator();
                Iterator iterator2 = eClass.getEReferences().iterator();
                while (iterator.hasNext()) {
                    try {
                        eAttribute = (EAttribute)iterator.next();
                        object = eObject.eGet((EStructuralFeature)eAttribute, true);
                        if (object == null) continue;
                        System.out.print(" " + eAttribute.getName() + "=\"" + object + "\"");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println(">");
                while (iterator2.hasNext()) {
                    eAttribute = (EReference)iterator2.next();
                    object = eObject.eGet((EStructuralFeature)eAttribute, true);
                    if (object == null) continue;
                    if (object instanceof EcoreEList) {
                        EMFHelper.printEObjects((EcoreEList)object, eAttribute.getName(), string2 + "  ", arrayList);
                        continue;
                    }
                    if (object instanceof EObject) {
                        EMFHelper.printEObject((EObject)object, eAttribute.getName(), string2 + "  ", arrayList);
                        continue;
                    }
                    throw new Exception("Printing the object '" + eObject.getClass().getName() + "' is not supported!  The supported types are org.eclipse.emf.ecore.util.EcoreDynamicEList and org.eclipse.emf.ecore.EObject!");
                }
                System.out.println(string2 + "</" + string + ">");
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
        }
    }

    public static void printEObjects(EcoreEList ecoreEList, String string, String string2, ArrayList arrayList) throws Exception {
        Iterator iterator = ecoreEList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof EcoreEList) {
                EMFHelper.printEObjects((EcoreEList)e, string, string2, arrayList);
                continue;
            }
            if (e instanceof EObject) {
                EMFHelper.printEObject((EObject)e, string, string2, arrayList);
                continue;
            }
            throw new Exception("Printing the object '" + e.getClass().getName() + "' is not supported!  The supported types are org.eclipse.emf.ecore.util.EcoreDynamicEList and org.eclipse.emf.ecore.EObject!");
        }
    }

    public static Object getEFeatureValue(EObject eObject, String string) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
        return eObject.eGet(eStructuralFeature, false);
    }

    public static boolean CompareECores(String string, String string2) {
        EPackage ePackage = EMFHelper.LoadEPackageFromECore(string, "");
        EPackage ePackage2 = EMFHelper.LoadEPackageFromECore(string2, "");
        if (ePackage == null || ePackage2 == null) {
            return false;
        }
        return EMFHelper.CompareECores(ePackage, ePackage2);
    }

    public static boolean CompareECores(EPackage ePackage, EPackage ePackage2) {
        if (!ePackage.getName().equals(ePackage2.getName())) {
            Streamer.debug.Header().println("The 2 ecores have different names");
            return false;
        }
        if (!ePackage.getNsURI().equals(ePackage2.getNsURI())) {
            Streamer.debug.Header().println("The 2 ecores have different NsURI");
            return false;
        }
        if (!ePackage.getNsPrefix().equals(ePackage2.getNsPrefix())) {
            Streamer.debug.Header().println("The 2 ecores have different NsPrefix");
            return false;
        }
        EList eList = ePackage.getEClassifiers();
        EList eList2 = ePackage2.getEClassifiers();
        if (eList.size() != eList2.size()) {
            Streamer.debug.Header().println("The 2 ecores have a different number of EClasses");
            return false;
        }
        int n = 0;
        while (n < eList.size()) {
            EClass eClass = (EClass)eList.get(n);
            EClass eClass2 = (EClass)ePackage2.getEClassifier(eClass.getName());
            if (eClass2 == null) {
                Streamer.debug.Header().println("The EClassifier '" + eClass.getName() + "' cannot be found in the second ECore");
                return false;
            }
            if (!EMFHelper.CompareEClasses(eClass, eClass2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean CompareEClasses(EClass eClass, EClass eClass2) {
        EAttribute eAttribute;
        EList eList = eClass.getEAllAttributes();
        EList eList2 = eClass2.getEAllAttributes();
        if (eList.size() != eList2.size()) {
            Streamer.debug.Header().println("The 2 EClasses '" + eClass.getName() + "' in the 2 ECores have a different number of EAttributes");
            return false;
        }
        int n = 0;
        while (n < eList.size()) {
            EAttribute eAttribute2 = (EAttribute)eList.get(n);
            eAttribute = (EAttribute)eClass2.getEStructuralFeature(eAttribute2.getName());
            if (eAttribute == null) {
                Streamer.debug.Header().println("The EAttribute '" + eAttribute2.getName() + "' cannot be found in the EClass '" + eClass.getName() + "' in the second ECore");
                return false;
            }
            if (!EMFHelper.CompareEAttributes(eClass, eAttribute2, eAttribute)) {
                return false;
            }
            ++n;
        }
        eList = eClass.getEAllReferences();
        eList2 = eClass2.getEAllReferences();
        if (eList.size() != eList2.size()) {
            Streamer.debug.Header().println("The 2 EClasses '" + eClass.getName() + "' in the 2 ECores have a different number of EReferences");
            return false;
        }
        int n2 = 0;
        while (n2 < eList.size()) {
            eAttribute = (EReference)eList.get(n2);
            EReference eReference = (EReference)eClass2.getEStructuralFeature(eAttribute.getName());
            if (eReference == null) {
                Streamer.debug.Header().println("The EReference '" + eAttribute.getName() + "' cannot be found in the EClass '" + eClass.getName() + "' in the second ECore");
                return false;
            }
            if (!EMFHelper.CompareEReferences(eClass, (EReference)eAttribute, eReference)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean CompareEAttributes(EClass eClass, EAttribute eAttribute, EAttribute eAttribute2) {
        if (!EMFHelper.CompareEFeatures(eClass, (EStructuralFeature)eAttribute, (EStructuralFeature)eAttribute2)) {
            return false;
        }
        if (eAttribute.isID() != eAttribute2.isID()) {
            Streamer.debug.Header().println("The EAttribute '" + eAttribute.getName() + "' in EClass '" + eClass.getName() + "' has a different 'ID' in the second ECore");
            return false;
        }
        return true;
    }

    public static boolean CompareEReferences(EClass eClass, EReference eReference, EReference eReference2) {
        if (!EMFHelper.CompareEFeatures(eClass, (EStructuralFeature)eReference, (EStructuralFeature)eReference2)) {
            return false;
        }
        EReference eReference3 = eReference.getEOpposite();
        EReference eReference4 = eReference2.getEOpposite();
        if (eReference3 != null && eReference4 != null) {
            String string;
            String string2;
            String string3;
            String string4 = eReference3.getName();
            if (!string4.equals(string3 = eReference4.getName())) {
                Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'EOpposite' in the second ECore");
                return false;
            }
            String string5 = eReference4.eClass().getName();
            if (!string5.equals(string2 = eReference3.eClass().getName())) {
                Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'EOpposite' in the second ECore");
                return false;
            }
            String string6 = eReference3.eClass().getEPackage().getName();
            if (!string6.equals(string = eReference4.eClass().getEPackage().getName())) {
                Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'EOpposite' in the second ECore");
                return false;
            }
        } else if (eReference3 != null || eReference4 != null) {
            Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'EOpposite' in the second ECore");
            return false;
        }
        if (eReference.isContainer() != eReference2.isContainer()) {
            Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Container' in the second ECore");
            return false;
        }
        if (eReference.isContainment() != eReference2.isContainment()) {
            Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Containment' in the second ECore");
            return false;
        }
        if (eReference.isResolveProxies() != eReference2.isResolveProxies()) {
            Streamer.debug.Header().println("The EReference '" + eReference.getName() + "' in EClass '" + eClass.getName() + "' has a different 'ResolveProxies' in the second ECore");
            return false;
        }
        return true;
    }

    public static boolean CompareEFeatures(EClass eClass, EStructuralFeature eStructuralFeature, EStructuralFeature eStructuralFeature2) {
        if (eStructuralFeature.getDefaultValueLiteral() != null && !eStructuralFeature.getDefaultValueLiteral().equals(eStructuralFeature2.getDefaultValueLiteral())) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'DefaultValueLitteral' in the second ECore");
            return false;
        }
        String string = TypesUtil.getRealETypeName(eStructuralFeature.getEType());
        String string2 = TypesUtil.getRealETypeName(eStructuralFeature2.getEType());
        if (string == null || !string.equals(string2)) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'EType' in the second ECore");
            Streamer.debug.Header().println("ETypes are '" + string + " and '" + string2 + "'");
            return false;
        }
        if (eStructuralFeature.getLowerBound() != eStructuralFeature2.getLowerBound()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'LowerBound' in the second ECore");
            return false;
        }
        if (eStructuralFeature.getUpperBound() != eStructuralFeature2.getUpperBound()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'UpperBound' in the second ECore");
            return false;
        }
        if (eStructuralFeature.isChangeable() != eStructuralFeature2.isChangeable()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Changeable' in the second ECore");
            return false;
        }
        if (eStructuralFeature.isTransient() != eStructuralFeature2.isTransient()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Transient' in the second ECore");
            return false;
        }
        if (eStructuralFeature.isUnique() != eStructuralFeature2.isUnique()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Unique' in the second ECore");
            return false;
        }
        if (eStructuralFeature.isUnsettable() != eStructuralFeature2.isUnsettable()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Unsettable' in the second ECore");
            return false;
        }
        if (eStructuralFeature.isVolatile() != eStructuralFeature2.isVolatile()) {
            Streamer.debug.Header().println("The EFeature '" + eStructuralFeature.getName() + "' in EClass '" + eClass.getName() + "' has a different 'Volatile' in the second ECore");
            return false;
        }
        return true;
    }

    public static DataObject loadDataObject(InputStream inputStream, EPackage ePackage) {
        DataObject dataObject = null;
        try {
            if (ePackage == null) {
                Streamer.error.Header().println("Can not load DataObject.  EPackage is null!");
                return null;
            }
            EMFHelper.initSDO();
            EMFHelper.initPackageForDataObject(ePackage);
            EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
            ResourceSet resourceSet = eDataGraph.getResourceSet();
            resourceSet.getResources().add((Object)ePackage.eResource());
            Resource resource = resourceSet.createResource(URI.createURI((String)"data.xmi"));
            Map map = resourceSet.getLoadOptions();
            map.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            map.put("ENCODING", "UTF-8");
            resource.load(inputStream, map);
            dataObject = (DataObject)resource.getContents().get(0);
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
            return null;
        }
        return dataObject;
    }

    public static DataObject getDataObject(Object object, boolean bl) {
        DataObject dataObject = null;
        if (object instanceof DataGraph) {
            dataObject = ((DataGraph)object).getRootObject();
        }
        return dataObject;
    }

    public static DataGraph createDataGraph(EPackage ePackage) {
        ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
        EDataGraph eDataGraph = SDOFactory.eINSTANCE.createEDataGraph();
        ResourceSet resourceSet = eDataGraph.getResourceSet();
        URI uRI = URI.createURI((String)ePackage.getNsURI());
        resourceSet.createResource(uRI).getContents().add((Object)ePackage);
        return eDataGraph;
    }

    public static DataGraph createDataGraph(EPackage ePackage, String string) {
        DataGraph dataGraph = EMFHelper.createDataGraph(ePackage);
        return dataGraph;
    }

    public static String getEClassName(DataObject dataObject) {
        return dataObject.getType().getName();
    }

    public static List getFeatureNames(DataObject dataObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Type type = dataObject.getType();
        List list = type.getProperties();
        int n = 0;
        while (n < list.size()) {
            Property property = (Property)list.get(n);
            arrayList.add(property.getName());
            ++n;
        }
        return arrayList;
    }

    public static void copy(DataObject dataObject, DataObject dataObject2) {
        List list = EMFHelper.getFeatureNames(dataObject);
        int n = 0;
        while (n < list.size()) {
            String string = (String)list.get(n);
            if (dataObject.isSet(string)) {
                dataObject2.set(string, dataObject.get(string));
            }
            ++n;
        }
    }

    public static void validateDataObject(DataObject dataObject) {
        Type type = dataObject.getType();
        List list = type.getProperties();
        int n = 0;
        while (n < list.size()) {
            Object object;
            Property property = (Property)list.get(n);
            if (dataObject.isSet(property) && (class$java$lang$String == null ? EMFHelper.class$("java.lang.String") : class$java$lang$String) == (object = dataObject.get(property)).getClass()) {
                dataObject.setString(property, dataObject.getString(property).replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            }
            ++n;
        }
    }

    public static void undoValidateDataObject(DataObject dataObject) {
        Type type = dataObject.getType();
        List list = type.getProperties();
        int n = 0;
        while (n < list.size()) {
            Property property = (Property)list.get(n);
            Object object = dataObject.get(property);
            if (dataObject.isSet(property) && (class$java$lang$String == null ? EMFHelper.class$("java.lang.String") : class$java$lang$String) == object.getClass()) {
                dataObject.setString(property, dataObject.getString(property).replaceAll("&lt;", "<").replaceAll("&gt;", ">"));
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        EMFHelper.initSDO();
        if (!EMFHelper.CompareECores("t:\\portfolio_sample1.ecore", "t:\\portfolio_sample2.ecore")) {
            Streamer.error.Header().println("The ECores are different");
        } else {
            Streamer.status.Header().println("The ECores are the same");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

