/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.Streamer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FileUtil {
    public static String NEWLINE = System.getProperty("line.separator");

    public static boolean FileCopy(String string, String string2, boolean bl) {
        return FileUtil.FileCopy(new File(string), new File(string2), bl);
    }

    public static boolean FileCopy(File file, String string, boolean bl) {
        return FileUtil.FileCopy(file, new File(string), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean FileCopy(File file, File file2, boolean bl) {
        int n;
        Object object;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        if (bl && !((File)(object = new File(file2.getParent()))).exists() && !((File)object).mkdirs()) {
            throw new IOException("Cannot create path '" + file2.getParent() + "'.");
        }
        fileOutputStream = new FileOutputStream(file2);
        object = new byte[4048];
        while ((n = bufferedInputStream.read((byte[])object)) != -1) {
            fileOutputStream.write((byte[])object, 0, n);
        }
        boolean bl2 = true;
        try {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
        catch (IOException iOException) {
            boolean bl3;
            try {
                Streamer.error.Header().println("Cannot copy file '" + file.getAbsolutePath() + "' to file '" + file2.getAbsolutePath() + "'.");
                Streamer.error.Header().printStackTrace(iOException);
                bl3 = false;
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bl3;
        }
    }

    public static boolean FileDelete(String string) {
        return FileUtil.FileDelete(new File(string));
    }

    public static boolean FileDelete(File file) {
        if (!file.exists()) {
            Streamer.warning.Header().println("The file '" + file.getPath() + "' does not exist. It't already deleted.");
            return true;
        }
        if (!file.delete()) {
            Streamer.error.Header().println("The file '" + file.getPath() + "' Could not be deleted.");
            return false;
        }
        return true;
    }

    public static boolean FileSystemTraverser(String string, FileFilter fileFilter, FileProcessor fileProcessor) {
        return FileUtil.FileSystemTraverser(new File(string), fileFilter, fileProcessor);
    }

    public static boolean FileSystemTraverser(File file, FileFilter fileFilter, FileProcessor fileProcessor) {
        try {
            if (!file.exists()) {
                Streamer.error.Header().println("The directory '" + file.getPath() + "' does not exist.");
                return false;
            }
            if (!file.isDirectory()) {
                Streamer.error.Header().println("The name '" + file.getPath() + "' does note denote a directory.");
                return false;
            }
            File[] fileArray = file.listFiles(fileFilter);
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory() ? !FileUtil.FileSystemTraverser(file2, fileFilter, fileProcessor) : !fileProcessor.Process(file2)) {
                    return false;
                }
                ++n;
            }
            return fileProcessor.Process(file);
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
            return false;
        }
    }

    public static boolean DirDelete(String string) {
        return FileUtil.DirDelete(new File(string));
    }

    public static boolean DirDelete(File file) {
        return FileUtil.FileSystemTraverser(file, null, (FileProcessor)new FileDeleter());
    }

    public static boolean isOlder(String string, String string2) {
        return FileUtil.isOlder(new File(string), new File(string2));
    }

    public static boolean isOlder(File file, String string) {
        return FileUtil.isOlder(file, new File(string));
    }

    public static boolean isOlder(File file, File file2) {
        return !file.exists() || file.lastModified() > file2.lastModified();
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = string = "abc def";
        int n = string.indexOf(string2);
        string = string.substring(0, n) + string.substring(n + string2.length());
        System.out.println("X= '" + string + "'");
        FileUtil.DirDelete("D:\\projects\\Testing\\Copy of src");
    }

    public static class ExtensionFilter
    implements FileFilter {
        protected ArrayList _Ext;
        protected boolean _Include;

        public ExtensionFilter(ArrayList arrayList, boolean bl) {
            this._Ext = arrayList;
            this._Include = bl;
        }

        public boolean accept(File file) {
            if (this._Ext.size() == 0 || file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = 0;
            while (n < this._Ext.size()) {
                String string2 = (String)this._Ext.get(n);
                if (string.endsWith(string2)) {
                    return this._Include;
                }
                ++n;
            }
            return !this._Include;
        }
    }

    public static class FileDeleter
    implements FileProcessor {
        public boolean Process(File file) throws Exception {
            if (file.isDirectory()) {
                if (!file.delete()) {
                    Streamer.error.Header().println("The directory '" + file.getName() + "' Could not be deleted.");
                    return false;
                }
            } else if (!FileUtil.FileDelete(file)) {
                Streamer.error.Header().println("The file '" + file.getName() + "' Could not be deleted.");
                return false;
            }
            return true;
        }
    }

    public static interface FileProcessor {
        public boolean Process(File var1) throws Exception;
    }
}

