/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.faces.el.ReferenceSyntaxException;

public class PathTokenizer {
    protected String path = null;
    protected String[] tokens = null;

    public PathTokenizer(String string) {
        this.path = string;
        if (this.path != null) {
            this.tokenize();
        }
    }

    protected void tokenize() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.path, ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            arrayList.add(string);
        }
        this.tokens = new String[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            this.tokens[n] = (String)arrayList.get(n);
            ++n;
        }
    }

    public String getPathToLastObject() {
        int n = this.path.lastIndexOf(46);
        if (n != -1) {
            return this.path.substring(0, n);
        }
        return this.path;
    }

    public String getRoot() {
        if (this.tokens == null) {
            this.tokenize();
        }
        return this.tokens[0];
    }

    public String[] getTokens() {
        if (this.tokens == null) {
            this.tokenize();
        }
        return this.tokens;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getLastToken() {
        if (this.path.indexOf(46) == -1) {
            return this.path;
        }
        return this.path.substring(this.path.lastIndexOf(46) + 1, this.path.length());
    }

    public static String getStrippedValueString(String string) throws ReferenceSyntaxException {
        if (string == null) {
            return null;
        }
        int n = 0;
        if ('#' == string.charAt(0)) {
            if ('{' != string.charAt(1)) {
                throw new ReferenceSyntaxException();
            }
            n = string.length();
            if ('}' != string.charAt(n - 1)) {
                throw new ReferenceSyntaxException();
            }
            string = string.substring(2, n - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        PathTokenizer pathTokenizer = new PathTokenizer("#{Root.Users[0].Portfolios[0]}");
        System.out.println("Input: #{Root.Users[0].Portfolios[0]}");
        System.out.println("Path: " + pathTokenizer.path);
        String string = pathTokenizer.getRoot();
        System.out.println("Root: " + string);
        String[] stringArray2 = pathTokenizer.getTokens();
        if (stringArray2 != null) {
            int n = 0;
            while (n < stringArray2.length) {
                System.out.println("Token " + n + ": " + stringArray2[n]);
                ++n;
            }
        }
    }
}

