/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import java.net.URL;
import java.security.CodeSource;

public class ResourceLocator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String GetRootPathFromMarkerClassName(String string) {
        try {
            Object object = ODCClassLoader.getClassInstance(string);
            return ResourceLocator.GetRootPath(object);
        }
        catch (Exception exception) {
            String string2 = "Cannot locate Marker class '" + string + "'.";
            Streamer.error.println(string2);
            Streamer.error.printStackTrace(exception);
            throw new Error(string2);
        }
    }

    public static String GetRootPath(Object object) {
        CodeSource codeSource = object.getClass().getProtectionDomain().getCodeSource();
        String string = null;
        if (codeSource != null) {
            URL uRL = codeSource.getLocation();
            string = uRL.toString();
        } else {
            string = "null";
        }
        if (!string.startsWith("file:/")) {
            String string2 = "The path for the class '" + object.getClass().getName() + "' came back as '" + string + "', which is not a file resource (does not start with 'file:/'). A class with a proper file resource is required.";
            Streamer.error.Header().println(string2);
            throw new Error(string2);
        }
        string = string.substring("file:/".length());
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(ResourceLocator.GetRootPath(new ResourceLocator()));
    }
}

