/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.EnumBoolean;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class SaxBase
extends HandlerBase {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected int _Line;
    protected int _Warning;
    protected int _Error;
    protected String _XmlFileSource;

    public int getWarning() {
        return this._Warning;
    }

    public int getError() {
        return this._Error;
    }

    public String getXmlFileSource() {
        return this._XmlFileSource;
    }

    public void setXmlFileSource(String string) {
        this._XmlFileSource = string;
    }

    protected final void Parse(String string) throws Exception {
        try {
            this._XmlFileSource = string;
            SAXParser sAXParser = null;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParser = sAXParserFactory.newSAXParser();
            this._Error = 0;
            this._Warning = 0;
            this._Line = 1;
            Streamer.status.Header().println("Starting  parsing XML file " + this._XmlFileSource);
            sAXParser.parse(new File(this._XmlFileSource), (HandlerBase)this);
            Streamer.status.Header().println("Ending parsing XML file " + this._XmlFileSource);
            if (this._Error != 0) {
                Streamer.error.Header().println("There were " + this._Error + " Errors.");
            }
            if (this._Warning != 0) {
                Streamer.error.Header().println("There were " + this._Warning + " Warnings.");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Streamer.error.Header().println("XML Parser Configuration Exception");
            Streamer.error.Header().printStackTrace(parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            Streamer.error.Header().println("Parsing Exception on file");
            throw sAXException;
        }
        catch (IOException iOException) {
            Streamer.error.Header().println("File I/O Exception");
            throw iOException;
        }
    }

    protected final void Parse(InputStream inputStream) throws Exception {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this._Error = 0;
            this._Warning = 0;
            this._Line = 1;
            Streamer.status.Header().println("Starting  parsing XML InputStream");
            sAXParser.parse(inputStream, (HandlerBase)this);
            Streamer.status.Header().println("Ending parsing XML InputStream");
            if (this._Error != 0) {
                Streamer.error.Header().println("There were " + this._Error + " Errors.");
            }
            if (this._Warning != 0) {
                Streamer.error.Header().println("There were " + this._Warning + " Warnings.");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Streamer.error.Header().println("XML Parser Configuration Exception");
            Streamer.error.Header().printStackTrace(parserConfigurationException);
            throw parserConfigurationException;
        }
        catch (SAXException sAXException) {
            Streamer.error.Header().println("Parsing Exception on InputStream");
            throw sAXException;
        }
    }

    public String CheckAttribute(AttributeList attributeList, String string, String string2, boolean bl) {
        String string3 = attributeList.getValue(string);
        if (string3 == null && bl) {
            Streamer.error.Header().println("Line " + this._Line + ", missing attribute '" + string + "'.");
            ++this._Error;
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public int CheckAttributeInt(AttributeList attributeList, String string, int n, boolean bl) {
        int n2;
        block2: {
            String string2 = this.CheckAttribute(attributeList, string, null, bl);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                Streamer.error.Header().println("Line " + this._Line + ", invalid value type for '" + string + "'. A positive integer expected.");
                ++this._Error;
            }
        }
        return n2;
    }

    public boolean CheckAttributeBool(AttributeList attributeList, String string, boolean bl, boolean bl2) {
        String string2 = this.CheckAttribute(attributeList, string, null, bl2);
        boolean bl3 = bl;
        if (string2 != null) {
            Boolean bl4 = EnumBoolean.getType(string2);
            if (bl4 != null) {
                bl3 = bl4;
            } else {
                Streamer.error.Header().println("Line " + this._Line + ", invalid value type for '" + string + "'. A boolean 'Y', '1', 'N' or '0' expected.");
                ++this._Error;
            }
        }
        return bl3;
    }
}

