/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.PropertiesUtil;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Calendar;

public final class Streamer {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String NULL = "null";
    protected static final Calendar _START_TIME = Calendar.getInstance();
    protected static Object _Mutex = new Object();
    protected static final boolean OVERRIDE_STDERR = false;
    protected static ThreadLocal _S = new ThreadLocal();
    static final int MAX_LOG_SIZE = 0x800000;
    static int _LogSize = 0;
    public static final String NEWLINE = System.getProperty("line.separator");
    protected static PrintStream _Stream = null;
    protected static int _LogLevel = Config.getIntegerSilent(Config.PROP_SERVER_LOG_LEVEL, 1);
    protected static int _SavedLogLevel = -666;
    protected static int _LookAhead = 256;
    protected static int _SavedLookAhead = -666;
    protected final int _StreamLevel;
    protected final String _Header;
    public static final Streamer defect = new Streamer(-1, "DEFECT!: T-H-I-S...S-H-O-U-L-D...N-E-V-E-R...H-A-P-P-E-N.!!!!! ");
    public static final Streamer error = new Streamer(0, "ERROR  : ");
    public static final Streamer warning = new Streamer(1, "WARNING: ");
    public static final Streamer status = new Streamer(2, "STATUS : ");
    public static final Streamer debug = new Streamer(3, "DEBUG  : ");
    public static final Streamer trace = new Streamer(4, "TRACE  : ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Streamer(int n, String string) {
        this._StreamLevel = n;
        this._Header = string;
        if (_Stream == null) {
            Object object = _Mutex;
            synchronized (object) {
                if (_Stream == null) {
                    Streamer.Init();
                }
            }
        }
    }

    public static void ForceStdErr() {
        if (_Stream != System.err) {
            _Stream.close();
            _Stream = System.err;
        }
    }

    public static Calendar getStartTime() {
        return _START_TIME;
    }

    protected static final synchronized void Init() {
        String string = Config.getStringSilent(Config.PROP_SERVER_LOG_FILENAME);
        if (string == null || string.trim().length() == 0) {
            _Stream = System.err;
        } else {
            try {
                _Stream = new PrintStream(new FileOutputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                _Stream = System.err;
                System.err.println("Could not open file '" + string + "' for logging. Using System.err.");
            }
        }
    }

    public static StringBuffer StartThread() {
        StringBuffer stringBuffer = (StringBuffer)_S.get();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(4096);
            _S.set(stringBuffer);
        }
        return stringBuffer;
    }

    public static void FlushThreadInternal(StringBuffer stringBuffer, int n) {
        Streamer.FlushThread(stringBuffer, n);
    }

    public static void FlushThread() {
        StringBuffer stringBuffer = (StringBuffer)_S.get();
        Streamer.FlushThread(stringBuffer, 1);
    }

    public static void FlushThread(StringBuffer stringBuffer, int n) {
        MoreConcurrency.Write(stringBuffer.toString(), n);
        stringBuffer.setLength(0);
    }

    protected static void FlushThread(Throwable throwable) {
        StringBuffer stringBuffer = (StringBuffer)_S.get();
        MoreConcurrency.Write(stringBuffer.toString(), throwable);
        stringBuffer.setLength(0);
    }

    public static void EndThread() {
        Streamer.EndThread(1);
    }

    public static void EndThread(int n) {
        StringBuffer stringBuffer = (StringBuffer)_S.get();
        MoreConcurrency.Write(stringBuffer.toString(), n);
        _S.set(null);
        stringBuffer = null;
    }

    public static int getLogLevel() {
        return _LogLevel;
    }

    public static void setLogLevel(int n) {
        _LogLevel = n;
    }

    public static void pushLogLevel(int n) {
        if (_SavedLogLevel == -666) {
            _SavedLogLevel = _LogLevel;
        }
        _LogLevel = n;
    }

    public static void popLogLevel() {
        _LogLevel = _SavedLogLevel;
        _SavedLogLevel = -666;
    }

    public static int getLookAhead() {
        return _LookAhead;
    }

    public static void setLookAhead(int n) {
        _LookAhead = n;
    }

    public static void pushLookAhead(int n) {
        if (_SavedLookAhead == -666) {
            _SavedLookAhead = _LookAhead;
        }
        _LookAhead = n;
    }

    public static void popLookAhead() {
        _LookAhead = _SavedLookAhead;
        _SavedLookAhead = -666;
    }

    public static PrintStream getStream() {
        return _Stream;
    }

    public final boolean isActivated() {
        return this._StreamLevel <= _LogLevel;
    }

    public final Streamer Header() {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.StartThread().append(this._Header);
        }
        return this;
    }

    public final Streamer println() {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(boolean bl) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.StartThread().append(bl);
        }
        return this;
    }

    public final Streamer println(boolean bl) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(bl).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(long l) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.StartThread().append(l);
        }
        return this;
    }

    public final Streamer println(long l) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(l).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(double d) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.StartThread().append(d);
        }
        return this;
    }

    public final Streamer println(double d) {
        if (this._StreamLevel <= _LogLevel) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(d).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(char[] cArray) {
        if (this.isActivated()) {
            Streamer.StartThread().append(new String(cArray));
        }
        return this;
    }

    public final Streamer println(char[] cArray) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(cArray)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(byte[] byArray) {
        if (this.isActivated()) {
            Streamer.StartThread().append(new String(byArray));
        }
        return this;
    }

    public final Streamer println(byte[] byArray) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(byArray)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(String string) {
        if (this.isActivated()) {
            Streamer.StartThread().append(string);
        }
        return this;
    }

    public final Streamer println(String string) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(string).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer print(Object object) {
        if (this.isActivated()) {
            Streamer.StartThread().append(object != null ? object.toString() : NULL);
        }
        return this;
    }

    public final Streamer println(Object object) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(object != null ? object.toString() : NULL).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(String string, int n) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(string.substring(n, n + _LookAhead > string.length() ? string.length() - n : _LookAhead)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(String string, int n, int n2) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(string.substring(n, n2 - n + 1)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(char[] cArray, int n) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(cArray, n, n + _LookAhead > cArray.length ? cArray.length - n : _LookAhead)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(char[] cArray, int n, int n2) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(cArray, n, n2 - n + 1)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(byte[] byArray, int n) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(byArray, n, n + _LookAhead > byArray.length ? byArray.length - n : _LookAhead)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printSubstring(byte[] byArray, int n, int n2) {
        if (this.isActivated()) {
            Streamer.FlushThreadInternal(Streamer.StartThread().append(new String(byArray, n, n2 - n + 1)).append(NEWLINE), this._StreamLevel);
        }
        return this;
    }

    public final Streamer printStackTrace(Throwable throwable) {
        if (this.isActivated()) {
            Streamer.FlushThread(throwable);
        }
        return this;
    }

    public static final void Separator() {
        Streamer.FlushThreadInternal(Streamer.StartThread().append(NEWLINE).append(NEWLINE).append(NEWLINE).append("------------------------------------------------------------------------------------------").append(NEWLINE).append(NEWLINE), 2);
    }

    public static void main(String[] stringArray) {
        Object object;
        Streamer.StartThread();
        try {
            object = new PropertiesUtil();
            ((PropertiesUtil)object).Open("D:\\projects\\OBF\\odc-jsf\\OdysseyBrowserFramework.properties");
            ((PropertiesUtil)object).AddProperty(Config.PROP_ECORE_FILES.toString(), "toto.ecore");
            ((PropertiesUtil)object).AddProperty(Config.PROP_EMAP_FILES.toString(), "toto.emap");
            ((PropertiesUtil)object).Save();
            Config.ReInit();
        }
        catch (Exception exception) {
            error.Header().println("Cannot update the properties file resources");
            error.Header().printStackTrace(exception);
        }
        Streamer.Init();
        object = new Object();
        try {
            int n = 0;
            while (n < 10) {
                error.Header().println("Hello...");
                warning.Header().println("Hello...");
                debug.Header().println("Hello...");
                if (n % 10 == 0) {
                    Streamer.FlushThread();
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < 1000) {
                    ++n2;
                    ++n3;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            error.Header().printStackTrace(exception);
        }
        Streamer.EndThread();
    }

    static class MoreConcurrency {
        MoreConcurrency() {
        }

        public static synchronized void Write(String string, int n) {
            _LogSize += string.length();
            if (_Stream == System.err && n > 1) {
                System.out.print(string);
            } else {
                _Stream.print(string);
            }
        }

        public static synchronized void Write(String string, Throwable throwable) {
            MoreConcurrency.Write(string, 0);
            throwable.printStackTrace(_Stream);
        }
    }
}

