/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.ODCClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class TypesUtil {
    public static final String DATE_ETYPE = "EDate";
    public static final String BIG_DECIMAL_ETYPE = "EBigDecimal";
    private static final String[] DECIMAL_TYPES = new String[]{"java.lang.Double", "java.lang.Float", "java.math.BigDecimal", "double", "float"};
    protected static final TypeInfo[] BASIC_TYPES = new TypeInfo[]{new TypeInfo(class$java$lang$String == null ? (class$java$lang$String = TypesUtil.class$("java.lang.String")) : class$java$lang$String, "[Ljava.lang.String;", "string", "EString", "getString", "setString", 'S', false), new TypeInfo(class$java$lang$Character == null ? (class$java$lang$Character = TypesUtil.class$("java.lang.Character")) : class$java$lang$Character, "[Ljava.lang.Character;", "char", "ECharObject", "getChar", "setChar", 'C', false), new TypeInfo(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypesUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean, "[Ljava.lang.Boolean;", "boolean", "EBooleanObject", "getBoolean", "setBoolean", 'B', false), new TypeInfo(class$java$lang$Double == null ? (class$java$lang$Double = TypesUtil.class$("java.lang.Double")) : class$java$lang$Double, "[Ljava.lang.Double;", "float", "EDoubleObject", "getDouble", "setDouble", 'N', false), new TypeInfo(class$java$lang$Float == null ? (class$java$lang$Float = TypesUtil.class$("java.lang.Float")) : class$java$lang$Float, "[Ljava.lang.Float;", "float", "EFloatObject", "getFloat", "setFloat", 'N', false), new TypeInfo(class$java$lang$Integer == null ? (class$java$lang$Integer = TypesUtil.class$("java.lang.Integer")) : class$java$lang$Integer, "[Ljava.lang.Integer;", "int", "EIntegerObject", "getInt", "setInt", 'N', false), new TypeInfo(class$java$lang$Long == null ? (class$java$lang$Long = TypesUtil.class$("java.lang.Long")) : class$java$lang$Long, "[Ljava.lang.Long;", "int", "ELongObject", "getLong", "setLong", 'N', false), new TypeInfo(class$java$lang$Short == null ? (class$java$lang$Short = TypesUtil.class$("java.lang.Short")) : class$java$lang$Short, "[Ljava.lang.Short;", "int", "EShortObject", "getShort", "setShort", 'N', false), new TypeInfo(class$java$lang$Byte == null ? (class$java$lang$Byte = TypesUtil.class$("java.lang.Byte")) : class$java$lang$Byte, "[Ljava.lang.Byte;", "int", "EByteObject", "getByte", "setByte", 'N', false), new TypeInfo(class$java$util$Date == null ? (class$java$util$Date = TypesUtil.class$("java.util.Date")) : class$java$util$Date, "[Ljava.util.Date;", "date", "EDate", "getDate", "setDate", 'D', false), new TypeInfo(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypesUtil.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, "[Ljava.math.BigDecimal;", "float", "EBigDecimal", "getBigDecimal", "setBigDecimal", 'N', false), new TypeInfo(Character.TYPE, "[C", "char", "EChar", "getChar", "setChar", 'C', true), new TypeInfo(Boolean.TYPE, "[Z", "boolean", "EBoolean", "getBoolean", "setBoolean", 'B', true), new TypeInfo(Double.TYPE, "[D", "float", "EDouble", "getDouble", "setDouble", 'N', true), new TypeInfo(Float.TYPE, "[F", "float", "EFloat", "getFloat", "setFloat", 'N', true), new TypeInfo(Integer.TYPE, "[I", "int", "EInt", "getInt", "setInt", 'N', true), new TypeInfo(Long.TYPE, "[J", "int", "ELong", "getLong", "setLong", 'N', true), new TypeInfo(Short.TYPE, "[S", "int", "EShort", "getShort", "setShort", 'N', true), new TypeInfo(Byte.TYPE, "[B", "int", "EByte", "getByte", "setByte", 'N', true)};
    public static final String BASIC_ETYPE_PREFIX = "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//";
    public static final String CUSTOM_ETYPE_PREFIX = "#//";
    protected static final String UNSUPPORTED_TYPE_HEADER = "__UNSUPPORTED_TYPE__";
    protected static final String UNKNOWN_TYPE_HEADER = "__UNKNOWN_TYPE__";
    protected static final String[][] BAD_TYPES_MAP = new String[][]{{"WDOByteArray", "__UNSUPPORTED_TYPE__WDOByteArray"}, {"EByteArray", "__UNSUPPORTED_TYPE__EByteArray"}};
    public static final String WDO_ETYPE_PREFIX = "ecore:EDataType http://ibm.com/wdo#//";
    protected static final String[][] SDO_TO_WDO_ETYPE_MAP = new String[][]{{"EDate", "WDODate"}, {"EBigDecimal", "WDOBigDecimal"}, {"EByteArray", "WDOByteArray"}};
    public static final Class[] COLLECTION_TYPES = new Class[]{class$java$util$Collection == null ? (class$java$util$Collection = TypesUtil.class$("java.util.Collection")) : class$java$util$Collection, class$java$util$List == null ? (class$java$util$List = TypesUtil.class$("java.util.List")) : class$java$util$List, class$java$util$Iterator == null ? (class$java$util$Iterator = TypesUtil.class$("java.util.Iterator")) : class$java$util$Iterator, class$com$ibm$odcb$jrender$datamodels$ODCDataModel == null ? (class$com$ibm$odcb$jrender$datamodels$ODCDataModel = TypesUtil.class$("com.ibm.odcb.jrender.datamodels.ODCDataModel")) : class$com$ibm$odcb$jrender$datamodels$ODCDataModel};
    public static final String[] INVALID_PROPERTY_NAMES = new String[]{"char", "boolean", "double", "float", "int", "long", "short", "byte", "class", "character", "integer", "object"};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$com$ibm$odcb$jrender$datamodels$ODCDataModel;

    public static boolean isDecimalType(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < DECIMAL_TYPES.length) {
            if (string.equals(DECIMAL_TYPES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isBasicJavaType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaType.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isPrimitiveJavaType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._Primitive && TypesUtil.BASIC_TYPES[n]._JavaType.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isArrayOfBasicJavaType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isArrayOfComplexJavaType(String string) {
        return TypesUtil.isArray(string) && !TypesUtil.isArrayOfBasicJavaType(string);
    }

    public static boolean isArrayOfBasicJavaType(String string, boolean bl) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._Primitive == bl && TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isArrayOfNonPrimitiveJavaType(String string) {
        return TypesUtil.isArray(string) && !string.equals("[Ljava.lang.Object;");
    }

    public static boolean isArray(String string) {
        return string.startsWith("[L") && string.endsWith(";");
    }

    public static String getComplexJavaTypeFromArrayType(String string) {
        return string.substring(2, string.length() - 1).replace('$', '.') + "[]";
    }

    public static String getBaseJavaTypeFromArrayType(String string) {
        return string.substring(2, string.length() - 1).replace('$', '.');
    }

    public static boolean isBasicEDataType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._EDataType.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isJavaObjectType(String string, boolean bl) {
        return string.equals((class$java$lang$Object == null ? (class$java$lang$Object = TypesUtil.class$("java.lang.Object")) : class$java$lang$Object).getName()) || bl && string.equals((array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = TypesUtil.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object).getName());
    }

    public static String getSimplifiedTypeFromJavaType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._SimpleType;
            }
            if (TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._SimpleType;
            }
            ++n;
        }
        return null;
    }

    public static String getEDataTypeFromJavaType(String string, boolean bl) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaType.equals(string) || bl && TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._EDataType;
            }
            ++n;
        }
        return null;
    }

    public static String getEDataTypeFromJavaType(String string) {
        return TypesUtil.getEDataTypeFromJavaType(string, false);
    }

    public static String getJavaTypeFromEDataType(String string, boolean bl) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._EDataType.equals(string)) {
                return bl ? TypesUtil.BASIC_TYPES[n]._JavaArrayType : TypesUtil.BASIC_TYPES[n]._JavaType;
            }
            ++n;
        }
        return null;
    }

    public static String getJavaTypeFromArrayType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._JavaType;
            }
            ++n;
        }
        return null;
    }

    public static String getShortJavaTypeFromArrayType(String string) {
        String string2 = TypesUtil.getJavaTypeFromArrayType(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    public static char getOutputTypeFromJavaType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._JavaType.equals(string) || TypesUtil.BASIC_TYPES[n]._JavaArrayType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._OutputType;
            }
            ++n;
        }
        return ' ';
    }

    public static char getOutputTypeFromEDataType(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._EDataType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._OutputType;
            }
            ++n;
        }
        return ' ';
    }

    public static boolean isUnsupportedSDOType(String string) {
        boolean bl = false;
        int n = 0;
        while (n < BAD_TYPES_MAP.length) {
            if (BAD_TYPES_MAP[n][0].equals(string)) {
                return true;
            }
            ++n;
        }
        return bl;
    }

    public static boolean hasWDOEquivalent(String string) {
        boolean bl = false;
        int n = 0;
        while (n < SDO_TO_WDO_ETYPE_MAP.length) {
            if (SDO_TO_WDO_ETYPE_MAP[n][0].equals(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public static String getWDOEquivalent(String string) {
        String string2 = null;
        int n = 0;
        while (n < SDO_TO_WDO_ETYPE_MAP.length) {
            if (SDO_TO_WDO_ETYPE_MAP[n][0].equals(string)) {
                string2 = SDO_TO_WDO_ETYPE_MAP[n][1];
                break;
            }
            ++n;
        }
        return string2;
    }

    public static String getFullEType(String string, boolean bl) {
        if (TypesUtil.isBasicEDataType(string) || TypesUtil.isUnsupportedSDOType(string)) {
            if (bl && TypesUtil.hasWDOEquivalent(string)) {
                string = TypesUtil.getWDOEquivalent(string);
                string = WDO_ETYPE_PREFIX + string;
            } else {
                string = BASIC_ETYPE_PREFIX + string;
            }
        } else {
            string = CUSTOM_ETYPE_PREFIX + string;
        }
        return string;
    }

    public static String getEDataGet(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._EDataType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._EDataGet;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < BAD_TYPES_MAP.length) {
            if (BAD_TYPES_MAP[n2][0].equals(string)) {
                return BAD_TYPES_MAP[n2][1];
            }
            ++n2;
        }
        return UNKNOWN_TYPE_HEADER + string;
    }

    public static String getEDataSet(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._EDataType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._EDataSet;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < BAD_TYPES_MAP.length) {
            if (BAD_TYPES_MAP[n2][0].equals(string)) {
                return BAD_TYPES_MAP[n2][1];
            }
            ++n2;
        }
        return UNKNOWN_TYPE_HEADER + string;
    }

    public static boolean isUnsupportedType(String string) {
        return string.startsWith(UNSUPPORTED_TYPE_HEADER) || string.startsWith(UNKNOWN_TYPE_HEADER);
    }

    private static final boolean isGeneralListInternal(String string, boolean bl) throws ClassNotFoundException {
        if (TypesUtil.isBasicJavaType(string)) {
            return false;
        }
        if (string.charAt(0) == '[') {
            return bl;
        }
        Class clazz = ODCClassLoader.getClass(string);
        int n = 0;
        while (n < COLLECTION_TYPES.length) {
            if (COLLECTION_TYPES[n].isAssignableFrom(clazz)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isGeneralList(String string) throws ClassNotFoundException {
        return TypesUtil.isGeneralListInternal(string, true);
    }

    public static boolean isGeneralListNoArrays(String string) throws ClassNotFoundException {
        return TypesUtil.isGeneralListInternal(string, false);
    }

    public static boolean isCollection(String string) throws ClassNotFoundException {
        return (class$java$util$Collection == null ? (class$java$util$Collection = TypesUtil.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(ODCClassLoader.getClass(string));
    }

    public static boolean isValidProperty(String string) {
        int n = 0;
        while (n < INVALID_PROPERTY_NAMES.length) {
            if (string.equals(INVALID_PROPERTY_NAMES[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getRealETypeName(EClassifier eClassifier) {
        int n;
        String string = eClassifier.getName();
        if (eClassifier.getInstanceClassName() != null) {
            String string2 = eClassifier.getInstanceClassName();
            int n2 = 0;
            while (n2 < BASIC_TYPES.length) {
                if (string2.equals(TypesUtil.BASIC_TYPES[n2]._JavaType)) {
                    return TypesUtil.BASIC_TYPES[n2]._EDataType;
                }
                ++n2;
            }
        }
        if (string != null) {
            return string;
        }
        if (eClassifier.eIsProxy() && eClassifier instanceof EObjectImpl) {
            string = ((EObjectImpl)eClassifier).eProxyURI().toString();
        }
        if (string == null && (n = (string = eClassifier.toString()).indexOf("(eProxyURI: ")) != -1) {
            string = string.substring(n + "(eProxyURI: ".length(), string.length() - 1);
        }
        if (string != null) {
            int n3 = 0;
            while (n3 < BASIC_TYPES.length) {
                if (string.endsWith("//" + TypesUtil.BASIC_TYPES[n3]._EDataType)) {
                    return TypesUtil.BASIC_TYPES[n3]._EDataType;
                }
                ++n3;
            }
        }
        return null;
    }

    public static Class getPrimitiveTypeClass(String string) {
        int n = 0;
        while (n < BASIC_TYPES.length) {
            if (TypesUtil.BASIC_TYPES[n]._Primitive && TypesUtil.BASIC_TYPES[n]._JavaType.equals(string)) {
                return TypesUtil.BASIC_TYPES[n]._JavaClass;
            }
            ++n;
        }
        return null;
    }

    public static boolean isInstantiable(Class clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < constructorArray.length) {
            Constructor<?> constructor = constructorArray[n];
            if (constructor.getParameterTypes().length == 0) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class TypeInfo {
        public Class _JavaClass;
        public String _JavaType;
        public String _JavaArrayType;
        public String _SimpleType;
        public String _EDataType;
        public String _EDataGet;
        public String _EDataSet;
        public char _OutputType;
        public boolean _Primitive;
        public static final char _CHAR_OUT = 'C';
        public static final char _STRING_OUT = 'S';
        public static final char _NUMBER_OUT = 'N';
        public static final char _DATE_OUT = 'D';
        public static final char _BOOL_OUT = 'B';
        public static final char _DEFAULT_OUT = ' ';

        public TypeInfo(Class clazz, String string, String string2, String string3, String string4, String string5, char c, boolean bl) {
            this._JavaClass = clazz;
            this._JavaType = clazz.getName();
            this._JavaArrayType = string;
            this._SimpleType = string2;
            this._EDataType = string3;
            this._EDataGet = string4;
            this._EDataSet = string5;
            this._OutputType = c;
            this._Primitive = bl;
        }
    }
}

