/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.utilities;

import com.ibm.odcb.jrender.misc.ClassGraphWalker;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.TypesUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Bean2ECoreGen {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static boolean _RETURN = true;
    protected static HashMap _KnownTypes;

    public static void main(String[] stringArray) {
        Streamer.ForceStdErr();
        Streamer.StartThread();
        Streamer.status.println().Header().println("USAGE: Bean2ECoreGen <project root path> <relative ecore file path>\n                     <root java class>\n                     ( <path expression> <java class> )*\n                     ( -include|-exclude ( <path expression> P|C )* )\n   You must specify the root of your project path (such as c:\\projects\\MyApp\\src) \n and the relative path from there to where you want the ecore file to be output (such \n as com/mycompany/myapp/myecores/abc.ecore).\n   Then, based on the root Java class specified, the utility recurses through all its\n members and writes out a matching ECore file. For generic types Collection and \n Iterator, the utility looks up the supplied list of path expressions to find a matching\n Java type. If not found, the property is discarded. For instance, a Java bean A may have\n a property x of type List, which contains instances of Java bean com.ibm.B. The utility \n would expect a pair 'com.ibm.A.x  com.ibm.B', where 'com.ibm.A.x' is the \"path\" to the \n property to match, and 'com.ibm.B' is the type of the contained Java bean B.\n   Then, you can specify classes ('C') and properties ('P') that you want to specifically\n include or exclude. Like the previous list, you specify a \"path\" starting with the fully\n qualified class name, and add information whether the path specifies a class or a property.\n If the list is included, nothing else but what is specified on the list will be in the ECore.\n If the list is excluded, then everything but what is in the list will be in the ECore. If the\n list is not supplied, then everything in the classes found will be processed.\n\n");
        Params params = new Params();
        if (params.Parse(stringArray)) {
            try {
                Bean2ECoreGen.Process(params);
            }
            catch (Exception exception) {
                Streamer.error.Header().printStackTrace(exception);
                _RETURN = false;
            }
        } else {
            _RETURN = false;
        }
        Streamer.status.Header().println("Bean2ECoreGen ended.");
        Streamer.EndThread();
    }

    public static void Process(Params params) throws Exception {
        ECoreWalker eCoreWalker = new ECoreWalker(params._BasePath, params._ECoreFile);
        ClassGraphWalker classGraphWalker = new ClassGraphWalker(params._RootJavaClassName, params._Mappings, params._Include, params._IncludesExcludes);
        classGraphWalker.Walk(eCoreWalker);
        _KnownTypes = eCoreWalker._Types;
    }

    public static HashMap GetKnownTypesAndClear() {
        HashMap hashMap = _KnownTypes;
        _KnownTypes = null;
        return hashMap;
    }

    public static class ECoreWalker
    implements ClassGraphWalker.Walker {
        protected File _BasePath;
        protected File _ECoreFile;
        protected String _PackageName;
        protected String _JavaClassName;
        protected PrintWriter _Out;
        protected HashMap _StringBuffers = new HashMap(17);
        protected HashMap _Types = new HashMap(17);

        public ECoreWalker(File file, File file2) throws Exception {
            this._BasePath = file;
            this._ECoreFile = file2;
            this._Out = new PrintWriter(new FileOutputStream(this._ECoreFile));
            Streamer.status.Header().println("Generating file '" + this._ECoreFile.getPath() + "'");
        }

        public boolean Begin(Class clazz) {
            this._Out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this._Out.println("<ecore:EPackage xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ecore=\"http://www.eclipse.org/emf/2002/Ecore\"");
            String string = this._ECoreFile.getName();
            string = string.substring(0, string.indexOf(".ecore"));
            this._Out.println("                name=\"" + string + "\"");
            this._PackageName = string;
            string = this._ECoreFile.getPath().substring(this._BasePath.getPath().length() + 1).replace('\\', '/');
            this._Out.println("                nsURI=\"http:///" + string + "\"");
            string = string.substring(0, string.lastIndexOf(".ecore")).replace('/', '.');
            this._Out.println("                nsPrefix=\"" + string + "\">");
            return true;
        }

        public boolean ProcessClassBegin(String string, Class clazz, int n) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("   <eClassifiers xsi:type=\"ecore:EClass\" name=\"" + this.MakeEClassifier(clazz.getName()) + "\">");
            this._StringBuffers.put(clazz.getName(), stringBuffer);
            return true;
        }

        public boolean ProcessBasicProperty(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2, int n) {
            StringBuffer stringBuffer = (StringBuffer)this._StringBuffers.get(clazz.getName());
            String string4 = TypesUtil.getEDataTypeFromJavaType(string3);
            string4 = string4.equals("WDODate") ? "ecore:EDataType http://ibm.com/wdo#//WDODate" : (string4.equals("WDOBigDecimal") ? "ecore:EDataType http://ibm.com/wdo#//WDOBigDecimal" : (string4.equals("EJavaObject") ? "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//EString" : "ecore:EDataType http://www.eclipse.org/emf/2002/Ecore#//" + string4));
            stringBuffer.append(Streamer.NEWLINE).append("      <eAttributes name=\"").append(string2).append("\" eType=\"").append(string4).append("\" lowerBound=\"").append(bl ? 0 : 1).append("\" upperBound=\"").append(bl ? -1 : 1);
            if (bl2) {
                stringBuffer.append("\" changeable=\"false");
            }
            stringBuffer.append("\"/>");
            return true;
        }

        public boolean ProcessComplexProperty(String string, Class clazz, String string2, String string3, boolean bl, boolean bl2, boolean bl3, int n) {
            if (!bl3) {
                return false;
            }
            StringBuffer stringBuffer = (StringBuffer)this._StringBuffers.get(clazz.getName());
            stringBuffer.append(Streamer.NEWLINE).append("      <eReferences name=\"").append(string2).append("\" eType=\"#//").append(this.MakeEClassifier(string3)).append("\" lowerBound=\"0\" upperBound=\"").append(bl ? -1 : 1).append("\" containment=\"false");
            if (bl2) {
                stringBuffer.append("\" changeable=\"false");
            }
            stringBuffer.append("\"/>");
            return !string3.equals(clazz.getName());
        }

        public boolean ProcessClassEnd(String string, Class clazz, boolean bl, int n) {
            StringBuffer stringBuffer = (StringBuffer)this._StringBuffers.remove(clazz.getName());
            if (bl) {
                this._Out.println();
                this._Out.println(stringBuffer);
                this._Out.println("   </eClassifiers>");
            } else {
                this._Out.println();
                this._Out.print("<!--");
                this._Out.print(stringBuffer);
                this._Out.println("</eClassifiers>   -->");
                this.RemoveEClassifier(clazz.getName());
            }
            return bl;
        }

        public boolean End(Class clazz) {
            this._Out.println();
            this._Out.println("</ecore:EPackage>");
            this._Out.close();
            return true;
        }

        public final void RemoveEClassifier(String string) {
            Streamer.debug.Header().println("Removing " + string);
            Iterator iterator = this._Types.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getValue();
                if (!string2.equals(string)) continue;
                this._Types.remove((String)entry.getKey());
                Streamer.debug.Header().println("    -->> Removed " + string2 + ":" + (String)entry.getKey());
                break;
            }
        }

        public final String MakeEClassifier(String string) {
            boolean bl;
            int n = string.lastIndexOf(36);
            if (n == -1) {
                n = string.lastIndexOf(46);
                bl = false;
            } else {
                bl = true;
            }
            String string2 = string.substring(n + 1);
            String string3 = (String)this._Types.get(string2);
            if (string3 == null) {
                Streamer.debug.Header().println("Adding " + string2 + ":" + string);
                this._Types.put(string2, string);
                return string2;
            }
            if (string3.equals(string)) {
                return string2;
            }
            if (bl) {
                string2 = string.substring(string.lastIndexOf(46) + 1);
                string3 = (String)this._Types.get(string2);
                if (string3 == null) {
                    Streamer.debug.Header().println("Adding " + string2 + ":" + string);
                    string2 = string2.replace('$', '_');
                    this._Types.put(string2, string);
                    return string2;
                }
                if (string3.equals(string)) {
                    return string2.replace('$', '_');
                }
            }
            String string4 = string.replace('.', '_').replace('$', '_');
            Streamer.debug.Header().println("Adding " + string4 + ":" + string);
            this._Types.put(string4, string);
            return string;
        }
    }

    public static class Params {
        public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
        public static final String USAGE = "USAGE: Bean2ECoreGen <project root path> <relative ecore file path>\n                     <root java class>\n                     ( <path expression> <java class> )*\n                     ( -include|-exclude ( <path expression> P|C )* )\n   You must specify the root of your project path (such as c:\\projects\\MyApp\\src) \n and the relative path from there to where you want the ecore file to be output (such \n as com/mycompany/myapp/myecores/abc.ecore).\n   Then, based on the root Java class specified, the utility recurses through all its\n members and writes out a matching ECore file. For generic types Collection and \n Iterator, the utility looks up the supplied list of path expressions to find a matching\n Java type. If not found, the property is discarded. For instance, a Java bean A may have\n a property x of type List, which contains instances of Java bean com.ibm.B. The utility \n would expect a pair 'com.ibm.A.x  com.ibm.B', where 'com.ibm.A.x' is the \"path\" to the \n property to match, and 'com.ibm.B' is the type of the contained Java bean B.\n   Then, you can specify classes ('C') and properties ('P') that you want to specifically\n include or exclude. Like the previous list, you specify a \"path\" starting with the fully\n qualified class name, and add information whether the path specifies a class or a property.\n If the list is included, nothing else but what is specified on the list will be in the ECore.\n If the list is excluded, then everything but what is in the list will be in the ECore. If the\n list is not supplied, then everything in the classes found will be processed.\n\n";
        public File _BasePath;
        public File _ECoreFile;
        public String _RootJavaClassName;
        public Map _Mappings = new HashMap(17);
        public boolean _Include = false;
        public Map _IncludesExcludes = new HashMap(17);

        public boolean Parse(String[] stringArray) {
            if (stringArray.length < 3) {
                Streamer.error.Header().println("The utility needs to be invoked with at least 3 parameters.");
                return false;
            }
            this._BasePath = new File(stringArray[0]);
            if (!this._BasePath.isDirectory()) {
                Streamer.error.Header().println("The first parameter '" + stringArray[0] + "' is not a valid path.");
                return false;
            }
            if (!stringArray[1].endsWith(".ecore")) {
                Streamer.error.Header().println("The second parameter '" + stringArray[1] + "' needs to end in '.ecore'.");
                return false;
            }
            this._ECoreFile = new File(stringArray[0].replace('/', File.separatorChar) + File.separator + stringArray[1].replace('/', File.separatorChar));
            File file = new File(this._ECoreFile.getParent());
            if (!file.isDirectory() && !file.mkdirs()) {
                Streamer.error.Header().println("The second parameter '" + this._ECoreFile + "' does not point to a valid path, or a path which cannot be created off the project root path");
                return false;
            }
            this._RootJavaClassName = stringArray[2];
            if (stringArray.length == 3) {
                return true;
            }
            int n = 3;
            String string = null;
            while (n < stringArray.length) {
                string = stringArray[n].toLowerCase();
                if (string.equals("-include") || string.equals("-exclude")) break;
                if (n + 1 < stringArray.length) {
                    Streamer.error.Header().println("There is an incomplete pair of arguments in the mappings list starting with " + stringArray[n]);
                    return false;
                }
                this._Mappings.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
            if (n == stringArray.length) {
                return true;
            }
            this._Include = string.equals("-include");
            ++n;
            while (n < stringArray.length) {
                if (n + 1 < stringArray.length) {
                    Streamer.error.Header().println("There is an incomplete pair of arguments in the include/exclude list starting with " + stringArray[n]);
                    return false;
                }
                String string2 = stringArray[n + 1];
                if (!string2.equals("C") || !string2.equals("P")) {
                    Streamer.error.Header().println("The pair of arguments in the include/exclude list starting with " + stringArray[n] + " does nor specify 'P' or 'C' as a ClassOrProperty flag.");
                    return false;
                }
                this._IncludesExcludes.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
            return true;
        }
    }
}

