/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.utilities;

import com.ibm.odcb.jrender.misc.FileUtil;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.ArrayList;

public class PreProcessor {
    public static final String TOKEN_IF = "//#IF#";
    public static final String TOKEN_ELSE = "//#ELSE#";
    public static final String TOKEN_END = "//#END#";

    public static void main(String[] stringArray) {
        Streamer.setLogLevel(3);
        Streamer.status.Header().println("PreProcessor <root_dir> {-nobackup} {-r} { -e <file_extension>+ ) {-d <token>+ }\n  Call this utility to process all files with the given extensions (-e) from a root directory,\n and on down recursively if -r is specified. The utility will rewrite files based on the defined\n tokens. if -nobackup is specified, then modified files will not be backed up.\n  In order to make the code compilable in Java (or any language where '//' is a line comment) and\n not bother developers using this facility, you must comment one conditional block, and the\n utility will handle the code accordingly. Make sure to use the '//' comments only at the begining\n of the line for each line in the commented block. For example, let's consider the code sample\n below:\n     //#IF# TOTO\n         Foo();\n         Boo();\n         Goo();\n     //#ELSE#\n     //    Far();\n     //    Bar();\n     //    Gar();\n     //#END#\n  If TOTO is defined, the code won't change. If TOTO is not defined though, the code will be\n rewritten as:\n     //#IF# TOTO\n//         Foo();\n//         Boo();\n//         Goo();\n     //#ELSE#\n         Far();\n         Bar();\n         Gar();\n     //#END#\n  The markers such as '//#IF#' must be on a line with nothing else on them except the\n token, and starting with white spaces. '//#ELSE#' blocks are optional. Additionally,\n make sure to also not have normal comments at all in any blocks, or the commenting and\n uncommenting algorithm will mess up your code: ALL commented lines in an included block\n will ne uncommented, and ALL uncommented lines in a non-included block will be commented.\n\n");
        Params params = new Params();
        if (params.Parse(stringArray)) {
            PreProcessor.Process(params);
        }
        Streamer.status.Header().println("Utility has finished processing");
        Streamer.FlushThread();
    }

    public static boolean Process(Params params) {
        return FileUtil.FileSystemTraverser(params._RootDir, (FileFilter)new FileUtil.ExtensionFilter(params._FileMasks, true), (FileUtil.FileProcessor)new IfElseEnd_Processor(params._Defines, params._Backup));
    }

    static class IfElseEnd_Processor
    implements FileUtil.FileProcessor {
        protected ArrayList _Defines;
        protected boolean _Backup;

        public IfElseEnd_Processor(ArrayList arrayList, boolean bl) {
            this._Defines = arrayList;
            this._Backup = bl;
        }

        public boolean Process(File file) throws Exception {
            Object object;
            if (file.isDirectory()) {
                return true;
            }
            Streamer.debug.Header().println("Checking the file " + file.getPath());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            ArrayList<String> arrayList = new ArrayList<String>(57);
            Object object2 = bufferedReader.readLine();
            int n = 1;
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            while (object2 != null) {
                String string = ((String)object2).trim();
                if (this.isLineTokenned(string, PreProcessor.TOKEN_IF)) {
                    if (n2 != 0) {
                        Streamer.error.Header().println("File '" + file.getPath() + "', line '" + n + "': found '" + PreProcessor.TOKEN_IF + "' nested within another '" + PreProcessor.TOKEN_IF + "/" + PreProcessor.TOKEN_END + "' block.");
                        return false;
                    }
                    n2 = 1;
                    bl = this.isTokenDefined((String)object2);
                } else if (this.isLineTokenned(string, PreProcessor.TOKEN_ELSE)) {
                    if (n2 != 1) {
                        Streamer.error.Header().println("File '" + file.getPath() + "', line '" + n + "': found '" + PreProcessor.TOKEN_ELSE + "' not after '" + PreProcessor.TOKEN_IF + "'.");
                        return false;
                    }
                    n2 = 2;
                    bl = !bl;
                } else if (this.isLineTokenned(string, PreProcessor.TOKEN_END)) {
                    if (n2 == 0) {
                        Streamer.error.Header().println("File '" + file.getPath() + "', line '" + n + "': found '" + PreProcessor.TOKEN_END + "' not after '" + PreProcessor.TOKEN_IF + "' or '" + PreProcessor.TOKEN_END + "'.");
                        return false;
                    }
                    n2 = 0;
                    bl = true;
                } else if (n2 != 0) {
                    Object object3 = object = bl ? this.UncommentLine((String)object2, string) : this.CommentLine((String)object2, string);
                    if (object != null) {
                        bl2 = true;
                        object2 = object;
                    }
                }
                arrayList.add((String)object2);
                object2 = bufferedReader.readLine();
                ++n;
            }
            bufferedReader.close();
            if (bl2) {
                boolean bl3;
                boolean bl4 = bl3 = !file.canWrite();
                if (this._Backup) {
                    Streamer.debug.Header().println("  --> Making a backup...");
                    object = file.getAbsolutePath();
                    File file2 = new File((String)object + ".bak");
                    if (file2.exists()) {
                        file2.delete();
                    }
                    file.renameTo(file2);
                    file = new File((String)object);
                } else {
                    file.delete();
                }
                Streamer.debug.Header().println("  --> Rewriting...");
                object = new FileOutputStream(file);
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    object2 = (String)arrayList.get(n3);
                    ((FileOutputStream)object).write(((String)object2).getBytes());
                    ((FileOutputStream)object).write(FileUtil.NEWLINE.getBytes());
                    ++n3;
                }
                ((FileOutputStream)object).close();
                if (bl3) {
                    file.setReadOnly();
                }
                Streamer.debug.Header().println("  --> Finished processing the file");
            }
            return true;
        }

        public boolean isTokenDefined(String string) {
            string = string.substring(string.indexOf(PreProcessor.TOKEN_IF) + PreProcessor.TOKEN_IF.length()).trim();
            int n = 0;
            while (n < this._Defines.size()) {
                if (string.equals((String)this._Defines.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String UncommentLine(String string, String string2) {
            if (string2.startsWith("//")) {
                int n = string.indexOf("//");
                return string.substring(0, n) + string.substring(n + 2);
            }
            return null;
        }

        public String CommentLine(String string, String string2) {
            if (!string2.startsWith("//")) {
                return "//" + string;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public boolean isLineTokenned(String var1_1, String var2_2) {
            var3_3 = var1_1.indexOf(var2_2);
            if (var3_3 != -1) ** GOTO lbl6
            return false;
lbl-1000:
            // 1 sources

            {
                if ((var4_4 = var1_1.charAt(var3_3--)) == '/' || Character.isWhitespace(var4_4)) continue;
                return false;
lbl6:
                // 2 sources

                ** while (var3_3 >= 0)
            }
lbl7:
            // 1 sources

            return true;
        }
    }

    public static class Params {
        public File _RootDir;
        public boolean _Recurse = false;
        public ArrayList _FileMasks = new ArrayList();
        public ArrayList _Defines = new ArrayList();
        public boolean _Backup = true;

        public boolean Parse(String[] stringArray) {
            int n = 0;
            if (n >= stringArray.length) {
                System.err.println("The utility was called without any parameters.");
                return false;
            }
            this._RootDir = new File(stringArray[n]);
            if (++n >= stringArray.length) {
                return true;
            }
            if (stringArray[n].equalsIgnoreCase("-nobackup")) {
                this._Backup = false;
                if (++n >= stringArray.length) {
                    return true;
                }
            }
            if (stringArray[n].equalsIgnoreCase("-r")) {
                this._Recurse = true;
                if (++n >= stringArray.length) {
                    return true;
                }
            }
            if (stringArray[n].equalsIgnoreCase("-e")) {
                while (++n < stringArray.length) {
                    if (stringArray[n].equalsIgnoreCase("-d")) break;
                    this._FileMasks.add(stringArray[n]);
                }
                if (n >= stringArray.length) {
                    return true;
                }
            }
            if (stringArray[n].equalsIgnoreCase("-d")) {
                while (++n < stringArray.length) {
                    this._Defines.add(stringArray[n]);
                }
            }
            return true;
        }
    }
}

