/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.heapdump.HeapDumpFormatter;
import com.ibm.jvm.heapdump.LongArrayReferenceIterator;
import com.ibm.jvm.heapdump.LongListReferenceIterator;
import com.ibm.jvm.heapdump.classicheapdump.ClassicHeapDumpFormatter;
import com.ibm.jvm.heapdump.portableheapdump.PortableHeapDumpFormatter;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpStats;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoader;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPool;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPoolEntry;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9ObjectIterator;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public abstract class HeapDumpUtil {
    public static String getDefaultFileName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DumpConsole.getInputFilePath());
        stringBuffer.append(HeapDumpUtil.isPortableDump() ? ".phd" : ".txt");
        stringBuffer.append(".gz");
        return stringBuffer.toString();
    }

    public static boolean isPortableDump() {
        String string = Console.getProperty("HEAPDUMPFORMAT");
        if (string == null) {
            return true;
        }
        return !string.equalsIgnoreCase("Classic");
    }

    public static HeapDumpStats doClassicHeapDump(Writer writer) throws IOException {
        Dump dump = J9JVMConsole.getTheDump();
        return HeapDumpUtil.doHeapDump(dump, new ClassicHeapDumpFormatter(writer, dump.getVersion(), dump.is64bit()));
    }

    public static HeapDumpStats doPortableHeapDump(OutputStream outputStream) throws IOException, IllegalArgumentException {
        Dump dump = J9JVMConsole.getTheDump();
        return HeapDumpUtil.doHeapDump(dump, new PortableHeapDumpFormatter(new DataOutputStream(outputStream), dump.getVersion(), dump.is64bit()));
    }

    private static HeapDumpStats doHeapDump(Dump dump, HeapDumpFormatter heapDumpFormatter) throws IOException {
        int n = 0;
        HeapDumpStats heapDumpStats = new HeapDumpStats();
        J9ObjectIterator j9ObjectIterator = J9ObjectIterator.getObjectIterator(null);
        while (j9ObjectIterator.hasNext()) {
            J9Object j9Object = (J9Object)j9ObjectIterator.next();
            J9Class j9Class = j9Object.getClassForObject();
            if (j9Object.isPrimitiveArray()) {
                HeapDumpUtil.dumpPrimitiveArray(heapDumpFormatter, j9Object, heapDumpStats);
            } else if (j9Object.isArray()) {
                HeapDumpUtil.dumpObjectArray(heapDumpFormatter, j9Object, heapDumpStats);
            } else if (j9Object.isInstanceOfClass()) {
                HeapDumpUtil.dumpClass(heapDumpFormatter, j9Object, heapDumpStats);
            } else {
                HeapDumpUtil.dumpObject(heapDumpFormatter, j9Object, heapDumpStats);
            }
            ++n;
        }
        heapDumpFormatter.close();
        heapDumpStats.setNumberOfObjects(n);
        return heapDumpStats;
    }

    private static void dumpObject(HeapDumpFormatter heapDumpFormatter, J9Object j9Object, HeapDumpStats heapDumpStats) throws IOException {
        J9Class j9Class = j9Object.getClassForObject();
        heapDumpFormatter.addObject(j9Object.getObjectAddress(), j9Class.getClassAddress(), j9Class.getName(), j9Class.getInstanceSize(), (int)j9Object.getHashCode(), new LongArrayReferenceIterator(j9Object.getObjectRefs()));
    }

    private static boolean stringContains(String string, String string2) {
        return string.indexOf(string2) != -1;
    }

    private static String decodePrimitiveArrayClassName(String string, HeapDumpStats heapDumpStats) {
        if (HeapDumpUtil.stringContains(string, "boolean")) {
            return string.replaceAll("boolean", "Z");
        }
        if (HeapDumpUtil.stringContains(string, "char")) {
            return string.replaceAll("char", "C");
        }
        if (HeapDumpUtil.stringContains(string, "byte")) {
            return string.replaceAll("byte", "B");
        }
        if (HeapDumpUtil.stringContains(string, "short")) {
            return string.replaceAll("short", "S");
        }
        if (HeapDumpUtil.stringContains(string, "int")) {
            return string.replaceAll("int", "I");
        }
        if (HeapDumpUtil.stringContains(string, "long")) {
            return string.replaceAll("long", "J");
        }
        if (HeapDumpUtil.stringContains(string, "float")) {
            return string.replaceAll("float", "F");
        }
        if (HeapDumpUtil.stringContains(string, "double")) {
            return string.replaceAll("double", "D");
        }
        Console.reportError("Unknown primitive array type: " + string, null);
        heapDumpStats.incrementErrors();
        return string;
    }

    private static void dumpClass(HeapDumpFormatter heapDumpFormatter, J9Object j9Object, HeapDumpStats heapDumpStats) throws IOException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        Object object5;
        J9Class j9Class = J9JVMConsole.getClass(j9Object.getObjectAddress());
        if (j9Class == null) {
            Console.reportError("Couldn't get class for object " + j9Object.getObjectAddress(), null);
            heapDumpStats.incrementErrors();
            return;
        }
        LinkedList<Long> linkedList = new LinkedList<Long>();
        Vector vector = j9Class.getStatics();
        if (vector != null) {
            object5 = vector.iterator();
            while (object5.hasNext()) {
                object4 = (J9Static)object5.next();
                object3 = ((J9Static)object4).getSignature();
                if (!((String)object3).matches("^\\[*L.*")) continue;
                long l = ((J9Static)object4).getValue();
                linkedList.add(new Long(l));
            }
        }
        if ((object5 = j9Class.getConstantPool()) != null) {
            object4 = ((J9ConstantPool)object5).getEntries();
            while (object4.hasNext()) {
                object3 = (J9ConstantPoolEntry)object4.next();
                Long l = Long.decode(((J9ConstantPoolEntry)object3).getId());
                linkedList.add(l);
            }
        }
        if (null != (object4 = j9Class.getLoader())) {
            object3 = J9JVMConsole.getClassLoader((String)object4);
            if (null != object3) {
                linkedList.add(new Long(((J9ClassLoader)object3).getObj()));
            } else {
                Console.reportError("Couldn't get classloader for address " + (String)object4 + " referenced by class " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
                heapDumpStats.incrementErrors();
            }
        } else if (!j9Class.isPrimitiveClass() && !j9Class.isArrayClass()) {
            Console.reportError("Couldn't get loader address for class: " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
            heapDumpStats.incrementErrors();
        }
        object3 = j9Class.getInheritanceChain();
        Iterator iterator = ((Vector)object3).iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            object2 = J9JVMConsole.getClass(string);
            if (object2 != null) {
                linkedList.add(new Long(((J9Class)object2).getClassAddress()));
                continue;
            }
            Console.reportError("Couldn't get class object while walking inheritance tree. Base class: " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ") - failed parent name: " + string, null);
            heapDumpStats.incrementErrors();
        }
        if (j9Class.isArrayClass() || j9Class.isPrimitiveArray()) {
            linkedList.add(new Long(j9Class.getLeaf()));
            linkedList.add(new Long(J9JVMConsole.getClass("java/lang/Object").getClassAddress()));
        }
        string = j9Class.getName();
        if (j9Class.isPrimitiveArray()) {
            string = HeapDumpUtil.decodePrimitiveArrayClassName(string, heapDumpStats);
        }
        if ((object2 = j9Class.getInterfaces()) != null) {
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                J9Class j9Class2 = J9JVMConsole.getClass(string2);
                linkedList.add(new Long(j9Class2.getClassAddress()));
            }
        }
        object = j9Class.getSuperId();
        long l = 0L;
        if (object != null) {
            l = Long.decode((String)object);
        } else if (!(j9Class.isPrimitiveClass() || j9Class.isArrayClass() || j9Class.getName().equals("java/lang/Object"))) {
            Console.reportError("Null superclass returned from class " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
            heapDumpStats.incrementErrors();
        }
        heapDumpFormatter.addClass(j9Class.getClassAddress(), string, l, j9Object.getInstanceSize(), j9Class.getInstanceSize(), (int)j9Object.getHashCode(), new LongListReferenceIterator(linkedList));
    }

    private static void dumpObjectArray(HeapDumpFormatter heapDumpFormatter, J9Object j9Object, HeapDumpStats heapDumpStats) throws IOException {
        Object object;
        J9Class j9Class = j9Object.getClassForObject();
        J9Class j9Class2 = null;
        J9Class j9Class3 = J9JVMConsole.getClass(j9Class.getLeaf());
        if (j9Class3 == null) {
            Console.reportError("Couldn't get leafClass from arrayClass: " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
            heapDumpStats.incrementErrors();
            return;
        }
        if (j9Class.getArity() == 1) {
            j9Class2 = j9Class3;
        } else {
            object = "[";
            for (int i = 1; i < j9Class.getArity() - 1; ++i) {
                object = (String)object + "[";
            }
            j9Class2 = J9JVMConsole.getClass((String)(object = (String)object + "L" + j9Class3.getName() + ";"));
            if (j9Class2 == null) {
                Console.reportError("Couldn't get elementClass " + (String)object + " while processing arrayClass: " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
                heapDumpStats.incrementErrors();
                return;
            }
        }
        object = new LinkedList();
        long[] lArray = j9Object.getObjectRefs();
        if (lArray != null) {
            for (int i = 0; i != lArray.length; ++i) {
                object.add(new Long(lArray[i]));
            }
        }
        object.add(new Long(j9Class.getClassAddress()));
        heapDumpFormatter.addObjectArray(j9Object.getObjectAddress(), j9Class.getClassAddress(), j9Class.getName(), j9Class2.getClassAddress(), j9Class2.getName(), j9Object.getInstanceSize(), j9Object.getElementCount(), (int)j9Object.getHashCode(), new LongListReferenceIterator((List)object));
    }

    private static void dumpPrimitiveArray(HeapDumpFormatter heapDumpFormatter, J9Object j9Object, HeapDumpStats heapDumpStats) throws IOException {
        if (j9Object.getClassForObject().getArity() == 1) {
            heapDumpFormatter.addPrimitiveArray(j9Object.getObjectAddress(), j9Object.getClassForObject().getClassAddress(), j9Object.getPrimitiveArrayType(), j9Object.getInstanceSize(), (int)j9Object.getHashCode(), j9Object.getElementCount());
        } else {
            J9Class j9Class = j9Object.getClassForObject();
            String string = j9Class.getName().substring(1);
            J9Class j9Class2 = J9JVMConsole.getClass(string);
            if (j9Class2 == null) {
                Console.reportError("Couldn't get elementClass " + string + " while processing primitive high-arity arrayClass: " + j9Class.getName() + "(" + Long.toHexString(j9Class.getClassAddress()) + ")", null);
                heapDumpStats.incrementErrors();
                return;
            }
            heapDumpFormatter.addObjectArray(j9Object.getObjectAddress(), j9Class.getClassAddress(), j9Class.getName(), j9Class2.getClassAddress(), j9Class2.getName(), j9Object.getInstanceSize(), j9Object.getElementCount(), (int)j9Object.getHashCode(), new LongArrayReferenceIterator(j9Object.getObjectRefs()));
        }
    }
}

