/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.ClassField;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.IOException;
import java.util.Vector;

public class J9JVMUtils {
    public static final String badString = "!unable to establish! (dis os run?)";
    private static Dump theDump;
    private static int stringValueOffset;
    private static int stringOffsetOffset;
    private static int stringLengthOffset;

    public static J9Class findClass(String string) {
        return J9JVMConsole.getClass(string);
    }

    public static J9Class findClass(long l) {
        return J9JVMConsole.getClass(l);
    }

    private static J9Object getCharArrayFromString(J9Object j9Object) {
        J9Object j9Object2 = null;
        if (0 == stringValueOffset) {
            J9Class j9Class = J9JVMConsole.getClass("java/lang/String");
            if (null == j9Class) {
                Console.reportError("Error in establishing the java/lang/String class structure (bad xml?)\nA lot of commands are going to be affected by this.\nThis needs investigation!", null);
                return null;
            }
            Vector vector = j9Class.getFields();
            for (int i = 0; i < vector.size(); ++i) {
                ClassField classField = (ClassField)vector.get(i);
                if (!classField.getFieldName().equals("value")) continue;
                stringValueOffset = classField.getOffset();
            }
        }
        if (0 != stringValueOffset) {
            try {
                long l = theDump.readPtr(j9Object.getObjectAddress() + (long)stringValueOffset);
                j9Object2 = J9Heap.checkForObject(l);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return j9Object2;
    }

    private static int getOffsetFromString(J9Object j9Object) {
        if (0 == stringOffsetOffset) {
            J9Class j9Class = J9JVMConsole.getClass("java/lang/String");
            if (null == j9Class) {
                Console.reportError("Error in establishing the java/lang/String class structue (bad xml?)\nA lot of commands are going to be affected bt this.\nThis needs investigation!!!!!!!!", null);
                return 0;
            }
            Vector vector = j9Class.getFields();
            for (int i = 0; i < vector.size(); ++i) {
                ClassField classField = (ClassField)vector.get(i);
                if (!classField.getFieldName().equals("offset")) continue;
                stringOffsetOffset = classField.getOffset();
            }
        }
        if (0 != stringOffsetOffset) {
            try {
                if (theDump.seekToMemoryAddress(j9Object.getObjectAddress() + (long)stringOffsetOffset) > 0L) {
                    return theDump.readIntEx();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static int getLengthFromString(J9Object j9Object) {
        if (0 == stringLengthOffset) {
            J9Class j9Class = J9JVMConsole.getClass("java/lang/String");
            if (null == j9Class) {
                Console.reportError("Error in establishing the java/lang/String class structure (bad xml?)\nA lot of commands are going to be affected by this.\nThis needs investigation!!!", null);
                return 0;
            }
            Vector vector = j9Class.getFields();
            for (int i = 0; i < vector.size(); ++i) {
                ClassField classField = (ClassField)vector.get(i);
                if (!classField.getFieldName().equals("count")) continue;
                stringLengthOffset = classField.getOffset();
            }
        }
        if (0 != stringLengthOffset) {
            try {
                if (theDump.seekToMemoryAddress(j9Object.getObjectAddress() + (long)stringLengthOffset) > 0L) {
                    return theDump.readIntEx();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static String convertCharArrayObject(J9Object j9Object, int n, int n2) {
        String string = "<unknown>";
        int n3 = j9Object.getElementCount();
        if (0 == n2 && 0 == (n2 = n3)) {
            return null;
        }
        J9Class j9Class = j9Object.getClassForObject();
        if (j9Class == null) {
            return string;
        }
        if (0L != theDump.seekToMemoryAddress(j9Object.getObjectAddress() + (long)j9Class.getFirstElementOffset() + (long)(n * 2))) {
            int n4 = Math.max(0, n3 - n) * 2;
            n4 = Math.min(n4, 2 * n2);
            byte[] byArray = new byte[n4];
            try {
                theDump.readEx(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            char[] cArray = new char[n4 / 2];
            if (theDump.isLittleEndian()) {
                for (int i = 0; i < n4; i += 2) {
                    cArray[i / 2] = (char)(byArray[i] | (char)byArray[i + 1] << 8);
                }
            } else {
                for (int i = 0; i < n4; i += 2) {
                    cArray[i / 2] = (char)(byArray[i + 1] | (char)byArray[i] << 8);
                }
            }
            string = new String(cArray);
        }
        return string;
    }

    public static String getStringValue(long l) {
        return J9JVMUtils.getStringValue(l, 0);
    }

    public static String getStringValue(long l, int n) {
        String string = badString;
        J9Object j9Object = new J9Object(l, -1);
        J9Object j9Object2 = J9JVMUtils.getCharArrayFromString(j9Object);
        if (null != j9Object2) {
            int n2 = J9JVMUtils.getOffsetFromString(j9Object);
            int n3 = J9JVMUtils.getLengthFromString(j9Object);
            n3 = Math.min(n == 0 ? n3 : n, n3);
            string = J9JVMUtils.convertCharArrayObject(j9Object2, n2, n3);
        }
        return string;
    }

    public static String analyseModifiers(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    static {
        stringValueOffset = 0;
        stringOffsetOffset = 0;
        stringLengthOffset = 0;
        theDump = DumpConsole.getTheDump();
    }
}

