/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipHandler {
    private ZipFile zipFile;
    private File XMLFile;
    private File coreFile;
    private File tempDir;
    private String coreFilename;
    private String XMLFilename;
    private Collection supportFiles;

    public ZipHandler(File file, String string, String string2) throws ZipException, IOException {
        String string3;
        this.zipFile = new ZipFile(file);
        this.coreFilename = null == string ? ((string3 = file.getName()).endsWith(".zip") ? string3.substring(0, string3.length() - 4) : string3) : string;
        this.XMLFilename = null == string2 ? this.coreFilename + ".xml" : string2;
        this.supportFiles = null;
        this.setupTempDir();
    }

    public File getXMLFile() {
        if (null == this.tempDir) {
            return null;
        }
        if (null == this.XMLFile) {
            ZipEntry zipEntry = this.zipFile.getEntry(this.XMLFilename);
            if (null == zipEntry) {
                return null;
            }
            try {
                this.XMLFile = new File(this.tempDir, zipEntry.getName());
                this.XMLFile.deleteOnExit();
                this.dumpStream(this.zipFile.getInputStream(zipEntry), new FileOutputStream(this.XMLFile));
            }
            catch (IOException iOException) {
                this.XMLFile = null;
            }
        }
        return this.XMLFile;
    }

    public File getCoreFile() {
        if (null == this.tempDir) {
            return null;
        }
        if (null == this.coreFile) {
            ZipEntry zipEntry = this.zipFile.getEntry(this.coreFilename);
            if (null == zipEntry) {
                return null;
            }
            if (null == this.supportFiles) {
                this.supportFiles = new Vector();
                String[] stringArray = new String[]{this.coreFilename, this.XMLFilename};
                Iterator iterator = this.getEntriesExcludingNames(stringArray);
                while (iterator.hasNext()) {
                    ZipEntry zipEntry2 = (ZipEntry)iterator.next();
                    try {
                        File file = new File(this.tempDir, zipEntry2.getName());
                        this.dumpStream(this.zipFile.getInputStream(zipEntry2), new FileOutputStream(file));
                        this.supportFiles.add(file);
                        file.deleteOnExit();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                this.coreFile = new File(this.tempDir, zipEntry.getName());
                this.coreFile.deleteOnExit();
                this.dumpStream(this.zipFile.getInputStream(zipEntry), new FileOutputStream(this.coreFile));
            }
            catch (IOException iOException) {
                this.coreFile = null;
            }
        }
        return this.coreFile;
    }

    public Iterator close() {
        Vector<File> vector = new Vector<File>();
        if (null != this.supportFiles) {
            for (File file : this.supportFiles) {
                if (file.delete()) continue;
                vector.add(file);
            }
        }
        if (null != this.XMLFile && !this.XMLFile.delete()) {
            vector.add(this.XMLFile);
        }
        if (null != this.coreFile && !this.coreFile.delete()) {
            vector.add(this.coreFile);
        }
        if (null != this.tempDir && !this.tempDir.delete()) {
            vector.add(this.tempDir);
        }
        return vector.iterator();
    }

    private Iterator getEntriesExcludingNames(String[] stringArray) {
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        Vector<ZipEntry> vector = new Vector<ZipEntry>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!zipEntry.getName().equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.add(zipEntry);
        }
        return vector.iterator();
    }

    private void dumpStream(InputStream inputStream, OutputStream outputStream) {
        byte[] byArray = new byte[65536];
        try {
            int n = inputStream.read(byArray);
            while (n >= 0) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void setupTempDir() throws IOException {
        this.tempDir = File.createTempFile("tempJdmpview", null);
        this.tempDir.deleteOnExit();
        if (!this.tempDir.delete() || !this.tempDir.mkdir()) {
            this.tempDir = null;
        }
    }

    public String openAndProcessZipFile() {
        String string = null;
        File file = this.getCoreFile();
        File file2 = this.getXMLFile();
        string = file.getAbsolutePath();
        return string;
    }

    public String getTempDirName() {
        String string = this.tempDir.getAbsolutePath();
        return string;
    }
}

