/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.DumpFile;
import com.ibm.recordio.IRandomAccessRecordFile;
import com.ibm.recordio.IRecordFile;
import com.ibm.recordio.RandomAccessRecordFile;
import com.ibm.recordio.RecordFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DatasetDumpFile
implements DumpFile {
    private final IRecordFile _file;
    private final IRandomAccessRecordFile _rafile;
    private final byte[] _recordBuffer;
    private final int _recordLength;
    private int _seekOffset = 0;
    private long _recordNumber = 0L;
    private int _bufferValid = 0;
    private final String _name;

    public DatasetDumpFile(String string) throws FileNotFoundException {
        try {
            this._file = RecordFile.getInstanceOf((String)("//" + string));
            this._rafile = RandomAccessRecordFile.getInstanceOf((IRecordFile)this._file, (String)"r");
            this._recordLength = this._rafile.getRecordLength();
            this._recordBuffer = new byte[this._recordLength];
            this._name = string;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.toString());
        }
        catch (LinkageError linkageError) {
            throw new FileNotFoundException(linkageError.toString());
        }
    }

    public String getDumpName() {
        return this._name;
    }

    public long getFilePointer() throws IOException {
        return this._recordNumber * (long)this._recordLength + (long)this._seekOffset;
    }

    public long length() throws IOException {
        return -1L;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        try {
            this.readFully(byArray);
            return byArray[0] & 0xFF;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            if (this._seekOffset != 0 || n2 - n3 < this._recordLength) {
                int n5 = n4 = this._bufferValid > 0 ? this._bufferValid : this._rafile.read(this._recordBuffer);
                if (n4 < 0) break;
                if (n4 < this._seekOffset) {
                    System.err.println("Problem reading record from RAFile. nbytes = " + n4 + ", seekOffset = " + this._seekOffset);
                    break;
                }
                int n6 = n4 - this._seekOffset;
                if (n6 > n2 - n3) {
                    System.arraycopy(this._recordBuffer, this._seekOffset, byArray, n + n3, n2 - n3);
                    n3 = n2;
                    this._seekOffset += n3;
                    this._bufferValid = n4;
                    continue;
                }
                System.arraycopy(this._recordBuffer, this._seekOffset, byArray, n + n3, n6);
                n3 += n6;
                ++this._recordNumber;
                this._seekOffset = 0;
                this._bufferValid = 0;
                continue;
            }
            n4 = this._rafile.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) break;
            ++this._recordNumber;
            n3 += n4;
        }
        return n3;
    }

    public void seek(long l) throws IOException {
        long l2 = l / (long)this._recordLength;
        if (l2 != this._recordNumber) {
            this._rafile.seek(l2);
            this._recordNumber = l2;
            this._bufferValid = 0;
        }
        this._seekOffset = (int)l % this._recordLength;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.read(byArray, n, n2);
        if (n3 < n2) {
            throw new EORFException(n3);
        }
    }

    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return (int)(((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL);
    }

    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public void close() throws IOException {
        this._rafile.close();
    }

    private static class EORFException
    extends EOFException {
        private static final long serialVersionUID = 1L;
        public int bytesRead;

        public EORFException(int n) {
            this.bytesRead = n;
        }
    }
}

