/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.FlatDumpFile;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Module;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.ProgramHeaderElement;
import com.ibm.jvm.j9.dump.systemdump.Register;
import com.ibm.jvm.j9.dump.systemdump.SectionHeaderElement;
import com.ibm.jvm.j9.dump.systemdump.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class Elfdump
extends Dump {
    private static boolean verbose = false;
    private int wordLength;
    private int machine;
    private long version;
    private long entry;
    private long dllLoadPoint;
    private long programHeaderOffset;
    private long sectionHeaderOffset;
    private long flags;
    private long elfHeaderSize;
    private long programHeaderEntrySize;
    private long numProgramHeaders;
    private long sectionHeaderEntrySize;
    private long numSectionHeaders;
    private long stringTable;
    private Map pHMap;
    private Vector pT_Dynamic_Entries;
    private Vector shVector = new Vector();
    PrPsInfo proc;
    private static Vector debugFiles;
    private Vector stringTableEntries = new Vector();
    private boolean isExec = false;
    private boolean isDll = false;
    SectionHeaderElement symTableEl;
    SectionHeaderElement symTableStringsEl;
    static final int NT_PRSTATUS = 1;
    static final int NT_PRFPREG = 2;
    static final int NT_PRPSINFO = 3;
    static final int NT_TASKSTRUCT = 4;
    static final int NT_PRXFPREG = 1189489535;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFCLASS64 = 2;
    static final int ELFDATA2LSB = 1;
    static final int ELFDATA2MSB = 2;
    static final int ARCH_SPARC = 2;
    static final int ARCH_IA32 = 3;
    static final int ARCH_IA64 = 50;
    static final int ARCH_PPC32 = 20;
    static final int ARCH_PPC64 = 21;
    static final int ARCH_S390 = 22;
    static final int ARCH_AMD64 = 62;
    static final long DT_NULL = 0L;
    static final long DT_DEBUG = 21L;
    private static String[] archStrings;

    public Elfdump(String string) throws FileNotFoundException {
        this(string, false, false, 0L);
    }

    public Elfdump(String string, boolean bl, boolean bl2, long l) throws FileNotFoundException {
        super(new FlatDumpFile(string));
        this.setExec(bl);
        this.setDll(bl2);
        this.dllLoadPoint = l;
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("ELFAS", this, 0);
        this.proc = new PrPsInfo("temp");
        this.setSystemType(2);
        byte[] byArray = new byte[16];
        try {
            Object object;
            int n;
            this.read(byArray);
            String string2 = new String(byArray);
            string2 = string2.toUpperCase();
            if (-1 != string2.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("It is an elf core file or executable ");
                }
            } else {
                throw new Exception("ELF signature not found in dump file.");
            }
            byte[] byArray2 = new byte[]{byArray[4], byArray[5]};
            this.setArchitecture(byArray2);
            int n2 = this.readHalf();
            if (verbose) {
                System.out.println("Object Type = " + n2);
            }
            this.machine = this.readHalf();
            switch (this.machine) {
                case 20: 
                case 21: 
                case 50: {
                    int n3 = 4;
                    break;
                }
                case 22: {
                    int n3 = this.wordLength / 2;
                    break;
                }
                default: {
                    int n3 = 2;
                }
            }
            if (this.is32bit()) {
                this.read32bitHeader();
            } else {
                this.read64bitHeader();
            }
            if (this.isExec || this.isDll) {
                this.readStringTable();
                n = 0;
                while ((long)n < this.numSectionHeaders) {
                    this.seek(this.sectionHeaderOffset + (long)n * this.sectionHeaderEntrySize);
                    object = SectionHeaderElement.readSectionHeaderElement(this, this.is32bit());
                    this.shVector.add(object);
                    ++n;
                }
                n = 0;
                while ((long)n < this.numSectionHeaders) {
                    object = (SectionHeaderElement)this.shVector.get(n);
                    if (((SectionHeaderElement)object).sh_type == 2L || ((SectionHeaderElement)object).sh_type == 11L) {
                        this.createSymbols((SectionHeaderElement)object);
                    }
                    ++n;
                }
            }
            this.pHMap = new HashMap((int)this.numProgramHeaders);
            n = 0;
            while ((long)n < this.numProgramHeaders) {
                this.seek(this.programHeaderOffset + (long)n * this.programHeaderEntrySize);
                object = ProgramHeaderElement.readProgramHeaderElement(this, this.is32bit());
                if (((ProgramHeaderElement)object).memsize != 0L) {
                    this.pHMap.put(new Long(((ProgramHeaderElement)object).virtaddr), object);
                }
                if (verbose) {
                    System.err.println(((ProgramHeaderElement)object).toString());
                }
                ++n;
            }
            n = 0;
            while ((long)n < this.numProgramHeaders) {
                this.seek(this.programHeaderOffset + (long)n * this.programHeaderEntrySize);
                object = ProgramHeaderElement.readProgramHeaderElement(this, this.is32bit());
                if (((ProgramHeaderElement)object).type == 2L) {
                    if (null == this.pT_Dynamic_Entries) {
                        this.pT_Dynamic_Entries = new Vector();
                    }
                    this.pT_Dynamic_Entries.add(object);
                }
                if (((ProgramHeaderElement)object).type == 4L) {
                    this.readNote((ProgramHeaderElement)object);
                }
                if (verbose) {
                    System.err.println(((ProgramHeaderElement)object).toString());
                }
                ++n;
            }
            this.pHMap = new TreeMap(this.pHMap);
            debugFiles = Elfdump.findDebugFiles(null, this, true);
            if (verbose) {
                ProgramHeaderElement[] programHeaderElementArray = this.pHMap.values().toArray(new ProgramHeaderElement[0]);
                long l2 = 0L;
                int n4 = 0;
                while ((long)n4 < this.numProgramHeaders) {
                    l2 += programHeaderElementArray[n4].memsize;
                    switch ((int)programHeaderElementArray[n4].type) {
                        case 1: {
                            if (programHeaderElementArray[n4].filesize == 0L || !verbose) break;
                            System.err.println("Its a LOAD entry thats dumped memory 0x" + Long.toHexString(programHeaderElementArray[n4].virtaddr) + "for " + Long.toHexString(programHeaderElementArray[n4].memsize) + " bytes. Offset in dump file is 0x" + Long.toHexString(programHeaderElementArray[n4].offset));
                            break;
                        }
                        case 4: {
                            if (!verbose) break;
                            System.err.println("It's a NOTE entry");
                            break;
                        }
                        case 2: {
                            if (!verbose) break;
                            System.err.println("It's a DYNAMIC entry");
                            break;
                        }
                    }
                    ++n4;
                }
                if (verbose) {
                    System.out.println("Total Memory Size =" + l2);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception reading dump file");
        }
    }

    private void read32bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignInt();
        this.programHeaderOffset = this.readUnsignInt();
        this.sectionHeaderOffset = this.readUnsignInt();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("32bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    private void read64bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignLong();
        this.programHeaderOffset = this.readUnsignLong();
        this.sectionHeaderOffset = this.readUnsignLong();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("64bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int dumpStat(String string) {
        int n = 0;
        if (new File(string).exists()) {
            n |= 1;
        } else {
            return n;
        }
        FlatDumpFile flatDumpFile = null;
        try {
            flatDumpFile = new FlatDumpFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return n;
        }
        n |= 2;
        byte[] byArray = new byte[16];
        try {
            flatDumpFile.seek(0L);
            flatDumpFile.read(byArray);
            String string2 = new String(byArray);
            string2 = string2.toUpperCase();
            if (-1 != string2.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("isSupportedDump: it's an elf core file");
                }
                n |= 4;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                flatDumpFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupportedDump(String string) {
        FlatDumpFile flatDumpFile = null;
        try {
            flatDumpFile = new FlatDumpFile(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        byte[] byArray = new byte[16];
        try {
            flatDumpFile.seek(0L);
            flatDumpFile.read(byArray);
            String string2 = new String(byArray);
            string2 = string2.toUpperCase();
            if (-1 != string2.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("isSupportedDump: it's an elf core file");
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                flatDumpFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    private void setArchitecture(byte[] byArray) throws IOException {
        switch (byArray[0]) {
            case 1: {
                this.set32Bit(true);
                break;
            }
            case 2: {
                this.set32Bit(false);
                break;
            }
            default: {
                throw new IOException("Unexpected bitness flag detected in core file.");
            }
        }
        switch (byArray[1]) {
            case 1: {
                Elfdump.setLittleEndian(true);
                break;
            }
            case 2: {
                Elfdump.setLittleEndian(false);
                break;
            }
            default: {
                throw new IOException("Unexpected endianess flag detected in core file.");
            }
        }
        if (verbose) {
            if (this.is32bit()) {
                System.err.println("Its a 32-bit dump");
            } else {
                System.err.println("Its a 64-bit dump");
            }
            if (bIsLittleEndian) {
                System.err.println("Its a little endian dump");
            } else {
                System.err.println("Its a big endian dump");
            }
        }
    }

    protected MemoryRange[] getRawMemoryRanges() {
        MemoryRange[] memoryRangeArray = new MemoryRange[this.pHMap.size()];
        int n = 0;
        for (ProgramHeaderElement programHeaderElement : this.pHMap.values()) {
            memoryRangeArray[n] = programHeaderElement.getRange();
            ++n;
        }
        return memoryRangeArray;
    }

    public long readUnsignInt() throws IOException {
        long[] lArray = new long[4];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.readUnsignedByte();
            lArray[i] = lArray[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24);
        }
        return lArray[3] + (lArray[2] << 8) + (lArray[1] << 16) + (lArray[0] << 24);
    }

    public int readHalf() throws IOException {
        int[] nArray = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readUnsignedByte();
            nArray[i] = nArray[i] & 0xFF;
        }
        if (this.isLittleEndian()) {
            return nArray[0] + (nArray[1] << 8);
        }
        return nArray[1] + (nArray[0] << 8);
    }

    public long readUnsignLong() throws IOException {
        long[] lArray = new long[8];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.readUnsignedByte();
            lArray[i] = lArray[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24) + (lArray[4] << 32) + (lArray[5] << 40) + (lArray[6] << 48) + (lArray[7] << 56);
        }
        return lArray[7] + (lArray[6] << 8) + (lArray[5] << 16) + (lArray[4] << 24) + (lArray[3] << 32) + (lArray[2] << 40) + (lArray[1] << 48) + (lArray[0] << 56);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n\tSystem subtype : ");
        stringBuffer.append(archStrings[this.machine]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private void readNote(ProgramHeaderElement programHeaderElement) {
        PrPsInfo prPsInfo = null;
        long l = programHeaderElement.offset;
        while (l < programHeaderElement.offset + programHeaderElement.filesize) {
            try {
                this.seek(l);
                int n = this.readIntEx();
                if (n > 4) {
                    n = 8;
                }
                int n2 = this.readIntEx();
                int n3 = this.readIntEx();
                String string = this.readString(n);
                l = this.getFilePointer() + (long)n2;
                switch (n3) {
                    case 1: {
                        if (this.isDll || this.isExec) break;
                        this.proc.addThread(new prStatus());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1189489535: {
                        break;
                    }
                    case 3: {
                        prPsInfo = new PrPsInfo(this.proc, this.getFilePointer() + (long)n2);
                        this.addressSpaces[0].addProcess(prPsInfo);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    long readWord() throws IOException {
        long l = 0L;
        l = this.bIs32Bit ? (long)this.readIntEx() : this.readLongEx();
        return l;
    }

    String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray);
        return new String(byArray);
    }

    public long readUid() throws IOException {
        return this.readIntEx();
    }

    public int readBuffer(byte[] byArray) throws IOException {
        long l = this.read(byArray);
        return (int)l;
    }

    public static Vector findDebugFiles(String string, Dump dump, boolean bl) {
        Object object;
        Object object2;
        String string2 = null;
        if (debugFiles != null) {
            return debugFiles;
        }
        debugFiles = new Vector();
        Vector<String> vector = new Vector<String>();
        String string3 = null;
        RandomAccessFile randomAccessFile = null;
        J9Process j9Process = (J9Process)dump.addressSpaces[0].processes.get(0);
        String string4 = j9Process.getExecutable();
        String string5 = j9Process.getCommand();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<J9Module> vector3 = new Vector<J9Module>();
        boolean bl2 = false;
        if (File.separator.equals("\\")) {
            string4 = DumpUtils.changeFileSeperator(string4, '\\');
        }
        if (string != null) {
            vector2.add(string);
        }
        if (string4.startsWith("/") || string4.startsWith("\\")) {
            vector2.add(string4);
        }
        if (string4.startsWith("./") || string4.startsWith(".\\") || string4.startsWith("/") || string4.startsWith("\\")) {
            vector2.add(string4);
            string4 = string4.startsWith("./") || string4.startsWith(".\\") ? string4.substring(2) : string4.substring(1);
            vector2.add(string4);
            String string6 = dump.getDumpName();
            int n = string6.lastIndexOf("\\");
            if (n == -1) {
                n = string6.lastIndexOf("/");
            }
            string2 = string6.substring(0, n + 1);
            object2 = string2.concat(string4);
            vector2.add(object2);
            object2 = string2.concat(string5);
            vector2.add(object2);
        }
        boolean bl3 = false;
        Iterator iterator = vector2.iterator();
        while (!bl3 && iterator.hasNext()) {
            string3 = ((String)iterator.next()).trim();
            try {
                randomAccessFile = new RandomAccessFile(string3, "r");
                bl3 = true;
                break;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        if (bl3 && string3 != null) {
            object2 = null;
            try {
                object2 = new Elfdump(string3, true, false, 0L);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
            object = ((Elfdump)object2).pT_Dynamic_Entries.iterator();
            vector.add(string3);
            while (object.hasNext()) {
                ProgramHeaderElement programHeaderElement = (ProgramHeaderElement)object.next();
                long l = programHeaderElement.virtaddr;
                int n = dump.findWhichMemoryRange(l);
                if (n != -1) {
                    if (bl) {
                        vector3.add(new J9Module(((Dump)object2).getDumpName(), l, programHeaderElement.memsize));
                    }
                    dump.seekToMemoryAddress(l);
                    try {
                        long l2 = dump.readPtr();
                        while (l2 != 0L) {
                            if (l2 == 21L) {
                                long l3;
                                long l4 = dump.readPtr();
                                dump.seekToMemoryAddress(l4);
                                long l5 = dump.readPtr();
                                long l6 = l3 = dump.readPtr();
                                while (l6 != 0L) {
                                    MemoryRange memoryRange;
                                    dump.seekToMemoryAddress(l6);
                                    long l7 = dump.readPtr();
                                    long l8 = dump.readPtr();
                                    long l9 = dump.readPtr();
                                    l6 = dump.readPtr();
                                    if (l7 == 0L) continue;
                                    dump.seekToMemoryAddress(l8);
                                    String string7 = dump.readString();
                                    vector.add(string7);
                                    if (!bl) continue;
                                    long l10 = -1L;
                                    int n2 = dump.findWhichMemoryRange(l7);
                                    if (-1 != n2 && (memoryRange = dump.getMemoryRanges()[n2]).getVaddr() == l7) {
                                        l10 = memoryRange.getSize();
                                    }
                                    vector3.add(new J9Module(string7, l7, l10));
                                    int n3 = string7.lastIndexOf("\\");
                                    if (-1 == n3) {
                                        n3 = string7.lastIndexOf("/");
                                    }
                                    string7 = string2.concat(string7.substring(n3 + 1));
                                    try {
                                        Elfdump elfdump = new Elfdump(string7, false, true, l7);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {}
                                }
                                l2 = 0L;
                                continue;
                            }
                            dump.readPtr();
                            l2 = dump.readPtr();
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                return null;
            }
        }
        for (int i = 0; i < vector3.size(); ++i) {
            object = (J9Module)vector3.get(i);
            j9Process.addModule(vector3.size(), i, ((J9Module)object).getName(), ((J9Module)object).getStartAddress(), ((J9Module)object).getSize());
        }
        debugFiles = vector;
        return vector;
    }

    private void readStringTable() {
        try {
            this.seek(this.sectionHeaderOffset + this.stringTable * this.sectionHeaderEntrySize);
            boolean bl = false;
            SectionHeaderElement sectionHeaderElement = SectionHeaderElement.readSectionHeaderElement(this, this.is32bit());
            if (sectionHeaderElement.sh_off != 0L && sectionHeaderElement.sh_size > 0L) {
                this.seek(sectionHeaderElement.sh_off);
                byte[] byArray = new byte[(int)sectionHeaderElement.sh_size];
                this.read(byArray);
                this.stringTableEntries = this.convertByteArrayToStringTable(byArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setExec(boolean bl) {
        this.isExec = bl;
    }

    private void createSymbols(SectionHeaderElement sectionHeaderElement) {
        byte[] byArray = null;
        String string = this.dumpName;
        int n = this.dumpName.lastIndexOf("\\");
        if (-1 == n) {
            n = this.dumpName.lastIndexOf("/");
        }
        if (-1 != n) {
            string = this.dumpName.substring(n + 1) + "::";
        }
        string.concat("::");
        try {
            SectionHeaderElement sectionHeaderElement2 = (SectionHeaderElement)this.shVector.get((int)sectionHeaderElement.sh_link);
            this.seek(sectionHeaderElement2.sh_off);
            byArray = new byte[(int)sectionHeaderElement2.sh_size];
            this.read(byArray);
        }
        catch (IOException iOException) {
            return;
        }
        try {
            this.seek(sectionHeaderElement.sh_off);
            int n2 = (int)sectionHeaderElement.sh_size / 24;
            long l = 0L;
            long l2 = 0L;
            byte by = 0;
            byte by2 = 0;
            short s = 0;
            if (this.is32bit()) {
                n2 *= 2;
                for (int i = 0; i < n2; ++i) {
                    String string2;
                    l = this.readUnsignInt();
                    l2 = this.readUnsignInt();
                    long l3 = this.readUnsignInt();
                    by = this.readByte();
                    by2 = this.readByte();
                    s = this.readShortEx();
                    if (by != 2 && by != 18 || (string2 = this.getStringFromByteArray(byArray, (int)l)) == null || l2 == 0L) continue;
                    if (this.isDll) {
                        l2 += this.dllLoadPoint;
                    }
                    Symbol symbol = new Symbol(string + string2, l2, (int)l3, 2, by);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    String string3;
                    l = this.readUnsignInt();
                    by = this.readByte();
                    by2 = this.readByte();
                    s = this.readShortEx();
                    l2 = this.readUnsignLong();
                    long l4 = this.readUnsignLong();
                    if (by != 2 && by != 18 || (string3 = this.getStringFromByteArray(byArray, (int)l)) == null || l2 == 0L) continue;
                    if (this.isDll) {
                        l2 += this.dllLoadPoint;
                    }
                    Symbol symbol = new Symbol(string + string3, l2, (int)l4, 2, by);
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private Vector convertByteArrayToStringTable(byte[] byArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            String string = new String(byArray, n, i - n);
            n = i + 1;
            vector.add(string);
        }
        return vector;
    }

    private String getStringFromByteArray(byte[] byArray, int n) {
        String string = null;
        try {
            for (int i = n; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                string = new String(byArray, n, i - n);
                return string;
            }
        }
        catch (Exception exception) {
            boolean bl = true;
        }
        return string;
    }

    public void setDll(boolean bl) {
        this.isDll = bl;
    }

    static {
        archStrings = new String[100];
        Elfdump.archStrings[2] = "Sun Sparc";
        Elfdump.archStrings[3] = "IA/32";
        Elfdump.archStrings[50] = "IA/64";
        Elfdump.archStrings[20] = "PPC/32";
        Elfdump.archStrings[21] = "PPC/64";
        Elfdump.archStrings[22] = "s390";
        Elfdump.archStrings[62] = "AMD64";
    }

    class PrPsInfo
    extends J9Process {
        long pid;
        long signalNumber;
        long thread;

        PrPsInfo(String string) {
            super(string, 0);
        }

        PrPsInfo(PrPsInfo prPsInfo, long l) throws IOException {
            super("ELFProc", 0);
            if (prPsInfo != null) {
                this.pid = prPsInfo.pid;
                this.signalNumber = prPsInfo.signalNumber;
                ((J9Process)this).signalNumber = (int)prPsInfo.signalNumber;
                this.SignalNumberAvailable = true;
                this.threads = prPsInfo.threads;
            }
            prPsInfo = this;
            byte[] byArray = Elfdump.this.bIs32Bit ? new byte[4] : new byte[8];
            Elfdump.this.readBuffer(byArray);
            long l2 = byArray[0];
            long l3 = byArray[1];
            long l4 = byArray[2];
            long l5 = byArray[3];
            long l6 = 0L;
            l6 = Elfdump.this.bIs32Bit ? (long)Elfdump.this.readIntEx() : Elfdump.this.readLongEx();
            long l7 = Elfdump.this.readUid();
            long l8 = Elfdump.this.readUid();
            long l9 = Elfdump.this.readWord();
            this.setProcessName(Long.toString(l9));
            long l10 = Elfdump.this.readWord();
            long l11 = Elfdump.this.readWord();
            long l12 = Elfdump.this.readWord();
            Elfdump.this.seek(l - 96L);
            this.command = Elfdump.this.readString(16).trim();
            this.commandLine = Elfdump.this.readString(80).trim();
            this.generateExecutable(this.command, this.commandLine);
        }

        void generateExecutable(String string, String string2) {
            this.command = string;
            this.commandLine = string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            if (stringTokenizer.hasMoreTokens()) {
                this.executable = stringTokenizer.nextToken();
            }
        }
    }

    class prStatus
    extends GenericThread {
        prStatus() throws IOException {
            super("threadId", 0L, 0, 0);
            long l = Elfdump.this.readIntEx();
            long l2 = Elfdump.this.readIntEx();
            long l3 = Elfdump.this.readIntEx();
            long l4 = Elfdump.this.readHalf();
            long l5 = Elfdump.this.readHalf();
            long l6 = 0L;
            long l7 = 0L;
            if (Elfdump.this.bIs32Bit) {
                l6 = Elfdump.this.readIntEx();
                l7 = Elfdump.this.readIntEx();
            } else {
                l6 = Elfdump.this.readLongEx();
                l7 = Elfdump.this.readLongEx();
            }
            long l8 = Elfdump.this.readIntEx();
            long l9 = Elfdump.this.readIntEx();
            long l10 = Elfdump.this.readIntEx();
            long l11 = Elfdump.this.readIntEx();
            long l12 = 0L;
            long l13 = 0L;
            long l14 = 0L;
            long l15 = 0L;
            long l16 = 0L;
            long l17 = 0L;
            long l18 = 0L;
            long l19 = 0L;
            if (Elfdump.this.bIs32Bit) {
                l12 = Elfdump.this.readIntEx();
                l13 = Elfdump.this.readIntEx();
                l14 = Elfdump.this.readIntEx();
                l15 = Elfdump.this.readIntEx();
                l16 = Elfdump.this.readIntEx();
                l17 = Elfdump.this.readIntEx();
                l18 = Elfdump.this.readIntEx();
                l19 = Elfdump.this.readIntEx();
            } else {
                l12 = Elfdump.this.readLongEx();
                l13 = Elfdump.this.readLongEx();
                l14 = Elfdump.this.readLongEx();
                l15 = Elfdump.this.readLongEx();
                l16 = Elfdump.this.readLongEx();
                l17 = Elfdump.this.readLongEx();
                l18 = Elfdump.this.readLongEx();
                l19 = Elfdump.this.readLongEx();
            }
            switch (Elfdump.this.machine) {
                case 20: 
                case 21: {
                    this.readRegistersPPC();
                    break;
                }
                case 50: {
                    this.readRegistersIA64();
                    break;
                }
                case 22: {
                    this.readRegistersS390();
                    break;
                }
                default: {
                    this.readRegistersIA32();
                }
            }
            if (this.context != null) {
                long l20 = this.context.getSp();
                int n = Elfdump.this.findWhichMemoryRange(l20);
                if (n != -1) {
                    this.stacksize = (int)Elfdump.this.getMemoryRanges()[n].getSize();
                    this.stackstart = Elfdump.this.getMemoryRanges()[n].getVaddr();
                }
                Elfdump.this.analyseStack(this);
            }
        }

        void readRegistersIA32() throws IOException {
            int n = Elfdump.this.readIntEx();
            int n2 = Elfdump.this.readIntEx();
            int n3 = Elfdump.this.readIntEx();
            int n4 = Elfdump.this.readIntEx();
            int n5 = Elfdump.this.readIntEx();
            int n6 = Elfdump.this.readIntEx();
            long l = Elfdump.this.readIntEx();
            int n7 = Elfdump.this.readIntEx();
            int n8 = Elfdump.this.readIntEx();
            int n9 = Elfdump.this.readIntEx();
            int n10 = Elfdump.this.readIntEx();
            int n11 = Elfdump.this.readIntEx();
            int n12 = Elfdump.this.readIntEx();
            int n13 = Elfdump.this.readIntEx();
            int n14 = Elfdump.this.readIntEx();
            int n15 = Elfdump.this.readIntEx();
            int n16 = Elfdump.this.readIntEx();
            this.addRegister(new Register("ebx", 32, n));
            this.addRegister(new Register("ecx", 32, n2));
            this.addRegister(new Register("edx", 32, n3));
            this.addRegister(new Register("esi", 32, n4));
            this.addRegister(new Register("edi", 32, n5));
            this.addRegister(new Register("ebp", 32, n6));
            this.addRegister(new Register("eax", 32, l));
            this.addRegister(new Register("ds", 32, n7));
            this.addRegister(new Register("es", 32, n8));
            this.addRegister(new Register("fs", 32, n9));
            this.addRegister(new Register("gs", 32, n10));
            this.addRegister(new Register("cs", 32, n13));
            this.addRegister(new Register("efl", 32, n14));
            this.addRegister(new Register("esp", 32, n15));
            this.addRegister(new Register("eip", 32, n12));
            this.addRegister(new Register("ss", 32, n16));
            this.context = new NativeThreadContext(32, 0L, n12, 0L, n15, n6);
        }

        void readRegistersIA64() throws IOException {
            for (int i = 0; i < 32; ++i) {
                Elfdump.this.readLongEx();
            }
            long l = Elfdump.this.readLongEx();
            long l2 = Elfdump.this.readLongEx();
            for (int i = 0; i < 8; ++i) {
                Elfdump.this.readLongEx();
            }
            long l3 = Elfdump.this.readLongEx();
            long l4 = Elfdump.this.readLongEx();
            long l5 = Elfdump.this.readLongEx();
            long l6 = Elfdump.this.readLongEx();
            long l7 = Elfdump.this.readLongEx();
            long l8 = Elfdump.this.readLongEx();
            long l9 = Elfdump.this.readLongEx();
            long l10 = Elfdump.this.readLongEx();
            long l11 = Elfdump.this.readLongEx();
            long l12 = Elfdump.this.readLongEx();
            long l13 = Elfdump.this.readLongEx();
            long l14 = Elfdump.this.readLongEx();
            long l15 = Elfdump.this.readLongEx();
            Elfdump.this.readBuffer(new byte[584]);
            this.addRegister(new Register("nat", 64, l));
            this.addRegister(new Register("pr", 64, l2));
            this.addRegister(new Register("ip", 64, l3));
            this.addRegister(new Register("cfm", 64, l4));
            this.addRegister(new Register("psr", 64, l5));
            this.addRegister(new Register("rsc", 64, l6));
            this.addRegister(new Register("bsp", 64, l7));
            this.addRegister(new Register("bspstore", 64, l8));
            this.addRegister(new Register("rnat", 64, l9));
            this.addRegister(new Register("ccv", 64, l10));
            this.addRegister(new Register("unat", 64, l11));
            this.addRegister(new Register("fpsr", 64, l12));
            this.addRegister(new Register("pfs", 64, l13));
            this.addRegister(new Register("lc", 64, l14));
            this.addRegister(new Register("ec", 64, l15));
            this.context = null;
        }

        void readRegistersPPC() throws IOException {
            long[] lArray = new long[32];
            for (int i = 0; i < 32; ++i) {
                lArray[i] = Elfdump.this.readPtr();
            }
            long l = Elfdump.this.readPtr();
            long l2 = Elfdump.this.readPtr();
            long l3 = Elfdump.this.readPtr();
            long l4 = Elfdump.this.readPtr();
            long l5 = Elfdump.this.readPtr();
            long l6 = Elfdump.this.readPtr();
            long l7 = Elfdump.this.readPtr();
            long l8 = Elfdump.this.readPtr();
            long l9 = Elfdump.this.readPtr();
            long l10 = Elfdump.this.readPtr();
            long l11 = Elfdump.this.readPtr();
            long l12 = Elfdump.this.readPtr();
            long l13 = Elfdump.this.readPtr();
            long l14 = Elfdump.this.readPtr();
            long l15 = Elfdump.this.readPtr();
            long l16 = Elfdump.this.readPtr();
            int n = 64;
            if (Elfdump.this.bIs32Bit) {
                n = 32;
            }
            for (int i = 0; i < 32; ++i) {
                this.addRegister(new Register("gpr" + i, n, lArray[i]));
            }
            this.addRegister(new Register("nat", n, l));
            this.addRegister(new Register("pr", n, l2));
            this.addRegister(new Register("ip", n, l3));
            this.addRegister(new Register("cfm", n, l4));
            this.addRegister(new Register("psr", n, l5));
            this.addRegister(new Register("rsc", n, l6));
            this.addRegister(new Register("bsp", n, l7));
            this.addRegister(new Register("bspstore", n, l8));
            this.addRegister(new Register("rnat", n, l9));
            this.addRegister(new Register("ccv", n, l10));
            this.addRegister(new Register("unat", n, l11));
            this.addRegister(new Register("fpsr", n, l12));
            this.addRegister(new Register("pfs", n, l13));
            this.addRegister(new Register("lc", n, l14));
            this.addRegister(new Register("ec", n, l15));
            this.addRegister(new Register("fpvalid", n, l16));
            this.context = new NativeThreadContext(n, 0L, l, l5, lArray[1], lArray[15]);
        }

        void readRegistersS390() throws IOException {
            int n;
            int n2;
            long[] lArray = new long[16];
            long[] lArray2 = new long[16];
            long l = Elfdump.this.readPtr();
            long l2 = Elfdump.this.readPtr();
            for (n2 = 0; n2 < 16; ++n2) {
                lArray[n2] = Elfdump.this.readPtr();
            }
            for (n2 = 0; n2 < 16; ++n2) {
                lArray2[n2] = Elfdump.this.readWord();
            }
            long l3 = Elfdump.this.readPtr();
            long l4 = Elfdump.this.readWord();
            int n3 = 64;
            long l5 = 0L;
            if (Elfdump.this.bIs32Bit) {
                n3 = 32;
                l5 = Elfdump.this.readWord();
            }
            for (n = 0; n < 16; ++n) {
                this.addRegister(new Register("gpr" + n, n3, lArray[n]));
            }
            for (n = 0; n < 16; ++n) {
                this.addRegister(new Register("acr" + n, n3, lArray2[n]));
            }
            this.addRegister(new Register("mask", n3, l));
            this.addRegister(new Register("addr", n3, l2));
            this.addRegister(new Register("origgpr2", n3, l3));
            this.addRegister(new Register("trap", n3, l4));
            if (Elfdump.this.bIs32Bit) {
                this.addRegister(new Register("old_ilc", n3, l5));
            }
            this.context = new NativeThreadContext(n3, 0L, l2, 0L, lArray[15], 0L);
        }
    }
}

