/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import java.util.Iterator;
import java.util.Vector;

public class J9Monitor {
    private String name;
    private long id;
    private long owner;
    private String idAsString;
    private String ownerAsString;
    private long objectAddr = 0L;
    private String objectAddrAsString;

    public J9Monitor(String string, String string2, String string3, String string4) {
        this.idAsString = string;
        this.name = string2;
        this.id = DumpUtils.parseLongHex(string);
        this.ownerAsString = string3;
        this.objectAddrAsString = string4;
        if (null != string3) {
            this.owner = DumpUtils.parseLongHex(string3);
        }
        if (null == this.name) {
            this.name = null == string4 ? "Un-named Monitor" : "Object monitor @ " + this.idAsString;
        }
        if (null != string4) {
            this.objectAddr = DumpUtils.parseLongHex(string4);
        }
        J9JVMConsole.addMonitor(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n" + this.name);
        stringBuffer.append("\n  id= " + this.idAsString);
        return stringBuffer.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public String getName() {
        return this.name;
    }

    public long getOwner() {
        return this.owner;
    }

    public String getOwnerAsString() {
        return this.ownerAsString;
    }

    public long getObjectAddr() {
        return this.objectAddr;
    }

    public Vector getEnterWaiters() {
        Vector<GenericThread> vector = new Vector<GenericThread>();
        J9Jvm j9Jvm = DumpConsole.getTheDump().getCurrentJvm();
        Iterator iterator = j9Jvm.getJavaThreads();
        while (iterator.hasNext()) {
            GenericThread genericThread = (GenericThread)iterator.next();
            if (null == genericThread.monitorId || !genericThread.monitorId.equals(this.idAsString) || !genericThread.getState().equals("Waiting")) continue;
            vector.add(genericThread);
        }
        return vector;
    }

    public Vector getNotifyWaiters() {
        Vector<GenericThread> vector = new Vector<GenericThread>();
        J9Jvm j9Jvm = DumpConsole.getTheDump().getCurrentJvm();
        Iterator iterator = j9Jvm.getJavaThreads();
        while (iterator.hasNext()) {
            GenericThread genericThread = (GenericThread)iterator.next();
            if (null == genericThread.monitorId || !genericThread.monitorId.equals(this.idAsString) || !genericThread.getState().equals("Blocked")) continue;
            vector.add(genericThread);
        }
        return vector;
    }

    public String getObjectAddrAsString() {
        return this.objectAddrAsString;
    }
}

