/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9JavaStackFrame;
import java.io.IOException;
import java.util.Vector;

public class J9Thread
extends GenericThread {
    private Vector frames = new Vector();
    private String nativeId;
    private static int nameOffset = -1;
    private static J9Class javaLangThreadClass;
    private static Dump theDump;

    public J9Thread(J9Thread j9Thread) {
        super(j9Thread);
        this.frames = (Vector)j9Thread.frames.clone();
        this.nativeId = j9Thread.nativeId;
    }

    public J9Thread(String string, String string2, String string3, String string4, String string5) {
        super(string, string2, string3, string4);
        this.nativeId = string5;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == this.threadName || this.threadName.equals("!unable to establish! (dis os run?)")) {
            String string = " !unknown! ";
            if (null != this.javaLangThreadObjectAddress) {
                long l = DumpUtils.parseLongHex(DumpUtils.stripOff0x(this.javaLangThreadObjectAddress));
                if (null == javaLangThreadClass) {
                    javaLangThreadClass = J9Thread.getJLTClass();
                }
                if (null != javaLangThreadClass && -1 != nameOffset) {
                    try {
                        long l2 = theDump.readPtr(l + (long)nameOffset);
                        string = J9JVMUtils.getStringValue(l2, 0);
                    }
                    catch (IOException iOException) {
                        boolean bl = true;
                    }
                }
            } else {
                string = "  !! non Java thread !!";
            }
            this.threadName = string;
        }
        stringBuffer.append("  Name    : " + this.threadName + "\n");
        stringBuffer.append("  Id      : " + this.threadId + "\n");
        stringBuffer.append("  NativeId: " + this.nativeId + "\n");
        if (null != this.javaLangThreadObjectAddress) {
            stringBuffer.append("  Obj     : " + this.javaLangThreadObjectAddress + " (java/lang/Thread) \n");
        }
        stringBuffer.append("  State   : " + this.state);
        if (null != this.monitorId) {
            stringBuffer.append("  MonitorId: " + this.monitorId);
        }
        if (0 != this.frames.size()) {
            stringBuffer.append("\n\tStack:\n");
            for (int i = 0; i < this.frames.size(); ++i) {
                J9JavaStackFrame j9JavaStackFrame = (J9JavaStackFrame)this.frames.get(i);
                if (null == j9JavaStackFrame) continue;
                stringBuffer.append("\t\t" + j9JavaStackFrame.toString() + "\n");
            }
        } else {
            stringBuffer.append("\n\t No Stack available");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void printHeader(StringBuffer stringBuffer) {
        stringBuffer.append("Info for thread - " + this.threadId + "\n===============================\n");
    }

    public boolean isJavaThread() {
        boolean bl = true;
        if (null == this.javaLangThreadObjectAddress) {
            bl = false;
        }
        return bl;
    }

    public String getThreadDetails() {
        if (null == this.threadDetails) {
            if (!this.isJavaThread()) {
                this.threadName = "** Not a Java Thread **";
                this.threadDetails = " Non-java thread ";
            } else {
                int n;
                String string = DumpUtils.stripOff0x(this.javaLangThreadObjectAddress);
                string = DumpUtils.padToPtrSize(string);
                long l = DumpUtils.parseLongHex(string);
                J9Class j9Class = J9JVMConsole.getClass("java/lang/Thread");
                this.threadDetails = j9Class.formatObject(l);
                int n2 = this.threadDetails.indexOf("\"");
                if (-1 != n2 && -1 != (n = this.threadDetails.indexOf("\"", n2 + 1))) {
                    this.threadName = this.threadDetails.substring(n2 + 1, n);
                }
            }
        }
        return this.threadDetails;
    }

    public String getThreadName() {
        if (null == this.threadName && null == this.threadDetails) {
            this.getThreadDetails();
        }
        return this.threadName;
    }

    public void addFrame(String string, String string2, String string3) {
        J9JavaStackFrame j9JavaStackFrame = new J9JavaStackFrame(string, string2, string3);
        this.frames.add(j9JavaStackFrame);
    }

    private static J9Class getJLTClass() {
        J9Class j9Class = null;
        j9Class = J9JVMConsole.getClass("java/lang/Thread");
        if (null == j9Class) {
            Console.reportError(" !!! No java/lang/Thread definition available !!!", null);
        } else {
            nameOffset = j9Class.getFieldOffset("name");
        }
        return j9Class;
    }

    public Vector getFrames() {
        return this.frames;
    }

    public String getNativeId() {
        return this.nativeId;
    }

    public GenericThread getNativeThread() {
        if (this.getNativeId() != null) {
            return J9JVMConsole.getKnownThread(this.getNativeId());
        }
        return null;
    }

    static {
        theDump = DumpConsole.getTheDump();
    }
}

