/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

public class PageCache {
    protected byte[] bytes;
    protected static final int NO_KEY = -1;
    public int numPages = 16;
    public int pageSize = 262144;
    public int hiUsage = 5;
    public int loUsage = 20;
    protected Page[] pages;
    protected long lruBits = 0L;
    protected int evictTick = 0;
    protected int evictPeriod = 1;
    protected int evictGrowth = 1;
    protected int maxPeriod = 65536;
    protected int maxGrowth = 32;

    protected void initialize() {
        this.pages = new Page[this.numPages];
        this.bytes = new byte[this.numPages * this.pageSize];
        for (int i = 0; i < this.numPages; ++i) {
            this.pages[i] = new Page();
            this.pages[i].slot = i * this.pageSize;
        }
    }

    PageCache() {
        this.initialize();
    }

    PageCache(int n, int n2, double d, double d2) {
        this.numPages = n;
        this.pageSize = n2;
        this.hiUsage = (int)(1.0 / d);
        this.loUsage = (int)(1.0 / d2);
        this.initialize();
    }

    public Page find(int n, long l, int n2) {
        int n3;
        if (n2 < 0 || n2 > this.pageSize) {
            return null;
        }
        for (n3 = 0; n3 < this.numPages; ++n3) {
            int n4;
            Page page = this.pages[n3];
            if (page.key != n || 0 > (n4 = (int)(l - page.base)) || n4 > page.span - n2) continue;
            return page;
        }
        if (this.evictTick++ % this.evictPeriod > 0) {
            return null;
        }
        n3 = 0;
        while (n3 < this.numPages) {
            long l2 = 1 << n3;
            long l3 = (this.lruBits ^ 0xFFFFFFFFFFFFFFFFL) & l2;
            this.lruBits &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            this.lruBits |= l3;
            if (l3 == 0L) {
                n3 += n3;
                continue;
            }
            n3 += n3 + 1;
        }
        Page page = this.pages[n3 - this.numPages];
        if (page.used < page.span / this.loUsage && this.evictPeriod < this.maxPeriod) {
            this.evictPeriod += this.evictGrowth;
            this.evictTick = 1;
            if (this.evictGrowth < this.maxGrowth) {
                this.evictGrowth <<= 1;
            }
        }
        page.base = l;
        page.span = 0;
        page.used = 0;
        page.key = -1;
        return page;
    }

    public class Page {
        protected int slot = -1;
        protected long base = 0L;
        protected int span = 0;
        protected int key = -1;
        protected int used = 1;

        public boolean isEmpty() {
            return this.key == -1;
        }

        public void push(int n, long l, byte[] byArray) {
            System.arraycopy(byArray, 0, PageCache.this.bytes, this.slot, byArray.length);
            this.base = l;
            this.span = byArray.length;
            this.key = n;
        }

        public byte[] pull(int n, long l, int n2) {
            if (this.key != n || this.key == -1) {
                return null;
            }
            int n3 = (int)(l - this.base);
            if (n3 > this.span - n2) {
                n2 = this.span - n3;
            }
            if (n2 < 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(PageCache.this.bytes, this.slot + n3, byArray, 0, n2);
            this.used += n2;
            if (this.used >= this.span / PageCache.this.hiUsage && PageCache.this.evictPeriod > 1) {
                PageCache.this.evictPeriod >>>= 1;
                PageCache.this.evictTick = 0;
                PageCache.this.evictGrowth = 1;
            }
            return byArray;
        }
    }
}

