/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Elfdump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.IOException;

class ProgramHeaderElement {
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_TLS = 7;
    long type;
    long flags;
    long offset;
    long virtaddr;
    long physaddr;
    long filesize;
    long memsize;
    long align;
    MemoryRange range;

    public String toString() {
        String string = "\ttype:" + this.type + "\toffset:0x" + Long.toHexString(this.offset) + "\tVirtAddr:0x" + Long.toHexString(this.virtaddr) + "\tPhyAddr:0x" + Long.toHexString(this.physaddr) + "\tfilesize:0x" + Long.toHexString(this.filesize) + "\tmemsize:0x" + Long.toHexString(this.memsize) + "\tflags:" + this.flags + "\tAlign:" + this.align;
        return string;
    }

    protected ProgramHeaderElement() {
    }

    public ProgramHeaderElement(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        this.type = l;
        this.flags = l2;
        this.offset = l3;
        this.virtaddr = l4;
        this.physaddr = l5;
        this.filesize = l6;
        this.memsize = l7;
        this.align = l8;
        this.range = new MemoryRange(l4, l3, l7);
    }

    public static ProgramHeaderElement readProgramHeaderElement(Elfdump elfdump, boolean bl) throws IOException {
        ProgramHeaderElement programHeaderElement = new ProgramHeaderElement();
        if (bl) {
            programHeaderElement.type = elfdump.readUnsignInt();
            programHeaderElement.offset = elfdump.readUnsignInt();
            programHeaderElement.virtaddr = elfdump.readUnsignInt();
            programHeaderElement.physaddr = elfdump.readUnsignInt();
            programHeaderElement.filesize = elfdump.readUnsignInt();
            programHeaderElement.memsize = elfdump.readUnsignInt();
            programHeaderElement.flags = elfdump.readUnsignInt();
            programHeaderElement.align = elfdump.readUnsignInt();
        } else {
            programHeaderElement.type = elfdump.readUnsignInt();
            programHeaderElement.flags = elfdump.readUnsignInt();
            programHeaderElement.offset = elfdump.readUnsignLong();
            programHeaderElement.virtaddr = elfdump.readUnsignLong();
            programHeaderElement.physaddr = elfdump.readUnsignLong();
            programHeaderElement.filesize = elfdump.readUnsignLong();
            programHeaderElement.memsize = elfdump.readUnsignLong();
            programHeaderElement.align = elfdump.readUnsignLong();
        }
        return programHeaderElement;
    }

    public MemoryRange getRange() {
        if (null == this.range) {
            this.range = new MemoryRange(this.virtaddr, this.offset, this.memsize);
        }
        return this.range;
    }
}

