/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.basic.BERObject;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabase;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.CertReqFile;
import com.ibm.gsk.ikeyman.basic.CertificateItem;
import com.ibm.gsk.ikeyman.basic.CertificateRequestItem;
import com.ibm.gsk.ikeyman.basic.CryptographicToken;
import com.ibm.gsk.ikeyman.basic.DNItem;
import com.ibm.gsk.ikeyman.basic.EncryptedPrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.IkeymanLogger;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMExtensionItem;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.KeyItem;
import com.ibm.gsk.ikeyman.basic.KeyStoreManagerException;
import com.ibm.gsk.ikeyman.basic.MSCertificateStore;
import com.ibm.gsk.ikeyman.basic.PrivateKeyInfoItem;
import com.ibm.gsk.ikeyman.basic.SSLightKeyDatabase;
import com.ibm.gsk.ikeyman.basic.SelfSignedCert;
import com.ibm.misc.BASE64Encoder;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.security.pkcs10.CertificationRequestInfo;
import com.ibm.security.pkcs7.Content;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.CertificateAlgorithmId;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateIssuerName;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateSubjectName;
import com.ibm.security.x509.CertificateValidity;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.spi.IBMKeyStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class KeyStoreManager {
    public static final int KEY_DATABASE_TYPE_UNKNOWN = 0;
    public static final int KEY_DATABASE_TYPE_CMS = 1;
    public static final int KEY_DATABASE_TYPE_MSDB = 2;
    public static final int KEY_DATABASE_TYPE_JAVA_CRYPTO = 3;
    public static final int KEY_DATABASE_TYPE_CMS_CRYPTO = 4;
    public static final int KEY_DATABASE_TYPE_SSLIGHT = 5;
    public static final int MAX_KEY_DATABASE_TYPE_INDEX = 10;
    public static final int KEY_STORAGE_TYPE_PKCS12 = 7;
    public static final int KEY_STORAGE_DATA_TYPE_BASE64 = 8;
    public static final int KEY_STORAGE_DATA_TYPE_DER = 9;
    public static final int KEY_STORAGE_DATA_TYPE_SSLIGHT = 10;
    public static final int CRYPTO_TYPE_WITH_CMS = 1;
    public static final int CRYPTO_TYPE_WITH_JSSE = 2;
    public static final int CRYPTO_TYPE_WITH_MS = 3;
    public static final int CRYPTO_TYPE_UNKNOWN = 4;
    public static final String nameOfCMS = "CMS";
    static final String nameOfSSLight = "SSLight";
    static final String nameOfPKCS12 = "PKCS12";
    static final String nameOfJKS = "JKS";
    static final String nameOfJCEKS = "JCEKS";
    public static final String nameOfMSStore = "Microsoft Certificate Store";
    public static final String nameOfJCryptoki = "Java Cryptographic Token";
    public static final String nameOfCCryptoki = "CMS Cryptographic Token";
    static final String RSAKEYTYPE = "RSA";
    static final String DSAKEYTYPE = "DSA";
    static final String SigOfMD5_IBMCMS = "MD5 with RSA";
    static final String SigOfSHA1_IBMCMS = "SHA1 with RSA";
    static final String PKCS11SigAlg_IBMJCEProvider = "PKCS11MD5withRSA";
    static final String SigOfMD5_IBMJCEProvider = "MD5withRSA";
    static final String SigOfSHA1_IBMJCEProvider = "SHA1withRSA";
    static final String DigOfMD5_IBMJCEProvider = "MD5";
    static final String DigOfSHA1_IBMJCEProvider = "SHA1";
    public static final int SIGNATURE_ALGORITHM_MD5_WITH_RSA = 1;
    public static final int SIGNATURE_ALGORITHM_SHA1_WITH_RSA = 2;
    static final String cmsProviderClass = "com.ibm.spi.IBMCMSProvider";
    static final String cmsProvider = "IBMCMS";
    public static String DEFAULT_KEYDB_LOCATION_CMS = ".";
    public static String DEFAULT_KEYDB_NAME_CMS = "key";
    public static String DEFAULT_KEYDB_NAME_EXT_CMS = ".kdb";
    public static boolean USE_LAST_OPENED_LOCATION_CMS = true;
    public static String DEFAULT_PKCS12_FILE_LOCATION = ".";
    public static String DEFAULT_PKCS12_FILE_NAME = "key";
    public static String DEFAULT_PKCS12_FILE_NAME_EXT = ".p12";
    public static boolean USE_LAST_OPENED_LOCATION_PKCS12 = true;
    public static String DEFAULT_JKS_FILE_LOCATION = null;
    public static String DEFAULT_JKS_FILE_NAME = "key";
    public static String DEFAULT_JKS_FILE_NAME_EXT = ".jks";
    public static boolean USE_LAST_OPENED_LOCATION_JKS = true;
    public static String DEFAULT_JCEKS_FILE_LOCATION = ".";
    public static String DEFAULT_JCEKS_FILE_NAME = "key";
    public static String DEFAULT_JCEKS_FILE_NAME_EXT = ".jck";
    public static boolean USE_LAST_OPENED_LOCATION_JCEKS = true;
    public static String DEFAULT_KEYDB_LOCATION_SSLIGHT = null;
    public static String DEFAULT_SSLIGHT_EXTRACT_FILE_LOCATION = null;
    public static String DEFAULT_SSLIGHT_PACKAGE_NAME = null;
    public static String DEFAULT_KEYDB_NAME_SSLIGHT = "keyring.class";
    public static String DEFAULT_SSLIGHT_EXTRACT_FILE_NAME = "keyring.class";
    public static String DEFAULT_CERTREQ_NAME = "certreq.arm";
    public static String DEFAULT_PRTFCERT_NAME = "cert.str";
    public static String DEFAULT_PRTFREQ_NAME = "certreq.str";
    public static String DEFAULT_CERTIFICATE_NAME_ARM = "cert.arm";
    public static String DEFAULT_CERTIFICATE_NAME_BIN = "cert.crt";
    public static String DEFAULT_CERTIFICATE_NAME_DER = "cert.der";
    public static String DEFAULT_CERTIFICATE_NAME_PEM = "cert.pem";
    public static String DEFAULT_KEYDB_NAME_EXT_SSLIGHT = ".class";
    public static String DEFAULT_BASE64_FILE_NAME_EXT = ".arm";
    public static String DEFAULT_DER_FILE_NAME_EXT = ".der";
    public static String DEFAULT_PEM_FILE_NAME_EXT = ".pem";
    public static final String DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST = ".rdb";
    public static final String DEFAULT_KEYDB_NAME_EXT_CMS_CRL = ".crl";
    public static final String DEFAULT_BINARY_CERT_FILE_NAME_EXT = ".crt";
    public static final String DEFAULT_PASSWORD_STASH_FILE_NAME_EXT = ".sth";
    public static String DEFAULT_PKCS12_EXPORT_VERSION = "3";
    public static int DEFAULT_1_BROWSER_ITERATION_COUNT = 1;
    public static String DEFAULT_1_BROWSER_ENC_ALGORITHM = "SHA1_RC2_40";
    public static int DEFAULT_2_IKEYMAN_ITERATION_COUNT = 5;
    public static String DEFAULT_2_IKEYMAN_ENC_ALGORITHM = "SHA1_3DES3";
    public static int DEFAULT_PKCS12_ENCODE_TYPE = 2;
    public static String DEFAULT_PKCS12_GUI_POPUPS = "1";
    public static int[] dbTypes = null;
    private static String[] sTypes = null;
    private static String[] defaultKeyStoreTypes;
    protected KeyStore iKeyStore = null;
    protected int type;
    protected String keyDbFileName;
    protected String keyDbPwd;
    protected long keyDbPwdExpireTime;
    protected String dbFileName = null;
    protected String dbDirName = null;
    public boolean isCAAddedUnderCMS = false;
    public static boolean isImportNow;
    public boolean isCLISource = false;
    public boolean keyDbChanged = false;
    protected Vector keyLabelList = null;
    protected Vector caCertLabelList = null;
    protected Vector myCertLabelList = null;
    protected Vector reqKeyLabelList = null;
    protected Vector crlLabelList = null;
    protected Vector siteCertLabelList = null;
    protected CryptographicToken cmsCryptoki = null;
    private static String aCryptographicTokenModuleName;
    private static String aCryptographicTokenLabel;
    private int cryptokiType = 0;
    private int cryptokiSlot_ID = 0;
    public static boolean isJSSECryptokiOpened;
    public static boolean isCMSCryptokiOpened;
    private byte[] keyidentifier = "IkeymanCertificateRequest".getBytes();
    public static String JCEProvider;
    public static int SYSTEM_DEFAULT;
    public static int RSA;
    public static int ICC;
    static final String CLASS1_ROOT_LABEL = "Verisign Class 1 Public Primary Certification Authority";
    static final String CLASS2_ROOT_LABEL = "Verisign Class 2 Public Primary Certification Authority";
    static String CLASS3_ROOT_LABEL;
    static final String RSA_SECURE_SERVER_CA_LABEL = "RSA Secure Server Certification Authority";
    static final String VERISIGN_TEST_CA_LABEL = "Verisign Test CA Root Certificate";
    static final String THAWTE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Server CA";
    static final String THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Premium Server CA";
    static final String THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Basic CA";
    static final String THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Freemail CA";
    static final String THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL = "Thawte Personal Premium CA";
    static final String CLASS1_INTERMEDIATE_LABEL = "VeriSign Class 1 CA Individual Subscriber-Persona Not Validated";
    static final String CLASS2_INTERMEDIATE_LABEL = "VeriSign Class 2 CA Individual Subscriber-Persona Not Validated";
    static final String CLASS3_INTERMEDIATE_LABEL = "VeriSign Class 3 CA Individual Subscriber-Persona Not Validated";
    static final String Verisign_International_Server_Certification_Authority_Class_3 = "VeriSign International Server CA - Class 3";
    static final String Verisign_Class_2_OnSite_Individual_Certification_Authority = "VeriSign Class 2 OnSite Individual CA";
    static final String Verisign_Class_1_Public_Primary_Certification_Authority_G2 = "Verisign Class 1 Public Primary Certification Authority - G2";
    static final String Verisign_Class_2_Public_Primary_Certification_Authority_G2 = "Verisign Class 2 Public Primary Certification Authority - G2";
    static final String Verisign_Class_3_Public_Primary_Certification_Authority_G2 = "Verisign Class 3 Public Primary Certification Authority - G2";
    static final String VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL = "VeriSign Class 1 Public Primary Certification Authority - G3";
    static final String VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL = "VeriSign Class 2 Public Primary Certification Authority - G3";
    static final String VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL = "VeriSign Class 3 Public Primary Certification Authority - G3";
    static final String VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL = "VeriSign Class 4 Public Primary Certification Authority - G3";
    static final String VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL = "VeriSign Class 1 Public Primary Certification Authority - G2";
    static final String VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL = "VeriSign Class 2 Public Primary Certification Authority - G2";
    static final String VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL = "VeriSign Class 3 Public Primary Certification Authority - G2";
    static final String VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL = "VeriSign Class 4 Public Primary Certification Authority - G2";
    static final String VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL = "VeriSign Class 1 Public Primary Certification Authority";
    static final String VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL = "VeriSign Class 2 Public Primary Certification Authority";
    static final String VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL = "VeriSign Class 3 Public Primary Certification Authority";
    static final String VERISIGN_CLASS3_SECURE_SERVER_CA_LABEL = "VeriSign Class 3 Secure Server CA";
    static final String ENTRUST_SECURE_SERVER_CA_LABEL = "Entrust.net Secure Server Certification Authority";
    static final String ENTRUST_CA_2048_LABEL = "Entrust.net Certification Authority (2048)";
    static final String ENTRUST_CLIENT_CA_LABEL = "Entrust.net Client Certification Authority";
    static final String ENTRUST_GLOBAL_CLIENT_CA_LABEL = "Entrust.net Global Client Certification Authority";
    static final String ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL = "Entrust.net Global Secure Server Certification Authority";
    static final String ENTRUST_WAPCA_LABEL = "Entrust.net WAP CA";

    public KeyStoreManager() {
        KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(void) 0000");
        this.type = 0;
        this.keyDbFileName = null;
        this.keyDbPwd = null;
        this.keyDbPwdExpireTime = 0L;
        KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(void) 9999");
    }

    public KeyStoreManager(boolean bl) {
        this();
        this.isCLISource = bl;
    }

    public KeyStoreManager(KeyStoreManager keyStoreManager) {
        this.type = keyStoreManager.getType();
        this.keyDbFileName = keyStoreManager.getKeyDbFileName();
        this.keyDbPwd = keyStoreManager.getKeyDbPwd();
        this.keyDbPwdExpireTime = keyStoreManager.getKeyDbPwdExpireTime();
        this.setKeyLabelList(keyStoreManager.getKeyLabelList());
        this.setCaCertLabelList(keyStoreManager.getCaCertLabelList());
        this.setMyCertLabelList(keyStoreManager.getMyCertLabelList());
        this.setReqKeyLabelList(keyStoreManager.getReqKeyLabelList());
        this.setCrlLabelList(keyStoreManager.getCrlLabelList());
        this.setSiteCertLabelList(keyStoreManager.getSiteCertLabelList());
        this.iKeyStore = keyStoreManager.iKeyStore;
        this.dbFileName = keyStoreManager.dbFileName;
        this.dbDirName = keyStoreManager.dbDirName;
    }

    public KeyStoreManager(String string, int n, int n2, boolean bl) throws KMException {
        this(string, n, n2);
        this.isCLISource = bl;
    }

    public KeyStoreManager(String string, int n, int n2) throws KMException {
        KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(Crypto args) 0000, tokenLabel=" + string + " Crypto type=" + n2);
        if (n2 == 1) {
            this.type = 4;
            this.cryptokiType = n2;
            this.cmsCryptoki = new CryptographicToken(string);
        } else if (n2 == 2) {
            this.type = 3;
            this.cryptokiType = n2;
            this.keyDbFileName = aCryptographicTokenModuleName;
            this.cryptokiSlot_ID = n;
            aCryptographicTokenLabel = string;
            try {
                File file = new File(this.keyDbFileName);
                this.keyDbFileName = file.getCanonicalPath();
                this.keyDbFileName = this.keyDbFileName + ':' + this.cryptokiSlot_ID;
                file = new File(this.keyDbFileName);
                this.dbFileName = file.getName() + this.cryptokiSlot_ID;
                this.dbDirName = file.getParent();
                KMUtil.debugMsg("KeyStoreManager-KeyStoreManager-100-this.keyDbFileName=" + this.keyDbFileName);
                this.iKeyStore = KeyStoreManager.createKeyStoreInstance(this.type);
            }
            catch (KeyStoreException keyStoreException) {
                IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(Crypto) Line 469", "The key database has an invalid database type: tokenLabel=" + string + " Crypto type=" + n2);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
            }
            catch (IOException iOException) {
                IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(Crypto) Line 475", "The key database has an invalid database name: keyDbFileName=" + this.keyDbFileName);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_KEYDB_NAME"));
            }
        } else {
            IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(Crypto) Line 481", "The key database crypto type was invalid: eachCryptoType=" + n2 + " This should be with CMS or JSSE.");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DATABASE_TYPE"));
        }
    }

    public KeyStoreManager(int n, String string, String string2) throws KeyStoreManagerException {
        this(n, string, string2, 0L, false);
    }

    public KeyStoreManager(int n, String string, String string2, long l, boolean bl) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(4 args) 0000, databaseType=" + n + ", keyDbFileName=" + string + ", keyDbPwd=" + string2 + ", keyDbPwdExpireTime" + l);
        if (!bl && !KeyStoreManager.isDbTypeSupported(n)) {
            IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(int,String,String,long,boolean) Line 509", "Not a supported database type:  databaseType=" + n + ", keyDbFileName=" + string + ", keyDbPwd=" + string2 + ", keyDbPwdExpireTime" + l);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
        }
        this.type = n;
        this.keyDbFileName = string;
        this.keyDbPwd = string2;
        this.keyDbPwdExpireTime = l;
        try {
            if (this.type != 2) {
                File file = new File(string);
                this.keyDbFileName = string = file.getCanonicalPath();
                file = new File(string);
                this.dbFileName = file.getName();
                this.dbDirName = file.getParent();
            }
            this.iKeyStore = KeyStoreManager.createKeyStoreInstance(this.type);
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(4 args) 9999-1, KeyStoreException=" + keyStoreException);
            IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(int,String,String,long,boolean) Line 544", "Not a supported database type:  databaseType=" + n + ", keyDbFileName=" + string + ", keyDbPwd=" + string2 + ", keyDbPwdExpireTime" + l);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::KeyStoreManager 9999-2, IOException=" + iOException);
            IkeymanLogger.error("KeyStoreManager", "KeyStoreManager(int,String,String,long,boolean) Line 559", "Not a valid key key databasename: keyDbFileName=" + string);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_KEYDB_NAME"));
        }
        KMUtil.debugMsg("KeyStoreManager::KeyStoreManager(4 args) 9999");
    }

    public static KeyItem getKeyItemFromCertificationRequest(String string, CertificationRequest certificationRequest, String string2, Key key) throws KMException {
        KeyItem keyItem = null;
        try {
            byte[] byArray = certificationRequest.encode();
            X500Name x500Name = certificationRequest.getCertRequestInfo().getSubjectName();
            DNItem dNItem = new DNItem(x500Name.getCommonName(), x500Name.getOrganizationalUnit(), x500Name.getOrganization(), x500Name.getLocality(), x500Name.getState(), x500Name.getPostalCode(), x500Name.getCountry(), x500Name.getEmail());
            PublicKey publicKey = certificationRequest.getCertRequestInfo().getSubjectPublicKeyInfo();
            int n = 0;
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
            if (n % 2 != 0) {
                ++n;
            }
            BERObject bERObject = new BERObject(publicKey.getEncoded());
            PKCSAttributes pKCSAttributes = certificationRequest.getCertRequestInfo().getAttributes();
            BERObject bERObject2 = new BERObject(pKCSAttributes.generateDerEncoding());
            byte[] byArray2 = certificationRequest.getSignature();
            AlgorithmId algorithmId = certificationRequest.getSignatureAlgorithm();
            BERObject bERObject3 = new BERObject(algorithmId.encode());
            byte[] byArray3 = certificationRequest.getCertRequestInfo().encode();
            CertificateRequestItem certificateRequestItem = new CertificateRequestItem((short)n, dNItem, bERObject, bERObject2, byArray2, bERObject3, algorithmId.getOID().toString(), algorithmId.getName(), byArray, byArray3);
            EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
            if (key != null && string2 != null && string2.length() > 0) {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(key.getEncoded());
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(string2.toCharArray(), privateKeyInfo, "SHA", "128BitRC4");
                byte[] byArray4 = encryptedPrivateKeyInfo.getEncryptedData();
                encryptedPrivateKeyInfoItem = new EncryptedPrivateKeyInfoItem(byArray4);
            }
            keyItem = new KeyItem(string, 0, certificateRequestItem.getKeySize(), encryptedPrivateKeyInfoItem, certificateRequestItem, null);
            keyItem.setHasPrivateKey(true);
        }
        catch (InvalidKeyException invalidKeyException) {
            IkeymanLogger.error("KeyStoreManager", "getKeyItemFromCertificationRequest(String,CertificationRequest,String,Key) Line 665", invalidKeyException.getMessage() + " certReq details: " + certificationRequest.getCertRequestInfo().toString());
            throw new KMException(invalidKeyException.getMessage());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            IkeymanLogger.error("KeyStoreManager", "getKeyItemFromCertificationRequest(String,CertificationRequest,String,Key) Line 671", invalidKeySpecException.getMessage() + " certReq details: " + certificationRequest.getCertRequestInfo().toString());
            throw new KMException(invalidKeySpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IkeymanLogger.error("KeyStoreManager", "getKeyItemFromCertificationRequest(String,CertificationRequest,String,Key) Line 677", noSuchAlgorithmException.getMessage() + " The cryptographic algorithm: " + certificationRequest.getSignatureAlgorithm().toString() + " requested is not available in your environment.");
            throw new KMException(noSuchAlgorithmException.getMessage());
        }
        catch (IOException iOException) {
            IkeymanLogger.error("KeyStoreManager", "getKeyItemFromCertificationRequest(String,CertificationRequest,String,Key) Line 684", iOException.getMessage() + " Check you have read/write permissions to perform the action attempted for certReq details: " + certificationRequest.getCertRequestInfo().toString());
            throw new KMException(iOException.getMessage());
        }
        catch (Exception exception) {
            IkeymanLogger.exception("KeyStoreManager", "getKeyItemFromCertificationRequest(String,CertificationRequest,String,Key) Line 690", exception, "certReq details: " + certificationRequest.getCertRequestInfo().toString());
        }
        return keyItem;
    }

    public static CertificationRequest getCertificationRequestFromKeyItem(KeyItem keyItem) throws KMException {
        try {
            return new CertificationRequest(keyItem.getCertificateRequestItem().getEncoded());
        }
        catch (Exception exception) {
            IkeymanLogger.error("KeyStoreManager", "getCertificationRequestFromKeyItem(KeyItem) Line 708", exception.getMessage() + " aKeyItem=" + keyItem.toString());
            throw new KMException(exception.toString());
        }
    }

    private static KeyStore createKeyStoreInstance(int n) throws KeyStoreException {
        KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 0000, aType=" + n);
        String string = KeyStoreManager.getKeyStoreName(n);
        KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 0010, ksType=" + string);
        try {
            if (string.equals(nameOfCMS) && n != 1 && n != 4) {
                IkeymanLogger.error("KeyStoreManager", "createKeyStoreInstance(int) Line 730", "While creating a KeyStore instance, it was found that the key store name in ksType=" + string + " didn't have the aType=" + n + " equal to CMS or CMS CRYPTO.");
                throw new KeyStoreException();
            }
            if (string.equals(nameOfCMS) || string.equals(nameOfCCryptoki)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-1");
                return IBMKeyStore.getInstance(string);
            }
            if (string.equals(nameOfJCryptoki)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-2");
                return KeyStore.getInstance("PKCS11KS");
            }
            if (string.equals(nameOfMSStore)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-3");
                return IBMKeyStore.getInstance(nameOfMSStore);
            }
            if (string.equals(nameOfPKCS12)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-4");
                return KeyStore.getInstance(string);
            }
            if (string.equals(nameOfJKS)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-5");
                return KeyStore.getInstance(string);
            }
            if (string.equals(nameOfJCEKS)) {
                KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-6");
                return KeyStore.getInstance(string);
            }
            KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-7");
            IkeymanLogger.error("KeyStoreManager", "createKeyStoreInstance(int) Line 777", "While creating a KeyStore instance the correct type  was not found:  ksType=" + string + " aType=" + n);
            throw new KeyStoreException();
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::createKeyStoreInstance() 9999-8, KeyStoreException=" + keyStoreException);
            throw keyStoreException;
        }
    }

    public static void refreshCryptoGraphicToken(int n) throws KMException {
        if (n == 1) {
            KMUtil.debugMsg("KeyStoreManager::refreshCryptoGraphicToken() 0000");
            CryptographicToken.refresh();
        }
    }

    public static void initCryptoGraphicToken(String string, int n) throws KMException {
        if (string == null) {
            return;
        }
        KMUtil.debugMsg("CKeyStoreManager::initCryptoGraphicToken() Module=" + string + " Token Type=" + n);
        if (n == 1) {
            CryptographicToken.init(string);
        } else if (n == 2) {
            aCryptographicTokenModuleName = string;
        } else {
            IkeymanLogger.error("KeyStoreManager", "initCryptoGraphicToken(String,int) Line 825", "There was an error initialising the Cryptographic token " + string + " with type " + n);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_NOT_INITIALIZED"));
        }
    }

    public static void loadInitSetting() {
        KMUtil.debugMsg("KeyStoreManager::loadInitSetting() 0000");
        String string = null;
        String string2 = null;
        Boolean bl = new Boolean("false");
        string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_KEYDB_LOCATION_CMS"));
        string2 = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_CMS_FILE_LOCATION"));
        DEFAULT_KEYDB_LOCATION_CMS = string2 != null ? string2 : (string != null ? string : KMSystem.getWorkingDirName());
        string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_EXT_CMS");
        string2 = KMSystem.getInitSetting("DEFAULT_CMS_FILE_NAME_EXT");
        if (string2 != null) {
            DEFAULT_KEYDB_NAME_EXT_CMS = string2;
        } else if (string != null) {
            DEFAULT_KEYDB_NAME_EXT_CMS = string;
        }
        string = KMSystem.getInitSetting("DEFAULT_KEYDB_NAME_CMS");
        string2 = KMSystem.getInitSetting("DEFAULT_CMS_FILE_NAME");
        if (string != null && KMUtil.isValidFileName(string)) {
            DEFAULT_KEYDB_NAME_CMS = string;
        } else if (string2 != null && KMUtil.isValidFileName(string2)) {
            DEFAULT_KEYDB_NAME_CMS = string2;
        }
        if (DEFAULT_KEYDB_NAME_CMS.endsWith(DEFAULT_KEYDB_NAME_EXT_CMS)) {
            DEFAULT_KEYDB_NAME_CMS = DEFAULT_KEYDB_NAME_CMS.substring(0, DEFAULT_KEYDB_NAME_CMS.lastIndexOf(DEFAULT_KEYDB_NAME_EXT_CMS));
        }
        if ((string = KMSystem.getInitSetting("USE_LAST_OPENED_LOCATION_CMS")) != null) {
            bl = new Boolean(string);
            USE_LAST_OPENED_LOCATION_CMS = bl;
        }
        DEFAULT_JKS_FILE_LOCATION = (string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_JKS_FILE_LOCATION"))) != null ? string : KMSystem.getWorkingDirName();
        string = KMSystem.getInitSetting("DEFAULT_JKS_FILE_NAME");
        if (string != null && KMUtil.isValidFileName(string)) {
            DEFAULT_JKS_FILE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_JKS_FILE_NAME_EXT")) != null) {
            DEFAULT_JKS_FILE_NAME_EXT = string;
        }
        if (DEFAULT_JKS_FILE_NAME.endsWith(DEFAULT_JKS_FILE_NAME_EXT)) {
            DEFAULT_JKS_FILE_NAME = DEFAULT_JKS_FILE_NAME.substring(0, DEFAULT_JKS_FILE_NAME.lastIndexOf(DEFAULT_JKS_FILE_NAME_EXT));
        }
        if ((string = KMSystem.getInitSetting("USE_LAST_OPENED_LOCATION_JKS")) != null) {
            bl = new Boolean(string);
            USE_LAST_OPENED_LOCATION_JKS = bl;
        }
        DEFAULT_JCEKS_FILE_LOCATION = (string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_JCEKS_FILE_LOCATION"))) != null ? string : KMSystem.getWorkingDirName();
        string = KMSystem.getInitSetting("DEFAULT_JCEKS_FILE_NAME");
        if (string != null && KMUtil.isValidFileName(string)) {
            DEFAULT_JCEKS_FILE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_JCEKS_FILE_NAME_EXT")) != null) {
            DEFAULT_JCEKS_FILE_NAME_EXT = string;
        }
        if (DEFAULT_JCEKS_FILE_NAME.endsWith(DEFAULT_JCEKS_FILE_NAME_EXT)) {
            DEFAULT_JCEKS_FILE_NAME = DEFAULT_JCEKS_FILE_NAME.substring(0, DEFAULT_JCEKS_FILE_NAME.lastIndexOf(DEFAULT_JCEKS_FILE_NAME_EXT));
        }
        if ((string = KMSystem.getInitSetting("USE_LAST_OPENED_LOCATION_JCEKS")) != null) {
            bl = new Boolean(string);
            USE_LAST_OPENED_LOCATION_JCEKS = bl;
        }
        DEFAULT_PKCS12_FILE_LOCATION = (string = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_LOCATION"))) != null ? string : KMSystem.getWorkingDirName();
        string = KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_NAME");
        if (string != null && KMUtil.isValidFileName(string)) {
            DEFAULT_PKCS12_FILE_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_FILE_NAME_EXT")) != null) {
            DEFAULT_PKCS12_FILE_NAME_EXT = string;
        }
        if (DEFAULT_PKCS12_FILE_NAME.endsWith(DEFAULT_PKCS12_FILE_NAME_EXT)) {
            DEFAULT_PKCS12_FILE_NAME = DEFAULT_PKCS12_FILE_NAME.substring(0, DEFAULT_PKCS12_FILE_NAME.lastIndexOf(DEFAULT_PKCS12_FILE_NAME_EXT));
        }
        if ((string = KMSystem.getInitSetting("USE_LAST_OPENED_LOCATION_PKCS12")) != null) {
            bl = new Boolean(string);
            USE_LAST_OPENED_LOCATION_PKCS12 = bl;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTREQ_NAME")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTREQ_NAME = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_ARM")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_ARM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_DER")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_DER = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_CERTIFICATE_NAME_PEM")) != null && KMUtil.isValidFileName(string)) {
            DEFAULT_CERTIFICATE_NAME_PEM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_BASE64_FILE_NAME_EXT")) != null) {
            DEFAULT_BASE64_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_DER_FILE_NAME_EXT")) != null) {
            DEFAULT_DER_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PEM_FILE_NAME_EXT")) != null) {
            DEFAULT_PEM_FILE_NAME_EXT = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_GUI_POPUPS")) != null) {
            DEFAULT_PKCS12_GUI_POPUPS = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_EXPORT_VERSION")) != null) {
            DEFAULT_PKCS12_EXPORT_VERSION = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_1_BROWSER_ITERATION_COUNT")) != null) {
            try {
                DEFAULT_1_BROWSER_ITERATION_COUNT = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_1_BROWSER_ITERATION_COUNT = 1;
            }
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_1_BROWSER_ENC_ALGORITHM")) != null) {
            DEFAULT_1_BROWSER_ENC_ALGORITHM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_2_IKEYMAN_ITERATION_COUNT")) != null) {
            try {
                DEFAULT_2_IKEYMAN_ITERATION_COUNT = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_2_IKEYMAN_ITERATION_COUNT = 5;
            }
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_2_IKEYMAN_ENC_ALGORITHM")) != null) {
            DEFAULT_2_IKEYMAN_ENC_ALGORITHM = string;
        }
        if ((string = KMSystem.getInitSetting("DEFAULT_PKCS12_ENCODE_TYPE")) != null) {
            try {
                DEFAULT_PKCS12_ENCODE_TYPE = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                DEFAULT_PKCS12_ENCODE_TYPE = 1;
            }
        }
        KMUtil.debugMsg("KeyStoreManager::loadInitSetting() 9999");
    }

    public KeyStore getKeyStoreInstance() {
        return this.iKeyStore;
    }

    public void setDefaultKey(String string) throws KeyStoreManagerException {
        if (this.type == 1) {
            try {
                ((IBMKeyStore)this.iKeyStore).setDefaultKeyEntry(string);
                this.keyDbChanged = true;
            }
            catch (KeyStoreException keyStoreException) {
                IkeymanLogger.error("KeyStoreManager", "setDefaultKey(String) Line 1043", keyStoreException.getMessage() + " alias=" + string);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
            }
        } else {
            if (this.type == 2) {
                return;
            }
            IkeymanLogger.error("KeyStoreManager", "setDefaultKey(String) Line 1051", "Error occurred setting the default key: alias=" + string);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_DEFAULT_KEY"));
        }
        this.save();
    }

    public void setKeyTrust(String string, boolean bl) throws KeyStoreManagerException {
        if (this.type != 1) {
            if (this.type == 2) {
                return;
            }
            IkeymanLogger.error("KeyStoreManager", "setKeyTrust(String,boolean) Line 1065", "Error occurred while setting the trusted key: alias=" + string + " isTrusted=" + bl);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_SET_TRUST_KEY"));
        }
        ((IBMKeyStore)this.iKeyStore).setTrusted(string, bl);
    }

    private boolean needTrustedCARoots() {
        return KeyStoreManager.isDbTypeSupported(this.type);
    }

    public void close() throws KeyStoreManagerException {
        this.save();
        isJSSECryptokiOpened = false;
        isCMSCryptokiOpened = false;
    }

    public void save() throws KeyStoreManagerException {
        block29: {
            KMUtil.debugMsg("KeyStoreManager::save() 0000");
            try {
                if (this.type == 4 || this.type == 3) {
                    if (this.cryptokiType == 1) {
                        this.closeCMSCryptoki();
                    }
                    if (this.cryptokiType == 2) {
                        KMUtil.debugMsg("KeyStoreManager::save() 0100");
                        KMUtil.debugMsg("KeyStoreManager::save() 0110");
                    }
                    KMUtil.debugMsg("KeyStoreManager::save() 9999-1");
                    return;
                }
                if (this.type == 0 || !this.keyDbChanged) {
                    KMUtil.debugMsg("KeyStoreManager::save() 9999-2");
                    return;
                }
                if (this.type == 2) {
                    this.iKeyStore.store(null, this.keyDbPwd.toCharArray());
                    break block29;
                }
                if (this.type == 1) {
                    KMUtil.debugMsg("KeyStoreManager::save() 0200");
                    FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
                    String string = null;
                    String string2 = null;
                    int n = this.keyDbFileName.lastIndexOf(46);
                    if (n == -1) {
                        string = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                        string2 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                    } else {
                        string = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                        string2 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                    }
                    try {
                        string = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    }
                    catch (Exception exception) {
                        string = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                        IkeymanLogger.error("KeyStoreManager", "save() Line 1163", "Could not save fileNameOfRdb=" + string + ". Please check " + "the file is a valid name.");
                        KMUtil.debugMsg("KeyStoreManager::save() 8000, Exception=" + exception + ", fileNameOfRdb=" + string);
                    }
                    File file = null;
                    File file2 = null;
                    FileOutputStream fileOutputStream2 = null;
                    FileOutputStream fileOutputStream3 = null;
                    file2 = new File(string);
                    fileOutputStream2 = new FileOutputStream(string);
                    try {
                        string2 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                    }
                    catch (Exception exception) {
                        string2 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                        IkeymanLogger.error("KeyStoreManager", "save() Line 1186", "Could not save fileNameOfCrl=" + string2 + ". Please check " + "the file is a valid name.");
                        KMUtil.debugMsg("KeyStoreManager::save() 8010, Exception=" + exception + ", fileNameOfRdb=" + string2);
                    }
                    file = new File(string2);
                    fileOutputStream3 = new FileOutputStream(string2);
                    ((IBMKeyStore)this.iKeyStore).storeCMS(fileOutputStream, fileOutputStream2, fileOutputStream3, this.keyDbPwd.toCharArray());
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                    if (fileOutputStream3 != null) {
                        fileOutputStream3.close();
                    }
                    try {
                        if (file2.length() <= 0L) {
                            file2.delete();
                        }
                        if (file.length() <= 0L) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {
                        KMUtil.debugMsg("KeyStoreManager::save() 8023, Exception=" + exception);
                    }
                    fileOutputStream.close();
                    break block29;
                }
                if (this.type != 5) {
                    if (KeyStoreManager.getKeyStoreName(this.type).equalsIgnoreCase(nameOfPKCS12)) {
                        KMUtil.debugMsg("KeyStoreManager::save() 0500");
                        FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
                        KMUtil.debugMsg("KeyStoreManager::save() 0510");
                        this.iKeyStore.store(fileOutputStream, this.keyDbPwd.toCharArray());
                        KMUtil.debugMsg("KeyStoreManager::save() 0520");
                        fileOutputStream.close();
                    } else {
                        KMUtil.debugMsg("KeyStoreManager::save() 0500");
                        FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
                        KMUtil.debugMsg("KeyStoreManager::save() 0510");
                        this.iKeyStore.store(fileOutputStream, this.keyDbPwd.toCharArray());
                        KMUtil.debugMsg("KeyStoreManager::save() 0520");
                        fileOutputStream.close();
                    }
                }
            }
            catch (IOException iOException) {
                KMUtil.debugMsg("KeyStoreManager::save() 9999-3, IOException=" + iOException);
                if (iOException.toString().startsWith("java.io.FileNotFoundException")) {
                    IkeymanLogger.error("KeyStoreManager", "save() Line 1284", "The file " + this.keyDbFileName + " was not found during save.  Check your file/directory permissions.");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DISK_NOT_WRITABLE"));
                }
                if (iOException.toString().startsWith("java.io.IOException")) {
                    IkeymanLogger.error("KeyStoreManager", "save() Line 1293", "Could not save the file " + this.keyDbFileName + ".  Check you have read/write permissions or " + "if there is enough space.");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INSUFFICIENT_SPACE"));
                }
                IkeymanLogger.error("KeyStoreManager", "save() Line 1301", "Could not save the file " + this.keyDbFileName + ".  Check you have read/write permissions or " + "if there is enough space.");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
            }
            catch (CertificateException certificateException) {
                KMUtil.debugMsg("KeyStoreManager::save() 9999-4, CertificateException=" + certificateException);
                IkeymanLogger.error("KeyStoreManager", "save() Line 1313", "Could not save the file " + this.keyDbFileName + " due to X509 exception.");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                KMUtil.debugMsg("KeyStoreManager::save() 9999-5, NoSuchAlgorithmException=" + noSuchAlgorithmException);
                IkeymanLogger.error("KeyStoreManager", "save() Line 1324", "Could not save the file " + this.keyDbFileName + " due to encountering an unsupported algorithm.");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
            }
            catch (KeyStoreException keyStoreException) {
                KMUtil.debugMsg("KeyStoreManager::save() 9999-6, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (KMException kMException) {
                KMUtil.debugMsg("KeyStoreManager::save() 9999-7, KMException=" + kMException);
            }
        }
        KMUtil.debugMsg("KeyStoreManager::save() 9999");
        this.keyDbChanged = false;
    }

    public void create() throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::create() 0000");
        try {
            if (this.type == 0 || this.type == 2) {
                KMUtil.debugMsg("KeyStoreManager::create() 9999-1");
                IkeymanLogger.warning("KeyStoreManager", "create() Line 1357", "Key database type is unknown or MSDB.");
                return;
            }
            if (this.type == 4 || this.type == 3) {
                if (this.cryptokiType == 2) {
                    byte[] byArray = this.keyDbFileName.getBytes();
                    ByteArrayInputStream byteArrayInputStream = null;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    KMUtil.debugMsg("KeyStoreManager::create() 0100");
                    this.iKeyStore.load(byteArrayInputStream, this.keyDbPwd.toCharArray());
                    KMUtil.debugMsg("KeyStoreManager::create() 0110");
                    this.keyDbChanged = true;
                    this.save();
                    KMUtil.debugMsg("KeyStoreManager::create() 9999-2");
                    return;
                }
            } else if (this.type == 1) {
                KMUtil.debugMsg("KeyStoreManager::create() 0200");
                ((IBMKeyStore)this.iKeyStore).loadCMS(null, null, null, this.keyDbPwd.toCharArray());
                KMUtil.debugMsg("KeyStoreManager::create() 0210");
                if (this.keyDbPwd != "") {
                    ((IBMKeyStore)this.iKeyStore).setExpireTime(this.keyDbPwdExpireTime);
                }
            } else {
                KMUtil.debugMsg("KeyStoreManager::create() 0300");
                this.iKeyStore.load(null, this.keyDbPwd.toCharArray());
                KMUtil.debugMsg("KeyStoreManager::create() 0310");
            }
            if (!this.needTrustedCARoots()) {
                KMUtil.debugMsg("KeyStoreManager::create() 9999-3");
                return;
            }
            this.addDefaultRootCertificates();
            Enumeration<String> enumeration = this.iKeyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                this.addCaCertLabel(string);
            }
            this.keyDbChanged = true;
            this.save();
            this.buildKeyStoreLabelList();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("KeyStoreManager::create() 9999-4, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_ALGORITHM"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::create() 9999-5, CertificateException=" + certificateException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::create() 9999-6, IOException=" + iOException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::create() 9999-7, KeyStoreException=" + keyStoreException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (Exception exception) {
            KMUtil.debugMsg("KeyStoreManager::create() 9999-9, Exception=" + exception);
            throw new KeyStoreManagerException(exception.getMessage());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_SUPPORT_LIBRARY_MISSING"));
        }
        KMUtil.debugMsg("KeyStoreManager::create() 9999");
    }

    public void createKeyStoreWithoutIkeymanCaCerts() throws KeyStoreManagerException {
        try {
            this.iKeyStore.load(null, this.keyDbPwd.toCharArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_ALGORITHM"));
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IOException iOException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
    }

    public void open(String string) throws KMException {
        block5: {
            try {
                KMUtil.debugMsg("KeyStoreManager::open(pwd) 0000, cryptokiType=" + this.cryptokiType);
                if (this.cryptokiType == 1) {
                    KMUtil.debugMsg("KeyStoreManager::open(pwd) 0010, cryptoPassword=" + string);
                    this.cmsCryptoki.open(string);
                    isCMSCryptokiOpened = true;
                    break block5;
                }
                if (this.cryptokiType == 2) {
                    this.keyDbPwd = string;
                    byte[] byArray = this.keyDbFileName.getBytes();
                    ByteArrayInputStream byteArrayInputStream = null;
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    KMUtil.debugMsg("KeyStoreManager::open(pwd) 0050, bytes=" + byArray + ", pwd=" + this.keyDbPwd);
                    this.iKeyStore.load(byteArrayInputStream, this.keyDbPwd.toCharArray());
                    KMUtil.debugMsg("KeyStoreManager::open(pwd) 0060");
                    this.buildPKCS11KeyStoreLabelList();
                    isJSSECryptokiOpened = true;
                    break block5;
                }
                KMUtil.debugMsg("KeyStoreManager::open(pwd) 0100");
                IkeymanLogger.error("KeyStoreManager", "open(String) Line 1529", "The crypto type is an invalid  type: cryptokiType=" + this.cryptokiType + " Should be either CMS or JSSE.");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DATABASE_TYPE"));
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::open(pwd) 0300, exception=" + exception);
                IkeymanLogger.error("KeyStoreManager", "open(String) Line 1539", "The cryptographic token initialization failed: cryptoPassword=" + string + " cryptokiType=" + this.cryptokiType + " keyDbFileName=" + this.keyDbFileName);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_INITIALIZATION_FAILED"));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                IkeymanLogger.error("KeyStoreManager", "open(String) Line 1547", "The cryptographic token support library wasn't found:  cryptokiType=" + this.cryptokiType + " keyDbFileName=" + this.keyDbFileName);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTOGRAPHIC_TOKEN_SUPPORT_LIBRARY_MISSING"));
            }
        }
        KMUtil.debugMsg("KeyStoreManager::open(pwd) 9999");
    }

    public void open() throws KeyStoreManagerException {
        try {
            KMUtil.debugMsg("KeyStoreManager::open() 0000, keyDbFileName=" + this.keyDbFileName);
            if (this.type == 0) {
                return;
            }
            if (this.type == 1) {
                String string = null;
                String string2 = null;
                FileInputStream fileInputStream = new FileInputStream(this.keyDbFileName);
                FileInputStream fileInputStream2 = null;
                FileInputStream fileInputStream3 = null;
                File file = new File(this.keyDbFileName);
                int n = this.keyDbFileName.lastIndexOf(46);
                KMUtil.debugMsg("KeyStoreManager::open() 0010, keyDbFileName=" + this.keyDbFileName);
                if (!file.exists()) {
                    KMUtil.debugMsg("KeyStoreManager::open() 9999-1");
                    IkeymanLogger.error("KeyStoreManager", "open() Line 1581", "The file doesn't exist: keyDbFileName=" + this.keyDbFileName);
                    throw new KeyStoreManagerException("file not found");
                }
                if (n == -1) {
                    string = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    string2 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                } else {
                    string = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    string2 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                }
                file = new File(string);
                if (file.exists()) {
                    fileInputStream2 = new FileInputStream(string);
                    KMUtil.debugMsg("KeyStoreManager::open() 0200, fileNameOfRdb=" + string);
                }
                if ((file = new File(string2)).exists()) {
                    fileInputStream3 = new FileInputStream(string2);
                    KMUtil.debugMsg("KeyStoreManager::open() 0210, fileNameOfCrl=" + string2);
                }
                ((IBMKeyStore)this.iKeyStore).loadCMS(fileInputStream, fileInputStream2, fileInputStream3, this.keyDbPwd.toCharArray());
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
                if (fileInputStream3 != null) {
                    fileInputStream3.close();
                }
                fileInputStream.close();
            } else if (this.type != 5) {
                if (this.type == 2) {
                    ((IBMKeyStore)this.iKeyStore).load(this.keyDbFileName, this.keyDbPwd);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(this.keyDbFileName);
                    KMUtil.debugMsg("KeyStoreManager::open() 500");
                    try {
                        this.iKeyStore.load(fileInputStream, this.keyDbPwd.toCharArray());
                    }
                    catch (IOException iOException) {
                        String string = KeyStoreManager.getKeyStoreName(this.type);
                        if (!string.equals(nameOfPKCS12)) {
                            IkeymanLogger.error("KeyStoreManager", "open() Line 1659", "Keystore name doesn't equal PKCS12: " + string);
                            throw iOException;
                        }
                        String string3 = iOException.getMessage();
                        KMUtil.debugMsg("KeyStoreManager::open() 8000a, IOException=" + string3);
                        if (string3.startsWith("DER input")) {
                            IkeymanLogger.error("KeyStoreManager", "open() Line 1668", "KM-PKCS12 unsupported");
                            throw new IOException("KM-PKCS12 unsupported");
                        }
                        throw iOException;
                    }
                    catch (Exception exception) {
                        IkeymanLogger.error("KeyStoreManager", "open() Line 1675", "An error occurred while trying to open the key database file: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                        throw exception;
                    }
                    KMUtil.debugMsg("KeyStoreManager::open() 510");
                    fileInputStream.close();
                }
            }
            this.buildKeyStoreLabelList();
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::open() 8000,\n IOException=" + iOException + "\n IOException/Msg=" + iOException.getMessage());
            if (iOException.getMessage() == null) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-0, e.getMessage()==null");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1725", "Check that the database you are trying to open is a valid file and/or you have read/write permissions: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_CORRUPTION"));
            }
            if (iOException.getMessage().equals(KMSystem.getNLSErrString("GSKKM_ERR_PASSWORD_EXPIRATION_TIME"))) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-1-password expired");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1735", "The password has expired. keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PASSWORD_EXPIRATION_TIME"));
            }
            if (iOException.getMessage().endsWith("18")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-2-database corrupted");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1745", "Check that the database you are trying to open is a valid file and/or you have read/write permissions: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_CORRUPTION"));
            }
            if (iOException.getMessage().endsWith("17")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-3-invalid format");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1754", "Check that the database you are trying to open is a valid file: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_FORMAT_INVALID"));
            }
            if (iOException.getMessage().endsWith("16") || iOException.getMessage().endsWith("Keystore was tampered with, or password was incorrect") || iOException.getMessage().endsWith("Unable to verify MAC.")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-4-wrong password");
                if (!isImportNow) {
                    IkeymanLogger.error("KeyStoreManager", "open() Line 1766", KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PASSWORD_CORRUPTION") + "keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type) + " isImportNow=" + isImportNow);
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PASSWORD_CORRUPTION"));
                }
                IkeymanLogger.error("KeyStoreManager", "open() Line 1773", KMSystem.getNLSErrString("GSKKM_ERR_PKCS12_PWD_CORRUPTION") + "to open was provided with the correct password: " + "keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type) + " isImportNow=" + isImportNow);
                isImportNow = false;
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PKCS12_PWD_CORRUPTION"));
            }
            if (iOException.getMessage().endsWith("Invalid keystore format")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-5-invalid keystore format");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1784", "Check that the database you are trying to open has a valid keystore format: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_FORMAT_INVALID"));
            }
            if (iOException.toString().startsWith("java.io.FileNotFoundException")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-14");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1793", "Check that the database you are trying to open exists: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_FORMAT_INVALID"));
            }
            if (iOException.toString().endsWith("KM-PKCS12 unsupported") || iOException.toString().endsWith("insufficient data") || iOException.toString().endsWith("not a SEQUENCE.") || iOException.toString().endsWith(" too big.")) {
                KMUtil.debugMsg("KeyStoreManager::open() 9999-15");
                IkeymanLogger.error("KeyStoreManager", "open() Line 1804", "Check that the database you are trying to open uses a supported PKCS12 or you supplied the correct password: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type) + " isImportNow=" + isImportNow);
                isImportNow = false;
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PKCS12_PWD_CORRUPTION"));
            }
            KMUtil.debugMsg("KeyStoreManager::open() 9999-16-else");
            IkeymanLogger.error("KeyStoreManager", "open() Line 1814", "Check that the database you are trying to open is a valid file and/or you have read/write permissions: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_CORRUPTION"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::open() 9999-310, CertificateException=" + certificateException);
            IkeymanLogger.error("KeyStoreManager", "open() Line 1826", "Unable to load a certificate in the keystore: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            KMUtil.debugMsg("KeyStoreManager::open() 9999-311, KeyStoreManagerException=" + keyStoreManagerException);
            IkeymanLogger.error("KeyStoreManager", "open() Line 1837", "An error occurred while building the keystore label list: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        catch (Exception exception) {
            IkeymanLogger.error("KeyStoreManager", "open() Line 1844", "An error occurred while opening the keystore: keyDbFileName=" + this.keyDbFileName + " keyDbPwd=" + this.keyDbPwd + " keystorename=" + KeyStoreManager.getKeyStoreName(this.type));
            KMUtil.debugMsg("KeyStoreManager::open() 9999-320, Exception=" + exception);
        }
        KMUtil.debugMsg("KeyStoreManager::open() 9999");
    }

    public void changeKeyDbPwd(String string, String string2, long l) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 0000");
        if (string != null && !string.equals(this.keyDbPwd)) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-1");
            IkeymanLogger.error("KeyStoreManager", "changeKeyDbPwd(String,String,long) Line 1863", "While attempting to change the password the old password supplied was incorrect: currKeyDbPwd=" + string);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_OLD_PASSWORD"));
        }
        try {
            if (this.type == 2) {
                return;
            }
            if (this.type == 1) {
                KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 0200");
                FileOutputStream fileOutputStream = new FileOutputStream(this.keyDbFileName);
                String string3 = null;
                String string4 = null;
                int n = this.keyDbFileName.lastIndexOf(46);
                if (n == -1) {
                    string3 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    string4 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                } else {
                    string3 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    string4 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                }
                try {
                    string3 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                }
                catch (Exception exception) {
                    string3 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 8000, Exception=" + exception + ", fileNameOfRdb=" + string3);
                }
                File file = null;
                File file2 = null;
                FileOutputStream fileOutputStream2 = null;
                FileOutputStream fileOutputStream3 = null;
                file2 = new File(string3);
                fileOutputStream2 = new FileOutputStream(string3);
                try {
                    string4 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                }
                catch (Exception exception) {
                    string4 = this.keyDbFileName + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                    KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 8010, Exception=" + exception + ", fileNameOfRdb=" + string4);
                }
                file = new File(string4);
                fileOutputStream3 = new FileOutputStream(string4);
                ((IBMKeyStore)this.iKeyStore).storeCMS(fileOutputStream, fileOutputStream2, fileOutputStream3, string2.toCharArray());
                if (fileOutputStream2 != null) {
                    fileOutputStream2.close();
                }
                if (fileOutputStream3 != null) {
                    fileOutputStream3.close();
                }
                try {
                    if (file2.length() <= 0L) {
                        file2.delete();
                    }
                    if (file.length() <= 0L) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    KMUtil.debugMsg("KeyStoreManager::save() 8023, Exception=" + exception);
                }
                fileOutputStream.close();
                if (string2 != "") {
                    ((IBMKeyStore)this.iKeyStore).setExpireTime(l);
                }
            } else if (this.type != 5) {
                String string5 = null;
                Enumeration<String> enumeration = this.iKeyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    string5 = enumeration.nextElement();
                    if (!this.iKeyStore.isKeyEntry(string5)) continue;
                    Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string5);
                    Key key = this.iKeyStore.getKey(string5, this.keyDbPwd.toCharArray());
                    this.iKeyStore.setKeyEntry(string5, key, string2.toCharArray(), certificateArray);
                }
            }
            this.keyDbPwd = string2;
            this.keyDbChanged = true;
            this.save();
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-2");
            IkeymanLogger.error("KeyStoreManager", "changeKeyDbPwd(String,String,long) Line 1997", "Unable to change the key database's password, check that you have read/write permissions to perform this operation: keyDbFileName=" + this.keyDbFileName);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-3");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-4");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PASSWORD_CORRUPTION"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-5");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999-6");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        KMUtil.debugMsg("KeyStoreManager::changeKeyDbPwd() 9999");
    }

    public void reCreate(KeyStoreManager keyStoreManager) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::reCreate 0000");
        try {
            String string;
            String string2;
            Object object;
            if (keyStoreManager.getType() == 0 || this.type == 0 || keyStoreManager.getType() == 2 || this.type == 2) {
                KMUtil.debugMsg("KeyStoreManager::reCreate 9999-1, invaild argument");
                IkeymanLogger.error("KeyStoreManager", "reCreate(KeyStoreManager) Line 2048", "Can't recreate the keystore because it is the wrong type, either unknown or MSDB.");
                return;
            }
            if (this.type == 1) {
                KMUtil.debugMsg("KeyStoreManager::reCreate 0080");
                ((IBMKeyStore)this.iKeyStore).loadCMS(null, null, null, this.keyDbPwd.toCharArray());
                KMUtil.debugMsg("KeyStoreManager::reCreate 0090");
                if (this.keyDbPwd != "") {
                    ((IBMKeyStore)this.iKeyStore).setExpireTime(this.keyDbPwdExpireTime);
                }
            } else {
                KMUtil.debugMsg("KeyStoreManager::reCreate 0100");
                this.iKeyStore.load(null, this.keyDbPwd.toCharArray());
                KMUtil.debugMsg("KeyStoreManager::reCreate 0110");
            }
            KeyStore keyStore = keyStoreManager.iKeyStore;
            Enumeration<String> enumeration = keyStore.aliases();
            String string3 = null;
            Certificate[] certificateArray = null;
            CertificationRequest certificationRequest = null;
            Key key = null;
            Hashtable<String, Certificate> hashtable = new Hashtable<String, Certificate>();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                string3 = enumeration.nextElement();
                this.addKeyLabel(string3);
                if (keyStoreManager.type == 1 && ((IBMKeyStore)keyStore).isCertReqEntry(string3)) {
                    if (this.type != 1) continue;
                    certificationRequest = ((IBMKeyStore)keyStore).getCertReqEntry(string3);
                    key = keyStore.getKey(string3, keyStoreManager.keyDbPwd.toCharArray());
                    ((IBMKeyStore)this.iKeyStore).setCertReqEntry(string3, certificationRequest, key);
                    this.addReqKeyLabel(string3);
                    continue;
                }
                if (!keyStore.isKeyEntry(string3)) {
                    if (this.type != 1 && keyStoreManager.type == 1 && !((IBMKeyStore)keyStore).isTrusted(string3)) continue;
                    object = ((X509Certificate)keyStore.getCertificate(string3)).getIssuerDN().toString();
                    if (((String)object).equals(string2 = ((X509Certificate)keyStore.getCertificate(string3)).getSubjectDN().toString())) {
                        try {
                            this.iKeyStore.setCertificateEntry(string3, keyStore.getCertificate(string3));
                            if (keyStoreManager.type == 1 && this.type == 1) {
                                ((IBMKeyStore)this.iKeyStore).setTrusted(string3, ((IBMKeyStore)keyStore).isTrusted(string3));
                            }
                            this.addCaCertLabel(string3);
                            continue;
                        }
                        catch (KeyStoreException keyStoreException) {
                            if (keyStoreException.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48") || keyStoreException.getMessage().endsWith("INVALID_CERT_CHAIN")) continue;
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                        }
                    }
                    hashtable.put(string3, keyStore.getCertificate(string3));
                    continue;
                }
                vector.add(string3);
            }
            object = hashtable.keys();
            string2 = null;
            while (object.hasMoreElements()) {
                string2 = (String)object.nextElement();
                try {
                    this.iKeyStore.setCertificateEntry(string2, (Certificate)hashtable.get(string2));
                    if (keyStoreManager.type == 1 && this.type == 1) {
                        ((IBMKeyStore)this.iKeyStore).setTrusted(string2, ((IBMKeyStore)keyStore).isTrusted(string2));
                    }
                    this.addCaCertLabel(string2);
                }
                catch (KeyStoreException keyStoreException) {
                    if (keyStoreException.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48") || keyStoreException.getMessage().endsWith("INVALID_CERT_CHAIN")) continue;
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                }
            }
            String string4 = null;
            key = null;
            certificateArray = new Certificate[1];
            int n = 0;
            while (n < vector.size()) {
                string4 = (String)vector.get(n);
                key = keyStore.getKey(string4, keyStoreManager.keyDbPwd.toCharArray());
                string = new PrivateKeyInfo(key.getEncoded());
                certificateArray[0] = keyStore.getCertificate(string4);
                this.iKeyStore.setKeyEntry(string4, (Key)((Object)string), this.keyDbPwd.toCharArray(), certificateArray);
                this.addMyCertLabel(string4);
                ++n;
            }
            if (this.type == 1 && keyStoreManager.type == 1 && (string = ((IBMKeyStore)keyStore).getDefaultKeyEntry()) != null) {
                ((IBMKeyStore)this.iKeyStore).setDefaultKeyEntry(string);
            }
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999-2, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999-3, CertificateException=" + certificateException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999-4, IOException=" + iOException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        catch (KeyStoreException keyStoreException) {
            if (keyStoreException.getMessage().endsWith("INVALID_CERT_CHAIN")) {
                KMUtil.debugMsg("KeyStoreManager::reCreate 9999-5b, KeyStoreException" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_SAVE"));
            }
            if (keyStoreException.getMessage().endsWith("24") || keyStoreException.getMessage().endsWith("25") || keyStoreException.getMessage().endsWith("26") || keyStoreException.getMessage().endsWith("27")) {
                KMUtil.debugMsg("KeyStoreManager::reCreate 9999-5c, KeyStoreException" + keyStoreException);
                throw new KeyStoreManagerException("reCreate duplicate certificate");
            }
            if (!keyStoreException.getMessage().equals("User canceled")) {
                KMUtil.debugMsg("KeyStoreManager::reCreate 9999-6, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999-7, KeyStoreException=" + keyStoreException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            KMUtil.debugMsg("KeyStoreManager::reCreate 9999-5a, UnrecoverableKeyException=" + unrecoverableKeyException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
    }

    public boolean stashKeydbPwd(String string) {
        if (this.type == 2) {
            return false;
        }
        try {
            String string2 = string.substring(0, string.lastIndexOf(46)) + DEFAULT_PASSWORD_STASH_FILE_NAME_EXT;
            ((IBMKeyStore)this.iKeyStore).stashKeydbPwd(new FileOutputStream(string2));
        }
        catch (Exception exception) {
            String string3 = string + DEFAULT_PASSWORD_STASH_FILE_NAME_EXT;
            try {
                ((IBMKeyStore)this.iKeyStore).stashKeydbPwd(new FileOutputStream(string3));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return true;
    }

    public void delete() throws IOException, KeyStoreManagerException {
        File file = new File(this.keyDbFileName);
        if (file.exists()) {
            this.open();
            this.close();
            file.delete();
            if (this.type == 1) {
                String string = null;
                String string2 = null;
                try {
                    string = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_REQUEST;
                    File file2 = new File(string);
                    file2.delete();
                    string2 = this.keyDbFileName.substring(0, this.keyDbFileName.lastIndexOf(46)) + DEFAULT_KEYDB_NAME_EXT_CMS_CRL;
                    File file3 = new File(string2);
                    file3.delete();
                }
                catch (Exception exception) {}
            } else {
                if (this.type == 2) {
                    return;
                }
                if (this.cryptokiType != 2 && this.dbDirName != null) {
                    CertReqFile certReqFile = new CertReqFile(this.dbDirName, this.dbFileName);
                    certReqFile.removeReqFile();
                }
            }
        } else {
            IkeymanLogger.error("KeyStoreManager", "delete() Line 2339", "Couldn't delete file: " + this.keyDbFileName + " because it " + "wasn't found.  Please check the file.");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_FILE_NOT_FOUND"));
        }
    }

    public void createNewSelfSignedCertificate(int n, String string, boolean bl, int n2, DNItem dNItem, int n3, int n4, String string2, boolean bl2, Vector vector) throws KeyStoreManagerException {
        String string3;
        boolean bl3;
        block65: {
            block64: {
                KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0000, keyLabel=<" + string + ">");
                bl3 = false;
                if (n2 != 512 && n2 != 1024 && n2 != 2048) {
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
                }
                try {
                    if (this.iKeyStore.containsAlias(string)) {
                        throw new KeyStoreManagerException("\"" + string + "\" " + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (this.type == 0) {
                    return;
                }
                if (this.type != 1 && this.type != 2) break block64;
                switch (n4) {
                    case 1: {
                        string3 = SigOfMD5_IBMCMS;
                        break block65;
                    }
                    case 2: {
                        string3 = SigOfSHA1_IBMCMS;
                        break block65;
                    }
                    default: {
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
                    }
                }
            }
            switch (n4) {
                case 1: {
                    string3 = SigOfMD5_IBMJCEProvider;
                    break;
                }
                case 2: {
                    string3 = SigOfSHA1_IBMJCEProvider;
                    break;
                }
                default: {
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
                }
            }
        }
        try {
            if (this.type == 4 || this.type == 3) {
                if (this.cryptokiType == 2) {
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0300");
                    X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                    X509Certificate x509Certificate = null;
                    Certificate[] certificateArray = null;
                    string3 = PKCS11SigAlg_IBMJCEProvider;
                    SelfSignedCert selfSignedCert = null;
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0350, RSAKEYTYPE=RSA, signatureAlgorithm=" + string3);
                    selfSignedCert = new SelfSignedCert(RSAKEYTYPE, string3, this.iKeyStore);
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0360");
                    try {
                        KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0370");
                        selfSignedCert.generate(n2, string);
                        KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0380");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0380, IllegalArgumentException=" + illegalArgumentException);
                        throw new KeyStoreManagerException(illegalArgumentException.getMessage());
                    }
                    x509Certificate = selfSignedCert.getSelfCertificate(x500Name, n3 * 24 * 60 * 60, n - 1);
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0390");
                    certificateArray = new X509Certificate[]{x509Certificate};
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0400");
                    this.iKeyStore.setKeyEntry(string, selfSignedCert.getPrivateKey(), this.keyDbPwd.toCharArray(), certificateArray);
                    KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 0410");
                    if (string2 != null) {
                        boolean bl4 = true;
                        File file = new File(string2);
                        try {
                            bl4 = file.exists();
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            if (bl2) {
                                PrintStream printStream = new PrintStream(fileOutputStream);
                                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                                printStream.println("-----BEGIN CERTIFICATE-----");
                                bASE64Encoder.encodeBuffer(x509Certificate.getEncoded(), (OutputStream)printStream);
                                printStream.println("-----END CERTIFICATE-----");
                                printStream.close();
                            } else {
                                fileOutputStream.write(x509Certificate.getEncoded());
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            if (!bl4 && file.exists()) {
                                file.delete();
                            }
                            bl3 = true;
                        }
                    }
                    this.addKeyLabelAt(string, 0);
                    this.addMyCertLabelAt(string, 0);
                }
            } else if (this.type == 1 || this.type == 2) {
                ((IBMKeyStore)this.iKeyStore).createNewSelfSignedCertificate(n, string, n2, dNItem, n3, n4, vector);
                X509Certificate x509Certificate = (X509Certificate)this.iKeyStore.getCertificate(string);
                if (bl) {
                    this.setDefaultKey(string);
                }
                if (string2 != null) {
                    boolean bl5 = true;
                    File file = new File(string2);
                    try {
                        bl5 = file.exists();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        if (bl2) {
                            PrintStream printStream = new PrintStream(fileOutputStream);
                            BASE64Encoder bASE64Encoder = new BASE64Encoder();
                            printStream.println("-----BEGIN CERTIFICATE-----");
                            bASE64Encoder.encodeBuffer(x509Certificate.getEncoded(), (OutputStream)printStream);
                            printStream.println("-----END CERTIFICATE-----");
                            printStream.close();
                        } else {
                            byte[] byArray = x509Certificate.getEncoded();
                            fileOutputStream.write(byArray);
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        this.iKeyStore.deleteEntry(string);
                        if (!bl5 && file.exists()) {
                            file.delete();
                        }
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                    }
                }
                this.addKeyLabelAt(string, 0);
                this.addMyCertLabelAt(string, 0);
            } else {
                Object object;
                Certificate[] certificateArray;
                Object object2;
                X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSAKEYTYPE, JCEProvider);
                SecureRandom secureRandom = SecureRandom.getInstance("IBMSecureRandom", JCEProvider);
                keyPairGenerator.initialize(n2, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PublicKey publicKey = keyPair.getPublic();
                PrivateKey privateKey = keyPair.getPrivate();
                Date date = new Date();
                Date date2 = new Date();
                date2.setTime(date2.getTime() + (long)(n3 * 24 * 60 * 60) * 1000L);
                CertificateValidity certificateValidity = new CertificateValidity(date, date2);
                X509CertInfo x509CertInfo = new X509CertInfo();
                if (n != 0 && n != 1 && n != 2) {
                    x509CertInfo.set("version", (Object)new CertificateVersion(2));
                } else {
                    x509CertInfo.set("version", (Object)new CertificateVersion(n - 1));
                }
                x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber((int)(date.getTime() / 1000L)));
                AlgorithmId algorithmId = AlgorithmId.getAlgorithmId((String)string3);
                x509CertInfo.set("algorithmID", (Object)new CertificateAlgorithmId(algorithmId));
                x509CertInfo.set("subject", (Object)new CertificateSubjectName(x500Name));
                x509CertInfo.set("key", (Object)new CertificateX509Key(publicKey));
                x509CertInfo.set("validity", (Object)certificateValidity);
                x509CertInfo.set("issuer", (Object)new CertificateIssuerName(x500Name));
                if (vector.size() > 0) {
                    GeneralNames generalNames = new GeneralNames();
                    int n5 = 0;
                    while (n5 < vector.size()) {
                        object2 = null;
                        int n6 = ((KMExtensionItem)vector.elementAt(n5)).getFieldType();
                        certificateArray = (Certificate[])((KMExtensionItem)vector.elementAt(n5)).getFieldValue();
                        if (n6 == 1) {
                            object2 = new RFC822Name((String)certificateArray);
                        } else if (n6 == 7) {
                            int n7 = new StringTokenizer((String)certificateArray, ".").countTokens();
                            if (n7 == 4) {
                                KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate an Valid ipv4" + (String)certificateArray);
                                Object object3 = certificateArray;
                                byte[] byArray = new byte[4];
                                int n8 = 0;
                                while (n8 < 3) {
                                    int n9 = object3.indexOf(".");
                                    String string4 = object3.substring(0, n9);
                                    object3 = object3.substring(n9 + 1);
                                    byArray[n8] = (byte)Integer.parseInt(string4);
                                    ++n8;
                                }
                                byArray[n8] = (byte)Integer.parseInt((String)object3);
                                DerValue derValue = new DerValue(4, byArray);
                                object2 = new IPAddressName(derValue);
                            } else {
                                object2 = new IPAddressName((String)certificateArray);
                            }
                        } else if (n6 == 2) {
                            object2 = new DNSName((String)certificateArray);
                        }
                        object = new GeneralName((GeneralNameInterface)object2);
                        generalNames.addElement(object);
                        ++n5;
                    }
                    object2 = new SubjectAlternativeNameExtension(generalNames);
                    object = new CertificateExtensions();
                    object.set("SubjectAlternativeName", object2);
                    x509CertInfo.set("extensions", object);
                }
                X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
                KMUtil.debugMsg("createNewSelfSignedCertificate(10 arg) 7500 -254" + JCEProvider + "  Algorithm " + n4);
                if (n4 == 2) {
                    x509CertImpl.sign(privateKey, string3, JCEProvider);
                } else {
                    x509CertImpl.sign(privateKey, string3);
                }
                KMUtil.debugMsg("createNewSelfSignedCertificate(10 arg) 7501 " + x509CertImpl);
                certificateArray = new X509Certificate[]{x509CertImpl};
                this.iKeyStore.setKeyEntry(string, privateKey, this.keyDbPwd.toCharArray(), certificateArray);
                if (string2 != null) {
                    boolean bl6 = true;
                    File file = new File(string2);
                    try {
                        bl6 = file.exists();
                        object2 = new FileOutputStream(file);
                        if (bl2) {
                            object = new PrintStream((OutputStream)object2);
                            BASE64Encoder bASE64Encoder = new BASE64Encoder();
                            ((PrintStream)object).println("-----BEGIN CERTIFICATE-----");
                            bASE64Encoder.encodeBuffer(x509CertImpl.getEncoded(), (OutputStream)object);
                            ((PrintStream)object).println("-----END CERTIFICATE-----");
                            ((PrintStream)object).close();
                        } else {
                            ((FileOutputStream)object2).write(x509CertImpl.getEncoded());
                            ((FileOutputStream)object2).close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!bl6 && file.exists()) {
                            file.delete();
                        }
                        bl3 = true;
                    }
                }
                this.addKeyLabelAt(string, 0);
                this.addMyCertLabelAt(string, 0);
            }
            this.keyDbChanged = true;
            this.save();
            if (bl3) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8000, IOException=" + iOException);
            if (bl3) {
                IkeymanLogger.error("KeyStoreManager", "createNewSelfSignedCertificate() Line 2792", "Please check your permissions for the file certFileName=" + string2);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
            }
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8010, NoSuchProviderException=" + noSuchProviderException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8020, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_ALGORITHM"));
        }
        catch (InvalidKeyException invalidKeyException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8030, InvalidKeyException=" + invalidKeyException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (SignatureException signatureException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8040, SignatureException=" + signatureException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8050, CertificateException=" + certificateException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8060, IllegalArgumentException=" + illegalArgumentException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_INVALID_DN_INPUT"));
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 8070, KeyStoreException=" + keyStoreException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        KMUtil.debugMsg("KeyStoreManager::createNewSelfSignedCertificate(10 arg) 9999");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createNewCertRequest(String string, int n, DNItem dNItem, int n2, String string2, boolean bl, Vector vector) throws KeyStoreManagerException {
        String string3;
        if (n != 512 && n != 1024 && n != 2048) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_KEY_SIZE"));
        }
        try {
            if (this.iKeyStore.containsAlias(string)) {
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 1100");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (this.type != 1 && this.reqKeyLabelList != null && this.reqKeyLabelList.size() != 0 && this.reqKeyLabelList.contains(string)) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
        }
        if (this.type == 0) return;
        if (this.type == 2) {
            return;
        }
        switch (n2) {
            case 1: {
                string3 = DigOfMD5_IBMJCEProvider;
                break;
            }
            case 2: {
                string3 = DigOfSHA1_IBMJCEProvider;
                break;
            }
            default: {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_SIGNATURE_ALGORITHM"));
            }
        }
        try {
            block41: {
                Object object;
                Object object2;
                Object object3;
                DerOutputStream derOutputStream;
                SubjectAlternativeNameExtension subjectAlternativeNameExtension;
                GeneralNames generalNames;
                block40: {
                    if (!bl) {
                        this.extractCertificateRequest(string, n2, string2);
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 7000");
                        return;
                    }
                    KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 2100");
                    if (this.type != 4 && this.type != 3) break block40;
                    if (this.cryptokiType == 2) {
                        X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                        CertificationRequest certificationRequest = null;
                        SelfSignedCert selfSignedCert = null;
                        string3 = PKCS11SigAlg_IBMJCEProvider;
                        selfSignedCert = new SelfSignedCert(RSAKEYTYPE, string3, this.iKeyStore);
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 2500");
                        try {
                            selfSignedCert.generate(n, string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 2962", "Illegal argument caught while generating key pair with variables: keySize=" + n + " keyLabel=" + string);
                            throw new KeyStoreManagerException(illegalArgumentException.getMessage());
                        }
                        try {
                            certificationRequest = selfSignedCert.getCertRequest(x500Name, string, this.iKeyStore, this.keyDbPwd.toCharArray());
                        }
                        catch (Exception exception) {
                            IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 2971", "Error while extracting the certificate request from the keypair record with variables: subject=" + x500Name.getCommonName() + " keyLabel=" + string + " keyDbPwd=" + this.keyDbPwd + " iKeyStore=" + this.iKeyStore.toString());
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
                        }
                        if (string2 == null) {
                            IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 3000", "Null certReqFileName");
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
                        }
                        File file = new File(string2);
                        boolean bl2 = file.exists();
                        try {
                            certificationRequest.write(string2, true);
                        }
                        catch (IOException iOException) {
                            if (!bl2 && file.exists()) {
                                file.delete();
                            }
                            IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 2988", "Error while encoding data Base64 encoding rule certReqFileName=" + string2);
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_ENCODING"));
                        }
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 3000");
                        this.addKeyLabelAt(string, 0);
                        this.addReqKeyLabelAt(string, 0);
                    }
                    break block41;
                }
                X500Name x500Name = new X500Name(dNItem.getRFC1779String());
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 4800-254==" + JCEProvider);
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSAKEYTYPE, JCEProvider);
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 4801-254 SecureRandom.signatureAlgorithm" + string3);
                SecureRandom secureRandom = SecureRandom.getInstance("IBMSecureRandom", JCEProvider);
                keyPairGenerator.initialize(n, secureRandom);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                PublicKey publicKey = keyPair.getPublic();
                PrivateKey privateKey = keyPair.getPrivate();
                PKCSAttributes pKCSAttributes = null;
                if (vector != null && vector.size() > 0) {
                    generalNames = this.makeGenNames(vector);
                    subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(generalNames);
                    derOutputStream = new DerOutputStream();
                    subjectAlternativeNameExtension.encode(derOutputStream);
                    object3 = new DerOutputStream();
                    object3.write((byte)48, derOutputStream.toByteArray());
                    object2 = new DerValue(49, ((ByteArrayOutputStream)object3).toByteArray());
                    object = new PKCSAttribute(PKCSOID.EXTENSION_REQUEST_OID, (Object)object2.toByteArray());
                    pKCSAttributes = new PKCSAttributes(new PKCSAttribute[]{object});
                }
                generalNames = new CertificationRequestInfo(x500Name, publicKey, pKCSAttributes);
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5200");
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5300-254:: KeyStoreManager.JCEProvider= " + JCEProvider + "Algorithm " + n2);
                subjectAlternativeNameExtension = n2 == 2 ? new CertificationRequest((CertificationRequestInfo)generalNames, JCEProvider) : new CertificationRequest((CertificationRequestInfo)generalNames);
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5300:: KeyStoreManager.JCEProvider= " + JCEProvider);
                derOutputStream = subjectAlternativeNameExtension.sign(string3, privateKey);
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5400");
                if (string2 != null) {
                    object3 = new File(string2);
                    try {
                        object2 = new FileOutputStream((File)object3);
                        ((FileOutputStream)object2).write(derOutputStream.toString().getBytes());
                        ((FileOutputStream)object2).close();
                        ((File)object3).delete();
                    }
                    catch (Exception exception) {
                        if (((File)object3).exists()) {
                            ((File)object3).delete();
                        }
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5800,Exception=" + exception + "Exception/Msg=" + exception.getMessage());
                        if (exception.toString().startsWith("java.io.IOException")) {
                            KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5825");
                            IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 3225", "Insufficient space for creating the certReqFileName=" + string2 + " certReq=" + derOutputStream.toString());
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INSUFFICIENT_SPACE"));
                        }
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5879");
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DISK_NOT_WRITABLE"));
                    }
                    object2 = new File(string2);
                    boolean bl3 = ((File)object2).exists();
                    KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5900");
                    try {
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5910");
                        derOutputStream.writeBASE64(string2);
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5930");
                    }
                    catch (IOException iOException) {
                        if (!bl3 && ((File)object2).exists()) {
                            ((File)object2).delete();
                        }
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5950");
                        IkeymanLogger.error("KeyStoreManager", "createNewCertRequest() Line 3255", "Error while encoding data Base64 encoding rule certReqFileName=" + string2);
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_ENCODING"));
                    }
                }
                KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5990");
                object3 = new PrivateKeyInfo(privateKey.getEncoded());
                if (this.type == 1) {
                    ((IBMKeyStore)this.iKeyStore).setCertReqEntry(string, (CertificationRequest)derOutputStream, (Key)object3);
                    KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 6000");
                } else {
                    object2 = new EncryptedPrivateKeyInfo(this.keyDbPwd.toCharArray(), (PrivateKeyInfo)object3, DigOfMD5_IBMJCEProvider, "DES");
                    object = new CertReqFile(this.dbDirName, this.dbFileName);
                    ((CertReqFile)object).generatePairFileNames(string);
                    String string4 = ((CertReqFile)object).getTempPKCS10FileName();
                    String string5 = ((CertReqFile)object).getTempPrivateKeyFileName();
                    derOutputStream.writeBASE64(string4);
                    FileOutputStream fileOutputStream = new FileOutputStream(string5);
                    object2.encode((OutputStream)fileOutputStream);
                    fileOutputStream.close();
                    ((CertReqFile)object).addLabel(string);
                }
                this.addKeyLabelAt(string, 0);
                this.addReqKeyLabelAt(string, 0);
            }
            this.keyDbChanged = true;
            this.save();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KeyStoreManagerException(illegalArgumentException.toString());
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 8000, KeyStoreException=" + keyStoreException);
            if (keyStoreException.getMessage() == null) throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            if (!keyStoreException.getMessage().equals(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"))) throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 9000, IOException=" + iOException);
            throw new KeyStoreManagerException(iOException.toString());
        }
        catch (PKCSException pKCSException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_ENGINE"));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PROVIDER_IBMJCE_LIBRARIES_NOTFOUND"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_UNSUPPORTED_ALGORITHM"));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
        catch (SignatureException signatureException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO"));
        }
    }

    private GeneralNames makeGenNames(Vector vector) throws IOException {
        GeneralNames generalNames = new GeneralNames();
        if (vector != null && vector.size() > 0) {
            int n = 0;
            while (n < vector.size()) {
                RFC822Name rFC822Name = null;
                int n2 = ((KMExtensionItem)vector.elementAt(n)).getFieldType();
                String string = (String)((KMExtensionItem)vector.elementAt(n)).getFieldValue();
                if (n2 == 1) {
                    rFC822Name = new RFC822Name(string);
                } else if (n2 == 7) {
                    rFC822Name = new IPAddressName(string);
                } else if (n2 == 2) {
                    rFC822Name = new DNSName(string);
                }
                GeneralName generalName = new GeneralName((GeneralNameInterface)rFC822Name);
                generalNames.addElement(generalName);
                ++n;
            }
        }
        return generalNames;
    }

    public void addCACertificate(String string, String string2, boolean bl) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::addCACertificate 0000");
        if (string2 == null || string == null) {
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-1, keyLabel=null or fullPathFileName=null");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        KMUtil.debugMsg("KeyStoreManager::addCACertificate 0010, keyLabel=" + string + ", fullPathFileName=" + string2 + ", isBase64Armored=" + bl);
        try {
            if (this.iKeyStore.containsAlias(string)) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-2");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
            }
        }
        catch (KeyStoreException keyStoreException) {
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 8000, KeyStoreException=" + keyStoreException);
        }
        try {
            if (this.type == 0) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-3");
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(string2);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", JCEProvider);
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
            fileInputStream.close();
            this.iKeyStore.setCertificateEntry(string, (X509Certificate)collection.toArray()[0]);
            this.addKeyLabel(string);
            this.addCaCertLabelAt(string, 0);
            this.keyDbChanged = true;
            this.save();
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999");
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-4, CertificateException=" + certificateException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-5, IOException=" + iOException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PERMISSION_DENIED"));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_FORMAT_INVALID"));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PROVIDER_IBMJCE_LIBRARIES_NOTFOUND"));
        }
        catch (KeyStoreException keyStoreException) {
            if (keyStoreException.getMessage().endsWith("INVALID_CERT_CHAIN")) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-6, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_STORE"));
            }
            if (keyStoreException.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48")) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-6-1, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD"));
            }
            if (keyStoreException.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY, 47")) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-6-2, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_VALIDATION_KEY_VALIDITY"));
            }
            if (!keyStoreException.getMessage().equals("User canceled")) {
                KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-7, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
            }
            KMUtil.debugMsg("KeyStoreManager::addCACertificate 9999-8, KeyStoreException=" + keyStoreException);
        }
    }

    public void addSiteCertificate(String string, String string2, boolean bl) {
    }

    public void exportKeyToKeyStore(KeyStoreManager keyStoreManager, String[] stringArray, String string) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 0000");
        int n = 0;
        while (n < stringArray.length) {
            block19: {
                try {
                    if (!this.iKeyStore.isKeyEntry(stringArray[n])) {
                        IkeymanLogger.error("KeyStoreManager", "exportKeyToKeyStore() Line 3565", "No matching key entry found for keyLabel=" + stringArray[n] + " in iKeyStore=" + this.iKeyStore.toString());
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    IkeymanLogger.error("KeyStoreManager", "exportKeyToKeyStore() Line 3573", "Error occurred looking for keyLabel=" + stringArray[n] + " in iKeyStore=" + this.iKeyStore.toString());
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
                }
                try {
                    Object object;
                    Object object2;
                    Certificate[] certificateArray = this.iKeyStore.getCertificateChain(stringArray[n]);
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 1000");
                    try {
                        if (certificateArray.length > 1) {
                            KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 1200");
                            object2 = null;
                            int n2 = 1;
                            while (n2 < certificateArray.length) {
                                KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 1400, for-loop");
                                object = object2 = this.iKeyStore.getCertificateAlias(certificateArray[n2]);
                                if (this.type == 2 && ((String)object).indexOf("##") != -1) {
                                    object = ((String)object).substring(0, ((String)object).indexOf("##"));
                                }
                                KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 2000");
                                keyStoreManager.getKeyStoreInstance().setCertificateEntry((String)object, certificateArray[n2]);
                                ++n2;
                            }
                        }
                    }
                    catch (Exception exception) {
                        IkeymanLogger.error("KeyStoreManager", "exportKeyToKeyStore() Line 3610", "Error while storing certificates.  certificate chain=" + certificateArray.toString());
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_STORE"));
                    }
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 2200");
                    object2 = new Certificate[]{certificateArray[0]};
                    Key key = this.iKeyStore.getKey(stringArray[n], this.keyDbPwd.toCharArray());
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 2300");
                    if (null == key) {
                        KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 3000");
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_PRIVATEKEY_CANNOT_BE_EXPORTED"));
                    }
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 3100");
                    object = string == null ? stringArray[n] : string;
                    if (this.type == 2 && ((String)object).indexOf("##") != -1) {
                        object = ((String)object).substring(0, ((String)object).indexOf("##"));
                    }
                    KMUtil.debugMsg("Key to setKeyEntry" + (String)object);
                    keyStoreManager.getKeyStoreInstance().setKeyEntry((String)object, key, keyStoreManager.getKeyDbPwd().toCharArray(), (Certificate[])object2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 4000, NoSuchAlgorithmException=" + noSuchAlgorithmException);
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 5000, UnrecoverableKeyException=" + unrecoverableKeyException);
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
                }
                catch (KeyStoreException keyStoreException) {
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 7000, KeyStoreException=" + keyStoreException);
                    if (keyStoreException.getMessage().equals("INVALID_CERT_CHAIN")) {
                        KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 7000-1, Msg=" + keyStoreException.getMessage());
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_STORE"));
                    }
                    if (keyStoreException.getMessage().endsWith("24")) {
                        KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey 7000-3");
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
                    }
                    if (keyStoreException.getMessage().equals("User canceled")) break block19;
                    KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 7000-5, Msg=" + keyStoreException.getMessage());
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                }
            }
            ++n;
        }
        try {
            keyStoreManager.keyDbChanged = true;
            keyStoreManager.close();
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 8000, KeyStoreManagerException=" + keyStoreManagerException);
            throw new KeyStoreManagerException(keyStoreManagerException.getMessage());
        }
        KMUtil.debugMsg("KeyStoreManager::exportKeyToKeyStoreKey, 9999");
    }

    public void importKeyFromKeyStore(KeyStoreManager keyStoreManager, String[] stringArray, String[] stringArray2) throws KeyStoreManagerException {
        this.importKeyFromKeyStore(keyStoreManager, stringArray, stringArray2, null);
    }

    /*
     * Unable to fully structure code
     */
    public void importKeyFromKeyStore(KeyStoreManager var1_1, String[] var2_2, String[] var3_3, KMFrame var4_4) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 0000, keyLabelList=<" + KMUtil.toStringObjectArray(var2_2) + ">, renameList=<" + KMUtil.toStringObjectArray(var3_3) + ">");
        if (var2_2 == null) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-1");
            return;
        }
        if (var1_1 == null) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-2");
            IkeymanLogger.error("KeyStoreManager", "importKeyFromKeyStore() Line 3754", "SourceKeyDb was null.");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        var5_5 = var1_1.getKeyStoreInstance();
        var8_6 = this.getCaCertLabelList();
        this.isCAAddedUnderCMS = false;
        try {
            var9_7 = new Vector<String>();
            var10_9 = new Vector<String>();
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 0200");
            var11_11 = 0;
            while (var11_11 < var2_2.length) {
                var6_13 = var2_2[var11_11];
                var7_14 = var3_3[var11_11];
                if (var5_5.isKeyEntry(var2_2[var11_11])) ** GOTO lbl66
                if (var5_5.isCertificateEntry(var2_2[var11_11])) {
                    var12_15 = (X509Certificate)var5_5.getCertificate(var6_13);
                    var13_17 = var12_15.getPublicKey();
                    var14_18 = false;
                    if (var8_6 != null) {
                        var15_20 = 0;
                        while (var15_20 < var8_6.size()) {
                            var16_23 = (String)var8_6.get(var15_20);
                            var17_25 = (X509Certificate)this.iKeyStore.getCertificate(var16_23);
                            var18_26 = var17_25.getPublicKey();
                            if (var16_23.equalsIgnoreCase(var7_14) && var18_26.equals(var13_17)) {
                                var14_18 = true;
                            } else {
                                if (var18_26.equals(var13_17)) {
                                    if (var4_4 == null) {
                                        throw new KeyStoreException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY") + ", 24");
                                    }
                                    KMFrame.errorHandler(KMFrame.mFrame, KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
                                    return;
                                }
                                if (var16_23.equalsIgnoreCase(var7_14)) {
                                    if (var4_4 == null) {
                                        throw new KeyStoreException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                                    }
                                    var7_14 = var4_4.accessResolveLabelConflictsWithGUI(var7_14);
                                    if (var8_6.contains(var7_14)) {
                                        KMFrame.errorHandler(KMFrame.mFrame, KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"), var7_14);
                                        return;
                                    }
                                }
                            }
                            ++var15_20;
                        }
                    }
                    if (!var14_18) {
                        try {
                            this.iKeyStore.setCertificateEntry(var7_14, var5_5.getCertificate(var2_2[var11_11]));
                            this.keyDbChanged = true;
                            this.addCaCertLabelAt(var7_14, 0);
                            if (this.type != 1) ** GOTO lbl68
                            this.isCAAddedUnderCMS = true;
                        }
                        catch (KeyStoreException var15_21) {
                            if (var15_21.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48") || var15_21.getMessage().endsWith("INVALID_CERT_CHAIN")) {
                                if (var4_4 != null) {
                                    var4_4.reportInvalidCertificateLabel(var7_14);
                                }
                                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_BAD_IMPORT") + var7_14);
                            }
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                        }
                    }
                } else {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-3, KeyLabel=" + var2_2[var11_11]);
                    throw new KeyStoreManagerException(var2_2[var11_11] + " " + KMSystem.getNLSErrString("GSKKM_ERR_KEY_GET_BY_LABEL"));
lbl66:
                    // 1 sources

                    var9_7.addElement(var6_13);
                    var10_9.addElement(var3_3[var11_11]);
                }
lbl68:
                // 5 sources

                ++var11_11;
            }
            var12_15 = null;
            var13_17 = null;
            var14_19 = null;
            var15_22 = null;
            var12_15 = new Certificate[1];
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 0500");
            var16_24 = 0;
            while (var16_24 < var9_7.size()) {
                var13_17 = (String)var9_7.get(var16_24);
                var14_19 = (String)var10_9.get(var16_24);
                var15_22 = var5_5.getKey((String)var13_17, var1_1.keyDbPwd.toCharArray());
                var17_25 = new PrivateKeyInfo(var15_22.getEncoded());
                var12_15[0] = var5_5.getCertificate((String)var13_17);
                if (!var13_17.equalsIgnoreCase(var14_19)) {
                    var13_17 = var14_19;
                }
                KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 0640");
                if (this.cryptokiType == 2) {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 1200");
                    this.iKeyStore.setKeyEntry((String)var13_17, (PrivateKey)var15_22, this.keyDbPwd.toCharArray(), var5_5.getCertificateChain((String)var9_7.get(var16_24)));
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 1300, myCertAlias=" + (String)var13_17);
                    this.addKeyLabelAt((String)var13_17, 0);
                    this.addMyCertLabel((String)var13_17);
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 1400");
                    this.buildPKCS11KeyStoreLabelList();
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 1500");
                } else {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 2600");
                    this.iKeyStore.setKeyEntry((String)var13_17, (Key)var17_25, this.keyDbPwd.toCharArray(), (Certificate[])var12_15);
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 2630");
                    this.addMyCertLabel((String)var13_17);
                }
                KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 2800");
                ++var16_24;
            }
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 3000");
            this.keyDbChanged = true;
            this.save();
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 4000");
        }
        catch (NoSuchAlgorithmException var9_8) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-4, NoSuchAlgorithmException=" + var9_8);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (UnrecoverableKeyException var10_10) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-5, UnrecoverableKeyException=" + var10_10);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (KeyStoreException var11_12) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 8000, KeyStoreException=" + var11_12);
            if (!var11_12.getMessage().equals("User canceled")) {
                if (var11_12.getMessage().equals("INVALID_CERT_CHAIN")) {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-6");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_IMPORT"));
                }
                if (var11_12.getMessage().endsWith("24")) {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-6-5");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
                }
                if (var11_12.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48")) {
                    KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-6-6");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD"));
                }
                KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-7");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
        }
        catch (IOException var12_16) {
            KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999-8, IOException=" + var12_16);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_IO"));
        }
        KMUtil.debugMsg("KeyStoreManager::importKeyFromKeyStore 9999");
    }

    public boolean isKeyConflict(KeyStoreManager keyStoreManager, String string) {
        KeyStore keyStore = keyStoreManager.getKeyStoreInstance();
        try {
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, keyStoreManager.getKeyDbPwd().toCharArray());
            PrivateKey privateKey2 = (PrivateKey)this.iKeyStore.getKey(string, this.keyDbPwd.toCharArray());
            return privateKey.equals(privateKey2);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void extractCertificate(String string, String string2, boolean bl) throws KeyStoreManagerException {
        block19: {
            if (string == null || string2 == null) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
            }
            if (this.type == 0) {
                return;
            }
            try {
                Object object;
                if (this.type == 4) {
                    this.cmsCryptoki.extractCertificate(string, string2, bl);
                    break block19;
                }
                X509Certificate x509Certificate = (X509Certificate)this.iKeyStore.getCertificate(string);
                if (x509Certificate == null) {
                    IkeymanLogger.error("KeyStoreManager", "extractCertificate(String,String,boolean) Line 4004", "X509 certificate was null because keyLabel=" + string + " couldn't be retrieved.");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_KEYREC_CERTIFICATE_NULL"));
                }
                byte[] byArray = x509Certificate.getEncoded();
                File file = new File(string2);
                try {
                    object = new FileOutputStream(file);
                    ((FileOutputStream)object).write(x509Certificate.toString().getBytes());
                    ((FileOutputStream)object).close();
                    file.delete();
                }
                catch (Exception exception) {
                    if (file.exists()) {
                        file.delete();
                    }
                    KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5800,Exception=" + exception + "Exception/Msg=" + exception.getMessage());
                    if (exception.toString().startsWith("java.io.IOException")) {
                        IkeymanLogger.error("KeyStoreManager", "extractCertificate(String,String,boolean) Line 4029", "Insufficient space to write a certificate: outputCertFileName=" + string2 + " cert.toString()=" + x509Certificate.toString());
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INSUFFICIENT_SPACE"));
                    }
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DISK_NOT_WRITABLE"));
                }
                object = new File(string2);
                boolean bl2 = ((File)object).exists();
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    if (bl) {
                        PrintStream printStream = new PrintStream(fileOutputStream);
                        BASE64Encoder bASE64Encoder = new BASE64Encoder();
                        printStream.println("-----BEGIN CERTIFICATE-----");
                        try {
                            bASE64Encoder.encodeBuffer(byArray, (OutputStream)printStream);
                        }
                        catch (IOException iOException) {
                            if (!bl2 && ((File)object).exists()) {
                                ((File)object).delete();
                            }
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_ENCODING"));
                        }
                        printStream.println("-----END CERTIFICATE-----");
                        printStream.close();
                        break block19;
                    }
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    if (!bl2 && ((File)object).exists()) {
                        ((File)object).delete();
                    }
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_FILE_WRITE"));
                }
            }
            catch (KeyStoreException keyStoreException) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (CertificateException certificateException) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (KMException kMException) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
        }
    }

    private X509Certificate[] readX509Certificates(String string) throws FileNotFoundException, IOException, CertificateException, NoSuchProviderException {
        X509Certificate[] x509CertificateArray;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509", JCEProvider);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        dataInputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<X509Certificate[]> vector = new Vector<X509Certificate[]>();
        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1300");
        while (byteArrayInputStream.available() > 0) {
            try {
                x509CertificateArray = certificateFactory.generateCertificate(byteArrayInputStream);
                vector.add(x509CertificateArray);
                byteArrayInputStream.mark(0);
            }
            catch (CertificateException certificateException) {
                byteArrayInputStream.reset();
                byteArrayInputStream.skip(1L);
                byteArrayInputStream.mark(0);
            }
        }
        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1310");
        x509CertificateArray = new X509Certificate[vector.size()];
        Iterator iterator = ((AbstractList)vector).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            x509CertificateArray[n] = (X509Certificate)iterator.next();
            ++n;
        }
        return x509CertificateArray;
    }

    /*
     * Unable to fully structure code
     */
    public void receiveCertificate(String var1_1, boolean var2_2, boolean var3_3) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0000, inputCertFileName=<" + var1_1 + ", isBase64Armored=<" + var2_2 + ", setAsDefault=<" + var3_3 + ">");
        if (var1_1 == null) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-1");
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_NULL_PARAMETER"));
        }
        if (this.type == 0 || this.type == 2) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-2");
            return;
        }
        try {
            var4_4 = this.readX509Certificates(var1_1);
            if (this.type != 1) ** GOTO lbl95
            if (var4_4[0] != null) {
                this.reorderCertChain((X509Certificate[])var4_4);
                var5_6 = "";
                var8_9 = new X509Certificate[1];
                var9_12 = false;
                var10_15 = null;
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate bbbbb  " + var4_4.length);
                var11_18 = 0;
                while (var11_18 < var4_4.length) {
                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate bbbbb  " + var11_18);
                    var10_15 = var4_4[var11_18].getPublicKey();
                    if (this.reqKeyLabelList != null) {
                        var12_26 = 0;
                        while (var12_26 < this.reqKeyLabelList.size()) {
                            var5_6 = (String)this.reqKeyLabelList.get(var12_26);
                            var6_20 = ((IBMKeyStore)this.iKeyStore).getCertReqEntry(var5_6);
                            var7_23 = var6_20.getCertRequestInfo();
                            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0200, pubKey=" + var10_15 + ", reqInfo.getSubjectPublicKeyInfo()" + var7_23.getSubjectPublicKeyInfo());
                            if (var10_15.equals(var7_23.getSubjectPublicKeyInfo())) {
                                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0210");
                                var9_12 = true;
                                var13_28 = this.iKeyStore.getKey(var5_6, this.keyDbPwd.toCharArray());
                                var14_30 = new PrivateKeyInfo(var13_28.getEncoded());
                                this.iKeyStore.deleteEntry(var5_6);
                                try {
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0250, alias=" + var5_6);
                                    this.iKeyStore.setKeyEntry(var5_6, (Key)var14_30, this.keyDbPwd.toCharArray(), var4_4);
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0260");
                                }
                                catch (KeyStoreException var15_32) {
                                    if (var15_32.getMessage().endsWith("INVALID_CERT_CHAIN")) {
                                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-2a, KeyStoreException=" + var15_32);
                                        ((IBMKeyStore)this.iKeyStore).setCertReqEntry(var5_6, var6_20, var13_28);
                                        IkeymanLogger.error("KeyStoreManager", "receiveCertificate() Line 4218", "Error while setting the key entry: alias=" + var5_6 + " Could be the keystore wasn't initialised." + this.iKeyStore.toString());
                                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_RECEIVE"));
                                    }
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-2b, KeyStoreException=" + var15_32);
                                    ((IBMKeyStore)this.iKeyStore).setCertReqEntry(var5_6, var6_20, var13_28);
                                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                                }
                                catch (Exception var16_36) {
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-3, Exception=" + var16_36);
                                    ((IBMKeyStore)this.iKeyStore).setCertReqEntry(var5_6, var6_20, var13_28);
                                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                                }
                                if (!var3_3) break;
                                ((IBMKeyStore)this.iKeyStore).setDefaultKeyEntry(var5_6);
                                break;
                            }
                            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0400, found=" + var9_12);
                            ++var12_26;
                        }
                    }
                    ++var11_18;
                }
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0410, found=" + var9_12);
                if (!(this.reqKeyLabelList != null && var9_12 || this.myCertLabelList == null)) {
                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0420, myCertLabelList.size=" + this.myCertLabelList.size());
                    var12_26 = 0;
                    while (var12_26 < this.myCertLabelList.size()) {
                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0430, i=" + var12_26);
                        var5_6 = (String)this.myCertLabelList.get(var12_26);
                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 0440, alias=" + var5_6);
                        var8_9[0] = (X509Certificate)this.iKeyStore.getCertificate(var5_6);
                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1000, pubKey=" + var10_15 + ", selfCert[0].getPublicKey()" + var8_9[0].getPublicKey());
                        if (var10_15.equals(var8_9[0].getPublicKey())) {
                            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1010");
                            var9_12 = true;
                            var13_28 = this.iKeyStore.getKey(var5_6, this.keyDbPwd.toCharArray());
                            var14_30 = new PrivateKeyInfo(var13_28.getEncoded());
                            this.iKeyStore.deleteEntry(var5_6);
                            try {
                                this.iKeyStore.setKeyEntry(var5_6, (Key)var14_30, this.keyDbPwd.toCharArray(), var4_4);
                            }
                            catch (Exception var15_33) {
                                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-4, Exception=" + var15_33);
                                this.iKeyStore.setKeyEntry(var5_6, (Key)var14_30, this.keyDbPwd.toCharArray(), var8_9);
                                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                            }
                            if (!var3_3) break;
                            ((IBMKeyStore)this.iKeyStore).setDefaultKeyEntry(var5_6);
                            break;
                        }
                        ++var12_26;
                    }
                }
                if (!var9_12) {
                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-5");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_REQRECORD_NULL"));
                }
            } else {
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-6");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
lbl95:
                // 1 sources

                var6_21 = 0;
                if (var4_4[0] != null) {
                    this.reorderCertChain((X509Certificate[])var4_4);
                    var5_7 = new CertReqFile(this.dbDirName, this.dbFileName);
                    var10_16 = "";
                    var11_19 = new X509Certificate[1];
                    var12_27 = false;
                    var13_29 = null;
                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate aaaaa  " + var4_4.length);
                    var14_31 = 0;
                    while (var14_31 < var4_4.length) {
                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate aaaaa  " + var14_31);
                        var13_29 = var4_4[var14_31].getPublicKey();
                        if (this.reqKeyLabelList != null) {
                            var15_34 = var5_7.getTempPKCS10FileNames();
                            var16_37 = var5_7.getTempPrivateKeyFileNames();
                            var17_38 = var5_7.getReqKeyLabels();
                            if (var15_34 == null) {
                                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-7");
                                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_REQRECORD_NULL"));
                            }
                            var6_21 = 0;
                            while (var6_21 < var15_34.length) {
                                var8_10 = new CertificationRequest(var15_34[var6_21], true);
                                var9_13 = var8_10.getCertRequestInfo();
                                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1500, pubKey=" + var13_29 + ", reqInfo.getSubjectPublicKeyInfo()" + var9_13.getSubjectPublicKeyInfo());
                                if (var9_13.getSubjectPublicKeyInfo() == null) {
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1505, reqInfo.getSubjectPublicKeyInfo()=null");
                                }
                                if (var13_29.equals(var9_13.getSubjectPublicKeyInfo())) {
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 1510");
                                    var12_27 = true;
                                    var18_39 = new EncryptedPrivateKeyInfo((String)var16_37[var6_21], false);
                                    var7_24 = var18_39.decrypt(this.keyDbPwd.toCharArray());
                                    var19_41 = new PrivateKeyInfo(var7_24);
                                    this.iKeyStore.setKeyEntry((String)var17_38[var6_21], (Key)var19_41, this.keyDbPwd.toCharArray(), var4_4);
                                    break;
                                }
                                ++var6_21;
                            }
                        }
                        ++var14_31;
                    }
                    if (this.reqKeyLabelList == null || !var12_27) {
                        var15_35 = 0;
                        while (var15_35 < this.myCertLabelList.size()) {
                            var10_16 = (String)this.myCertLabelList.get(var15_35);
                            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 2000, alias=" + var10_16);
                            var11_19[0] = (X509Certificate)this.iKeyStore.getCertificate(var10_16);
                            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 2010, selfCert[0].getPublicKey()" + var11_19[0].getPublicKey());
                            if (var13_29.equals(var11_19[0].getPublicKey())) {
                                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 2020");
                                var12_27 = true;
                                var16_37 = this.iKeyStore.getKey(var10_16, this.keyDbPwd.toCharArray());
                                var17_38 = new PrivateKeyInfo(var16_37.getEncoded());
                                this.iKeyStore.deleteEntry(var10_16);
                                try {
                                    this.iKeyStore.setKeyEntry(var10_16, (Key)var17_38, this.keyDbPwd.toCharArray(), var4_4);
                                    break;
                                }
                                catch (Exception var18_40) {
                                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-8, Exception=" + var18_40);
                                    this.iKeyStore.setKeyEntry(var10_16, (Key)var17_38, this.keyDbPwd.toCharArray(), var11_19);
                                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
                                }
                            }
                            ++var15_35;
                        }
                    }
                    if (!var12_27) {
                        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-9");
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEY_FOR_CERT_NULL"));
                    }
                } else {
                    KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-10");
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
                }
                var5_7.removeLabelAt(var6_21);
            }
            this.keyDbChanged = true;
            this.save();
            this.buildKeyStoreLabelList();
        }
        catch (IOException var4_5) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-11, IOException=" + var4_5);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_PERMISSION_DENIED"));
        }
        catch (KeyStoreException var5_8) {
            if (var5_8.getMessage().equals("INVALID_CERT_CHAIN")) {
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-12a");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_ADD_ROOTCA_FIRST_RECEIVE"));
            }
            if (!var5_8.getMessage().equals("User canceled")) {
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-12b, KeyStoreException=" + var5_8);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
            }
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-12c, KeyStoreException=" + var5_8);
        }
        catch (CertificateException var6_22) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-13, CertificateException=" + var6_22);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (PKCSException var7_25) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-14, PKCSException=" + (Object)var7_25);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CRYPTO_ENGINE"));
        }
        catch (InvalidKeyException var8_11) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-15, InvalidKeyException=" + var8_11);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (KeyStoreManagerException var9_14) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-16,\nKeyStoreManagerException =" + var9_14 + "\nKeyStoreManagerException/Message =" + var9_14.getNLSErrString());
            throw new KeyStoreManagerException(var9_14.getNLSErrString());
        }
        catch (Exception var10_17) {
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999-17, Exception=" + var10_17);
            if (var10_17.toString().startsWith("java.lang.NullPointerException")) {
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_REQRECORD_NULL"));
            }
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_CERT_RECV"));
        }
        KMUtil.debugMsg("KeyStoreManager::receiveCertificate 9999");
    }

    public void extractCertificateRequest(String string, int n, String string2) throws KeyStoreManagerException {
        block29: {
            KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 0000");
            if (this.type == 0 || this.type == 2) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-1, type unknown or is a MSDB");
                return;
            }
            if (string2 == null) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 0010, keyLabel=" + string + ", signatureAlg=" + n + ", certReqFileName=null");
            } else {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 0020, keyLabel=" + string + ", signatureAlg=" + n + ", certReqFileName=" + string2);
            }
            try {
                Object object;
                Object object2;
                String string3;
                switch (n) {
                    case 1: {
                        string3 = DigOfMD5_IBMJCEProvider;
                        break;
                    }
                    case 2: {
                        string3 = DigOfSHA1_IBMJCEProvider;
                        break;
                    }
                    default: {
                        string3 = DigOfMD5_IBMJCEProvider;
                    }
                }
                CertificationRequest certificationRequest = null;
                if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
                    if (this.type == 1) {
                        certificationRequest = ((IBMKeyStore)this.iKeyStore).getCertReqEntry(string);
                    } else {
                        object2 = new CertReqFile(this.dbDirName, this.dbFileName);
                        ((CertReqFile)object2).getTempPKCS10FileName(string);
                        object = ((CertReqFile)object2).getTempPKCS10FileName(string);
                        certificationRequest = new CertificationRequest((String)object, true);
                    }
                } else {
                    object2 = this.iKeyStore.getCertificate(string);
                    object = new X509CertImpl(((Certificate)object2).getEncoded());
                    X500Name x500Name = (X500Name)object.getSubjectDN();
                    PublicKey publicKey = object.getPublicKey();
                    PrivateKey privateKey = (PrivateKey)this.iKeyStore.getKey(string, this.keyDbPwd.toCharArray());
                    CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, publicKey, null);
                    CertificationRequest certificationRequest2 = new CertificationRequest(certificationRequestInfo);
                    if (this.cryptokiType == 2) {
                        string3 = PKCS11SigAlg_IBMJCEProvider;
                    }
                    certificationRequest = certificationRequest2.sign(string3, privateKey);
                }
                if (string2 != null) {
                    object2 = new File(string2);
                    try {
                        object = new FileOutputStream((File)object2);
                        ((FileOutputStream)object).write(certificationRequest.toString().getBytes());
                        ((FileOutputStream)object).close();
                        ((File)object2).delete();
                    }
                    catch (Exception exception) {
                        if (((File)object2).exists()) {
                            ((File)object2).delete();
                        }
                        KMUtil.debugMsg("KeyStoreManager::createNewCertRequest 5800,Exception=" + exception + "Exception/Msg=" + exception.getMessage());
                        if (exception.toString().startsWith("java.io.IOException")) {
                            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_INSUFFICIENT_SPACE"));
                        }
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_CREATE") + "\n" + KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DISK_NOT_WRITABLE"));
                    }
                    object = new File(string2);
                    boolean bl = ((File)object).exists();
                    try {
                        certificationRequest.writeBASE64(string2);
                        break block29;
                    }
                    catch (IOException iOException) {
                        if (!bl && ((File)object).exists()) {
                            ((File)object).delete();
                        }
                        throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_BASE64_ENCODING"));
                    }
                }
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_FILENAME_NULL"));
            }
            catch (KeyStoreException keyStoreException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-2, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (IOException iOException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-3, IOException=" + iOException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (CertificateEncodingException certificateEncodingException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-4, CertificateEncodingException=" + certificateEncodingException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (CertificateException certificateException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-5, CertificateException=" + certificateException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-6, NoSuchAlgorithmException=" + noSuchAlgorithmException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (PKCSException pKCSException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-7, PKCSException=" + (Object)((Object)pKCSException));
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-8, UnrecoverableKeyException=" + unrecoverableKeyException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
            catch (SignatureException signatureException) {
                KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999-9, SignatureException=" + signatureException);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_RECREATE_CERTREQ"));
            }
        }
        KMUtil.debugMsg("KMFrame::extractCertificateRequest(3 args) 9999");
    }

    public KeyItem getDefaultKeyItem() throws KMException {
        String string = null;
        try {
            string = ((IBMKeyStore)this.iKeyStore).getDefaultKeyEntry();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        if (string == null) {
            return null;
        }
        return this.getKeyItemByLabel(string);
    }

    public KeyItem getKeyItemByLabel(String string) throws KMException {
        block35: {
            KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0000, keyLabel=" + string);
            if (this.type == 4 || this.type == 3) {
                if (this.cryptokiType == 1) {
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-1");
                    return this.cmsCryptoki.getKeyItemByLabel(string);
                }
                if (this.cryptokiType == 2) {
                    Certificate certificate = null;
                    try {
                        certificate = this.iKeyStore.getCertificate(string);
                    }
                    catch (KeyStoreException keyStoreException) {
                        IkeymanLogger.error("KeyStoreManager", "getKeyItemByLabel() Line 4868", "The keystore hasn't been initialised: " + this.iKeyStore.toString() + " while trying to get a certificate associated with keyLabel=" + string + " crypto type JSSE");
                        throw new KeyStoreManagerException(keyStoreException.getMessage());
                    }
                    try {
                        if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
                            certificate = this.iKeyStore.getCertificate(string);
                            X509CertImpl x509CertImpl = new X509CertImpl(certificate.getEncoded());
                            X500Name x500Name = (X500Name)x509CertImpl.getSubjectDN();
                            PublicKey publicKey = x509CertImpl.getPublicKey();
                            PrivateKey privateKey = (PrivateKey)this.iKeyStore.getKey(string, this.keyDbPwd.toCharArray());
                            CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(x500Name, publicKey, null);
                            CertificationRequest certificationRequest = new CertificationRequest(certificationRequestInfo);
                            CertificationRequest certificationRequest2 = certificationRequest.sign(PKCS11SigAlg_IBMJCEProvider, privateKey);
                            KeyItem keyItem = KeyStoreManager.getKeyItemFromCertificationRequest(string, certificationRequest2, this.keyDbPwd, privateKey);
                            return keyItem;
                        }
                        KeyItem keyItem = new KeyItem();
                        keyItem.setKeyLabel(string);
                        if (this.iKeyStore.isKeyEntry(string)) {
                            keyItem.setHasPrivateKey(true);
                            Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string);
                            if (certificateArray == null) {
                                certificateArray = new Certificate[]{certificate};
                            }
                            PublicKey publicKey = certificateArray[0].getPublicKey();
                            int n = 0;
                            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
                            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
                            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
                            if (n % 2 != 0) {
                                ++n;
                            }
                            keyItem.setKeySize((short)n);
                            int n2 = 0;
                            while (n2 < certificateArray.length) {
                                CertificateItem certificateItem = this.parseCertificate(certificateArray[n2]);
                                keyItem.addCertificate(certificateItem);
                                ++n2;
                            }
                            keyItem.setTrusted(true);
                            return keyItem;
                        }
                        if (certificate != null) {
                            short s = 0;
                            CertificateItem certificateItem = this.parseCertificate((X509Certificate)certificate);
                            s = certificateItem.getKeySize();
                            keyItem.setKeySize(s);
                            keyItem.addCertificate(certificateItem);
                            keyItem.setTrusted(true);
                            return keyItem;
                        }
                        break block35;
                    }
                    catch (Exception exception) {
                        IkeymanLogger.error("KeyStoreManager", "getKeyItemByLabel() Line 4949", "There was a problem getting the key item by label using keyLabel=" + string + " " + exception.getMessage());
                        throw new KeyStoreManagerException(exception.getMessage());
                    }
                }
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-2");
                return null;
            }
            try {
                if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
                    Object object;
                    Object object2;
                    Object object3;
                    CertificationRequest certificationRequest = null;
                    Object var3_10 = null;
                    if (this.type == 1) {
                        certificationRequest = ((IBMKeyStore)this.iKeyStore).getCertReqEntry(string);
                    } else {
                        object3 = new CertReqFile(this.dbDirName, this.dbFileName);
                        ((CertReqFile)object3).getTempPKCS10FileName(string);
                        object2 = ((CertReqFile)object3).getTempPKCS10FileName(string);
                        certificationRequest = new CertificationRequest((String)object2, true);
                    }
                    object3 = certificationRequest.encode();
                    object2 = new DNItem(certificationRequest.getCertRequestInfo().getSubjectName().getCommonName(), certificationRequest.getCertRequestInfo().getSubjectName().getOrganizationalUnit(), certificationRequest.getCertRequestInfo().getSubjectName().getOrganization(), certificationRequest.getCertRequestInfo().getSubjectName().getLocality(), certificationRequest.getCertRequestInfo().getSubjectName().getState(), certificationRequest.getCertRequestInfo().getSubjectName().getPostalCode(), certificationRequest.getCertRequestInfo().getSubjectName().getCountry(), certificationRequest.getCertRequestInfo().getSubjectName().getEmail());
                    PublicKey publicKey = certificationRequest.getCertRequestInfo().getSubjectPublicKeyInfo();
                    int n = 0;
                    X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
                    PublicKey publicKey3 = keyFactory.generatePublic(x509EncodedKeySpec);
                    n = publicKey3 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey3).getModulus().bitLength() : ((DSAPublicKey)publicKey3).getY().bitLength();
                    if (n % 2 != 0) {
                        ++n;
                    }
                    BERObject bERObject = new BERObject(publicKey.getEncoded());
                    PKCSAttributes pKCSAttributes = certificationRequest.getCertRequestInfo().getAttributes();
                    BERObject bERObject2 = new BERObject(pKCSAttributes.generateDerEncoding());
                    byte[] byArray = certificationRequest.getSignature();
                    AlgorithmId algorithmId = certificationRequest.getSignatureAlgorithm();
                    BERObject bERObject3 = new BERObject(algorithmId.encode());
                    byte[] byArray2 = certificationRequest.getCertRequestInfo().encode();
                    CertificateRequestItem certificateRequestItem = new CertificateRequestItem((short)n, (DNItem)object2, bERObject, bERObject2, byArray, bERObject3, algorithmId.getOID().toString(), algorithmId.getName(), (byte[])object3, byArray2);
                    EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem = null;
                    if (var3_10 != null) {
                        object = var3_10.getEncryptedData();
                        encryptedPrivateKeyInfoItem = new EncryptedPrivateKeyInfoItem((byte[])object);
                    }
                    object = new KeyItem(string, 0, certificateRequestItem.getKeySize(), null, certificateRequestItem, null);
                    ((KeyItem)object).setHasPrivateKey(true);
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-3");
                    return object;
                }
                String string2 = null;
                if (this.type == 1) {
                    string2 = ((IBMKeyStore)this.iKeyStore).getDefaultKeyEntry();
                }
                KeyItem keyItem = new KeyItem();
                keyItem.setKeyLabel(string);
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0790");
                X509Certificate x509Certificate = (X509Certificate)this.iKeyStore.getCertificate(string);
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0800");
                if (this.iKeyStore.isKeyEntry(string)) {
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0810");
                    keyItem.setHasPrivateKey(true);
                    if (x509Certificate == null) {
                        KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-4");
                        return null;
                    }
                    Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string);
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0820");
                    if (certificateArray == null) {
                        KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0830");
                        certificateArray = new Certificate[]{this.iKeyStore.getCertificate(string)};
                    }
                    PublicKey publicKey = certificateArray[0].getPublicKey();
                    int n = 0;
                    X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0900");
                    PublicKey publicKey4 = keyFactory.generatePublic(x509EncodedKeySpec);
                    n = publicKey4 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey4).getModulus().bitLength() : ((DSAPublicKey)publicKey4).getY().bitLength();
                    if (n % 2 != 0) {
                        ++n;
                    }
                    keyItem.setKeySize((short)n);
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 0890, manyCerts.length=" + certificateArray.length);
                    int n3 = 0;
                    while (n3 < certificateArray.length) {
                        KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 1000");
                        CertificateItem certificateItem = this.parseCertificate(certificateArray[n3]);
                        KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 1010");
                        keyItem.addCertificate(certificateItem);
                        ++n3;
                    }
                    keyItem.setTrusted(true);
                    if (string2 != null && string.equals(string2)) {
                        keyItem.setDefault(true);
                    }
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999a");
                    return keyItem;
                }
                if (x509Certificate != null) {
                    short s = 0;
                    CertificateItem certificateItem = this.parseCertificate(x509Certificate);
                    s = certificateItem.getKeySize();
                    keyItem.setKeySize(s);
                    keyItem.addCertificate(certificateItem);
                    if (this.type == 1) {
                        keyItem.setTrusted(((IBMKeyStore)this.iKeyStore).isTrusted(string));
                    } else {
                        keyItem.setTrusted(true);
                    }
                    KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999b");
                    return keyItem;
                }
            }
            catch (InvalidKeyException invalidKeyException) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-7, InvalidKeyException=" + invalidKeyException);
                throw new KeyStoreManagerException(invalidKeyException.getMessage());
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-8, InvalidKeySpecException=" + invalidKeySpecException);
                throw new KeyStoreManagerException(invalidKeySpecException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-9, KeyStoreException=" + keyStoreException);
                throw new KeyStoreManagerException(keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-10, NoSuchAlgorithmException=" + noSuchAlgorithmException);
                throw new KeyStoreManagerException(noSuchAlgorithmException.getMessage());
            }
            catch (IOException iOException) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-11, IOException=" + iOException);
                throw new KeyStoreManagerException(iOException.getMessage());
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 8000, Exception=" + exception);
            }
        }
        KMUtil.debugMsg("KeyStoreManager::getKeyItemByLabel() 9999-13");
        return null;
    }

    public KeyItem[] getKeyItemListByLabel(String string) throws KeyStoreManagerException {
        return null;
    }

    public CertificateItem parseCertificate(Certificate certificate) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0000");
        try {
            if (certificate == null) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-1");
                return null;
            }
            X509CertImpl x509CertImpl = new X509CertImpl(certificate.getEncoded());
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0010");
            PublicKey publicKey = certificate.getPublicKey();
            int n = 0;
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0050");
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm());
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0070");
            PublicKey publicKey2 = keyFactory.generatePublic(x509EncodedKeySpec);
            n = publicKey2 instanceof RSAPublicKey ? ((RSAPublicKey)publicKey2).getModulus().bitLength() : ((DSAPublicKey)publicKey2).getY().bitLength();
            if (n % 2 != 0) {
                ++n;
            }
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0100");
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            String string12 = "";
            String string13 = "";
            String string14 = "";
            X500Name x500Name = (X500Name)x509CertImpl.getIssuerDN();
            try {
                string = x500Name.getCommonName();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8000, Exception=" + exception);
                string = "<invalid issuer cn>";
            }
            try {
                string2 = x500Name.getOrganizationalUnit();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8010, Exception=" + exception);
                string2 = "<invalid issuer ou>";
            }
            try {
                string3 = x500Name.getOrganization();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8020, Exception=" + exception);
                string3 = "<invalid orgnanization name>";
            }
            try {
                string4 = x500Name.getLocality();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8020, Exception=" + exception);
                string4 = "<invalid locality>";
            }
            try {
                string5 = x500Name.getState();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8020, Exception=" + exception);
                string5 = "<invalid state>";
            }
            try {
                string6 = x500Name.getPostalCode();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8020, Exception=" + exception);
                string6 = "<invalid postal code>";
            }
            try {
                string7 = x500Name.getCountry();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8030, Exception=" + exception);
                string7 = "<invalid country name>";
            }
            X500Name x500Name2 = (X500Name)x509CertImpl.getSubjectDN();
            try {
                string8 = x500Name2.getCommonName();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8040, Exception=" + exception);
                string8 = "<invalid subject cn>";
            }
            try {
                string9 = x500Name2.getOrganizationalUnit();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8050, Exception=" + exception);
                string9 = "<invalid subject ou>";
            }
            try {
                string10 = x500Name2.getOrganization();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8060, Exception=" + exception);
                string10 = "<invalid subject origination name>";
            }
            try {
                string11 = x500Name2.getLocality();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8060, Exception=" + exception);
                string11 = "<invalid subject location>";
            }
            try {
                string12 = x500Name2.getState();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8060, Exception=" + exception);
                string12 = "<invalid subject state>";
            }
            try {
                string13 = x500Name2.getPostalCode();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8060, Exception=" + exception);
                string13 = "<invalid subject postal code>";
            }
            try {
                string14 = x500Name2.getCountry();
            }
            catch (Exception exception) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 8070, Exception=" + exception);
                string14 = "<invalid subject country name>";
            }
            DNItem dNItem = new DNItem(string, string2, string3, string4, string5, string6, string7, null);
            DNItem dNItem2 = new DNItem(string8, string9, string10, string11, string12, string13, string14, null);
            AlgorithmId algorithmId = (AlgorithmId)x509CertImpl.get("x509.algorithm");
            X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
            CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
            CertificateItem certificateItem = null;
            if (certificateExtensions != null) {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0200");
                DerOutputStream derOutputStream = new DerOutputStream();
                certificateExtensions.encode((OutputStream)derOutputStream);
                certificateItem = new CertificateItem((short)((X509Certificate)certificate).getVersion(), (short)n, ((X509Certificate)certificate).getSerialNumber().toString(), dNItem, dNItem2, ((X509Certificate)certificate).getNotBefore(), ((X509Certificate)certificate).getNotAfter(), new BERObject(certificate.getPublicKey().getEncoded()), new BERObject(derOutputStream.toByteArray()), ((X509Certificate)certificate).getSignature(), new BERObject(algorithmId.encode()), x509CertImpl.getSigAlgOID(), x509CertImpl.getSigAlgName(), certificate.getEncoded());
            } else {
                KMUtil.debugMsg("KeyStoreManager::parseCertificate() 0300");
                certificateItem = new CertificateItem((short)((X509Certificate)certificate).getVersion(), (short)n, ((X509Certificate)certificate).getSerialNumber().toString(), dNItem, dNItem2, ((X509Certificate)certificate).getNotBefore(), ((X509Certificate)certificate).getNotAfter(), new BERObject(certificate.getPublicKey().getEncoded()), null, ((X509Certificate)certificate).getSignature(), new BERObject(algorithmId.encode()), x509CertImpl.getSigAlgOID(), x509CertImpl.getSigAlgName(), certificate.getEncoded());
            }
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999");
            return certificateItem;
        }
        catch (IOException iOException) {
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-1, IOException=" + iOException);
            throw new KeyStoreManagerException("IOException");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-2, InvalidKeySpecException=" + invalidKeySpecException);
            throw new KeyStoreManagerException(invalidKeySpecException.getMessage());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-3, CertificateEncodingException=" + certificateEncodingException);
            throw new KeyStoreManagerException(certificateEncodingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-4, NoSuchAlgorithmException=" + noSuchAlgorithmException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
        }
        catch (CertificateException certificateException) {
            KMUtil.debugMsg("KeyStoreManager::parseCertificate() 9999-5, CertificateException=" + certificateException);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
    }

    public static CertificateItem[] buildPKCS7CertChain(String string, boolean bl) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::buildPKCS7CertChain() 0000, inputCertFileName=" + string + ", isBase64Armored=" + bl);
        CertificateItem[] certificateItemArray = null;
        try {
            certificateItemArray = CMSKeyDatabase.buildPKCS7CertChain(string, bl);
        }
        catch (CMSKeyDatabaseException cMSKeyDatabaseException) {
            KMUtil.debugMsg("KeyStoreManager::buildPKCS7CertChain() 9999-1, CMSKeyDatabaseException=" + cMSKeyDatabaseException);
            throw new KeyStoreManagerException();
        }
        KMUtil.debugMsg("KeyStoreManager::buildPKCS7CertChain() 9999-2");
        return certificateItemArray;
    }

    public PrivateKeyInfoItem decryptPrivateKey(EncryptedPrivateKeyInfoItem encryptedPrivateKeyInfoItem) throws KeyStoreManagerException {
        return null;
    }

    public void deleteKeyByLabel(String string) throws KeyStoreManagerException {
        block8: {
            if (string == null) {
                return;
            }
            try {
                this.iKeyStore.deleteEntry(string);
                if (this.keyLabelList.contains(string)) {
                    this.keyLabelList.removeElement(string);
                }
                if (this.needTrustedCARoots() && this.caCertLabelList != null && this.caCertLabelList.contains(string)) {
                    this.caCertLabelList.removeElement(string);
                    this.keyDbChanged = true;
                    return;
                }
                if (this.myCertLabelList != null && this.myCertLabelList.contains(string)) {
                    this.myCertLabelList.removeElement(string);
                    this.keyDbChanged = true;
                    return;
                }
                if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(string)) {
                    this.reqKeyLabelList.removeElement(string);
                    if (this.type != 1) {
                        this.deleteCertRequest(string);
                    }
                }
                this.keyDbChanged = true;
                this.save();
            }
            catch (KeyStoreException keyStoreException) {
                if (keyStoreException.getMessage().equals("User canceled")) break block8;
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
            }
        }
    }

    private void deleteCertRequest(String string) {
        if (string == null) {
            return;
        }
        if (this.cryptokiType != 2) {
            CertReqFile certReqFile = new CertReqFile(this.dbDirName, this.dbFileName);
            certReqFile.removeLabel(string);
        }
    }

    public void renewCert(String string, boolean bl) throws KeyStoreManagerException {
    }

    public boolean checkCertAsRenewal(String string, boolean bl) {
        boolean bl2 = false;
        return bl2;
    }

    public int getType() {
        return this.type;
    }

    public int getSlotID() {
        return this.cryptokiSlot_ID;
    }

    public String getKeyDbFileName() {
        return this.keyDbFileName;
    }

    public String getKeyDbPwd() {
        return this.keyDbPwd;
    }

    public long getKeyDbPwdExpireTime() {
        return this.keyDbPwdExpireTime;
    }

    public void setKeyDbFileName(String string) {
        this.keyDbFileName = string;
        try {
            File file = new File(this.keyDbFileName);
            this.keyDbFileName = file.getCanonicalPath();
            file = new File(this.keyDbFileName);
            this.dbFileName = file.getName();
            this.dbDirName = file.getParent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector getKeyLabelList() {
        return this.keyLabelList;
    }

    public Vector getCaCertLabelList() {
        return this.caCertLabelList;
    }

    public Vector getMyCertLabelList() {
        return this.myCertLabelList;
    }

    public Vector getReqKeyLabelList() {
        return this.reqKeyLabelList;
    }

    public Vector getCrlLabelList() {
        return this.crlLabelList;
    }

    public Vector getSiteCertLabelList() {
        return this.siteCertLabelList;
    }

    public void setKeyLabelList(Vector vector) {
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        } else {
            this.keyLabelList.removeAllElements();
        }
        this.copyVector(vector, this.keyLabelList);
    }

    public void setCaCertLabelList(Vector vector) {
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        } else {
            this.caCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.caCertLabelList);
    }

    public void setMyCertLabelList(Vector vector) {
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        } else {
            this.myCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.myCertLabelList);
    }

    public void setReqKeyLabelList(Vector vector) {
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        } else {
            this.reqKeyLabelList.removeAllElements();
        }
        this.copyVector(vector, this.reqKeyLabelList);
    }

    public void setCrlLabelList(Vector vector) {
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        } else {
            this.crlLabelList.removeAllElements();
        }
        this.copyVector(vector, this.crlLabelList);
    }

    public void setSiteCertLabelList(Vector vector) {
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        } else {
            this.siteCertLabelList.removeAllElements();
        }
        this.copyVector(vector, this.siteCertLabelList);
    }

    protected void copyVector(Vector vector, Vector vector2) {
        if (vector == null) {
            vector2 = null;
            return;
        }
        if (vector2 == null) {
            vector2 = new Vector<String>();
        } else {
            vector2.removeAllElements();
        }
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            vector2.addElement(string);
            ++n;
        }
    }

    public void addKeyLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        }
        this.keyLabelList.addElement(string);
    }

    public void addCaCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        }
        this.caCertLabelList.addElement(string);
    }

    public void addMyCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        }
        this.myCertLabelList.addElement(string);
    }

    public void addReqKeyLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        }
        this.reqKeyLabelList.addElement(string);
    }

    public void addCrlLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        }
        this.crlLabelList.addElement(string);
    }

    public void addSiteCertLabel(String string) {
        if (string == null) {
            return;
        }
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        }
        this.siteCertLabelList.addElement(string);
    }

    public void addKeyLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.keyLabelList == null) {
            this.keyLabelList = new Vector();
        }
        this.keyLabelList.insertElementAt(string, n);
    }

    public void addCaCertLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.caCertLabelList == null) {
            this.caCertLabelList = new Vector();
        }
        this.caCertLabelList.insertElementAt(string, n);
    }

    public void addMyCertLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.myCertLabelList == null) {
            this.myCertLabelList = new Vector();
        }
        this.myCertLabelList.insertElementAt(string, n);
    }

    public void addReqKeyLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.reqKeyLabelList == null) {
            this.reqKeyLabelList = new Vector();
        }
        this.reqKeyLabelList.insertElementAt(string, n);
    }

    public void addCrlLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.crlLabelList == null) {
            this.crlLabelList = new Vector();
        }
        this.crlLabelList.insertElementAt(string, n);
    }

    public void addSiteCertLabelAt(String string, int n) {
        if (string == null) {
            return;
        }
        if (this.siteCertLabelList == null) {
            this.siteCertLabelList = new Vector();
        }
        this.siteCertLabelList.insertElementAt(string, n);
    }

    private void buildKeyStoreLabelList() throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0000");
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        this.siteCertLabelList = null;
        this.reqKeyLabelList = null;
        try {
            Enumeration<String> enumeration = this.iKeyStore.aliases();
            KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0020");
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0030, alias=" + string);
                if (this.type == 0) {
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 9999-4");
                    return;
                }
                if (this.type == 1) {
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0100, alias=" + string);
                    this.addKeyLabel(string);
                    if (((IBMKeyStore)this.iKeyStore).isCertReqEntry(string)) {
                        KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0110");
                        this.addReqKeyLabel(string);
                        continue;
                    }
                    if (this.iKeyStore.isKeyEntry(string)) {
                        KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0120");
                        this.addMyCertLabel(string);
                        continue;
                    }
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0130");
                    this.addCaCertLabel(string);
                    continue;
                }
                if (this.type == 5) continue;
                KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0200");
                this.addKeyLabel(string);
                if (this.iKeyStore.isKeyEntry(string)) {
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0220");
                    this.addMyCertLabel(string);
                    continue;
                }
                if (this.iKeyStore.isCertificateEntry(string)) {
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 0240");
                    this.addCaCertLabel(string);
                    continue;
                }
                KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 9999-1");
                IkeymanLogger.error("KeyStoreManager", "buildKeyStoreLabelList() Line 6033", "Uninitialized keystore, alias value is " + string);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
            }
            if (this.type != 1 && this.type != 2 && this.type != 3 && this.type != 4) {
                CertReqFile certReqFile = new CertReqFile(this.dbDirName, this.dbFileName);
                String[] stringArray = certReqFile.getReqKeyLabels();
                if (stringArray == null) {
                    KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 9999-4");
                    return;
                }
                int n = 0;
                while (n < stringArray.length) {
                    this.addReqKeyLabel(stringArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 9999-2, Exception=" + exception);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        KMUtil.debugMsg("KeyStoreManager::buildKeyStoreLabelList() 9999-3");
    }

    private void buildPKCS11KeyStoreLabelList() throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::buildPKCS11KeyStoreLabelList() 1000");
        this.keyLabelList = new Vector();
        this.myCertLabelList = null;
        this.caCertLabelList = null;
        this.siteCertLabelList = null;
        this.reqKeyLabelList = null;
        String string = null;
        try {
            Enumeration<String> enumeration = this.iKeyStore.aliases();
            KMUtil.debugMsg("KeyStoreManager::buildPKCS11KeyStoreLabelList() 2000");
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                this.keyLabelList.addElement(string);
                boolean bl = false;
                if (this.iKeyStore.isKeyEntry(string)) {
                    block14: {
                        Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string);
                        if (certificateArray.length == 1) {
                            Certificate certificate = certificateArray[0];
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", JCEProvider);
                            X509CertImpl x509CertImpl = null;
                            x509CertImpl = !(certificate instanceof X509CertImpl) ? (X509CertImpl)certificateFactory.generateCertificate(new ByteArrayInputStream(certificate.getEncoded())) : (X509CertImpl)certificate;
                            try {
                                byte[] byArray;
                                CertificateExtensions certificateExtensions = (CertificateExtensions)x509CertImpl.get("x509.info.extensions");
                                if (certificateExtensions == null) break block14;
                                SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
                                try {
                                    subjectKeyIdentifierExtension = (SubjectKeyIdentifierExtension)certificateExtensions.get("SubjectKeyIdentifier");
                                }
                                catch (IOException iOException) {
                                    throw new CertificateParsingException();
                                }
                                if (subjectKeyIdentifierExtension != null && (byArray = ((KeyIdentifier)subjectKeyIdentifierExtension.get("key_id")).getIdentifier()) != null && byArray.length == this.keyidentifier.length) {
                                    int n = 0;
                                    bl = true;
                                    while (n < byArray.length) {
                                        if (byArray[n] != this.keyidentifier[n]) {
                                            n = byArray.length;
                                            bl = false;
                                        }
                                        ++n;
                                    }
                                }
                            }
                            catch (CertificateParsingException certificateParsingException) {
                                // empty catch block
                            }
                        }
                    }
                    if (bl) {
                        this.addReqKeyLabel(string);
                        continue;
                    }
                    this.addMyCertLabel(string);
                    continue;
                }
                if (this.iKeyStore.isCertificateEntry(string)) {
                    this.addCaCertLabel(string);
                    continue;
                }
                IkeymanLogger.error("KeyStoreManager", "buildPKCS11KeyStoreLabelList() Line 6160", "Uninitialised keystore, unknown type encountered the value of alias is " + string);
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("KeyStoreManager::buildPKCS11KeyStoreLabelList(), 9999-1, Exception=" + exception);
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_BUILD_KEYLIST"));
        }
        KMUtil.debugMsg("KeyStoreManager::buildPKCS11KeyStoreLabelList() 9999");
    }

    public static boolean isPasswordNeededInSetting(int n) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::isPasswordNeededInSetting() 0000, aKdbType=" + n);
        if (n == 0) {
            IkeymanLogger.error("KeyStoreManager", "isPasswordNeededInSetting() Line 6184", "An unknown key database type was encountered: " + KeyStoreManager.getKeyStoreName(n));
            throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_INVALID_TYPE"));
        }
        if (!(KMSystem.isJNIEnabled() || n != 1 && n != 4 && n != 2)) {
            return false;
        }
        String string = null;
        switch (n) {
            case 1: {
                string = KMSystem.getInitSetting("DEFAULT_CMS_PASSWORD_REQUIRED");
                break;
            }
            case 5: {
                string = KMSystem.getInitSetting("DEFAULT_SSLIGHT_PASSWORD_REQUIRED");
                break;
            }
            default: {
                string = "true";
            }
        }
        boolean bl = true;
        if (string != null && string.equalsIgnoreCase("false")) {
            bl = false;
        }
        KMUtil.debugMsg("KeyStoreManager::isPasswordNeededInSetting() 9999, returnValue=" + bl);
        return bl;
    }

    public static boolean isPasswordNeeded(int n, String string) throws KeyStoreManagerException {
        KMUtil.debugMsg("KeyStoreManager::isPasswordNeeded(2 args) 0000, ksType=" + n + ", fileName=" + string);
        boolean bl = true;
        try {
            if (n == 0) {
                IkeymanLogger.error("KeyStoreManager", "isPasswordNeeded() Line 6233", "An unknown key database type was encountered: " + KeyStoreManager.getKeyStoreName(n) + " for file " + string);
                KMUtil.debugMsg("KeyStoreManager::isPasswordNeeded(2 args) 9999-1");
                throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_UNDEFINED_KEY_TYPE"));
            }
            bl = n == 1 ? CMSKeyDatabase.isPasswordNeeded(string) : (n == 5 ? SSLightKeyDatabase.isPasswordNeeded(string) : true);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            KMUtil.debugMsg("KeyStoreManager::isPasswordNeeded(2 args) 8000, KeyDatabaseException=" + keyDatabaseException);
            bl = true;
        }
        KMUtil.debugMsg("KeyStoreManager::isPasswordNeeded(2 args) 9999, returnValue=" + bl);
        return bl;
    }

    public boolean isStashPwdSupported() {
        KMUtil.debugMsg("KeyStoreManager::isStashPwdSupported(void) 0000");
        boolean bl = false;
        if (this.type == 1) {
            try {
                int n = this.getType();
                String string = this.getKeyDbFileName();
                bl = KeyStoreManager.isPasswordNeeded(n, string);
            }
            catch (KeyStoreManagerException keyStoreManagerException) {
                KMUtil.debugMsg("KeyStoreManager::isStashPwdSupported(void) 8000, KeyStoreManagerException=" + keyStoreManagerException);
                bl = false;
            }
        }
        KMUtil.debugMsg("KeyStoreManager::isStashPwdSupported(void) 9999, returnValue=" + bl);
        return bl;
    }

    public static boolean isKeyLabelNeeded(int n) {
        return true;
    }

    public boolean isPersonalCertificateSupported() {
        KMUtil.debugMsg("KeyStoreManager::isPersonalCertificateSupported(void), always return true");
        return true;
    }

    public static String getKeyDbFileExtensionWithType(String string) {
        String string2 = string;
        if (string2.equals(nameOfCMS)) {
            string2 = DEFAULT_KEYDB_NAME_EXT_CMS;
        } else if (string2.equals(nameOfSSLight)) {
            string2 = DEFAULT_KEYDB_NAME_EXT_SSLIGHT;
        } else if (string2.equals(nameOfJKS)) {
            string2 = DEFAULT_JKS_FILE_NAME_EXT;
        } else if (string2.equals(nameOfJCEKS)) {
            string2 = DEFAULT_JCEKS_FILE_NAME_EXT;
        } else if (string2.equals(nameOfPKCS12)) {
            string2 = DEFAULT_PKCS12_FILE_NAME_EXT;
        } else if (string2 != null) {
            string2 = "";
        } else {
            return null;
        }
        return string2;
    }

    public static boolean loadCMSNoJavaOnlyProvider() {
        KMUtil.debugMsg("KeyStoreManager::loadCMSJavaOnlyProvider() 0000");
        try {
            Provider provider = Security.getProvider(cmsProvider);
            if (provider == null) {
                Class<?> clazz = Class.forName(cmsProviderClass);
                Object obj = clazz.newInstance();
                provider = (Provider)obj;
            }
            Security.insertProviderAt(provider, 1);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean loadCMSProvider() {
        KMUtil.debugMsg("KeyStoreManager::loadCMSProvider() 0000");
        if (!Ikeyman.javaOnly) {
            return KeyStoreManager.loadCMSNoJavaOnlyProvider();
        }
        return true;
    }

    public static int[] getSupportedDatabaseTypes() {
        return KeyStoreManager.getSupportedDatabaseTypes(Ikeyman.javaOnly);
    }

    public static int[] getSupportedCLIDatabaseTypes() {
        return KeyStoreManager.getSupportedDatabaseTypes(false);
    }

    public static int[] getSupportedDatabaseTypes(boolean bl) {
        KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0000");
        Vector vector = new Vector();
        Object var2_2 = null;
        boolean bl2 = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Object object;
            Object object2;
            if (!bl) {
                object2 = Security.getProvider(cmsProvider);
                KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0003");
                if (object2 != null) {
                    KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0005, CMS provider=" + ((Provider)object2).getName());
                    hashtable.put(nameOfCCryptoki, nameOfCCryptoki);
                    if (KMSystem.isMSKeyStoreOS()) {
                        hashtable.put(nameOfMSStore, nameOfMSStore);
                    }
                }
            }
            object2 = Security.getProviders();
            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0050, providers.length=" + ((Provider[])object2).length);
            int n = 0;
            while (n < ((Object)object2).length) {
                block47: {
                    block46: {
                        String string = ((Provider)object2[n]).toString();
                        KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0070, pro_name=" + string);
                        if (string.startsWith("IBMJCE")) {
                            bl2 = true;
                        }
                        object = ((Provider)object2[n]).keySet();
                        if (!string.startsWith(cmsProvider)) break block46;
                        if (bl) break block47;
                        if (object.size() == 0) {
                            hashtable.put(nameOfCMS, nameOfCMS);
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0075");
                        }
                    }
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (!(e instanceof String) || !((String)e).startsWith("KeyStore.")) continue;
                        String string = ((String)e).substring(9);
                        try {
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0100, tmpKS=" + string);
                            if (!string.startsWith("PKCS11")) {
                                KeyStore keyStore = KeyStore.getInstance(string);
                            }
                            if (string.startsWith("PKCS11")) {
                                string = nameOfJCryptoki;
                            }
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0120");
                            if (string.startsWith("PKCS12JarSigner")) continue;
                            hashtable.put(string, string);
                        }
                        catch (Error error) {
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 8000, Error=" + error);
                        }
                        catch (SecurityException securityException) {
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 8020, Exception=" + securityException);
                        }
                        catch (Exception exception) {
                            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 8010, Exception=" + exception);
                        }
                    }
                }
                ++n;
            }
            if (((Object)object2).length != 0) {
                int n2;
                sTypes = new String[hashtable.size()];
                dbTypes = new int[hashtable.size()];
                defaultKeyStoreTypes = new String[hashtable.size()];
                object = hashtable.keys();
                int n3 = 0;
                int n4 = 0;
                while (object.hasMoreElements()) {
                    KeyStoreManager.defaultKeyStoreTypes[n3] = (String)object.nextElement();
                    if (defaultKeyStoreTypes[n3].equalsIgnoreCase(nameOfCMS)) {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 1;
                    } else if (defaultKeyStoreTypes[n3].equalsIgnoreCase(nameOfSSLight)) {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 5;
                    } else if (defaultKeyStoreTypes[n3].equalsIgnoreCase(nameOfMSStore)) {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 2;
                    } else if (defaultKeyStoreTypes[n3].equalsIgnoreCase(nameOfJCryptoki)) {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 3;
                    } else if (defaultKeyStoreTypes[n3].equalsIgnoreCase(nameOfCCryptoki)) {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 4;
                    } else {
                        KeyStoreManager.sTypes[n3] = defaultKeyStoreTypes[n3];
                        KeyStoreManager.dbTypes[n3] = 6 + n4;
                        ++n4;
                        hashtable.remove(defaultKeyStoreTypes[n3]);
                    }
                    KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 0500, sTypes[" + n3 + "]=" + sTypes[n3] + ", dbTypes[" + n3 + "]=" + dbTypes[n3]);
                    ++n3;
                }
                boolean bl3 = false;
                boolean bl4 = false;
                int n5 = 0;
                while (n5 < sTypes.length) {
                    if (sTypes[n5].equalsIgnoreCase(nameOfCMS)) {
                        bl3 = true;
                    }
                    ++n5;
                }
                if (sTypes[0].equalsIgnoreCase(nameOfCMS)) {
                    bl4 = true;
                }
                if (bl3 && !bl4) {
                    int n6 = 0;
                    String string = sTypes[0];
                    n2 = dbTypes[0];
                    int n7 = 0;
                    while (n7 < sTypes.length) {
                        if (sTypes[n7].equalsIgnoreCase(nameOfCMS)) {
                            n6 = n7;
                        }
                        ++n7;
                    }
                    KeyStoreManager.sTypes[0] = nameOfCMS;
                    KeyStoreManager.dbTypes[0] = 1;
                    KeyStoreManager.sTypes[n6] = string;
                    KeyStoreManager.dbTypes[n6] = n2;
                }
                if (bl2) {
                    int n8 = 0;
                    int n9 = 0;
                    n2 = 0;
                    while (n2 < sTypes.length) {
                        if (sTypes[n2].equalsIgnoreCase(nameOfJCEKS)) {
                            n8 = n2;
                        } else if (sTypes[n2].equalsIgnoreCase(nameOfJKS)) {
                            n9 = n2;
                        }
                        ++n2;
                    }
                    if (n8 < n9) {
                        String string = sTypes[n9];
                        KeyStoreManager.sTypes[n9] = sTypes[n8];
                        KeyStoreManager.sTypes[n8] = string;
                        int n10 = dbTypes[n9];
                        KeyStoreManager.dbTypes[n9] = dbTypes[n8];
                        KeyStoreManager.dbTypes[n8] = n10;
                    }
                }
            }
        }
        catch (Exception exception) {
            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 8050, Exception=" + exception);
        }
        if (!bl2) {
            KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 9999-1");
            return null;
        }
        KMUtil.debugMsg("KeyStoreManager::getSupportedDatabaseTypes() 9999");
        return dbTypes;
    }

    public static int[] getSupportedDatabaseTypes(int n) {
        if (n == 0) {
            return KeyStoreManager.getSupportedDatabaseTypes();
        }
        int[] nArray = new int[]{n};
        return nArray;
    }

    public static void reloadProviderKeyStores() {
    }

    public static String[] listProviders() {
        KMUtil.debugMsg("KeyStoreManager::listProviders(void) 0000");
        Provider[] providerArray = Security.getProviders();
        boolean bl = false;
        if (providerArray == null) {
            return null;
        }
        String[] stringArray = new String[providerArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = providerArray[n].toString();
            if (string.startsWith("IBMJCE")) {
                bl = true;
            }
            stringArray[n] = providerArray[n].getName();
            KMUtil.debugMsg("KeyStoreManager::listProviders(void) 0200, alist[" + n + "]=" + stringArray[n]);
            ++n;
        }
        if (!bl) {
            stringArray = new String[]{};
        }
        KMUtil.debugMsg("KeyStoreManager::listProviders(void) 9999");
        return stringArray;
    }

    private static String[] getSupportedKeyStoreTypes() {
        KMUtil.debugMsg("KeyStoreManager::getSupportedKeyStoreTypes() 0000");
        Object[] objectArray = new String[sTypes.length];
        int n = 0;
        while (n < sTypes.length) {
            objectArray[n] = sTypes[n];
            ++n;
        }
        KMUtil.debugMsg("KeyStoreManager::getSupportedKeyStoreTypes() 9999, returnKSTypes = " + KMUtil.toStringObjectArray(objectArray));
        return objectArray;
    }

    public static String getKeyStoreName(int n) {
        KMUtil.debugMsg("KeyStoreManager::getKeyStoreName(int kstype) 0000, kstype=" + n);
        String string = nameOfCMS;
        if (sTypes == null) {
            return string;
        }
        int n2 = 0;
        while (n2 < dbTypes.length) {
            if (n == dbTypes[n2]) {
                string = sTypes[n2];
            }
            ++n2;
        }
        KMUtil.debugMsg("KeyStoreManager::getKeyStoreName(int kstype) 9999, rtypes=" + string);
        return string;
    }

    public static int getDbTypeFromKeyStore(String string) {
        KMUtil.debugMsg("KeyStoreManager::getDbTypeFromKeyStore() 0000 " + string);
        if (sTypes != null) {
            int n = 0;
            while (n < sTypes.length) {
                if (string.equals(sTypes[n])) {
                    return dbTypes[n];
                }
                ++n;
            }
        }
        return 0;
    }

    public static int getKeyDatabaseTypeBySuffix(String string) {
        if (string == null) {
            return 0;
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_CMS) || string.endsWith(DEFAULT_KEYDB_NAME_EXT_CMS.toUpperCase())) {
            return 1;
        }
        if (string.endsWith(DEFAULT_JKS_FILE_NAME_EXT) || string.endsWith(DEFAULT_JKS_FILE_NAME_EXT.toUpperCase())) {
            return KeyStoreManager.getDbTypeFromKeyStore(nameOfJKS);
        }
        if (string.endsWith(DEFAULT_JCEKS_FILE_NAME_EXT) || string.endsWith(DEFAULT_JCEKS_FILE_NAME_EXT.toUpperCase())) {
            return KeyStoreManager.getDbTypeFromKeyStore(nameOfJCEKS);
        }
        if (string.endsWith(DEFAULT_PKCS12_FILE_NAME_EXT) || string.endsWith(DEFAULT_PKCS12_FILE_NAME_EXT.toUpperCase())) {
            return KeyStoreManager.getDbTypeFromKeyStore(nameOfPKCS12);
        }
        if (string.endsWith(DEFAULT_KEYDB_NAME_EXT_SSLIGHT)) {
            return 5;
        }
        return 0;
    }

    public static int getKeyDatabaseTypeByName(String string, String string2) {
        if (string == null) {
            return 0;
        }
        String[] stringArray = KeyStoreManager.getSupportedKeyStoreTypes();
        int n = string.toLowerCase().indexOf(".dll");
        if (KeyStoreManager.isKeyStoreTypeSupported(nameOfJCryptoki) && n > -1) {
            return KeyStoreManager.getDbTypeFromKeyStore(nameOfJCryptoki);
        }
        FileInputStream fileInputStream = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            try {
                if (stringArray[n2].equalsIgnoreCase(nameOfJCryptoki)) {
                    try {
                        byte[] byArray = string.getBytes();
                        ByteArrayInputStream byteArrayInputStream = null;
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        KeyStore keyStore = KeyStore.getInstance("PKCS11KS");
                        keyStore.load(byteArrayInputStream, string2.toCharArray());
                        keyStore.store(null, null);
                        return KeyStoreManager.getDbTypeFromKeyStore(nameOfJCryptoki);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                fileInputStream = new FileInputStream(string);
                KeyStore keyStore = KeyStore.getInstance(stringArray[n2]);
                keyStore.load(fileInputStream, string2.toCharArray());
                fileInputStream.close();
                return KeyStoreManager.getDbTypeFromKeyStore(stringArray[n2]);
            }
            catch (Exception exception) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return 0;
    }

    public static String getDefaultKeyDbFileLocation(int n) {
        String string = KeyStoreManager.getKeyStoreName(n);
        KMUtil.debugMsg("KeyStoreManager::getDefaultKeyDbFileLocation(), databaseType=" + string);
        if (string == null) {
            return KMSystem.getWorkingDirName();
        }
        if (string.equals(nameOfCMS)) {
            return DEFAULT_KEYDB_LOCATION_CMS;
        }
        if (string.equals(nameOfSSLight)) {
            return DEFAULT_KEYDB_LOCATION_SSLIGHT;
        }
        if (string.equals(nameOfJKS)) {
            return DEFAULT_JKS_FILE_LOCATION;
        }
        if (string.equals(nameOfJCEKS)) {
            return DEFAULT_JCEKS_FILE_LOCATION;
        }
        if (string.equals(nameOfPKCS12)) {
            return DEFAULT_PKCS12_FILE_LOCATION;
        }
        return KMSystem.getWorkingDirName();
    }

    public static String getDefaultKeyDbFileName(String string) {
        String string2 = "";
        if (string.equals(nameOfCMS)) {
            string2 = DEFAULT_KEYDB_NAME_CMS + DEFAULT_KEYDB_NAME_EXT_CMS;
        } else if (string.equals(nameOfSSLight)) {
            string2 = DEFAULT_KEYDB_NAME_SSLIGHT + DEFAULT_KEYDB_NAME_EXT_SSLIGHT;
        } else if (string.equals(nameOfJKS)) {
            string2 = DEFAULT_JKS_FILE_NAME + DEFAULT_JKS_FILE_NAME_EXT;
        } else if (string.equals(nameOfJCEKS)) {
            string2 = DEFAULT_JCEKS_FILE_NAME + DEFAULT_JCEKS_FILE_NAME_EXT;
        } else if (string.equals(nameOfPKCS12)) {
            string2 = DEFAULT_PKCS12_FILE_NAME + DEFAULT_PKCS12_FILE_NAME_EXT;
        } else if (string.equals(nameOfCCryptoki) || string.equals(nameOfJCryptoki)) {
            String string3 = KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_MODULE");
            string2 = string3 != null ? string3 : "";
        } else {
            return string2;
        }
        return string2;
    }

    private static boolean isKeyStoreTypeSupported(String string) {
        int n = 0;
        while (n < sTypes.length) {
            if (sTypes[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isDbTypeSupported(int n) {
        int n2;
        KMUtil.debugMsg("KeyStoreManager::isDbTypeSupported() 0000, aType=" + n);
        boolean bl = false;
        try {
            n2 = dbTypes.length;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        KMUtil.debugMsg("KeyStoreManager::isDbTypeSupported() 0010");
        n2 = 0;
        while (n2 < dbTypes.length) {
            KMUtil.debugMsg("KeyStoreManager::isDbTypeSupported() 0020 i=" + n2);
            if (dbTypes[n2] == n) {
                bl = true;
            }
            ++n2;
        }
        KMUtil.debugMsg("KeyStoreManager::isDbTypeSupported() 9999, returnValue=" + bl);
        return bl;
    }

    public static Vector getTokenLabelList(int n) throws KMException {
        if (n == 1) {
            return CryptographicToken.getTokenLabelList();
        }
        if (n == 2) {
            Vector<String> vector = new Vector<String>();
            vector.add("");
            vector.add("");
            vector.add("");
            return vector;
        }
        return null;
    }

    public static Vector getMSCspNameList() {
        Vector vector = MSCertificateStore.getCSPNameList();
        KMUtil.debugMsg("KeyStoreManager::getMSCspNameList(), returnValue=" + KMUtil.toStringVector(vector));
        return vector;
    }

    public int getCryptoGraphicTokenType() {
        KMUtil.debugMsg("KeyStoreManager::getCryptoGraphicTokenType(void) 0000");
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            String string = providerArray[n].toString();
            if (string.startsWith("IBMPKCS11") && this.type == 3) {
                return 2;
            }
            if (string.startsWith(cmsProvider) && this.type == 4) {
                return 1;
            }
            ++n;
        }
        return 4;
    }

    public static boolean isCryptoGraphicTokenExists(int n) throws KMException {
        if (n == 1) {
            return CryptographicToken.exists();
        }
        return aCryptographicTokenModuleName != null;
    }

    public static boolean isAnyPasswordRequired() throws KMException {
        return CryptographicToken.isAnyPasswordRequired();
    }

    public boolean isPasswordNeeded() throws KMException {
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.isPasswordRequired();
        }
        return true;
    }

    public boolean isOpen() {
        KMUtil.debugMsg("KeyStoreManager::Cryptographic::isOpen() 0000");
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.isOpen();
        }
        if (this.cryptokiType == 2) {
            KMUtil.debugMsg("KeyStoreManager::isOpen()::JSSE 1000");
            if (isJSSECryptokiOpened) {
                KMUtil.debugMsg("KeyStoreManager::isOpen(), return true 1500");
                return true;
            }
            KMUtil.debugMsg("KeyStoreManager::isOpen(), return false 1900");
            return false;
        }
        return true;
    }

    public void closeCMSCryptoki() throws KMException {
        this.cmsCryptoki.close();
    }

    public void changePassword(String string) throws KMException {
        this.cmsCryptoki.changePassword(string);
    }

    public String getLabel() {
        if (this.cryptokiType == 2) {
            return nameOfJCryptoki;
        }
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.getLabel();
        }
        return null;
    }

    public Vector getPersonalKeyLabelList() throws KMException {
        if (this.cryptokiType == 2) {
            return this.getMyCertLabelList();
        }
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.getPersonalKeyLabelList();
        }
        return null;
    }

    public Vector getRequestKeyLabelList() throws KMException {
        if (this.cryptokiType == 2) {
            return this.getReqKeyLabelList();
        }
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.getRequestKeyLabelList();
        }
        return null;
    }

    public Vector getSignerKeyLabelList() throws KMException {
        if (this.cryptokiType == 2) {
            return this.getCaCertLabelList();
        }
        if (this.cryptokiType == 1) {
            return this.cmsCryptoki.getSignerKeyLabelList();
        }
        return null;
    }

    public boolean isPersonalCertificateRenewal(String string, boolean bl) throws KMException {
        return this.cmsCryptoki.isPersonalCertificateRenewal(string, bl);
    }

    public void renewPersonalCertificate(String string, boolean bl) throws KMException {
        this.cmsCryptoki.renewPersonalCertificate(string, bl);
    }

    public void createSelfSignedCertificate(int n, String string, int n2, DNItem dNItem, int n3, int n4) throws KMException {
        if (this.cryptokiType == 1) {
            KMUtil.debugMsg("KeyStoreManager::PKCS11/cms/createSelfSignedCertificate(), 1234");
            this.cmsCryptoki.createSelfSignedCertificate(n, string, n2, dNItem, n3, n4);
        } else if (this.cryptokiType == 2) {
            KMUtil.debugMsg("KeyStoreManager::PKCS11/jce/createSelfSignedCertificate(), 2234");
            this.createNewSelfSignedCertificate(n, string, false, n2, dNItem, n3, n4, null, false, null);
            this.buildPKCS11KeyStoreLabelList();
        }
    }

    public void createPersonalCertificateRequest(String string, int n, DNItem dNItem, int n2, String string2) throws KMException {
        if (this.cryptokiType == 1) {
            KMUtil.debugMsg("KeyStoreManager::PKCS11/cms/createPersonalCertificateRequest(), 4434");
            this.cmsCryptoki.createPersonalCertificateRequest(string, n, dNItem, n2, string2);
        } else if (this.cryptokiType == 2) {
            KMUtil.debugMsg("KeyStoreManager::PKCS11/jce/createPersonalCertificateRequest(), 5434");
            this.createNewCertRequest(string, n, dNItem, n2, string2, true, null);
            this.buildPKCS11KeyStoreLabelList();
        }
    }

    public void addSignerCertificate(String string, String string2, boolean bl) throws KMException {
        if (this.cryptokiType == 1) {
            this.cmsCryptoki.addSignerCertificate(string, string2, bl);
        } else if (this.cryptokiType == 2) {
            this.addCACertificate(string, string2, bl);
        }
    }

    public void relabel(String string, String string2) throws KMException {
        try {
            if (this.iKeyStore.isCertificateEntry(string)) {
                Certificate certificate = this.iKeyStore.getCertificate(string);
                this.iKeyStore.deleteEntry(string);
                this.iKeyStore.setCertificateEntry(string2, certificate);
                this.caCertLabelList.remove(string);
                this.caCertLabelList.add(string2);
            } else if (this.iKeyStore.isKeyEntry(string)) {
                Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string);
                Key key = this.iKeyStore.getKey(string, this.keyDbPwd.toCharArray());
                this.iKeyStore.deleteEntry(string);
                this.iKeyStore.setKeyEntry(string2, key, this.keyDbPwd.toCharArray(), certificateArray);
                this.keyLabelList.remove(string);
                this.myCertLabelList.remove(string);
                this.keyLabelList.add(string2);
                this.myCertLabelList.add(string2);
            }
        }
        catch (Exception exception) {
            IkeymanLogger.error("KeyStoreManager", "relabel() Line 7182", "Error while relabelling oldLabel=" + string + "to newLabel=" + string2);
            throw new KMException(exception.getMessage());
        }
    }

    public void doPfx() throws KMException {
        try {
            Enumeration<String> enumeration = this.iKeyStore.aliases();
            Vector vector = this.toVector(enumeration);
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.iKeyStore.isCertificateEntry(string)) continue;
                Certificate certificate = this.iKeyStore.getCertificate(string);
                this.iKeyStore.deleteEntry(string);
                String string2 = this.iKeyStore.getCertificateAlias(certificate);
                if (string2 == null || this.iKeyStore.isCertificateEntry(string2)) {
                    this.iKeyStore.setCertificateEntry(string, certificate);
                    continue;
                }
                Key key = this.iKeyStore.getKey(string2, this.keyDbPwd.toCharArray());
                Certificate[] certificateArray = this.iKeyStore.getCertificateChain(string2);
                this.iKeyStore.deleteEntry(string2);
                this.iKeyStore.setKeyEntry(string, key, this.keyDbPwd.toCharArray(), certificateArray);
                this.keyLabelList.remove(string2);
                this.myCertLabelList.remove(string2);
                this.caCertLabelList.remove(string);
                this.keyLabelList.add(string);
                this.myCertLabelList.add(string);
            }
        }
        catch (Exception exception) {
            throw new KMException(exception.getMessage());
        }
    }

    private Vector toVector(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public void importKeyItems(KeyStoreManager keyStoreManager, String[] stringArray, String[] stringArray2) throws KMException {
        this.cmsCryptoki.importKeyItems(keyStoreManager, stringArray, stringArray2);
    }

    public void importKeyItems(KeyStoreManager keyStoreManager, KeyStoreManager keyStoreManager2, String[] stringArray, String[] stringArray2) throws KMException {
        this.importKeyItems(keyStoreManager, keyStoreManager2, stringArray, null, stringArray2);
    }

    public void importKeyItems(KeyStoreManager keyStoreManager, KeyStoreManager keyStoreManager2, String[] stringArray, KMFrame kMFrame, String[] stringArray2) throws KMException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        Vector vector5 = keyStoreManager.getCaCertLabelList();
        Vector vector6 = keyStoreManager2.getCaCertLabelList();
        int n = 0;
        while (n < stringArray.length) {
            KeyItem keyItem = keyStoreManager2.getKeyItemByLabel(stringArray[n]);
            if (keyItem.hasPrivateKey()) {
                vector.addElement(stringArray[n]);
                vector2.addElement(stringArray2[n]);
            } else {
                vector3.addElement(stringArray[n]);
                vector4.addElement(stringArray2[n]);
            }
            ++n;
        }
        String[] stringArray3 = new String[vector.size()];
        String[] stringArray4 = new String[vector.size()];
        String[] stringArray5 = new String[vector3.size()];
        String[] stringArray6 = new String[vector3.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray3[n2] = (String)vector.elementAt(n2);
            stringArray4[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            KeyStore keyStore = keyStoreManager2.getKeyStoreInstance();
            KeyStore keyStore2 = keyStoreManager.getKeyStoreInstance();
            stringArray5[n3] = (String)vector3.elementAt(n3);
            stringArray6[n3] = (String)vector4.elementAt(n3);
            String string = null;
            boolean bl = false;
            if (vector5 != null) {
                try {
                    X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(stringArray5[n3]);
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    int n4 = 0;
                    while (n4 < vector5.size()) {
                        String string2 = (String)vector5.get(n4);
                        X509Certificate x509Certificate2 = (X509Certificate)keyStore2.getCertificate(string2);
                        PublicKey publicKey2 = x509Certificate2.getPublicKey();
                        if (string2.equalsIgnoreCase(stringArray6[n3]) && publicKey2.equals(publicKey)) {
                            bl = true;
                        } else {
                            if (publicKey2.equals(publicKey)) {
                                KMFrame.errorHandler(KMFrame.mFrame, KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY"));
                                return;
                            }
                            if (string2.equalsIgnoreCase(stringArray6[n3])) {
                                if (kMFrame == null) {
                                    IkeymanLogger.error("KeyStoreManager", "importKeyItems() Line 7308", "A duplicate key label was found caCertLabelList=" + stringArray5[n3]);
                                    throw new KeyDatabaseException(KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"));
                                }
                                string = kMFrame.accessResolveLabelConflictsWithGUI(stringArray6[n3]);
                                if (vector5.contains(string)) {
                                    KMFrame.errorHandler(KMFrame.mFrame, KMSystem.getNLSErrString("GSKKM_ERR_DATABASE_DUPLICATE_KEY_LABEL"), string);
                                    return;
                                }
                            }
                        }
                        ++n4;
                    }
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (!bl) {
                    if (string == null) {
                        string = stringArray6[n3];
                    }
                    try {
                        keyStoreManager.getKeyStoreInstance().setCertificateEntry(string, keyStoreManager2.getKeyStoreInstance().getCertificate(stringArray5[n3]));
                        keyStoreManager.keyDbChanged = true;
                    }
                    catch (KeyStoreException keyStoreException) {
                        // empty catch block
                    }
                    keyStoreManager.addKeyLabelAt(string, 0);
                    keyStoreManager.addCaCertLabelAt(string, 0);
                }
            }
            ++n3;
        }
        this.cmsCryptoki.importKeyItems(keyStoreManager, keyStoreManager2, stringArray3, stringArray2);
    }

    public void extractCryptokiCertificate(String string, String string2, boolean bl) throws KMException {
        if (this.cryptokiType == 1) {
            this.cmsCryptoki.extractCertificate(string, string2, bl);
        } else if (this.cryptokiType == 2) {
            this.extractCertificate(string, string2, bl);
        }
    }

    public void receivePersonalCertificate(String string, boolean bl, boolean bl2) throws KMException {
        if (this.cryptokiType == 1) {
            this.cmsCryptoki.receivePersonalCertificate(string, bl);
        } else if (this.cryptokiType == 2) {
            this.receivePKCS11CertificateChain(string, bl, bl2);
        }
    }

    private void receivePKCS11CertificateChain(String string, boolean bl, boolean bl2) throws KMException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X509", JCEProvider);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                certificateFactory = CertificateFactory.getInstance("X509");
            }
            Collection<? extends Certificate> collection = null;
            try {
                collection = certificateFactory.generateCertificates(fileInputStream);
            }
            catch (CertificateException certificateException) {
                fileInputStream.close();
                fileInputStream = new FileInputStream(string);
                object4 = new byte[fileInputStream.available()];
                fileInputStream.read((byte[])object4);
                object3 = new ContentInfo((byte[])object4);
                Content content = object3.getContent();
                object2 = new ByteArrayOutputStream();
                content.encode((OutputStream)object2);
                object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                collection = certificateFactory.generateCertificates((InputStream)object);
            }
            fileInputStream.close();
            Certificate[] certificateArray = new X509Certificate[collection.size()];
            object4 = collection.iterator();
            int n = 0;
            while (object4.hasNext()) {
                certificateArray[n] = (X509Certificate)object4.next();
                ++n;
            }
            if (certificateArray[0] == null) {
                IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain() Line 7452", "An error occurred while receiving PKCS11 certificate inputCertFileName=" + string + " No certificate was retrieved from PKCS7.");
                throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_INVALID_INPUT"));
            }
            this.reorderCertChain((X509Certificate[])certificateArray);
            object3 = null;
            boolean bl3 = false;
            object2 = this.reqKeyLabelList.elements();
            object = null;
            KMUtil.debugMsg("KeyStoreManager::receiveCertificate ccccc  " + certificateArray.length);
            int n2 = 0;
            while (n2 < certificateArray.length) {
                KMUtil.debugMsg("KeyStoreManager::receiveCertificate ccccc  " + n2);
                object = certificateArray[n2].getPublicKey();
                while (object2.hasMoreElements()) {
                    object3 = (String)object2.nextElement();
                    Certificate certificate = this.iKeyStore.getCertificate((String)object3);
                    if (!object.equals(certificate.getPublicKey())) continue;
                    PrivateKey privateKey = null;
                    try {
                        privateKey = (PrivateKey)this.iKeyStore.getKey((String)object3, this.keyDbPwd.toCharArray());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (privateKey != null) {
                        this.iKeyStore.setKeyEntry((String)object3, privateKey, this.keyDbPwd.toCharArray(), certificateArray);
                    }
                    bl3 = true;
                    break;
                }
                ++n2;
            }
            if (!bl3) {
                IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain() Line 7498", "An error occurred while receiving PKCS11 certificate inputCertFileName=" + string + " No public key was found.");
                throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_REQKEY_FOR_CERT_NULL"));
            }
            if (this.reqKeyLabelList != null && this.reqKeyLabelList.contains(object3)) {
                this.reqKeyLabelList.removeElement(object3);
            }
            this.buildPKCS11KeyStoreLabelList();
        }
        catch (CertificateException certificateException) {
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
        }
        catch (IOException iOException) {
            IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain()", "IO exception caught while receiving PKCS11 certificate inputCertFileName=" + string + " Check read/write permissions (An encoding/decoding error occurred).");
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_ASN"));
        }
        catch (KeyStoreException keyStoreException) {
            IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain() Line 7543", "KeyStoreException caught while receiving PKCS11 certificate inputCertFileName=" + string + " An error occurred while inserting keys into the database.");
            throw new KMException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
        }
        catch (KeyStoreManagerException keyStoreManagerException) {
            IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain() Line 7549", "KeyStoreManagerException caught while receiving PKCS11 certificate inputCertFileName=" + string);
            throw new KMException(keyStoreManagerException.getMessage());
        }
        catch (KMException kMException) {
            IkeymanLogger.error("KeyStoreManager", "receivePKCS11CertificateChain() Line 7554", "KMException caught while receiving PKCS11 certificate inputCertFileName=" + string);
            throw new KMException(kMException.getMessage());
        }
    }

    private void reorderCertChain(X509Certificate[] x509CertificateArray) {
        boolean bl = false;
        int n = 0;
        int n2 = x509CertificateArray.length;
        while (n < n2 && !bl) {
            if (x509CertificateArray[n].getIssuerDN().equals(x509CertificateArray[n].getSubjectDN())) {
                bl = true;
                if (n == n2 - 1) break;
                X509Certificate x509Certificate = x509CertificateArray[n];
                x509CertificateArray[n] = x509CertificateArray[n2 - 1];
                x509CertificateArray[n2 - 1] = x509Certificate;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        bl = false;
        int n3 = --n2;
        while (n3 > 0) {
            int n4 = 0;
            while (n4 < n3 && !bl) {
                if (x509CertificateArray[n3].getSubjectDN().equals(x509CertificateArray[n4].getIssuerDN())) {
                    X509Certificate x509Certificate = x509CertificateArray[n4];
                    x509CertificateArray[n4] = x509CertificateArray[n3 - 1];
                    x509CertificateArray[n3 - 1] = x509Certificate;
                    bl = true;
                }
                ++n4;
            }
            bl = false;
            --n3;
        }
    }

    public void receivePersonalCertificate(KeyStoreManager keyStoreManager, String string, boolean bl) throws KMException {
        this.cmsCryptoki.receivePersonalCertificate(keyStoreManager, string, bl);
    }

    public void extractPersonalCertificateRequest(String string, int n, String string2) throws KMException {
        if (this.cryptokiType == 1) {
            this.cmsCryptoki.extractPersonalCertificateRequest(string, n, string2);
        } else if (this.cryptokiType == 2) {
            this.extractCertificateRequest(string, n, string2);
        }
    }

    public void deleteKeyItemByLabel(String string) throws KMException {
        if (this.cryptokiType == 1) {
            this.cmsCryptoki.deleteKeyItemByLabel(string);
        } else if (this.cryptokiType == 2) {
            this.deleteKeyByLabel(string);
        }
    }

    private void addDefaultRootCertificates() throws KeyStoreManagerException {
        String[] stringArray = new String[]{RSA_SECURE_SERVER_CA_LABEL, THAWTE_ROOT_SELF_SIGNED_CERT_LABEL, THAWTE_SPR_ROOT_SELF_SIGNED_CERT_LABEL, THAWTE_PBASIC_ROOT_SELF_SIGNED_CERT_LABEL, THAWTE_PFREE_ROOT_SELF_SIGNED_CERT_LABEL, THAWTE_PPR_ROOT_SELF_SIGNED_CERT_LABEL, CLASS1_INTERMEDIATE_LABEL, Verisign_International_Server_Certification_Authority_Class_3, Verisign_Class_2_OnSite_Individual_Certification_Authority, VERISIGN_TEST_CA_LABEL, VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G3_LABEL, VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G3_LABEL, VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G3_LABEL, VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G3_LABEL, VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_G2_LABEL, VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_G2_LABEL, VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_G2_LABEL, VERISIGN_CLASS4_PUBLIC_PRIMARY_CA_G2_LABEL, VERISIGN_CLASS1_PUBLIC_PRIMARY_CA_LABEL, VERISIGN_CLASS2_PUBLIC_PRIMARY_CA_LABEL, VERISIGN_CLASS3_PUBLIC_PRIMARY_CA_LABEL, VERISIGN_CLASS3_SECURE_SERVER_CA_LABEL, ENTRUST_SECURE_SERVER_CA_LABEL, ENTRUST_CA_2048_LABEL, ENTRUST_CLIENT_CA_LABEL, ENTRUST_GLOBAL_CLIENT_CA_LABEL, ENTRUST_GLOBAL_SECURE_SERVER_CA_LABEL};
        byte[][] byArrayArray = new byte[][]{KeyStoreManager.getRSASecureServerCASelfSignedCert(), KeyStoreManager.getThawteRootSelfSignedCert(), KeyStoreManager.getThawteSPRRootSelfSignedCert(), KeyStoreManager.getThawtePBasicRootSelfSignedCert(), KeyStoreManager.getThawtePFreeRootSelfSignedCert(), KeyStoreManager.getThawtePPRRootSelfSignedCert(), KeyStoreManager.getClass1IntermediateCert(), KeyStoreManager.getClass1G99Cert(), KeyStoreManager.getClass1G88Cert(), KeyStoreManager.getVerisignTestCASelfSignedCert(), KeyStoreManager.getVerisignClass1PublicPrimaryCAG3Cert(), KeyStoreManager.getVeriSignClass2PublicPrimaryCAG3Cert(), KeyStoreManager.getVerisignClass3PublicPrimaryCAG3Cert(), KeyStoreManager.getVerisignClass4PublicPrimaryCAG3Cert(), KeyStoreManager.getVeriSignClass1PublicPrimaryCAG2Cert(), KeyStoreManager.getVeriSignClass2PublicPrimaryCAG2Cert(), KeyStoreManager.getVeriSignClass3PublicPrimaryCAG2Cert(), KeyStoreManager.getVeriSignClass4PublicPrimaryCAG2Cert(), KeyStoreManager.getVerisignClass1PublicPrimaryCACert(), KeyStoreManager.getVerisignClass2PublicPrimaryCACert(), KeyStoreManager.getVeriSignClass3PublicPrimaryCACert(), KeyStoreManager.getVeriSignClass3SecureServerCACert(), KeyStoreManager.getEntrustSecureServerCACert(), KeyStoreManager.getEntrustCA2048Cert(), KeyStoreManager.getEntrustClientCACert(), KeyStoreManager.getEntrustGlobalClientCACert(), KeyStoreManager.getEntrustGlobalSecureServerCACert()};
        if (this.type == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block8: {
                try {
                    X509CertImpl x509CertImpl = new X509CertImpl(byArrayArray[n]);
                    try {
                        x509CertImpl.checkValidity();
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        KMUtil.debugMsg("KeyStoreManager::addDefaultRootCerts Cert Not Yet Valid:" + certificateNotYetValidException.getMessage());
                    }
                    this.iKeyStore.setCertificateEntry(stringArray[n], (Certificate)x509CertImpl);
                }
                catch (CertificateExpiredException certificateExpiredException) {
                    KMUtil.debugMsg("KeyStoreManager::addDefaultRootCerts Cert Expired:" + certificateExpiredException.getMessage());
                }
                catch (CertificateException certificateException) {
                    IkeymanLogger.error("KeyStoreManager", "addDefaultRootCertificates() Line 7713", "There was a problem processing X509 certificates.  defaultLabel=" + stringArray[n].toString() + " " + "defaultByte=" + byArrayArray[n].toString());
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_X509"));
                }
                catch (KeyStoreException keyStoreException) {
                    if (keyStoreException.getMessage().endsWith("GSKKM_ERR_VALIDATION_KEY_VALIDITY_PERIOD, 48") || keyStoreException.getMessage().endsWith("INVALID_CERT_CHAIN") || keyStoreException.getMessage().equals("User canceled")) break block8;
                    IkeymanLogger.error("KeyStoreManager", "addDefaultRootCertificates() Line 7728", "There was a problem inserting keys into the database.  defaultLabel=" + stringArray[n].toString() + " " + "defaultByte=" + byArrayArray[n].toString());
                    throw new KeyStoreManagerException(KMSystem.getNLSErrString("GSKKM_ERR_CMN_KEYDB_KEY_INSERT"));
                }
            }
            ++n;
        }
    }

    private static byte[] getClass1RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 61, 48, -126, 1, -90, 2, 17, 0, -51, -70, 127, 86, -16, -33, -28, -68, 84, -2, 34, -84, -77, 114, -86, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -27, 25, -65, 109, -93, 86, 97, 45, -103, 72, 113, -10, 103, -34, -71, -115, -21, -73, -98, -122, -128, 10, -111, 14, -6, 56, 37, -81, 70, -120, -126, -27, 115, -88, -96, -101, 36, 93, 13, 31, -52, 101, 110, 12, -80, -48, 86, -124, 24, -121, -102, 6, -101, 16, -95, 115, -33, -76, 88, 57, 107, 110, -63, -10, 21, -43, -88, -88, 63, -86, 18, 6, -115, 49, -84, 127, -80, 52, -41, -113, 52, 103, -120, 9, -51, 20, 17, -30, 78, 69, 86, 105, 31, 120, 2, -128, -38, -36, 71, -111, 41, -69, 54, -55, 99, 92, -59, -32, -41, 45, -121, 123, -95, -73, 50, -80, 123, 48, -70, 42, 47, 49, -86, -18, -93, 103, -38, -37, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 76, 63, -72, -117, -58, 104, -33, -18, 67, 51, 14, 93, -23, -90, -53, 7, -124, 77, 122, 51, -1, -110, 27, -12, 54, -83, -40, -107, 34, 54, 104, 17, 108, 124, 66, -52, -13, -100, 46, -60, 7, 63, 20, -80, 15, 79, -1, -112, -110, 118, -7, -30, -68, 74, -23, -113, -51, -96, -128, 10, -9, -59, 41, -15, -126, 34, 93, -72, -79, -35, -127, 35, -93, 123, 37, 21, 70, 48, 121, 22, -8, -22, 5, 75, -108, 127, 29, -62, 28, -56, -29, -73, -12, 16, 64, 60, 19, -61, 95, 31, 83, -24, 72, -28, -122, -76, 123, -95, 53, -80, 123, 37, -70, -72, -45, -114, -85, 63, 56, -99, 0, 52, 0, -104, -13, -47, 113, -108};
        return byArray;
    }

    private static byte[] getClass2RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 45, 27, -4, 74, 23, -115, -93, -111, -21, -25, -1, -11, -117, 69, -66, 11, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -74, 90, -117, -93, 13, 106, 35, -125, -128, 107, -49, 57, -121, -12, 33, 19, 51, 6, 76, 37, -94, -19, 85, 18, -105, -59, -89, -128, -71, -6, -125, -63, 32, -96, -6, 47, 21, 13, 124, -95, 96, 107, 126, 121, 44, -6, 6, 15, 58, -82, -10, 27, 111, -79, -46, -1, 47, 40, 82, 95, -125, 125, 75, -60, 122, -73, -8, 102, 31, -128, 84, -4, -73, -62, -114, 89, 74, 20, 87, 70, -47, -102, -109, -66, 65, -111, 3, -69, 21, -128, -109, 92, -21, -25, -52, 8, 108, 63, 62, -77, 74, -4, -1, 75, 108, 35, -43, 80, -126, 38, 68, 25, -114, 35, -61, 113, -22, 25, 36, 71, 4, -98, 117, -65, -56, -90, 0, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -118, 27, 43, -6, 57, -63, 116, -41, 94, -40, 25, 100, -94, 88, 74, 45, 55, -32, 51, 71, 15, -84, -19, -9, -86, -37, 30, -28, -117, 6, 92, 96, 39, -54, 69, 82, -50, 22, -17, 63, 6, 100, -25, -108, 104, 124, 96, 51, 21, 17, 105, -81, -99, 98, -115, -93, 3, 84, 107, -90, -66, -27, -18, 5, 24, 96, 4, -65, 66, -128, -3, -48, -88, -88, 30, 1, 59, -9, -93, 92, -81, -93, -36, -26, 38, -128, 35, 60, -72, 68, 116, -9, 10, -82, 73, -117, 97, 120, -52, 36, -65, -120, -118, -89, 14, -22, 115, 25, 65, -3, 77, 3, -16, -120, -47, -27, 120, -115, -91, 42, 79, -10, -105, 13, 23, 119, -54, -40};
        return byArray;
    }

    private static byte[] getClass3RootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 112, -70, -28, 29, 16, -39, 41, 52, -74, 56, -54, 123, 3, -52, -70, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -55, 92, 89, -98, -14, 27, -118, 1, 20, -76, 16, -33, 4, 64, -37, -29, 87, -81, 106, 69, 64, -113, -124, 12, 11, -47, 51, -39, -39, 17, -49, -18, 2, 88, 31, 37, -9, 42, -88, 68, 5, -86, -20, 3, 31, 120, 127, -98, -109, -71, -102, 0, -86, 35, 125, -42, -84, -123, -94, 99, 69, -57, 114, 39, -52, -12, 76, -58, 117, 113, -46, 57, -17, 79, 66, -16, 117, -33, 10, -112, -58, -114, 32, 111, -104, 15, -8, -84, 35, 95, 112, 41, 54, -92, -55, -122, -25, -79, -102, 32, -53, 83, -91, -123, -25, 61, -66, 125, -102, -2, 36, 69, 51, -36, 118, 21, -19, 15, -94, 113, 100, 76, 101, 46, -127, 104, 69, -89, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -69, 76, 18, 43, -49, 44, 38, 0, 79, 20, 19, -35, -90, -5, -4, 10, 17, -124, -116, -13, 40, 28, 103, -110, 47, 124, -74, -59, -6, -33, -16, -24, -107, -68, 29, -113, 108, 44, -88, 81, -52, 115, -40, -92, -64, 83, -16, 78, -42, 38, -64, 118, 1, 87, -127, -110, 94, 33, -15, -47, -79, -1, -25, -48, 33, 88, -51, 105, 23, -29, 68, 28, -100, 25, 68, 57, -119, 92, -36, -100, 0, 15, 86, -115, 2, -103, -19, -94, -112, 69, 76, -28, -69, 16, -92, 61, -16, 50, 3, 14, -15, -50, -8, -24, -55, 81, -116, -26, 98, -97, -26, -97, -64, 125, -73, 114, -100, -55, 54, 58, 107, -97, 78, -88, -1, 100, 13, 100};
        return byArray;
    }

    private static byte[] getRSASecureServerCASelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 52, 48, -126, 1, -95, 2, 16, 2, -83, 102, 126, 78, 69, -2, 94, 87, 111, 60, -104, 25, 94, -35, -64, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 52, 49, 49, 48, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 48, 48, 49, 48, 55, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 32, 48, 30, 6, 3, 85, 4, 10, 19, 23, 82, 83, 65, 32, 68, 97, 116, 97, 32, 83, 101, 99, 117, 114, 105, 116, 121, 44, 32, 73, 110, 99, 46, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -101, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -119, 0, 48, -127, -123, 2, 126, 0, -110, -50, 122, -63, -82, -125, 62, 90, -86, -119, -125, 87, -84, 37, 1, 118, 12, -83, -82, -114, 44, 55, -50, -21, 53, 120, 100, 84, 3, -27, -124, 64, 81, -55, -65, -113, 8, -30, -118, -126, 8, -46, 22, -122, 55, 85, -23, -79, 33, 2, -83, 118, 104, -127, -102, 5, -94, 75, -55, 75, 37, 102, 34, 86, 108, -120, 7, -113, -9, -127, 89, 109, -124, 7, 101, 112, 19, 113, 118, 62, -101, 119, 76, -29, 80, -119, 86, -104, 72, -71, 29, -89, 41, 26, 19, 46, 74, 17, 89, -100, 30, 21, -43, 73, 84, 44, 115, 58, 105, -126, -79, -105, 57, -100, 109, 112, 103, 72, -27, -35, 45, -42, -56, 30, 123, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, 126, 0, 101, -35, 126, -31, -78, -20, -80, -30, 58, -32, -20, 113, 70, -102, 25, 17, -72, -45, -57, -96, -76, 3, 64, 38, 2, 62, 9, -100, -31, 18, -77, -47, 90, -10, 55, -91, -73, 97, 3, -74, 91, 22, 105, 59, -58, 68, 8, 12, -120, 83, 12, 107, -105, 73, -57, 62, 53, -36, 108, -71, -69, -86, -33, 92, -69, 58, 47, -109, 96, -74, -87, 75, 77, -14, 32, -9, -51, 95, 127, 100, 123, -114, -36, 0, 92, -41, -6, 119, -54, 57, 22, 89, 111, 14, -22, -45, -75, -125, 127, 77, 77, 66, 86, 118, -76, -55, 95, 4, -8, 56, -8, -21, -46, 95, 117, 95, -51, 123, -4, -27, -114, -128, 124, -4, 80};
        return byArray;
    }

    private static byte[] getVerisignTestCASelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 2, 82, 48, -126, 1, -4, -96, 3, 2, 1, 2, 2, 16, 2, -59, -15, 98, 57, -11, -31, 9, -68, -6, -58, 92, -124, 26, 98, 102, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -87, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 49, 71, 48, 69, 6, 3, 85, 4, 11, 19, 62, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 84, 101, 115, 116, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 32, 76, 105, 97, 98, 46, 32, 76, 84, 68, 46, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 70, 111, 114, 32, 86, 101, 114, 105, 83, 105, 103, 110, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 116, 101, 115, 116, 105, 110, 103, 32, 111, 110, 108, 121, 46, 32, 78, 111, 32, 97, 115, 115, 117, 114, 97, 110, 99, 101, 115, 32, 40, 67, 41, 86, 83, 49, 57, 57, 55, 48, 30, 23, 13, 57, 56, 48, 50, 48, 52, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 51, 48, 51, 48, 52, 50, 51, 53, 57, 53, 57, 90, 48, -127, -87, 49, 22, 48, 20, 6, 3, 85, 4, 10, 19, 13, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 49, 71, 48, 69, 6, 3, 85, 4, 11, 19, 62, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 84, 101, 115, 116, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 32, 76, 105, 97, 98, 46, 32, 76, 84, 68, 46, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 70, 111, 114, 32, 86, 101, 114, 105, 83, 105, 103, 110, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 116, 101, 115, 116, 105, 110, 103, 32, 111, 110, 108, 121, 46, 32, 78, 111, 32, 97, 115, 115, 117, 114, 97, 110, 99, 101, 115, 32, 40, 67, 41, 86, 83, 49, 57, 57, 55, 48, 92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, 75, 0, 48, 72, 2, 65, 0, -58, -92, -21, 18, 38, 39, 30, 56, -116, -62, -100, 110, 64, 2, -53, -97, -62, -56, -64, 54, 126, -91, -54, -32, -7, 115, 78, -48, -79, 70, -82, 109, 22, 64, -13, -99, -18, -20, 112, -113, 40, 20, -81, -55, -6, 1, 89, 52, 77, -37, -114, 39, 67, -59, -3, 59, 59, 114, 78, 96, 111, 81, 27, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, 65, 0, 109, 36, 103, 36, -46, 93, 127, -7, 117, 112, -123, -24, -72, 121, 8, -85, 59, -108, 16, -10, 19, 78, 52, -57, 12, -127, -46, -40, -81, -62, -81, -38, -29, -57, -118, -22, 103, -23, 11, -120, 123, 114, -6, -105, 71, 99, 123, 72, 76, -118, 47, -39, -120, 81, 57, -125, -4, -118, 32, 117, -81, -23, -12, -17};
        return byArray;
    }

    private static byte[] getThawteRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 19, 48, -126, 2, 124, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -60, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 3, 19, 16, 84, 104, 97, 119, 116, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 38, 48, 36, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 23, 115, 101, 114, 118, 101, 114, 45, 99, 101, 114, 116, 115, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -60, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 25, 48, 23, 6, 3, 85, 4, 3, 19, 16, 84, 104, 97, 119, 116, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 38, 48, 36, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 23, 115, 101, 114, 118, 101, 114, 45, 99, 101, 114, 116, 115, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -45, -92, 80, 110, -56, -1, 86, 107, -26, -49, 93, -74, -22, 12, 104, 117, 71, -94, -86, -62, -38, -124, 37, -4, -88, -12, 71, 81, -38, -123, -75, 32, 116, -108, -122, 30, 15, 117, -55, -23, 8, 97, -11, 6, 109, 48, 110, 21, 25, 2, -23, 82, -64, 98, -37, 77, -103, -98, -30, 106, 12, 68, 56, -51, -2, -66, -29, 100, 9, 112, -59, -2, -79, 107, 41, -74, 47, 73, -56, 59, -44, 39, 4, 37, 16, -105, 47, -25, -112, 109, -64, 40, 66, -103, -41, 76, 67, -34, -61, -11, 33, 109, 84, -97, 93, -61, 88, -31, -64, -28, -39, 91, -80, -72, -36, -76, 123, -33, 54, 58, -62, -75, 102, 34, 18, -42, -121, 13, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 7, -6, 76, 105, 92, -5, -107, -52, 70, -18, -123, -125, 77, 33, 48, -114, -54, -39, -88, 111, 73, 26, -26, -38, 81, -29, 96, 112, 108, -124, 97, 17, -95, 26, -56, 72, 62, 89, 67, 125, 79, -107, 61, -95, -117, -73, 11, 98, -104, 122, 117, -118, -35, -120, 78, 78, -98, 64, -37, -88, -52, 50, 116, -71, 111, 13, -58, -29, -77, 68, 11, -39, -118, 111, -102, 41, -101, -103, 24, 40, 59, -47, -29, 64, 40, -102, 90, 60, -43, -75, -25, 32, 27, -117, -54, -92, -85, -115, -23, 81, -39, -30, 76, 44, 89, -87, -38, -71, -78, 117, 27, -10, 66, -14, -17, -57, -14, 24, -7, -119, -68, -93, -1, -118, 35, 46, 112, 71};
        return byArray;
    }

    private static byte[] getThawteSPRRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 39, 48, -126, 2, -112, -96, 3, 2, 1, 2, 2, 1, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 56, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -50, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 29, 48, 27, 6, 3, 85, 4, 10, 19, 20, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 32, 99, 99, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 114, 101, 109, 105, 117, 109, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 114, 101, 109, 105, 117, 109, 45, 115, 101, 114, 118, 101, 114, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -46, 54, 54, 106, -117, -41, -62, 91, -98, -38, -127, 65, 98, -113, 56, -18, 73, 4, 85, -42, -48, -17, 28, 27, -107, 22, 71, -17, 24, 72, 53, 58, 82, -12, 43, 106, 6, -113, 59, 47, -22, 86, -29, -81, -122, -115, -98, 23, -9, -98, -76, 101, 117, 2, 77, -17, -53, 9, -94, 33, 81, -40, -101, -48, 103, -48, -70, 13, -110, 6, 20, 115, -44, -109, -53, -105, 42, 0, -100, 92, 78, 12, -68, -6, 21, 82, -4, -14, 68, 110, -38, 17, 74, 110, 8, -97, 47, 45, -29, -7, -86, 58, -122, 115, -74, 70, 83, 88, -56, -119, 5, -67, -125, 17, -72, 115, 63, -86, 7, -115, -12, 66, 77, -25, 64, -99, 28, 55, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 38, 72, 44, 22, -62, 88, -6, -24, 22, 116, 12, -86, -86, 95, 84, 63, -14, -41, -55, 120, 96, 94, 94, 110, 55, 99, 34, 119, 54, 126, -78, 23, -60, 52, -71, -11, 8, -123, -4, -55, 1, 56, -1, 77, -66, -14, 22, 66, 67, -25, -69, 90, 70, -5, -63, -58, 17, 31, -15, 74, -80, 40, 70, -55, -61, -60, 66, 125, -68, -6, -85, 89, 110, -43, -73, 81, -120, 17, -29, -92, -123, 25, 107, -126, 76, -92, 12, 18, -83, -23, -92, -82, 63, -15, -61, 73, 101, -102, -116, -59, -56, 62, 37, -73, -108, -103, -69, -110, 50, 113, 7, -16, -122, 94, -19, 80, 39, -90, 13, -90, 35, -7, -69, -53, -90, 7, 20, 66};
        return byArray;
    }

    private static byte[] getThawtePBasicRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 33, 48, -126, 2, -118, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -53, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 66, 97, 115, 105, 99, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 101, 114, 115, 111, 110, 97, 108, 45, 98, 97, 115, 105, 99, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -53, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 33, 48, 31, 6, 3, 85, 4, 3, 19, 24, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 66, 97, 115, 105, 99, 32, 67, 65, 49, 40, 48, 38, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 25, 112, 101, 114, 115, 111, 110, 97, 108, 45, 98, 97, 115, 105, 99, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -68, -68, -109, 83, 109, -64, 80, 79, -126, 21, -26, 72, -108, 53, -90, 90, -66, 111, 66, -6, 15, 71, -18, 119, 117, 114, -35, -115, 73, -101, -106, 87, -96, 120, -44, -54, 63, 81, -77, 105, 11, -111, 118, 23, 34, 7, -105, 106, -60, 81, -109, 75, -32, -115, -17, 55, -107, -95, 12, 77, -38, 52, -112, 29, 23, -119, -105, -32, 53, 56, 87, 74, -64, -12, 8, 112, -23, 60, 68, 123, 80, 126, 97, -102, -112, -29, 35, -45, -120, 17, 70, 39, -11, 11, 7, 14, -69, -35, -47, 127, 32, 10, -120, -71, 86, 11, 46, 28, -128, -38, -15, -29, -98, 41, -17, 20, -67, 10, 68, -5, 27, 91, 24, -47, -65, 35, -109, 33, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 45, -30, -103, 107, -80, 61, 122, -119, -41, 89, -94, -108, 1, 31, 43, -35, 18, 75, 83, -62, -83, 127, -86, -89, 0, 92, -111, 64, 87, 37, 74, 56, -86, -124, 112, -71, -39, -128, 15, -91, 123, 92, -5, 115, -58, -67, -41, -118, 97, 92, 3, -29, 45, 39, -88, 23, -32, -124, -123, 66, -36, 94, -101, -58, -73, -78, 109, -69, 116, -81, -28, 63, -53, -89, -73, -80, -32, 93, -66, 120, -125, 37, -108, -46, -37, -127, 15, 121, 7, 109, 79, -12, 57, 21, 90, 82, 1, 123, -34, 50, -42, 77, 56, -10, 18, 92, 6, 80, -33, 5, 91, -67, 20, 75, -95, -33, 41, -70, 59, 65, -115, -9, 99, 86, -95, -33, 34, -79};
        return byArray;
    }

    private static byte[] getThawtePFreeRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 45, 48, -126, 2, -106, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -47, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 70, 114, 101, 101, 109, 97, 105, 108, 32, 67, 65, 49, 43, 48, 41, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 28, 112, 101, 114, 115, 111, 110, 97, 108, 45, 102, 114, 101, 101, 109, 97, 105, 108, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -47, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 36, 48, 34, 6, 3, 85, 4, 3, 19, 27, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 70, 114, 101, 101, 109, 97, 105, 108, 32, 67, 65, 49, 43, 48, 41, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 28, 112, 101, 114, 115, 111, 110, 97, 108, 45, 102, 114, 101, 101, 109, 97, 105, 108, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -44, 105, -41, -44, -80, -108, 100, 91, 113, -23, 71, -40, 12, 81, -74, -22, 114, -111, -80, -124, 94, 125, 45, 13, -113, 123, 18, -33, -123, 37, 117, 40, 116, 58, 66, 44, 99, 39, -97, -107, 123, 75, -17, 126, 25, -121, 29, -122, -22, -93, -35, -71, -50, -106, 100, 26, -62, 20, 110, 68, -84, 124, -26, -113, -24, 77, 15, 113, 31, 64, 56, -90, 0, -93, -121, 120, -10, -7, -108, -122, 94, -83, -22, -64, 94, 118, -21, -39, 20, -93, 93, 110, 122, 124, 12, -91, 75, 85, 127, 6, 25, 41, 127, -98, -102, 38, -43, 106, -69, 56, 36, 8, 106, -104, -57, -79, -38, -93, -104, -111, -3, 121, -37, -27, 90, -60, 28, -71, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, -57, -20, -110, 126, 78, -8, -11, -106, -91, 103, 98, 42, -92, -16, 77, 17, 96, -48, 111, -115, 96, 88, 97, -84, 38, -69, 82, 53, 92, 8, -49, 48, -5, -88, 74, -106, -118, 31, 98, 66, 35, -116, 23, 15, -12, -70, 100, -100, 23, -84, 71, 41, -33, -99, -104, 94, -46, 108, 96, 113, 92, -94, -84, -36, 121, -29, -25, 110, 0, 71, 31, -75, 13, 40, -24, 2, -99, -28, -102, -3, 19, -12, -90, -39, 124, -79, -8, -36, 95, 35, 38, 9, -111, -128, 115, -48, 20, 27, -34, 67, -87, -125, 37, -14, -26, -100, 47, 21, -54, -2, -90, -85, -118, 7, 117, -117, 12, -35, 81, -124, 107, -28, -8, -47, -50, 119, -94, -127};
        return byArray;
    }

    private static byte[] getThawtePPRRootSelfSignedCert() {
        byte[] byArray = new byte[]{48, -126, 3, 41, 48, -126, 2, -110, -96, 3, 2, 1, 2, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -49, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 35, 48, 33, 6, 3, 85, 4, 3, 19, 26, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 80, 114, 101, 109, 105, 117, 109, 32, 67, 65, 49, 42, 48, 40, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 27, 112, 101, 114, 115, 111, 110, 97, 108, 45, 112, 114, 101, 109, 105, 117, 109, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, 30, 23, 13, 57, 54, 48, 49, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 48, 49, 50, 51, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -49, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 90, 65, 49, 21, 48, 19, 6, 3, 85, 4, 8, 19, 12, 87, 101, 115, 116, 101, 114, 110, 32, 67, 97, 112, 101, 49, 18, 48, 16, 6, 3, 85, 4, 7, 19, 9, 67, 97, 112, 101, 32, 84, 111, 119, 110, 49, 26, 48, 24, 6, 3, 85, 4, 10, 19, 17, 84, 104, 97, 119, 116, 101, 32, 67, 111, 110, 115, 117, 108, 116, 105, 110, 103, 49, 40, 48, 38, 6, 3, 85, 4, 11, 19, 31, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 83, 101, 114, 118, 105, 99, 101, 115, 32, 68, 105, 118, 105, 115, 105, 111, 110, 49, 35, 48, 33, 6, 3, 85, 4, 3, 19, 26, 84, 104, 97, 119, 116, 101, 32, 80, 101, 114, 115, 111, 110, 97, 108, 32, 80, 114, 101, 109, 105, 117, 109, 32, 67, 65, 49, 42, 48, 40, 6, 9, 42, -122, 72, -122, -9, 13, 1, 9, 1, 22, 27, 112, 101, 114, 115, 111, 110, 97, 108, 45, 112, 114, 101, 109, 105, 117, 109, 64, 116, 104, 97, 119, 116, 101, 46, 99, 111, 109, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -55, 102, -39, -8, 7, 68, -49, -71, -116, 46, -16, -95, -17, 19, 69, 108, 5, -33, -34, 39, 22, 81, 54, 65, 17, 108, 108, 59, -19, -2, 16, 125, 18, -98, -27, -101, 66, -102, -2, 96, 49, -61, 102, -73, 115, 58, 72, -82, 78, -48, 50, 55, -108, -120, -75, 13, -74, -39, -13, -14, 68, -39, -43, -120, 18, -35, 118, 77, -14, 26, -4, 111, 35, 30, 122, -15, -40, -104, 69, 78, 7, 16, -17, 22, 66, -48, 67, 117, 109, 74, -34, -30, -86, -55, 49, -1, 31, 0, 112, 124, 102, -49, 16, 37, 8, -70, -6, -18, 0, -23, 70, 3, 102, 39, 17, 21, 59, -86, 91, -14, -104, -35, 54, 66, -78, -38, -120, 117, 2, 3, 1, 0, 1, -93, 19, 48, 17, 48, 15, 6, 3, 85, 29, 19, 1, 1, -1, 4, 5, 48, 3, 1, 1, -1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 105, 54, -119, -9, 52, 42, 51, 114, 47, 109, 59, -44, 34, -78, -72, 111, -102, -59, 54, 102, 14, 27, 60, -95, -79, 117, 90, -26, -3, 53, -45, -8, -88, -14, 7, 111, -123, 103, -114, -34, 43, -71, -30, 23, -80, 58, -96, -16, 14, -94, 0, -102, -33, -13, 20, 21, 110, -69, -56, -123, 90, -104, -128, -7, -1, -66, 116, 29, 61, -13, -2, 48, 37, -47, 55, 52, 103, -6, -91, 113, 121, 48, 97, 41, 114, -64, -32, 44, 76, -5, 86, -28, 58, -88, 111, -27, 50, 89, 82, -37, 117, 40, 80, 89, 12, -8, 11, 25, -28, -84, -39, -81, -106, -115, 47, 80, -37, 7, -61, -22, 31, -85, 51, -32, -11, 43, 49, -119};
        return byArray;
    }

    private static byte[] getClass1IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 3, 102, 48, -126, 2, -49, -96, 3, 2, 1, 2, 2, 16, 13, -117, 79, -18, -86, -46, 24, 91, -12, 117, 106, -99, 41, -31, 127, -5, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 56, 48, 53, 49, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 56, 48, 53, 49, 50, 50, 51, 53, 57, 53, 57, 90, 48, -127, -52, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 44, 76, 73, 65, 66, 46, 76, 84, 68, 40, 99, 41, 57, 56, 49, 72, 48, 70, 6, 3, 85, 4, 3, 19, 63, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 67, 65, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 83, 117, 98, 115, 99, 114, 105, 98, 101, 114, 45, 80, 101, 114, 115, 111, 110, 97, 32, 78, 111, 116, 32, 86, 97, 108, 105, 100, 97, 116, 101, 100, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -69, 90, 68, -118, 4, 22, -69, 85, -3, 3, 122, -118, 45, -108, 79, 21, 120, 54, -72, 13, 74, -78, 111, -100, 84, -65, -68, -24, 119, 42, -99, -71, -16, 104, -69, -107, -39, 49, 65, 112, 122, -127, 75, -71, 72, 19, 86, 45, -57, 8, -31, -124, 66, -85, -64, -94, -110, -85, 68, 92, -86, 66, -16, -126, 14, 2, -23, 47, -5, -62, 59, -69, -66, -55, 39, 10, 93, -74, -80, 54, 66, 51, -75, 110, 84, -120, 79, -121, 74, -65, 25, -38, -7, 21, -24, 15, -121, -74, 28, -29, -52, -58, -102, -114, 127, 106, 36, -110, -29, -4, -32, 101, -70, -89, -79, 126, -17, -55, -37, 55, 106, -56, 74, -56, 9, 6, -28, -103, 2, 3, 1, 0, 1, -93, -127, -76, 48, -127, -79, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 53, 6, 3, 85, 29, 31, 4, 46, 48, 44, 48, 42, -96, 40, -96, 38, -122, 36, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 49, 46, 49, 46, 49, 46, 99, 114, 108, 48, 71, 6, 3, 85, 29, 32, 4, 64, 48, 62, 48, 60, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, 45, 48, 43, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 31, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 66, 124, 14, -33, -116, 121, 76, -84, -65, 8, -20, 77, 85, 47, 80, -119, -96, -59, 94, 78, 46, 94, -107, 50, -101, 121, -83, 101, 17, 11, 28, 74, 82, -60, -43, -88, 49, 33, -114, -34, 16, -101, 108, 8, -59, 7, -26, 3, -71, -25, -56, 52, 120, 9, 9, -14, -68, 6, 66, -8, 90, -116, -125, -47, -118, -34, -86, 34, -11, -39, -29, 33, -46, -49, 101, -116, 6, 51, -80, -51, 32, -78, 51, -51, 10, -67, 62, -31, -99, -63, 53, -87, 100, -80, -89, -91, 36, 91, -23, -15, 104, -21, 19, -60, 124, 55, -12, -108, 100, 13, -102, -59, -67, 51, 23, -17, -125, 51, -96, 62, -27, -86, 62, -82, -40, 115, 31, -83};
        return byArray;
    }

    private static byte[] getClass2IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 3, 82, 48, -126, 2, -69, -96, 3, 2, 1, 2, 2, 16, 82, -56, 32, 19, 124, -123, -89, -19, -14, 23, -50, -126, -56, 69, 22, 115, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 56, 48, 53, 49, 50, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 52, 48, 49, 48, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -72, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 70, 48, 68, 6, 3, 85, 4, 11, 19, 61, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 32, 73, 110, 99, 111, 114, 112, 46, 32, 66, 121, 32, 82, 101, 102, 46, 44, 76, 73, 65, 66, 46, 76, 84, 68, 40, 99, 41, 57, 56, 49, 52, 48, 50, 6, 3, 85, 4, 3, 19, 43, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 67, 65, 32, 45, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 83, 117, 98, 115, 99, 114, 105, 98, 101, 114, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -75, -53, 26, 84, 94, 37, -80, 44, 89, 95, 9, 107, -48, -38, -42, 74, 75, 17, -99, 26, 10, 62, 126, 47, -73, 101, 95, 23, 99, 21, -27, 44, -48, 32, 0, 12, -16, -70, 107, -86, 94, 73, -79, 104, -109, -125, 37, -84, 36, 95, -94, 35, 28, 105, 77, -72, 59, -37, 125, -38, -113, -63, 9, -49, -91, 88, 58, -74, 75, -60, -44, -37, -40, -82, 117, -6, -122, 34, -103, 34, 1, 40, 96, -91, -37, -43, 48, -33, 33, 112, 94, 72, -103, -83, 33, 84, -111, -47, -34, 95, -5, 56, 41, 83, 27, -30, 122, 83, 88, -59, 13, 93, 19, 7, -77, 80, -60, 6, 75, 57, -8, 84, -85, -71, -117, 105, 18, 19, 2, 3, 1, 0, 1, -93, -127, -76, 48, -127, -79, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 53, 6, 3, 85, 29, 31, 4, 46, 48, 44, 48, 42, -96, 40, -96, 38, -122, 36, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 50, 46, 49, 46, 49, 46, 99, 114, 108, 48, 71, 6, 3, 85, 29, 32, 4, 64, 48, 62, 48, 60, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, 45, 48, 43, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 31, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 101, 112, 111, 115, 105, 116, 111, 114, 121, 47, 82, 80, 65, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, -110, 11, 99, 81, 34, -22, -40, -23, 85, 95, -6, 56, -51, -45, 36, 94, -31, -12, 59, 24, -76, 73, -90, -88, -116, 20, 68, 17, 55, 20, -113, -102, 82, -72, -78, -124, -50, -35, -20, 23, -119, -43, 117, -60, -118, 82, -127, 7, -44, 88, 5, -39, -82, -97, -69, 8, -48, 100, -101, -103, -126, 86, 1, 47, -65, -34, 52, -95, -63, -119, 72, -41, -113, -117, 98, 22, -58, -123, -112, 101, 8, -40, 29, -7, -64, -73, 108, -53, 64, 126, 104, -17, -105, 33, 27, 52, -2, 90, -13, -96, -57, 95, 112, 3, 32, -19, -94, -126, -20, -26, -80, -63, -67, -13, 76, -21, -36, -96, 8, -95, 24, 65, 40, 47, -110, 127, 12, -71};
        return byArray;
    }

    private static byte[] getClass3IntermediateCert() {
        byte[] byArray = new byte[]{48, -126, 4, 49, 48, -126, 3, -102, -96, 3, 2, 1, 2, 2, 16, 35, 108, -105, 30, 43, -58, 13, 11, -7, 116, 96, -34, -15, 8, -61, -61, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 55, 48, 52, 49, 55, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 52, 48, 49, 48, 55, 50, 51, 53, 57, 53, 57, 90, 48, -127, -70, 49, 31, 48, 29, 6, 3, 85, 4, 10, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 23, 48, 21, 6, 3, 85, 4, 11, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 51, 48, 49, 6, 3, 85, 4, 11, 19, 42, 86, 101, 114, 105, 83, 105, 103, 110, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 32, 45, 32, 67, 108, 97, 115, 115, 32, 51, 49, 73, 48, 71, 6, 3, 85, 4, 11, 19, 64, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 98, 121, 32, 82, 101, 102, 46, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 32, 76, 84, 68, 46, 40, 99, 41, 57, 55, 32, 86, 101, 114, 105, 83, 105, 103, 110, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -40, -126, -128, -24, -42, 25, 2, 125, 31, -123, 24, 57, 37, -94, 101, 43, -31, -65, -44, 5, -45, -68, -26, 54, 59, -86, -16, 76, 108, 91, -74, -25, -86, 60, 115, 69, 85, -78, -15, -67, -22, -105, 66, -19, -102, 52, 10, 21, -44, -87, 92, -11, 64, 37, -35, -39, 7, -63, 50, -78, 117, 108, -60, -54, -69, -93, -2, 86, 39, 113, 67, -86, 99, -11, 48, 62, -109, 40, -27, -6, -15, 9, 59, -13, -73, 77, 78, 57, -9, 92, 73, 90, -72, -63, 29, -45, -78, -118, -2, 112, 48, -107, 66, -53, -2, 43, 81, -117, 90, 60, 58, -7, 34, 79, -112, -78, 2, -89, 83, -100, 79, 52, -25, -85, 4, -78, 123, 111, 2, 3, 1, 0, 1, -93, -126, 1, -112, 48, -126, 1, -116, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 32, 6, 3, 85, 29, 37, 4, 25, 48, 23, 6, 10, 96, -122, 72, 1, -122, -8, 69, 1, 8, 1, 6, 9, 96, -122, 72, 1, -122, -8, 66, 4, 1, 48, -126, 1, 53, 6, 3, 85, 29, 32, 4, -126, 1, 44, 48, -126, 1, 40, 48, -126, 1, 36, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, -126, 1, 19, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 48, -127, -26, 6, 8, 43, 6, 1, 5, 5, 7, 2, 2, 48, -127, -39, 48, 21, 22, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 48, 3, 2, 1, 1, 26, -127, -65, 86, 101, 114, 105, 83, 105, 103, 110, 39, 115, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 80, 114, 97, 99, 116, 105, 99, 101, 32, 83, 116, 97, 116, 101, 109, 101, 110, 116, 44, 32, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 44, 32, 103, 111, 118, 101, 114, 110, 115, 32, 116, 104, 105, 115, 32, 99, 101, 114, 116, 105, 102, 105, 99, 97, 116, 101, 32, 38, 32, 105, 115, 32, 105, 110, 99, 111, 114, 112, 111, 114, 97, 116, 101, 100, 32, 98, 121, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 104, 101, 114, 101, 105, 110, 46, 32, 83, 79, 77, 69, 32, 87, 65, 82, 82, 65, 78, 84, 73, 69, 83, 32, 68, 73, 83, 67, 76, 65, 73, 77, 69, 68, 32, 38, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 32, 76, 84, 68, 46, 32, 40, 99, 41, 49, 57, 57, 55, 32, 86, 101, 114, 105, 83, 105, 103, 110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -72, -116, -104, -61, 43, 72, -11, 114, -51, 104, 13, 26, -77, 116, 99, -69, -79, 88, -74, -104, 69, 34, -20, 17, -115, -57, 78, 51, -117, 98, 90, 33, 36, 108, -102, -64, 66, -76, 69, -87, 58, -5, 103, -16, -111, -66, 24, 31, -43, 72, 25, -109, 107, -115, -53, 55, 75, -122, -26, 125, -101, -3, -116, 120, -103, -1, -125, -62, -4, -39, 85, 6, -98, 49, 102, 70, 125, 27, 120, 96, -12, 85, -44, 108, 85, -56, 105, 98, 112, 124, 77, -74, -119, 6, 5, -101, -56, 67, -114, -52, 12, 40, -43, -47, -116, -51, 70, 80, -29, 49, -106, 102, -110, 17, 36, 30, 74, 91, 75, 102, 94, 101, 85, 30, 95, 55, -102, -82};
        return byArray;
    }

    private static byte[] getClass1G99Cert() {
        byte[] byArray = new byte[]{48, -126, 3, -125, 48, -126, 2, -20, -96, 3, 2, 1, 2, 2, 16, 37, 75, -118, -123, 56, 66, -52, -29, 88, -8, -59, -35, -82, 34, 110, -92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 55, 48, 52, 49, 55, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 49, 49, 48, 50, 52, 50, 51, 53, 57, 53, 57, 90, 48, -127, -70, 49, 31, 48, 29, 6, 3, 85, 4, 10, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 23, 48, 21, 6, 3, 85, 4, 11, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 51, 48, 49, 6, 3, 85, 4, 11, 19, 42, 86, 101, 114, 105, 83, 105, 103, 110, 32, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 32, 45, 32, 67, 108, 97, 115, 115, 32, 51, 49, 73, 48, 71, 6, 3, 85, 4, 11, 19, 64, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 32, 73, 110, 99, 111, 114, 112, 46, 98, 121, 32, 82, 101, 102, 46, 32, 76, 73, 65, 66, 73, 76, 73, 84, 89, 32, 76, 84, 68, 46, 40, 99, 41, 57, 55, 32, 86, 101, 114, 105, 83, 105, 103, 110, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -40, -126, -128, -24, -42, 25, 2, 125, 31, -123, 24, 57, 37, -94, 101, 43, -31, -65, -44, 5, -45, -68, -26, 54, 59, -86, -16, 76, 108, 91, -74, -25, -86, 60, 115, 69, 85, -78, -15, -67, -22, -105, 66, -19, -102, 52, 10, 21, -44, -87, 92, -11, 64, 37, -35, -39, 7, -63, 50, -78, 117, 108, -60, -54, -69, -93, -2, 86, 39, 113, 67, -86, 99, -11, 48, 62, -109, 40, -27, -6, -15, 9, 59, -13, -73, 77, 78, 57, -9, 92, 73, 90, -72, -63, 29, -45, -78, -118, -2, 112, 48, -107, 66, -53, -2, 43, 81, -117, 90, 60, 58, -7, 34, 79, -112, -78, 2, -89, 83, -100, 79, 52, -25, -85, 4, -78, 123, 111, 2, 3, 1, 0, 1, -93, -127, -29, 48, -127, -32, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 68, 6, 3, 85, 29, 32, 4, 61, 48, 59, 48, 57, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 1, 1, 48, 42, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 67, 80, 83, 48, 52, 6, 3, 85, 29, 37, 4, 45, 48, 43, 6, 8, 43, 6, 1, 5, 5, 7, 3, 1, 6, 8, 43, 6, 1, 5, 5, 7, 3, 2, 6, 9, 96, -122, 72, 1, -122, -8, 66, 4, 1, 6, 10, 96, -122, 72, 1, -122, -8, 69, 1, 8, 1, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 49, 6, 3, 85, 29, 31, 4, 42, 48, 40, 48, 38, -96, 36, -96, 34, -122, 32, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 51, 46, 99, 114, 108, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 8, 1, -20, -28, 104, -108, 3, 66, -15, 115, -15, 35, -94, 58, -34, -23, -15, -38, -58, 84, -60, 35, 62, -122, -22, -49, 106, 58, 51, -85, -22, -100, 4, 20, 7, 54, 6, 11, -7, -120, 111, -43, 19, -18, 41, 43, -61, -28, 114, -115, 68, -19, -47, -84, 32, 9, 45, -31, -10, -31, 25, 5, 56, -80, 61, 15, -97, 127, -8, -98, 2, -36, -122, 2, -122, 97, 78, 38, 95, 94, -97, -110, 30, 12, 36, -92, -11, -48, 112, 19, -49, 38, -61, 67, 61, 73, 29, -98, -126, 46, 82, 95, -68, 62, -58, 102, 41, 1, -114, 78, -110, 44, -68, 70, 117, 3, -126, -84, 115, -23, -39, 126, 11, 103, -17, 84, 82, 26};
        return byArray;
    }

    private static byte[] getClass1G88Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 57, 48, -126, 2, -94, -96, 3, 2, 1, 2, 2, 16, 67, -34, 69, 6, 126, -111, -19, 59, -74, 112, -28, 23, 82, 102, 73, -75, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 48, 57, 49, 48, 49, 50, 50, 51, 53, 57, 53, 57, 90, 48, 67, 49, 17, 48, 15, 6, 3, 85, 4, 10, 19, 8, 86, 101, 114, 105, 83, 105, 103, 110, 49, 46, 48, 44, 6, 3, 85, 4, 11, 19, 37, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 79, 110, 83, 105, 116, 101, 32, 73, 110, 100, 105, 118, 105, 100, 117, 97, 108, 32, 67, 65, 48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -36, 42, -103, -99, 110, 51, -4, -69, 65, 118, -60, 57, 30, -115, -9, 118, -25, -112, 15, 116, 85, 97, 97, 114, 60, -8, 55, 75, 27, 31, 8, -23, 48, 29, 112, -59, 22, -119, 96, 51, 70, 72, 127, -58, -48, -102, 61, 118, -104, -61, -95, -63, -84, 82, -47, 23, -71, 20, 4, 105, -122, 92, 97, 79, -77, 101, 101, -117, 99, -94, -18, 33, 124, 65, -81, -83, 114, 64, -61, 77, -111, -77, 73, -66, -104, -5, 87, -57, 90, 46, -80, 75, -89, -17, 9, 36, -13, -127, -99, 56, -59, -110, -38, 74, -89, -104, 81, -87, -40, 48, 118, 45, 106, -42, -81, 47, 126, -37, 17, 42, -123, -5, 101, 96, 90, 69, -24, 27, 2, 1, 3, -93, -127, -80, 48, -127, -83, 48, 15, 6, 3, 85, 29, 19, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 68, 6, 3, 85, 29, 32, 4, 61, 48, 59, 48, 57, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 23, 2, 48, 42, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 112, 97, 48, 52, 6, 3, 85, 29, 31, 4, 45, 48, 43, 48, 41, -96, 39, -96, 37, -122, 35, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 50, 45, 103, 50, 46, 99, 114, 108, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -119, -112, -66, -82, 115, -107, -36, 66, 30, 77, -96, -113, -17, 2, -5, -87, 104, 91, 11, -19, 44, 69, -77, -120, -21, -114, 78, -49, 52, -118, -90, 53, 14, -125, -116, -48, -76, 19, 47, -21, -86, -107, -4, 54, 126, 104, -123, -100, -4, 55, 89, 83, -54, -71, 12, 6, -124, -31, 59, 100, 7, 11, 33, 52, 68, 117, -120, 55, 54, -59, -75, 88, 13, -88, 56, 59, -81, -96, 97, -72, 124, 108, 23, -97, -31, -1, -31, -38, 67, -88, 66, -122, 2, 93, 74, -19, -100, -112, -115, 18, -86, 76, -62, 110, 3, -104, 31, 67, -81, 126, -101, 73, -75, -76, 116, -93, 110, -83, 106, 91, -21, 47, -79, -53, -102, 30, -90, -102};
        return byArray;
    }

    private static byte[] getClass1G2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 76, -57, -22, -86, -104, 62, 113, -45, -109, 16, -8, 61, 58, -119, -111, -110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -86, -48, -70, -66, 22, 45, -72, -125, -44, -54, -46, 15, -68, 118, 49, -54, -108, -40, 29, -109, -116, 86, 2, -68, -39, 111, 26, 111, 82, 54, 110, 117, 86, 10, 85, -45, -33, 67, -121, 33, 17, 101, -118, 126, -113, -67, 33, -34, 107, 50, 63, 27, -124, 52, -107, 5, -99, 65, 53, -21, -110, -21, -106, -35, -86, 89, 63, 1, 83, 109, -103, 79, -19, -27, -30, 42, 90, -112, -63, -71, -60, -90, 21, -49, -56, 69, -21, -90, 93, -114, -100, 62, -16, 100, 36, 118, -91, -51, -85, 26, 111, -74, -40, 123, 81, 97, 110, -90, 127, -121, -56, -30, -73, -27, 52, -36, 65, -120, -22, 9, 64, -66, 115, -110, 61, 107, -25, 117, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -87, 79, -61, 13, -57, 103, -66, 44, -53, -39, -88, -51, 45, 117, -25, 126, 21, -98, 59, 114, -21, 126, -21, 92, 45, 9, -121, -42, 107, 109, 96, 124, -27, -82, -59, -112, 35, 12, 92, 74, -48, -81, -79, 93, -13, -57, -74, 10, -37, -32, 21, -109, 13, -35, 3, -68, -57, 118, -118, -75, -35, 79, -61, -101, 19, 117, -72, 1, -64, -26, -55, 91, 107, -91, -72, -119, -36, -84, -92, -35, 114, -19, 78, -95, -9, 79, -68, 6, -45, -22, -56, 100, 116, 123, -62, -107, 65, -100, 101, 115, 88, -15, -112, -102, 60, 106, -79, -104, -55, -60, -121, -68, -49, 69, 109, 69, -30, 110, 34, 63, -2, -68, 15, 49, 92, -24, -14, -39};
        return byArray;
    }

    private static byte[] getClass2G2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 3, 48, -126, 2, 108, 2, 17, 0, -71, 47, 96, -52, -120, -97, -95, 122, 70, 9, -72, 91, 112, 108, -118, -81, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -89, -120, 1, 33, 116, 44, -25, 26, 3, -16, -104, -31, -105, 60, 15, 33, 8, -15, -100, -37, -105, -23, -102, -4, -62, 4, 6, 19, -66, 95, 82, -56, -52, 30, 44, 18, 86, 44, -72, 1, 105, 44, -52, -103, 31, -83, -80, -106, -82, 121, 4, -14, 19, 57, -63, 123, -104, -70, 8, 44, -24, -62, -124, 19, 44, -86, 105, -23, 9, -12, -57, -87, 2, -92, 66, -62, 35, 79, 74, -40, -16, 14, -94, -5, 49, 108, -55, -26, 111, -103, 39, 7, -11, -26, -12, 76, 120, -98, 109, -21, 70, -122, -6, -71, -122, -55, 84, -14, -78, -60, -81, -44, 70, 28, 90, -55, 21, 48, -1, 13, 108, -11, 45, 14, 109, -50, 127, 119, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 114, 46, -7, 127, -47, -15, 113, -5, -60, -98, -10, -59, 94, 81, -118, 64, -104, -72, 104, -8, -101, 28, -125, -40, -30, -99, -67, -1, -19, -95, -26, 102, -22, 47, 9, -12, -54, -41, -22, -91, 43, -107, -10, 36, 96, -122, 77, 68, 46, -125, -91, -60, 45, -96, -45, -82, 120, 105, 111, 114, -38, 108, -82, 8, -16, 99, -110, 55, -26, -69, -60, 48, 23, -83, 119, -52, 73, 53, -86, -49, -40, -113, -47, -66, -73, 24, -106, 71, 115, 106, 84, 34, 52, 100, 45, -74, 22, -101, 89, 91, -76, 81, 89, 58, -77, 11, 20, -12, 18, -33, 103, -96, -12, -83, 50, 100, 94, -79, 70, 114, 39, -116, 18, 123, -59, 68, -76, -82};
        return byArray;
    }

    private static byte[] getClass3G2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 125, -39, -2, 7, -49, -88, 30, -73, 16, 121, 103, -5, -89, -119, 52, -58, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -52, 94, -47, 17, 93, 92, 105, -48, -85, -45, -71, 106, 76, -103, 31, 89, -104, 48, -114, 22, -123, 32, 70, 109, 71, 63, -44, -123, 32, -124, -31, 109, -77, -8, -92, -19, 12, -15, 23, 15, 59, -7, -89, -7, 37, -41, -63, -49, -124, 99, -14, 124, 99, -49, -94, 71, -14, -58, 91, 51, -114, 100, 64, 4, 104, -63, -128, -71, 100, 28, 69, 119, -57, -40, 110, -11, -107, 41, 60, 80, -24, 52, -41, 120, 31, -88, -70, 109, 67, -111, -107, -113, 69, 87, 94, 126, -59, -5, -54, -92, 4, -21, -22, -105, 55, 84, 48, 111, -69, 1, 71, 50, 51, -51, -36, 87, -101, 100, 105, 97, -8, -101, 29, 28, -119, 79, 92, 103, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 81, 77, -51, -66, 92, -53, -104, 25, -100, 21, -78, 1, 57, 120, 46, 77, 15, 103, 112, 112, -103, -58, 16, 90, -108, -92, 83, 77, 84, 109, 43, -81, 13, 93, 64, -117, 100, -45, -41, -18, -34, 86, 97, -110, 95, -90, -60, 29, 16, 97, 54, -45, 44, 39, 60, -24, 41, 9, -71, 17, 100, 116, -52, -75, 115, -97, 28, 72, -87, -68, 97, 1, -18, -30, 23, -90, 12, -29, 64, 8, 59, 14, -25, -21, 68, 115, 42, -102, -15, 105, -110, -17, 113, 20, -61, 57, -84, 113, -89, -111, 9, 111, -28, 113, 6, -77, -70, 89, 87, 38, 121, 0, -10, -8, 13, -94, 51, 48, 40, -44, -86, 88, -96, -99, -99, 105, -111, -3};
        return byArray;
    }

    private static byte[] getVerisignClass1PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -117, 91, 117, 86, -124, 84, -123, 11, 0, -49, -81, 56, 72, -50, -79, -92, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -35, -124, -44, -71, -76, -7, -89, -40, -13, 4, 120, -100, -34, 61, -36, 108, 19, 22, -39, 122, -35, 36, 81, 102, -64, -57, 38, 89, 13, -84, 6, 8, -62, -108, -47, 51, 31, -16, -125, 53, 31, 110, 27, -56, -34, -86, 110, 21, 78, 84, 39, -17, -60, 109, 26, -20, 11, -29, 14, -16, 68, -91, 87, -57, 64, 88, 30, -93, 71, 31, 113, -20, 96, -10, 109, -108, -56, 24, 57, -19, -2, 66, 24, 86, -33, -28, 76, 73, 16, 120, 78, 1, 118, 53, 99, 18, 54, -35, 102, -68, 1, 4, 54, -93, 85, 104, -43, -94, 54, 9, -84, -85, 33, 38, 84, 6, -83, 63, -54, 20, -32, -84, -54, -83, 6, 29, -107, -30, -8, -99, -15, -32, 96, -1, -62, 127, 117, 43, 76, -52, -38, -2, -121, -103, 33, -22, -70, -2, 62, 84, -41, -46, 89, 120, -37, 60, 110, -49, -96, 19, 0, 26, -72, 39, -95, -28, -66, 103, -106, -54, -96, -59, -77, -100, -35, -55, 117, -98, -21, 48, -102, 95, -93, -51, -39, -82, 120, 25, 63, 35, -23, 92, -37, 41, -67, -83, 85, -56, 27, 84, -116, 99, -10, -24, -90, -22, -57, 55, 18, 92, -93, 41, 30, 2, -39, -37, 31, 59, -76, -41, 15, 86, 71, -127, 21, 4, 74, -81, -125, 39, -47, -59, 88, -120, -63, -35, -10, -86, -89, -93, 24, -38, 104, -86, 109, 17, 81, -31, -65, 101, 107, -97, -106, 118, -47, 61, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -85, 102, -115, -41, -77, -70, -57, -102, -74, -26, 85, -48, 5, -15, -97, 49, -115, 90, -86, -39, -86, 70, 38, 15, 113, -19, -91, -83, 83, 86, 98, 1, 71, 42, 68, -23, -2, 63, 116, 11, 19, -101, -71, -12, 77, 27, -78, -47, 95, -78, -74, -46, -120, 92, -77, -97, -51, -53, -44, -89, -39, 96, -107, -124, 58, -8, -63, 55, 29, 97, -54, -25, -80, -59, -27, -111, -38, 84, -90, -84, 49, -127, -82, -105, -34, -51, 8, -84, -72, -64, -105, -128, 127, 110, 114, -92, -25, 105, 19, -107, 101, 31, -60, -109, 60, -3, 121, -113, 4, -44, 62, 79, -22, -9, -98, -50, -51, 103, 124, 79, 101, 2, -1, -111, -123, 84, 115, -57, -1, 54, -9, -122, 45, -20, -48, 94, 79, -1, 17, -97, 114, 6, -42, -72, 26, -15, 76, 13, 38, 101, -30, 68, -128, 30, -57, -97, -29, -35, -24, 10, -38, -20, -91, 32, -128, 105, 104, -95, 79, 126, -31, 107, -49, 7, 65, -6, -125, -114, -68, 56, -35, -80, 46, 17, -79, 107, -78, 66, -52, -102, -68, -7, 72, 34, 121, 74, 25, 15, -78, 28, 62, 32, 116, -39, 106, -61, -66, -14, 40, 120, 19, 86, 121, 79, 109, 80, -22, 27, -80, -75, 87, -79, 55, 102, 88, 35, -13, -36, 15, -33, 10, -121, -60, -17, -122, 5, -43, 56, 20, 96, -103, -93, 75, -34, 6, -106, 113, 44, -14, -37, -74, 31, -92, -17, 63, -18};
        return byArray;
    }

    private static byte[] getVeriSignClass2PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 25, 48, -126, 3, 1, 2, 16, 97, 112, -53, 73, -116, 95, -104, 69, 41, -25, -80, -90, -39, 80, 91, 122, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -81, 10, 13, -62, -43, 44, -37, 103, -71, 45, -27, -108, 39, -35, -91, -66, -32, -80, 77, -113, -77, 97, 86, 60, -42, 124, -61, -12, -51, 62, -122, -53, -94, -120, -30, -31, -40, -92, 105, -59, -75, -30, -65, -63, -90, 71, 80, 94, 70, 57, -117, -43, -106, -70, -75, 111, 20, -65, 16, -50, 39, 19, -98, 5, 71, -101, 49, 122, 19, -40, 31, -39, -45, 2, 55, -117, -83, 44, 71, -16, -114, -127, 6, -89, 13, 48, 12, -21, -9, 60, 15, 32, 29, -36, 114, 70, -18, -91, 2, -56, 91, -61, -55, 86, 105, 76, -59, 24, -63, -111, 123, 11, -43, 19, 0, -101, -68, -17, -61, 72, 62, 70, 96, 32, -123, 42, -43, -112, -74, -51, -117, -96, -52, 50, -35, -73, -3, 64, 85, -78, 80, 28, 86, -82, -52, -115, 119, 77, -57, 32, 77, -89, 49, 118, -17, 104, -110, -118, -112, 30, 8, -127, 86, -78, -83, 105, -93, 82, -48, -53, 28, -60, 35, 61, 31, -103, -2, 76, -24, 22, 99, -114, -58, 8, -114, -10, 49, -10, -46, -6, -27, 118, -35, -75, 28, -110, -93, 73, -51, -51, 1, -51, 104, -51, -87, 105, -70, -93, -21, 29, 13, -100, -92, 32, -90, -63, -96, -59, -47, 70, 76, 23, 109, -46, -84, 102, 63, -106, -116, -32, -124, -44, 54, -1, 34, 89, -59, -7, 17, 96, -88, 95, 4, 125, -14, 26, -10, 37, 66, 97, 15, -60, 74, -72, 62, -119, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 52, 38, 21, 60, -64, -115, 77, 67, 73, 29, -67, -23, 33, -110, -41, 102, -100, -73, -34, -59, -72, -48, -28, 93, 95, 118, 34, -64, 38, -7, -124, 58, 58, -7, -116, -75, -5, -20, 96, -15, -24, -50, 4, -80, -56, -35, -89, 3, -113, 48, -13, -104, -33, -92, -26, -92, 49, -33, -45, 28, 11, 70, -36, 114, 32, 63, -82, -18, 5, 60, -92, 51, 63, 11, 57, -84, 112, 120, 115, 75, -103, 43, -33, 48, -62, 84, -80, -88, 59, 85, -95, -2, 22, 40, -51, 66, -67, 116, 110, -128, -37, 39, 68, -89, -50, 68, 93, -44, 27, -112, -104, 13, 30, 66, -108, -79, 0, 44, 4, -48, 116, -93, 2, 5, 34, 99, 99, -51, -125, -75, -5, -63, 109, 98, 107, 105, 117, -3, 93, 112, 65, -71, -11, -65, 124, -33, -66, -63, 50, 115, 34, 33, -117, 88, -127, 123, 21, -111, 122, -70, -29, 100, 72, -80, 127, -5, 54, 37, -38, -107, -48, -15, 36, 20, 23, -35, 24, -128, 107, 70, 35, 57, 84, -11, -114, 98, 9, 4, 29, -108, -112, -90, -101, -26, 37, -30, 66, 69, -86, -72, -112, -83, -66, 8, -113, -87, 11, 66, 24, -108, -49, 114, 57, -31, -79, 67, -32, 40, -49, -73, -25, 90, 108, 19, 107, 73, -77, -1, -29, 24, 124, -119, -117, 51, 93, -84, 51, -41, -89, -7, -38, 58, 85, -55, 88, 16, -7, -86, -17, 90, -74, -49, 75, 75, -33, 42};
        return byArray;
    }

    private static byte[] getVerisignClass3PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -101, 126, 6, 73, -93, 62, 98, -71, -43, -18, -112, 72, 113, 41, -17, 87, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -53, -70, -100, 82, -4, 120, 31, 26, 30, 111, 27, 55, 115, -67, -8, -55, 107, -108, 18, 48, 79, -16, 54, 71, -11, -48, -111, 10, -11, 23, -56, -91, 97, -63, 22, 64, 77, -5, -118, 97, -112, -27, 118, 32, -63, 17, 6, 125, -85, 44, 110, -90, -11, 17, 65, -114, -6, 45, -83, 42, 97, 89, -92, 103, 38, 76, -48, -24, -68, 82, 91, 112, 32, 4, 88, -47, 122, -55, -92, 105, -68, -125, 23, 100, -83, 5, -117, -68, -48, 88, -50, -115, -116, -11, -21, -16, 66, 73, 11, -99, -105, 39, 103, 50, 110, -31, -82, -109, 21, 28, 112, -68, 32, 77, 47, 24, -34, -110, -120, -24, 108, -123, 87, 17, 26, -23, 126, -29, 38, 17, 84, -94, 69, -106, 85, -125, -54, 48, -119, -24, -36, -40, -93, -19, 42, -128, 63, 127, 121, 101, 87, 62, 21, 32, 102, 8, 47, -107, -109, -65, -86, 71, 47, -88, 70, -105, -16, 18, -30, -2, -62, 10, 43, 81, -26, 118, -26, -73, 70, -73, -30, 13, -90, -52, -88, -61, 76, 89, 85, -119, -26, -24, 83, 92, 28, -22, -99, -16, 98, 22, 11, -89, -55, 95, 12, -16, -34, -62, 118, -50, -81, -9, 106, -14, -6, 65, -90, -94, 51, 20, -55, -27, 122, 99, -45, -98, 98, 55, -43, -123, 101, -98, 14, -26, 83, 36, 116, 27, 94, 29, 18, 83, 91, -57, 44, -25, -125, 73, 59, 21, -82, -118, 104, -71, 87, -105, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 17, 20, -106, -63, -85, -110, 8, -9, 63, 47, -55, -78, -2, -28, 90, -97, 100, -34, -37, 33, 79, -122, -103, 52, 118, 54, 87, -35, -48, 21, 47, -59, -83, 127, 21, 31, 55, 98, 115, 62, -44, -25, 95, -50, 23, 3, -37, 53, -6, 43, -37, -82, 96, 9, 95, 30, 95, -113, 110, -69, 11, 61, -22, 90, 19, 30, 12, 96, 111, -75, -64, -75, 35, 34, 46, 7, 11, -53, -87, 116, -53, 71, -69, 29, -63, -41, -91, 107, -52, 47, -46, 66, -3, 73, -35, -89, -119, -49, 83, -70, -38, 0, 90, 40, -65, -126, -33, -8, -70, 19, 29, 80, -122, -126, -3, -114, 48, -113, 41, 70, -80, 30, 61, 53, -38, 56, 98, 22, 24, 74, -83, -26, -74, 81, 108, -34, -81, 98, -21, 1, -48, 30, 36, -2, 122, -113, 18, 26, 18, 104, -72, -5, 102, -103, 20, 20, 69, 92, -82, -25, -82, 105, 23, -127, 43, 90, 55, -55, 94, 42, -12, -58, -30, -95, 92, 84, -101, -90, 84, 0, -49, -16, -15, -63, -57, -104, 48, 26, 59, 54, 22, -37, -93, 110, -22, -3, -83, -78, -62, -38, -17, 2, 71, 19, -118, -64, -15, -77, 49, -83, 79, 28, -31, 79, -100, -81, 15, 12, -99, -9, 120, 13, -40, -12, 53, 86, -128, -38, -73, 109, 23, -113, -99, 30, -127, 100, -31, -2, -59, 69, -70, -83, 107, -71, 10, 122, 78, 79, 75, -124, -18, 75, -15, 125, -35, 17};
        return byArray;
    }

    public static byte[] getVerisignClass4PublicPrimaryCAG3Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 26, 48, -126, 3, 2, 2, 17, 0, -20, -96, -89, -117, 110, 117, 106, 1, -49, -60, 124, -52, 47, -108, 94, -41, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, 30, 23, 13, 57, 57, 49, 48, 48, 49, 48, 48, 48, 48, 48, 48, 90, 23, 13, 51, 54, 48, 55, 49, 54, 50, 51, 53, 57, 53, 57, 90, 48, -127, -54, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 57, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 69, 48, 67, 6, 3, 85, 4, 3, 19, 60, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 51, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, -53, -91, 17, 105, -58, 89, -85, -15, -113, -75, 25, 15, 86, -50, -52, -75, 31, 32, -28, -98, 38, 37, 75, -32, 115, 101, -119, 89, -34, -48, -125, -28, -11, 15, -75, -69, -83, -15, 124, -24, 33, -4, -28, -24, 12, -18, 124, 69, 34, 25, 118, -110, -76, 19, -73, 32, 91, 9, -6, 97, -82, -88, -14, -91, -115, -123, -62, 42, -42, -34, 102, 54, -46, -101, 2, -12, -88, -110, 96, 124, -100, 105, -76, -113, 36, 30, -48, -122, 82, -10, 50, -100, 65, 88, 30, 34, -67, -51, 69, 98, -107, 8, 110, -48, 102, -35, 83, -94, -52, -16, 16, -36, 84, 115, -117, 4, -95, 70, 51, 51, 92, 23, 64, -71, -98, 77, -45, -13, -66, 85, -125, -24, -79, -119, -114, 90, 124, -102, -106, 34, -112, 59, -120, 37, -14, -46, 83, -120, 2, 12, 11, 120, -14, -26, 55, 23, 75, 48, 70, 7, -28, -128, 109, -90, -40, -106, 46, -24, 44, -8, 17, -77, 56, 13, 102, -90, -101, -22, -55, 35, 91, -37, -114, -30, -13, 19, -114, 26, 89, 45, -86, 2, -16, -20, -92, -121, 102, -36, -63, 63, -11, -40, -71, -12, -20, -126, -58, -46, 61, -107, 29, -27, -64, 79, -124, -55, -39, -93, 68, 40, 6, 106, -41, 69, -84, -16, 107, 106, -17, 78, 95, -8, 17, -126, 30, 56, 99, 52, 102, 80, -44, 62, -109, 115, -6, 48, -61, 102, -83, -1, -109, 45, -105, -17, 3, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, -113, -6, 37, 107, 79, 91, -28, -92, 78, 39, 85, -85, 34, 21, 89, 60, -54, -75, 10, -44, 74, -37, -85, -35, -95, 95, 83, -59, -96, 87, 57, -62, -50, 71, 43, -66, 58, -56, 86, -65, -62, -39, 39, 16, 58, -79, 5, 60, -64, 119, 49, -69, 58, -45, 5, 123, 109, -102, 28, 48, -116, -128, -53, -109, -109, 42, -125, -85, 5, 81, -126, 2, 0, 17, 103, 107, -13, -120, 97, 71, 95, 3, -109, -43, 91, 13, -32, -15, -44, -95, 50, 53, -123, -78, 58, -37, -80, -126, -85, -47, -53, 10, -68, 79, -116, 91, -59, 75, 0, 59, 31, 42, -126, -90, 126, 54, -123, -36, 126, 60, 103, 0, -75, -28, 59, 82, -32, -88, -21, 93, 21, -7, -58, 109, -16, -83, 29, 14, -123, -73, -87, -102, 115, 20, 90, 91, -113, 65, 40, -64, -43, -24, 45, 77, -92, 94, -51, -86, -39, -19, -50, -36, -40, -43, 60, 66, 29, 23, -63, 18, 93, 69, 56, -61, 56, -13, -4, -123, 46, -125, 70, 72, -78, -41, 32, 95, -110, 54, -113, -25, 121, 15, -104, 94, -103, -24, -16, -48, -92, -69, -11, 83, -67, 42, -50, 89, -80, -81, 110, 127, 108, -69, -46, 30, 0, -80, 33, -19, -8, 65, 98, -126, -71, -40, -78, -60, -69, 70, 80, -13, 49, -59, -113, 1, -88, 116, -21, -11, 120, 39, -38, -25, -9, 102, 67, -13, -98, -125, 62, 32, -86, -61, 53, 96, -111, -50};
        return byArray;
    }

    private static byte[] getVeriSignClass1PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 76, -57, -22, -86, -104, 62, 113, -45, -109, 16, -8, 61, 58, -119, -111, -110, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -86, -48, -70, -66, 22, 45, -72, -125, -44, -54, -46, 15, -68, 118, 49, -54, -108, -40, 29, -109, -116, 86, 2, -68, -39, 111, 26, 111, 82, 54, 110, 117, 86, 10, 85, -45, -33, 67, -121, 33, 17, 101, -118, 126, -113, -67, 33, -34, 107, 50, 63, 27, -124, 52, -107, 5, -99, 65, 53, -21, -110, -21, -106, -35, -86, 89, 63, 1, 83, 109, -103, 79, -19, -27, -30, 42, 90, -112, -63, -71, -60, -90, 21, -49, -56, 69, -21, -90, 93, -114, -100, 62, -16, 100, 36, 118, -91, -51, -85, 26, 111, -74, -40, 123, 81, 97, 110, -90, 127, -121, -56, -30, -73, -27, 52, -36, 65, -120, -22, 9, 64, -66, 115, -110, 61, 107, -25, 117, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -87, 79, -61, 13, -57, 103, -66, 44, -53, -39, -88, -51, 45, 117, -25, 126, 21, -98, 59, 114, -21, 126, -21, 92, 45, 9, -121, -42, 107, 109, 96, 124, -27, -82, -59, -112, 35, 12, 92, 74, -48, -81, -79, 93, -13, -57, -74, 10, -37, -32, 21, -109, 13, -35, 3, -68, -57, 118, -118, -75, -35, 79, -61, -101, 19, 117, -72, 1, -64, -26, -55, 91, 107, -91, -72, -119, -36, -84, -92, -35, 114, -19, 78, -95, -9, 79, -68, 6, -45, -22, -56, 100, 116, 123, -62, -107, 65, -100, 101, 115, 88, -15, -112, -102, 60, 106, -79, -104, -55, -60, -121, -68, -49, 69, 109, 69, -30, 110, 34, 63, -2, -68, 15, 49, 92, -24, -14, -39};
        return byArray;
    }

    private static byte[] getVeriSignClass2PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 3, 48, -126, 2, 108, 2, 17, 0, -71, 47, 96, -52, -120, -97, -95, 122, 70, 9, -72, 91, 112, 108, -118, -81, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -89, -120, 1, 33, 116, 44, -25, 26, 3, -16, -104, -31, -105, 60, 15, 33, 8, -15, -100, -37, -105, -23, -102, -4, -62, 4, 6, 19, -66, 95, 82, -56, -52, 30, 44, 18, 86, 44, -72, 1, 105, 44, -52, -103, 31, -83, -80, -106, -82, 121, 4, -14, 19, 57, -63, 123, -104, -70, 8, 44, -24, -62, -124, 19, 44, -86, 105, -23, 9, -12, -57, -87, 2, -92, 66, -62, 35, 79, 74, -40, -16, 14, -94, -5, 49, 108, -55, -26, 111, -103, 39, 7, -11, -26, -12, 76, 120, -98, 109, -21, 70, -122, -6, -71, -122, -55, 84, -14, -78, -60, -81, -44, 70, 28, 90, -55, 21, 48, -1, 13, 108, -11, 45, 14, 109, -50, 127, 119, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 114, 46, -7, 127, -47, -15, 113, -5, -60, -98, -10, -59, 94, 81, -118, 64, -104, -72, 104, -8, -101, 28, -125, -40, -30, -99, -67, -1, -19, -95, -26, 102, -22, 47, 9, -12, -54, -41, -22, -91, 43, -107, -10, 36, 96, -122, 77, 68, 46, -125, -91, -60, 45, -96, -45, -82, 120, 105, 111, 114, -38, 108, -82, 8, -16, 99, -110, 55, -26, -69, -60, 48, 23, -83, 119, -52, 73, 53, -86, -49, -40, -113, -47, -66, -73, 24, -106, 71, 115, 106, 84, 34, 52, 100, 45, -74, 22, -101, 89, 91, -76, 81, 89, 58, -77, 11, 20, -12, 18, -33, 103, -96, -12, -83, 50, 100, 94, -79, 70, 114, 39, -116, 18, 123, -59, 68, -76, -82};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 125, -39, -2, 7, -49, -88, 30, -73, 16, 121, 103, -5, -89, -119, 52, -58, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -52, 94, -47, 17, 93, 92, 105, -48, -85, -45, -71, 106, 76, -103, 31, 89, -104, 48, -114, 22, -123, 32, 70, 109, 71, 63, -44, -123, 32, -124, -31, 109, -77, -8, -92, -19, 12, -15, 23, 15, 59, -7, -89, -7, 37, -41, -63, -49, -124, 99, -14, 124, 99, -49, -94, 71, -14, -58, 91, 51, -114, 100, 64, 4, 104, -63, -128, -71, 100, 28, 69, 119, -57, -40, 110, -11, -107, 41, 60, 80, -24, 52, -41, 120, 31, -88, -70, 109, 67, -111, -107, -113, 69, 87, 94, 126, -59, -5, -54, -92, 4, -21, -22, -105, 55, 84, 48, 111, -69, 1, 71, 50, 51, -51, -36, 87, -101, 100, 105, 97, -8, -101, 29, 28, -119, 79, 92, 103, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 81, 77, -51, -66, 92, -53, -104, 25, -100, 21, -78, 1, 57, 120, 46, 77, 15, 103, 112, 112, -103, -58, 16, 90, -108, -92, 83, 77, 84, 109, 43, -81, 13, 93, 64, -117, 100, -45, -41, -18, -34, 86, 97, -110, 95, -90, -60, 29, 16, 97, 54, -45, 44, 39, 60, -24, 41, 9, -71, 17, 100, 116, -52, -75, 115, -97, 28, 72, -87, -68, 97, 1, -18, -30, 23, -90, 12, -29, 64, 8, 59, 14, -25, -21, 68, 115, 42, -102, -15, 105, -110, -17, 113, 20, -61, 57, -84, 113, -89, -111, 9, 111, -28, 113, 6, -77, -70, 89, 87, 38, 121, 0, -10, -8, 13, -94, 51, 48, 40, -44, -86, 88, -96, -99, -99, 105, -111, -3};
        return byArray;
    }

    private static byte[] getVeriSignClass4PublicPrimaryCAG2Cert() {
        byte[] byArray = new byte[]{48, -126, 3, 2, 48, -126, 2, 107, 2, 16, 50, -120, -114, -102, -46, -11, -21, 19, 71, -8, 127, -60, 32, 55, 37, -8, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, 30, 23, 13, 57, 56, 48, 53, 49, 56, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, -127, -63, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 67, 108, 97, 115, 115, 32, 52, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 45, 32, 71, 50, 49, 58, 48, 56, 6, 3, 85, 4, 11, 19, 49, 40, 99, 41, 32, 49, 57, 57, 56, 32, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 32, 45, 32, 70, 111, 114, 32, 97, 117, 116, 104, 111, 114, 105, 122, 101, 100, 32, 117, 115, 101, 32, 111, 110, 108, 121, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -70, -16, -28, -49, -7, -60, -82, -123, 84, -71, 7, 87, -7, -113, -59, 127, 104, 17, -8, -60, 23, -80, 68, -36, -29, 48, 115, -43, 42, 98, 42, -72, -48, -52, 28, -19, 40, 91, 126, -67, 106, -36, -77, -111, 36, -54, 65, 98, 60, -4, 2, 1, -65, 28, 22, 49, -108, 5, -105, 118, 110, -94, -83, -67, 97, 23, 108, 78, 48, -122, -16, 81, 55, 42, 80, -57, -88, 98, -127, -36, 91, 74, -86, -63, -96, -76, 110, -21, 47, -27, 87, -59, -79, 43, 64, 112, -37, 90, 77, -95, -114, 31, -67, 3, 31, -40, 3, -44, -113, 76, -103, 113, -68, -30, -126, -52, 88, -24, -104, 58, -122, -45, -122, 56, -13, 0, 41, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -123, -116, 18, -63, -89, -71, 80, 21, 122, -53, 62, -84, -72, 67, -118, -36, -86, -35, 20, -70, -119, -127, 126, 1, 60, 35, 113, 33, -120, 47, -126, -36, 99, -6, 2, 69, -84, 69, 89, -41, 42, 88, 68, 91, -73, -97, -127, 59, -110, 104, 61, -30, 55, 36, -11, 123, 108, -113, 118, 53, -106, 9, -88, 89, -99, -71, -50, 35, -85, 116, -42, -125, -3, 50, 115, 39, -40, 105, 62, 67, 116, -10, -82, -59, -119, -102, -25, 83, 124, -23, 123, -10, 75, -13, -63, 101, -125, -34, -115, -118, -100, 60, -120, -115, 57, 89, -4, -86, 63, 34, -115, -95, -63, 102, 80, -127, 114, 76, -19, 34, 100, 79, 79, -54, -128, -111, -74, 41};
        return byArray;
    }

    private static byte[] getVerisignClass1PublicPrimaryCACert() {
        byte[] byArray = new byte[]{48, -126, 2, 61, 48, -126, 1, -90, 2, 17, 0, -51, -70, 127, 86, -16, -33, -28, -68, 84, -2, 34, -84, -77, 114, -86, 85, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 49, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -27, 25, -65, 109, -93, 86, 97, 45, -103, 72, 113, -10, 103, -34, -71, -115, -21, -73, -98, -122, -128, 10, -111, 14, -6, 56, 37, -81, 70, -120, -126, -27, 115, -88, -96, -101, 36, 93, 13, 31, -52, 101, 110, 12, -80, -48, 86, -124, 24, -121, -102, 6, -101, 16, -95, 115, -33, -76, 88, 57, 107, 110, -63, -10, 21, -43, -88, -88, 63, -86, 18, 6, -115, 49, -84, 127, -80, 52, -41, -113, 52, 103, -120, 9, -51, 20, 17, -30, 78, 69, 86, 105, 31, 120, 2, -128, -38, -36, 71, -111, 41, -69, 54, -55, 99, 92, -59, -32, -41, 45, -121, 123, -95, -73, 50, -80, 123, 48, -70, 42, 47, 49, -86, -18, -93, 103, -38, -37, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, 76, 63, -72, -117, -58, 104, -33, -18, 67, 51, 14, 93, -23, -90, -53, 7, -124, 77, 122, 51, -1, -110, 27, -12, 54, -83, -40, -107, 34, 54, 104, 17, 108, 124, 66, -52, -13, -100, 46, -60, 7, 63, 20, -80, 15, 79, -1, -112, -110, 118, -7, -30, -68, 74, -23, -113, -51, -96, -128, 10, -9, -59, 41, -15, -126, 34, 93, -72, -79, -35, -127, 35, -93, 123, 37, 21, 70, 48, 121, 22, -8, -22, 5, 75, -108, 127, 29, -62, 28, -56, -29, -73, -12, 16, 64, 60, 19, -61, 95, 31, 83, -24, 72, -28, -122, -76, 123, -95, 53, -80, 123, 37, -70, -72, -45, -114, -85, 63, 56, -99, 0, 52, 0, -104, -13, -47, 113, -108};
        return byArray;
    }

    private static byte[] getVerisignClass2PublicPrimaryCACert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 45, 27, -4, 74, 23, -115, -93, -111, -21, -25, -1, -11, -117, 69, -66, 11, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 50, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -74, 90, -117, -93, 13, 106, 35, -125, -128, 107, -49, 57, -121, -12, 33, 19, 51, 6, 76, 37, -94, -19, 85, 18, -105, -59, -89, -128, -71, -6, -125, -63, 32, -96, -6, 47, 21, 13, 124, -95, 96, 107, 126, 121, 44, -6, 6, 15, 58, -82, -10, 27, 111, -79, -46, -1, 47, 40, 82, 95, -125, 125, 75, -60, 122, -73, -8, 102, 31, -128, 84, -4, -73, -62, -114, 89, 74, 20, 87, 70, -47, -102, -109, -66, 65, -111, 3, -69, 21, -128, -109, 92, -21, -25, -52, 8, 108, 63, 62, -77, 74, -4, -1, 75, 108, 35, -43, 80, -126, 38, 68, 25, -114, 35, -61, 113, -22, 25, 36, 71, 4, -98, 117, -65, -56, -90, 0, 31, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -118, 27, 43, -6, 57, -63, 116, -41, 94, -40, 25, 100, -94, 88, 74, 45, 55, -32, 51, 71, 15, -84, -19, -9, -86, -37, 30, -28, -117, 6, 92, 96, 39, -54, 69, 82, -50, 22, -17, 63, 6, 100, -25, -108, 104, 124, 96, 51, 21, 17, 105, -81, -99, 98, -115, -93, 3, 84, 107, -90, -66, -27, -18, 5, 24, 96, 4, -65, 66, -128, -3, -48, -88, -88, 30, 1, 59, -9, -93, 92, -81, -93, -36, -26, 38, -128, 35, 60, -72, 68, 116, -9, 10, -82, 73, -117, 97, 120, -52, 36, -65, -120, -118, -89, 14, -22, 115, 25, 65, -3, 77, 3, -16, -120, -47, -27, 120, -115, -91, 42, 79, -10, -105, 13, 23, 119, -54, -40};
        return byArray;
    }

    private static byte[] getVeriSignClass3PublicPrimaryCACert() {
        byte[] byArray = new byte[]{48, -126, 2, 60, 48, -126, 1, -91, 2, 16, 112, -70, -28, 29, 16, -39, 41, 52, -74, 56, -54, 123, 3, -52, -70, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 54, 48, 49, 50, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 50, 56, 48, 56, 48, 49, 50, 51, 53, 57, 53, 57, 90, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -55, 92, 89, -98, -14, 27, -118, 1, 20, -76, 16, -33, 4, 64, -37, -29, 87, -81, 106, 69, 64, -113, -124, 12, 11, -47, 51, -39, -39, 17, -49, -18, 2, 88, 31, 37, -9, 42, -88, 68, 5, -86, -20, 3, 31, 120, 127, -98, -109, -71, -102, 0, -86, 35, 125, -42, -84, -123, -94, 99, 69, -57, 114, 39, -52, -12, 76, -58, 117, 113, -46, 57, -17, 79, 66, -16, 117, -33, 10, -112, -58, -114, 32, 111, -104, 15, -8, -84, 35, 95, 112, 41, 54, -92, -55, -122, -25, -79, -102, 32, -53, 83, -91, -123, -25, 61, -66, 125, -102, -2, 36, 69, 51, -36, 118, 21, -19, 15, -94, 113, 100, 76, 101, 46, -127, 104, 69, -89, 2, 3, 1, 0, 1, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 2, 5, 0, 3, -127, -127, 0, -69, 76, 18, 43, -49, 44, 38, 0, 79, 20, 19, -35, -90, -5, -4, 10, 17, -124, -116, -13, 40, 28, 103, -110, 47, 124, -74, -59, -6, -33, -16, -24, -107, -68, 29, -113, 108, 44, -88, 81, -52, 115, -40, -92, -64, 83, -16, 78, -42, 38, -64, 118, 1, 87, -127, -110, 94, 33, -15, -47, -79, -1, -25, -48, 33, 88, -51, 105, 23, -29, 68, 28, -100, 25, 68, 57, -119, 92, -36, -100, 0, 15, 86, -115, 2, -103, -19, -94, -112, 69, 76, -28, -69, 16, -92, 61, -16, 50, 3, 14, -15, -50, -8, -24, -55, 81, -116, -26, 98, -97, -26, -97, -64, 125, -73, 114, -100, -55, 54, 58, 107, -97, 78, -88, -1, 100, 13, 100};
        return byArray;
    }

    private static byte[] getVeriSignClass3SecureServerCACert() {
        byte[] byArray = new byte[]{48, -126, 4, -100, 48, -126, 4, 5, -96, 3, 2, 1, 2, 2, 16, 117, 51, 125, -102, -80, -31, 35, 59, -82, 45, 125, -28, 70, -111, 98, -44, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 48, 53, 48, 49, 49, 57, 48, 48, 48, 48, 48, 48, 90, 23, 13, 49, 53, 48, 49, 49, 56, 50, 51, 53, 57, 53, 57, 90, 48, -127, -80, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 31, 48, 29, 6, 3, 85, 4, 11, 19, 22, 86, 101, 114, 105, 83, 105, 103, 110, 32, 84, 114, 117, 115, 116, 32, 78, 101, 116, 119, 111, 114, 107, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 84, 101, 114, 109, 115, 32, 111, 102, 32, 117, 115, 101, 32, 97, 116, 32, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 112, 97, 32, 40, 99, 41, 48, 53, 49, 42, 48, 40, 6, 3, 85, 4, 3, 19, 33, 86, 101, 114, 105, 83, 105, 103, 110, 32, 67, 108, 97, 115, 115, 32, 51, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 65, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -107, -61, 33, 18, -114, 64, -59, 13, 1, 95, 118, 94, 102, -108, -39, 115, 44, 88, 25, 34, -72, -55, -4, 122, 57, -112, 42, 119, 114, 124, 29, 62, -9, -40, 85, -29, -81, 66, -53, -121, 48, 2, -36, 91, -84, 112, -26, -72, 68, -76, 43, 53, -21, -109, -46, 23, 5, 126, -53, 70, -42, 92, 83, -96, 50, 81, -99, 116, 100, 88, -7, 12, -102, 0, -22, 94, 68, 73, 100, 114, -12, -51, 16, -30, -123, 10, -7, 52, -18, -77, -120, 102, -87, -91, -92, 90, -48, 14, -104, 127, 88, 13, 43, 82, -69, -122, -87, 126, 46, -6, -78, 72, 124, -115, -37, 45, 95, 1, 117, -94, -115, 6, 59, -117, -76, 97, 7, -55, -66, 34, -103, -8, 27, -47, -75, 87, 102, 4, 77, 53, -12, -111, 113, -106, -75, -103, 8, 37, -101, -105, -56, 58, -13, 32, -79, -35, -98, -104, 12, 74, 99, -73, -90, -50, -80, 1, -50, -8, -109, 106, -13, 12, 110, -97, -79, -23, -124, 123, -127, -104, 65, -26, -127, -36, 61, 44, -25, -76, 107, -29, -98, -4, 8, 22, -41, -77, -43, -71, 102, 18, -103, 124, 109, 113, -56, 77, -66, -57, 15, -29, -5, 55, -83, -43, 117, -121, 33, 107, -122, -48, 68, 20, 90, 84, 121, 57, -106, 105, 86, -55, -71, 49, -51, -119, 97, 88, -31, -39, 118, 5, 5, -83, -9, -71, 2, -81, -89, -3, 71, -111, -94, 34, 52, 90, 49, -47, 2, 3, 1, 0, 1, -93, -126, 1, -127, 48, -126, 1, 125, 48, 18, 6, 3, 85, 29, 19, 1, 1, -1, 4, 8, 48, 6, 1, 1, -1, 2, 1, 0, 48, 68, 6, 3, 85, 29, 32, 4, 61, 48, 59, 48, 57, 6, 11, 96, -122, 72, 1, -122, -8, 69, 1, 7, 23, 3, 48, 42, 48, 40, 6, 8, 43, 6, 1, 5, 5, 7, 2, 1, 22, 28, 104, 116, 116, 112, 115, 58, 47, 47, 119, 119, 119, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 114, 112, 97, 48, 49, 6, 3, 85, 29, 31, 4, 42, 48, 40, 48, 38, -96, 36, -96, 34, -122, 32, 104, 116, 116, 112, 58, 47, 47, 99, 114, 108, 46, 118, 101, 114, 105, 115, 105, 103, 110, 46, 99, 111, 109, 47, 112, 99, 97, 51, 46, 99, 114, 108, 48, 14, 6, 3, 85, 29, 15, 1, 1, -1, 4, 4, 3, 2, 1, 6, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 1, 6, 48, 41, 6, 3, 85, 29, 17, 4, 34, 48, 32, -92, 30, 48, 28, 49, 26, 48, 24, 6, 3, 85, 4, 3, 19, 17, 67, 108, 97, 115, 115, 51, 67, 65, 50, 48, 52, 56, 45, 49, 45, 52, 53, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 111, -20, -81, -96, -35, -118, -92, -17, -11, 42, 16, 103, 45, 63, 85, -126, -68, -41, -17, 37, 48, -127, -128, 6, 3, 85, 29, 35, 4, 121, 48, 119, -95, 99, -92, 97, 48, 95, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 23, 48, 21, 6, 3, 85, 4, 10, 19, 14, 86, 101, 114, 105, 83, 105, 103, 110, 44, 32, 73, 110, 99, 46, 49, 55, 48, 53, 6, 3, 85, 4, 11, 19, 46, 67, 108, 97, 115, 115, 32, 51, 32, 80, 117, 98, 108, 105, 99, 32, 80, 114, 105, 109, 97, 114, 121, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, -126, 16, 112, -70, -28, 29, 16, -39, 41, 52, -74, 56, -54, 123, 3, -52, -70, -65, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -61, 126, 8, 70, 93, -111, 54, -49, 103, -36, -41, -89, -81, -81, -72, 34, -61, -117, 4, 116, -45, -79, 96, -68, -26, -2, -73, 68, 18, -127, 91, 49, 115, 20, 99, 86, -58, 114, 46, -47, 26, 3, 67, 92, 56, 10, 80, 74, 77, -51, -38, -74, 25, -88, -12, -103, 13, -81, -29, -9, -40, -15, 117, 40, 101, -10, 106, -2, -101, -12, -67, 82, -39, 63, -53, -38, 22, -53, -91, -98, 46, -114, 102, 82, 120, 61, 38, -6, -2, -108, 54, -120, 74, -107, 94, 42, 76, 25, -17, 110, -6, -126, 63, 45, 3, -17, -42, 40, -77, 55, 24, -49, 66, -78, 52, 33, 100, 71, -45, 32, 107, 58, 76, -36, -26, 3, -112, 12};
        return byArray;
    }

    private static byte[] getEntrustSecureServerCACert() {
        byte[] byArray = new byte[]{48, -126, 4, -40, 48, -126, 4, 65, -96, 3, 2, 1, 2, 2, 4, 55, 74, -46, 67, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -61, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, 23, 13, 49, 57, 48, 53, 50, 53, 49, 54, 51, 57, 52, 48, 90, 48, -127, -61, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -51, 40, -125, 52, 84, 27, -119, -13, 15, -81, 55, -111, 49, -1, -81, 49, 96, -55, -88, -24, -78, 16, 104, -19, -97, -25, -109, 54, -15, 10, 100, -69, 71, -11, 4, 23, 63, 35, 71, 77, -59, 39, 25, -127, 38, 12, 84, 114, 13, -120, 45, -39, 31, -102, 18, -97, -68, -77, 113, -45, -128, 25, 63, 71, 102, 123, -116, 53, 40, -46, -71, 10, -33, 36, -38, -100, -42, 80, 121, -127, 122, 90, -45, 55, -9, -62, 74, -40, 41, -110, 38, 100, -47, -28, -104, 108, 58, 0, -118, -11, 52, -101, 101, -8, -19, -29, 16, -1, -3, -72, 73, 88, -36, -96, -34, -126, 57, 107, -127, -79, 22, 25, 97, -71, 84, -74, -26, 67, 2, 1, 3, -93, -126, 1, -41, 48, -126, 1, -45, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, -126, 1, 25, 6, 3, 85, 29, 31, 4, -126, 1, 16, 48, -126, 1, 12, 48, -127, -34, -96, -127, -37, -96, -127, -40, -92, -127, -43, 48, -127, -46, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 59, 48, 57, 6, 3, 85, 4, 11, 19, 50, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 58, 48, 56, 6, 3, 85, 4, 3, 19, 49, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 83, 101, 99, 117, 114, 101, 32, 83, 101, 114, 118, 101, 114, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 49, 13, 48, 11, 6, 3, 85, 4, 3, 19, 4, 67, 82, 76, 49, 48, 41, -96, 39, -96, 37, -122, 35, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 82, 76, 47, 110, 101, 116, 49, 46, 99, 114, 108, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 49, 57, 57, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, -127, 15, 50, 48, 49, 57, 48, 53, 50, 53, 49, 54, 48, 57, 52, 48, 90, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -16, 23, 98, 19, 85, 61, -77, -1, 10, 0, 107, -5, 80, -124, -105, -13, -19, 98, -48, 26, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -16, 23, 98, 19, 85, 61, -77, -1, 10, 0, 107, -5, 80, -124, -105, -13, -19, 98, -48, 26, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 25, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 12, 48, 10, 27, 4, 86, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, -112, -36, 48, 2, -6, 100, 116, -62, -89, 10, -91, 124, 33, -115, 52, 23, -88, -5, 71, 14, -1, 37, 124, -115, 19, 10, -5, -28, -104, -75, -17, -116, -8, -59, 16, 13, -9, -110, -66, -15, -61, -43, -43, -107, 106, 4, -69, 44, -50, 38, 54, 101, -56, 49, -58, -25, -18, 63, -29, 87, 117, -124, 122, 17, -17, 70, 79, 24, -12, -45, -104, -69, -88, -121, 50, -70, 114, -10, 60, -30, 61, -97, -41, 29, -39, -61, 96, 67, -116, 88, 14, 34, -106, 47, 98, -93, 44, 31, -70, -83, 5, -17, -85, 50, 120, -121, -96, 84, 115, 25, -75, 92, 5, -7, 82, 62, 109, 45, 69, 11, -9, 10, -109, -22, -19, 6, -7, -78};
        return byArray;
    }

    private static byte[] getEntrustCA2048Cert() {
        byte[] byArray = new byte[]{48, -126, 4, 92, 48, -126, 3, 68, -96, 3, 2, 1, 2, 2, 4, 56, 99, -71, 102, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, 30, 23, 13, 57, 57, 49, 50, 50, 52, 49, 55, 53, 48, 53, 49, 90, 23, 13, 49, 57, 49, 50, 50, 52, 49, 56, 50, 48, 53, 49, 90, 48, -127, -76, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 64, 48, 62, 6, 3, 85, 4, 11, 20, 55, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 80, 83, 95, 50, 48, 52, 56, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 40, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 41, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 32, 40, 50, 48, 52, 56, 41, 48, -126, 1, 34, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, 1, 15, 0, 48, -126, 1, 10, 2, -126, 1, 1, 0, -83, 77, 75, -87, 18, -122, -78, -22, -93, 32, 7, 21, 22, 100, 42, 43, 75, -47, -65, 11, 74, 77, -114, -19, -128, 118, -91, 103, -73, 120, 64, -64, 115, 66, -56, 104, -64, -37, 83, 43, -35, 94, -72, 118, -104, 53, -109, -117, 26, -99, 124, 19, 58, 14, 31, 91, -73, 30, -49, -27, 36, 20, 30, -79, -127, -87, -115, 125, -72, -52, 107, 75, 3, -15, 2, 12, -36, -85, -91, 64, 36, 0, 127, 116, -108, -95, -99, 8, 41, -77, -120, 11, -11, -121, 119, -99, 85, -51, -28, -61, 126, -41, 106, 100, -85, -123, 20, -122, -107, 91, -105, 50, 80, 111, 61, -56, -70, 102, 12, -29, -4, -67, -72, 73, -63, 118, -119, 73, 25, -3, -64, -88, -67, -119, -93, 103, 47, -58, -97, -68, 113, 25, 96, -72, 45, -23, 44, -55, -112, 118, 102, 123, -108, -30, -81, 120, -42, 101, 83, 93, 60, -42, -100, -78, -49, 41, 3, -7, 47, -92, 80, -78, -44, 72, -50, 5, 50, 85, -118, -3, -78, 100, 76, 14, -28, -104, 7, 117, -37, 127, -33, -71, 8, 85, 96, -123, 48, 41, -7, 123, 72, -92, 105, -122, -29, 53, 63, 30, -122, 93, 122, 122, 21, -67, -17, 0, -114, 21, 34, 84, 23, 0, -112, 38, -109, -68, 14, 73, 104, -111, -65, -8, 71, -45, -99, -107, 66, -63, 14, 77, -33, 111, 38, -49, -61, 24, 33, 98, 102, 67, 112, -42, -43, -64, 7, -31, 2, 3, 1, 0, 1, -93, 116, 48, 114, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, 85, -28, -127, -47, 17, -128, -66, -40, -119, -71, 8, -93, 49, -7, -95, 36, 9, 22, -71, 112, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, 85, -28, -127, -47, 17, -128, -66, -40, -119, -71, 8, -93, 49, -7, -95, 36, 9, 22, -71, 112, 48, 29, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 16, 48, 14, 27, 8, 86, 53, 46, 48, 58, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -126, 1, 1, 0, 89, 71, -84, 33, -124, -118, 23, -55, -100, -119, 83, 30, -70, -128, -123, 26, -58, 60, 78, 62, -79, -100, -74, 124, -58, -110, 93, 24, 100, 2, -29, -45, 6, 8, 17, 97, 124, 99, -29, 43, -99, 49, 3, 112, 118, -46, -93, 40, -96, -12, -69, -102, 99, 115, -19, 109, -27, 42, -37, -19, 20, -87, 43, -58, 54, 17, -48, 43, -21, 7, -117, -91, -38, -98, 92, 25, -99, 86, 18, -11, 84, 41, -56, 5, -19, -78, 18, 42, -115, -12, 3, 27, -1, -25, -110, 16, -121, -80, 58, -75, -61, -99, 5, 55, 18, -93, -57, -12, 21, -71, -43, -92, 57, 22, -101, 83, 58, 35, -111, -15, -88, -126, -94, 106, -120, 104, -63, 121, 2, 34, -68, -86, -90, -42, -82, -33, -80, 20, 95, -72, -121, -48, -35, 124, 127, 123, -1, -81, 28, -49, -26, -37, 7, -83, 94, -37, -123, -99, -48, 43, 13, 51, -37, 4, -47, -26, 73, 64, 19, 43, 118, -5, 62, -23, -100, -119, 15, 21, -50, 24, -80, -123, 120, 33, 79, 107, 79, 14, -6, 54, 103, -51, 7, -14, -1, 8, -48, -30, -34, -39, -65, 42, -81, -72, -121, -122, 33, 60, 4, -54, -73, -108, 104, 127, -49, 60, -23, -104, -41, 56, -1, -20, -64, -39, 80, -16, 46, 75, 88, -82, 70, 111, -48, 46, -61, 96, -38, 114, 85, 114, -67, 76, 69, -98, 97, -70, -65, -124, -127, -110, 3, -47, -46, 105, 124, -59};
        return byArray;
    }

    private static byte[] getEntrustClientCACert() {
        byte[] byArray = new byte[]{48, -126, 4, -19, 48, -126, 4, 86, -96, 3, 2, 1, 2, 2, 4, 56, 3, -111, -18, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 48, -127, -55, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, 30, 23, 13, 57, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, 23, 13, 49, 57, 49, 48, 49, 50, 49, 57, 53, 52, 51, 48, 90, 48, -127, -55, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 48, -127, -99, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -117, 0, 48, -127, -121, 2, -127, -127, 0, -56, 58, -103, 94, 49, 23, -33, -84, 39, 111, -112, 123, -28, 25, -1, 69, -93, 52, -62, -37, -63, -88, 79, -16, 104, -22, -124, -3, -97, 117, 121, -49, -63, -118, 81, -108, -81, -57, 87, 3, 71, 100, -98, -83, -126, 27, 90, -38, 127, 55, 120, 71, -69, 55, -104, 18, -106, -50, -58, 19, 125, -17, -46, 12, 48, 81, -87, 57, -98, 85, -8, -5, -79, -25, 48, -34, -125, -78, -70, 62, -15, -43, -119, 59, 59, -123, -70, -86, 116, 44, -2, 63, 49, 110, -81, -111, -107, 110, 6, -44, 7, 77, 75, 44, 86, 71, 24, 4, 82, -38, 14, 16, -109, -65, 99, -112, -101, -31, -33, -116, -26, 2, -92, -26, 79, 94, -9, -117, 2, 1, 3, -93, -126, 1, -32, 48, -126, 1, -36, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, -126, 1, 34, 6, 3, 85, 29, 31, 4, -126, 1, 25, 48, -126, 1, 21, 48, -127, -28, -96, -127, -31, -96, -127, -34, -92, -127, -37, 48, -127, -40, 49, 11, 48, 9, 6, 3, 85, 4, 6, 19, 2, 85, 83, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 72, 48, 70, 6, 3, 85, 4, 11, 20, 63, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 108, 105, 101, 110, 116, 95, 67, 65, 95, 73, 110, 102, 111, 47, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 51, 48, 49, 6, 3, 85, 4, 3, 19, 42, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 67, 108, 105, 101, 110, 116, 32, 67, 101, 114, 116, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 65, 117, 116, 104, 111, 114, 105, 116, 121, 49, 13, 48, 11, 6, 3, 85, 4, 3, 19, 4, 67, 82, 76, 49, 48, 44, -96, 42, -96, 40, -122, 38, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 67, 82, 76, 47, 67, 108, 105, 101, 110, 116, 49, 46, 99, 114, 108, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 49, 57, 57, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, -127, 15, 50, 48, 49, 57, 49, 48, 49, 50, 49, 57, 50, 52, 51, 48, 90, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -60, -5, -100, 41, 123, -105, -51, 76, -106, -4, -18, 91, -77, -54, -103, 116, -117, -107, -22, 76, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -60, -5, -100, 41, 123, -105, -51, 76, -106, -4, -18, 91, -77, -54, -103, 116, -117, -107, -22, 76, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 25, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 12, 48, 10, 27, 4, 86, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 4, 5, 0, 3, -127, -127, 0, 63, -82, -118, -15, -41, 102, 3, 5, -98, 62, -6, -22, 28, 70, -69, -92, 91, -113, 120, -102, 18, 72, -103, -7, -12, 53, -34, 12, 54, 7, 2, 107, 16, 58, -119, 20, -127, -100, 49, -90, 124, -78, 65, -78, 106, -25, 7, 1, -95, 75, -7, -97, 37, 59, -106, -54, -103, -61, 62, -95, 81, 28, -13, -61, 46, 68, -9, -80, 103, 70, -86, -110, -27, 59, -38, 28, 25, 20, 56, 48, -43, -30, -94, 49, 37, 46, -15, -20, 69, 56, -19, -8, 6, 88, 3, 115, 98, -80, 16, 49, -113, 64, -65, 100, -32, 92, 62, -59, 79, 31, -38, 18, 67, -1, 76, -26, 6, 38, -88, -101, 25, -86, 68, 60, 118, -78, 92, -20};
        return byArray;
    }

    private static byte[] getEntrustGlobalClientCACert() {
        byte[] byArray = new byte[]{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};
        return byArray;
    }

    private static byte[] getEntrustGlobalSecureServerCACert() {
        byte[] byArray = new byte[]{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};
        return byArray;
    }

    private static byte[] getEntrustWAPCACert() {
        byte[] byArray = new byte[]{48, -126, 4, 11, 48, -126, 3, 116, -96, 3, 2, 1, 2, 2, 4, 56, 85, 52, -36, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 48, -127, -116, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 87, 65, 80, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 15, 48, 13, 6, 3, 85, 4, 3, 19, 6, 87, 65, 80, 32, 67, 65, 48, 30, 23, 13, 57, 57, 49, 50, 49, 51, 49, 55, 51, 51, 49, 57, 90, 23, 13, 49, 57, 49, 50, 49, 51, 49, 56, 48, 51, 49, 57, 90, 48, -127, -116, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 87, 65, 80, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 15, 48, 13, 6, 3, 85, 4, 3, 19, 6, 87, 65, 80, 32, 67, 65, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -100, -27, -84, -82, -64, 107, -83, 69, 49, -93, 86, 76, -3, 56, 109, 80, 116, -41, 86, -39, 101, 36, -55, -57, 96, 14, -103, -100, -22, 64, 30, 14, 112, -119, 24, -34, 61, -42, -45, 122, -61, 68, 99, -108, 51, 61, 117, -58, -75, 16, 106, -42, 48, 96, 119, 19, 87, 59, -96, -112, 66, -31, 19, 57, -63, -122, -90, -99, -28, -39, -96, -23, 88, 10, -67, -13, 91, -64, 25, 12, -128, -55, 78, -51, 62, 50, -63, 110, -39, 64, 61, -12, -100, 42, -100, -58, 85, 81, -17, -126, 69, 113, 0, -8, -107, -79, 86, -26, 117, 121, -32, -103, 3, 9, 25, -94, 54, 80, -79, 109, -81, -6, -120, -13, -113, -86, 61, -119, 2, 3, 1, 0, 1, -93, -126, 1, 118, 48, -126, 1, 114, 48, 17, 6, 9, 96, -122, 72, 1, -122, -8, 66, 1, 1, 4, 4, 3, 2, 0, 7, 48, -127, -75, 6, 3, 85, 29, 31, 4, -127, -83, 48, -127, -86, 48, -127, -89, -96, -127, -92, -96, -127, -95, -92, -127, -98, 48, -127, -101, 49, 20, 48, 18, 6, 3, 85, 4, 10, 19, 11, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 49, 60, 48, 58, 6, 3, 85, 4, 11, 19, 51, 119, 119, 119, 46, 101, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 47, 87, 65, 80, 67, 80, 83, 32, 105, 110, 99, 111, 114, 112, 46, 32, 98, 121, 32, 114, 101, 102, 46, 32, 108, 105, 109, 105, 116, 115, 32, 108, 105, 97, 98, 46, 49, 37, 48, 35, 6, 3, 85, 4, 11, 19, 28, 40, 99, 41, 32, 49, 57, 57, 57, 32, 69, 110, 116, 114, 117, 115, 116, 46, 110, 101, 116, 32, 76, 105, 109, 105, 116, 101, 100, 49, 15, 48, 13, 6, 3, 85, 4, 3, 19, 6, 87, 65, 80, 32, 67, 65, 49, 13, 48, 11, 6, 3, 85, 4, 3, 19, 4, 67, 82, 76, 49, 48, 43, 6, 3, 85, 29, 16, 4, 36, 48, 34, -128, 15, 49, 57, 57, 57, 49, 50, 49, 51, 49, 55, 51, 51, 49, 57, 90, -127, 15, 50, 48, 49, 57, 49, 50, 49, 51, 49, 56, 48, 51, 49, 57, 90, 48, 11, 6, 3, 85, 29, 15, 4, 4, 3, 2, 1, 6, 48, 31, 6, 3, 85, 29, 35, 4, 24, 48, 22, -128, 20, -20, -32, -80, 112, 103, 3, 79, 110, 96, -128, -89, -101, 7, 95, 81, -118, 120, -123, 122, -1, 48, 29, 6, 3, 85, 29, 14, 4, 22, 4, 20, -20, -32, -80, 112, 103, 3, 79, 110, 96, -128, -89, -101, 7, 95, 81, -118, 120, -123, 122, -1, 48, 12, 6, 3, 85, 29, 19, 4, 5, 48, 3, 1, 1, -1, 48, 29, 6, 9, 42, -122, 72, -122, -10, 125, 7, 65, 0, 4, 16, 48, 14, 27, 8, 86, 53, 46, 48, 58, 52, 46, 48, 3, 2, 4, -112, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 5, 5, 0, 3, -127, -127, 0, 23, -82, 22, 79, 66, 105, -87, 110, 106, -95, 85, -107, -50, 13, -63, -40, -104, 122, -1, 48, 25, 101, -114, 81, 80, -35, 6, -116, -64, 106, -20, 83, -113, 102, -4, 117, -117, -43, 96, -50, -46, -48, 71, -113, 65, 12, 98, -28, -88, -99, 7, 126, -89, -112, 59, 76, -109, 20, 93, 4, 35, 62, 72, 39, -50, 87, -104, -91, -36, -104, -57, -68, 94, 68, 75, 97, 68, -51, 26, -120, -66, 94, -103, -95, 57, 60, 123, 91, -61, 56, -16, -77, -63, -64, -33, 31, -27, 96, 12, -59, 113, 114, -62, 7, 59, -32, -120, -44, 121, 51, -114, 121, -3, 123, -2, 126, -115, -55, -55, 4, -45, -81, -70, 77, -15, -103, 11, 61};
        return byArray;
    }

    static {
        isImportNow = false;
        aCryptographicTokenModuleName = null;
        aCryptographicTokenLabel = null;
        isJSSECryptokiOpened = false;
        isCMSCryptokiOpened = false;
        JCEProvider = KMSystem.isJCEFIPSFirst() ? "IBMJCEFIPS" : "IBMJCE";
        SYSTEM_DEFAULT = 0;
        RSA = 1;
        ICC = 2;
        CLASS3_ROOT_LABEL = "Verisign Class 3 Public Primary Certification Authority";
    }
}

