/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.jacl;

import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.EngineUtils;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclObject;

class BSFCommand
implements Command {
    BSFManager mgr;
    BSFEngine jengine;

    BSFCommand(BSFManager bSFManager, BSFEngine bSFEngine) {
        this.mgr = bSFManager;
        this.jengine = bSFEngine;
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            interp.setResult("invalid # of args; usage: bsf lookupBean|registerBean|unregisterBean|addEventListener args");
            throw new TclException(1);
        }
        String string = tclObjectArray[1].toString();
        if (string.equals("lookupBean")) {
            if (tclObjectArray.length != 3) {
                interp.setResult("invalid # of args; usage: bsf lookupBean name-of-bean");
                throw new TclException(1);
            }
            String string2 = tclObjectArray[2].toString();
            Object object = this.mgr.lookupBean(string2);
            if (object == null) {
                interp.setResult("unknown object: " + string2);
                throw new TclException(1);
            }
            interp.setResult(ReflectObject.newInstance((Interp)interp, object.getClass(), (Object)object));
        } else if (string.equals("registerBean")) {
            if (tclObjectArray.length != 4) {
                interp.setResult("invalid # of args; usage: bsf registerBean name-of-bean bean");
                throw new TclException(1);
            }
            this.mgr.registerBean(tclObjectArray[2].toString(), ReflectObject.get((Interp)interp, (TclObject)tclObjectArray[3]));
            interp.setResult("");
        } else if (string.equals("unregisterBean")) {
            if (tclObjectArray.length != 3) {
                interp.setResult("invalid # of args; usage: bsf unregisterBean name-of-bean");
                throw new TclException(1);
            }
            this.mgr.unregisterBean(tclObjectArray[2].toString());
            interp.setResult("");
        } else if (string.equals("addEventListener")) {
            if (tclObjectArray.length != 6) {
                interp.setResult("invalid # of args; usage: bsf addEventListener object event-set-name filter script-to-run");
                throw new TclException(1);
            }
            try {
                String string3 = tclObjectArray[4].toString();
                string3 = string3.equals("") ? null : string3;
                EngineUtils.addEventListener((Object)ReflectObject.get((Interp)interp, (TclObject)tclObjectArray[2]), (String)tclObjectArray[3].toString(), (String)string3, (BSFEngine)this.jengine, (BSFManager)this.mgr, (String)"<event-script>", (int)0, (int)0, (Object)tclObjectArray[5].toString());
            }
            catch (BSFException bSFException) {
                bSFException.printStackTrace();
                interp.setResult("got BSF exception: " + bSFException.getMessage());
                throw new TclException(1);
            }
        }
    }
}

