/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf.engines.netrexx;

import COM.ibm.netrexx.process.NetRexxC;
import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.debug.util.DebugLog;
import com.ibm.bsf.util.BSFEngineImpl;
import com.ibm.bsf.util.BSFFunctions;
import com.ibm.bsf.util.EngineUtils;
import com.ibm.bsf.util.MethodUtils;
import com.ibm.bsf.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import netrexx.lang.BadArgumentException;
import netrexx.lang.Rexx;

public class NetRexxEngine
extends BSFEngineImpl {
    BSFFunctions mgrfuncs;
    private boolean bsfHandleCreated = false;
    static Hashtable codeToClass = new Hashtable();
    static String serializeCompilation = "";
    static String placeholder = "$$CLASSNAME$$";
    String minorPrefix;
    private static int uniqueFileOffset = 0;

    public NetRexxEngine() {
        new BadArgumentException();
    }

    public Object call(Object object, String string, Object[] objectArray) throws BSFException {
        throw new BSFException(BSFException.REASON_UNSUPPORTED_FEATURE, "NetRexx doesn't currently support call()", null);
    }

    Object callStatic(Class clazz, String string, Object[] objectArray) throws BSFException {
        Object object = null;
        try {
            if (clazz != null) {
                Class[] classArray = new Class[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    classArray[i] = objectArray[i].getClass();
                }
                Method method = MethodUtils.getMethod((Object)clazz, (String)string, (Class[])classArray);
                object = method.invoke(null, objectArray);
            } else {
                DebugLog.stderrPrintln((Object)"NetRexxEngine: ERROR: rexxclass==null!", (int)3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof InvocationTargetException) {
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                throwable.printStackTrace();
            }
            throw new BSFException(BSFException.REASON_IO_ERROR, exception.getMessage(), (Throwable)exception);
        }
        return object;
    }

    public void declareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
    }

    public Object eval(String string, int n, int n2, Object object) throws BSFException {
        return this.execEvalShared(string, n, n2, object, true);
    }

    public void exec(String string, int n, int n2, Object object) throws BSFException {
        this.execEvalShared(string, n, n2, object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object execEvalShared(String string, int n, int n2, Object object, boolean bl) throws BSFException {
        String string3;
        Object object2 = null;
        String string2 = null;
        GeneratedFile generatedFile = null;
        Class clazz = null;
        String string4 = string3 = object.toString();
        try {
            try {
                Object[] objectArray;
                clazz = (Class)codeToClass.get(string3);
                if (clazz != null) {
                    DebugLog.debugPrintln((Object)("NetRexxEngine: Found pre-compiled class for script '" + string3 + "'"), (int)3);
                    string2 = clazz.getName();
                } else {
                    StringBuffer stringBuffer;
                    generatedFile = this.openUniqueFile(this.tempDir, "BSFNetRexx", ".nrx");
                    if (generatedFile == null) {
                        throw new BSFException("couldn't create NetRexx scratchfile");
                    }
                    string2 = generatedFile.className;
                    objectArray = "";
                    if (bl) {
                        objectArray = "returns java.lang.Object";
                    }
                    generatedFile.fos.write(("class " + string2 + ";\n").getBytes());
                    generatedFile.fos.write(("method BSFNetRexxEngineEntry(bsf=com.ibm.bsf.util.BSFFunctions)  public static " + (String)objectArray + ";\n").getBytes());
                    int n4 = string4.indexOf(placeholder);
                    if (n4 >= 0) {
                        stringBuffer = new StringBuffer();
                        while (n4 >= 0) {
                            stringBuffer.setLength(0);
                            if (n4 > 0) {
                                stringBuffer.append(string4.substring(0, n4));
                            }
                            stringBuffer.append(string2);
                            int n5 = n4 + placeholder.length();
                            if (n5 < string4.length()) {
                                stringBuffer.append(string4.substring(n5));
                            }
                            string4 = stringBuffer.toString();
                            n4 = string4.indexOf(placeholder, n4);
                        }
                    }
                    for (int i = 0; i < this.declaredBeans.size(); ++i) {
                        stringBuffer = (BSFDeclaredBean)this.declaredBeans.elementAt(i);
                        String string5 = StringUtils.getClassName((Class)((BSFDeclaredBean)stringBuffer).type);
                        generatedFile.fos.write((((BSFDeclaredBean)stringBuffer).name + " =" + string5 + "   bsf.lookupBean(\"" + ((BSFDeclaredBean)stringBuffer).name + "\");").getBytes());
                    }
                    if (bl) {
                        generatedFile.fos.write("return ".getBytes());
                    }
                    generatedFile.fos.write(string4.getBytes());
                    generatedFile.fos.close();
                    DebugLog.debugPrintln((Object)("NetRexxEngine: wrote temp file " + generatedFile.file.getPath() + ", now compiling"), (int)3);
                    String string6 = generatedFile.file.getPath();
                    if (DebugLog.getLogLevel() >= 3) {
                        string6 = string6 + " -verbose4";
                    } else {
                        string6 = string6 + " -noverbose";
                        string6 = string6 + " -noconsole";
                    }
                    Rexx rexx = new Rexx(string6);
                    String string7 = serializeCompilation;
                    // MONITORENTER : string7
                    int n3 = NetRexxC.main((Rexx)rexx, (PrintWriter)new PrintWriter(DebugLog.getDebugStream()));
                    // MONITOREXIT : string7
                    if (n3 == 2) {
                        throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "There were NetRexx errors.");
                    }
                    DebugLog.debugPrintln((Object)("NetRexxEngine: loading class " + string2), (int)3);
                    clazz = EngineUtils.loadClass((BSFManager)this.mgr, (String)string2);
                    codeToClass.put(string3, clazz);
                }
                objectArray = new Object[]{this.mgrfuncs};
                object2 = this.callStatic(clazz, "BSFNetRexxEngineEntry", objectArray);
            }
            catch (BSFException bSFException) {
                throw bSFException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!(exception instanceof InvocationTargetException)) throw new BSFException(BSFException.REASON_IO_ERROR, exception.getMessage(), (Throwable)exception);
                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                throwable.printStackTrace();
                throw new BSFException(BSFException.REASON_IO_ERROR, exception.getMessage(), (Throwable)exception);
            }
            Object var23_25 = null;
            if (generatedFile != null && generatedFile.file != null && generatedFile.file.exists()) {
                generatedFile.file.delete();
            }
            if (string2 == null) return object2;
            File file = new File(this.tempDir + File.separatorChar + string2 + ".java");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(string2 + ".class")).exists()) {
                file.delete();
            }
            if ((file = new File(this.tempDir + File.separatorChar + string2 + ".crossref")).exists()) {
                file.delete();
            }
            file = new File(this.tempDir);
            this.minorPrefix = string2 + "$";
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return 0 == string.indexOf(NetRexxEngine.this.minorPrefix) && string.lastIndexOf(".class") == string.length() - 6;
                }
            });
            if (stringArray == null) return object2;
            int n3 = stringArray.length;
            while (n3 > 0) {
                file = new File(stringArray[--n3]);
                file.delete();
            }
            return object2;
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            if (generatedFile != null && generatedFile.file != null && generatedFile.file.exists()) {
                generatedFile.file.delete();
            }
            if (string2 == null) throw throwable;
            File file = new File(this.tempDir + File.separatorChar + string2 + ".java");
            if (file.exists()) {
                file.delete();
            }
            if ((file = new File(string2 + ".class")).exists()) {
                file.delete();
            }
            if ((file = new File(this.tempDir + File.separatorChar + string2 + ".crossref")).exists()) {
                file.delete();
            }
            file = new File(this.tempDir);
            this.minorPrefix = string2 + "$";
            String[] stringArray = file.list(new /* invalid duplicate definition of identical inner class */);
            if (stringArray == null) throw throwable;
            int n7 = stringArray.length;
            while (n7 > 0) {
                file = new File(stringArray[--n7]);
                file.delete();
            }
            throw throwable;
        }
    }

    public void initialize(BSFManager bSFManager, String string, Vector vector) throws BSFException {
        super.initialize(bSFManager, string, vector);
        this.mgrfuncs = new BSFFunctions(bSFManager, (BSFEngine)this);
    }

    private GeneratedFile openUniqueFile(String string, String string2, String string3) {
        File file = null;
        File file2 = null;
        FileOutputStream fileOutputStream = null;
        int n = 1000;
        GeneratedFile generatedFile = null;
        String string4 = null;
        int n2 = n;
        ++uniqueFileOffset;
        while (fileOutputStream == null && n2 > 0) {
            block6: {
                try {
                    string4 = string2 + uniqueFileOffset;
                    file = new File(string + File.separatorChar + string4 + string3);
                    file2 = new File(string + File.separatorChar + string4 + ".class");
                    if (file != null && !file.exists() & file2 != null & !file2.exists()) {
                        fileOutputStream = new FileOutputStream(file);
                    }
                }
                catch (Exception exception) {
                    if (file.exists()) break block6;
                    DebugLog.stderrPrintln((Object)("openUniqueFile: unexpected " + exception), (int)0);
                }
            }
            --n2;
            ++uniqueFileOffset;
        }
        if (fileOutputStream == null) {
            DebugLog.stderrPrintln((Object)("openUniqueFile: Failed " + n + "attempts."), (int)0);
        } else {
            generatedFile = new GeneratedFile(file, fileOutputStream, string4);
        }
        return generatedFile;
    }

    public void undeclareBean(BSFDeclaredBean bSFDeclaredBean) throws BSFException {
    }

    private class GeneratedFile {
        File file = null;
        FileOutputStream fos = null;
        String className = null;

        GeneratedFile(File file, FileOutputStream fileOutputStream, String string) {
            this.file = file;
            this.fos = fileOutputStream;
            this.className = string;
        }
    }
}

