/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.AccessPointGroupImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.CoreGroupAccessPointImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.PeerAccessPointImpl;
import com.ibm.ws.cgbridge.config.AccessPointGroupTopology;
import com.ibm.ws.cgbridge.config.BridgeInterface;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.CoreGroupAccessPoint;
import com.ibm.ws.cgbridge.config.PeerAccessPoint;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.exception.ConfigurationWarning;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class AccessPointGroup {
    private static final TraceComponent tc = Tr.register((Class)AccessPointGroup.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private String name;
    private AccessPointGroupTopology topology;
    private boolean isTopologySet;
    private HashMap properties;
    private Hashtable htPeerAccessPoints;
    private Hashtable htCoreGroupAccessPoints;
    private CGBridgeConfig cgbridgeConfig;
    Set coreGroups;

    public AccessPointGroup(CGBridgeConfig cGBridgeConfig, AccessPointGroupImpl accessPointGroupImpl) throws ConfigurationWarning, CGBInternalErrorException {
        if (tc.isDebugEnabled()) {
            this.debug("constructor");
        }
        this.coreGroups = new HashSet();
        this.cgbridgeConfig = cGBridgeConfig;
        this.name = accessPointGroupImpl.getName();
        if (null == this.name) {
            throw new ConfigurationWarning("AccessPointGroup must have name defined.");
        }
        this.properties = CGBridgeConfig.loadProperties(accessPointGroupImpl.getProperties());
        this.loadPeerAccessPoints(accessPointGroupImpl);
        this.loadCoreGroupAccessPoints(accessPointGroupImpl);
        this.checkEndPointName();
        this.topology = this.determineTopology();
    }

    private AccessPointGroupTopology determineTopology() {
        if (this.properties.containsKey("cgb.apgTopology")) {
            this.isTopologySet = true;
            try {
                if (((String)this.properties.get("cgb.apgTopology")).equalsIgnoreCase("Ring")) {
                    return AccessPointGroupTopology.RING;
                }
                if (((String)this.properties.get("cgb.apgTopology")).equalsIgnoreCase("Chain")) {
                    return AccessPointGroupTopology.CHAIN;
                }
            }
            catch (Exception exception) {
                return AccessPointGroupTopology.DEFAULT;
            }
        }
        return AccessPointGroupTopology.DEFAULT;
    }

    private void loadPeerAccessPoints(AccessPointGroupImpl accessPointGroupImpl) throws ConfigurationWarning, CGBInternalErrorException {
        this.htPeerAccessPoints = new Hashtable();
        EObjectResolvingEList eObjectResolvingEList = (EObjectResolvingEList)accessPointGroupImpl.getPeerAccessPointRefs();
        if (null != eObjectResolvingEList) {
            String string = "";
            PeerAccessPoint peerAccessPoint = null;
            Iterator iterator = eObjectResolvingEList.iterator();
            while (iterator.hasNext()) {
                PeerAccessPointImpl peerAccessPointImpl = (PeerAccessPointImpl)iterator.next();
                if (!peerAccessPointImpl.eIsProxy()) {
                    string = peerAccessPointImpl.getName();
                    peerAccessPoint = (PeerAccessPoint)this.cgbridgeConfig.getPeerAccessPoints().get(string);
                    if (null == peerAccessPoint) {
                        throw new ConfigurationWarning("loadPeerAccessPoints, No peerAccessPoint with key=[" + string + "] found");
                    }
                    peerAccessPoint.setAccessPointGroup(this);
                    this.coreGroups.add(CGBridgeUtils.generateCGKey(this.cgbridgeConfig.getCellName(), peerAccessPoint.getCoreGroupName()));
                    if (!this.htPeerAccessPoints.containsKey(string)) {
                        peerAccessPoint.pushDownProperties(this.properties);
                        this.htPeerAccessPoints.put(string, peerAccessPoint);
                        continue;
                    }
                    throw new ConfigurationWarning("Multiple peerAccessPoints with name [" + string + "] defined.");
                }
                throw new ConfigurationWarning("loadPeerAccessPoints eIsProxy, PeerAccessPointImpl.name=[" + peerAccessPointImpl.getName() + "]");
            }
        } else {
            throw new ConfigurationWarning("loadPeerAccessPoints, getPeerAccessPointRefs returned null.");
        }
    }

    private void loadCoreGroupAccessPoints(AccessPointGroupImpl accessPointGroupImpl) throws ConfigurationWarning, CGBInternalErrorException {
        this.htCoreGroupAccessPoints = new Hashtable();
        EObjectResolvingEList eObjectResolvingEList = (EObjectResolvingEList)accessPointGroupImpl.getCoreGroupAccessPointRefs();
        if (null != eObjectResolvingEList) {
            Iterator iterator = eObjectResolvingEList.iterator();
            while (iterator.hasNext()) {
                CoreGroupAccessPointImpl coreGroupAccessPointImpl = (CoreGroupAccessPointImpl)iterator.next();
                if (!coreGroupAccessPointImpl.eIsProxy()) {
                    String string = coreGroupAccessPointImpl.getCoreGroup();
                    String string2 = coreGroupAccessPointImpl.getName();
                    String string3 = CoreGroupAccessPoint.makeKey(string, string2);
                    CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)this.cgbridgeConfig.getCoreGroupAccessPoints().get(string3);
                    if (null == coreGroupAccessPoint) {
                        throw new ConfigurationWarning("loadCoreGroupAccessPoints, No coreGroupAccessPoint with key=[" + string3 + "] found");
                    }
                    this.coreGroups.add(CGBridgeUtils.generateCGKey(this.cgbridgeConfig.getCellName(), string));
                    if (!this.htCoreGroupAccessPoints.containsKey(string3)) {
                        coreGroupAccessPoint.pushDownProperties(this.properties);
                        this.htCoreGroupAccessPoints.put(string3, coreGroupAccessPoint);
                        continue;
                    }
                    throw new ConfigurationWarning("Multiple coreGroupAccessPoints with key [" + string3 + "] defined.");
                }
                throw new ConfigurationWarning(" loadCoreGroupAccessPoints eIsProxy, CoreGroupAccessPointImpl.name=[" + coreGroupAccessPointImpl.getName() + "]");
            }
        } else {
            throw new ConfigurationWarning("loadCoreGroupAccessPoints, getCoreGroupAccessPointRefs returned null.");
        }
    }

    private void checkEndPointName() throws ConfigurationWarning, CGBInternalErrorException {
        if (0 < this.htCoreGroupAccessPoints.size()) {
            CoreGroupAccessPoint coreGroupAccessPoint;
            this.debug("checkEndPointName start");
            String string = null;
            boolean bl = false;
            Enumeration enumeration = this.htCoreGroupAccessPoints.elements();
            while (enumeration.hasMoreElements()) {
                coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
                if (null == coreGroupAccessPoint.getEndPointName()) {
                    bl = true;
                    this.debug("   checkEndPointName cgap=[" + coreGroupAccessPoint.getKey() + "] endPointNameNeedsSetting");
                    continue;
                }
                string = coreGroupAccessPoint.getEndPointName();
                this.debug("   checkEndPointName endPointName=[" + string + "]");
            }
            if (bl && null != string) {
                enumeration = this.htCoreGroupAccessPoints.elements();
                while (enumeration.hasMoreElements()) {
                    coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
                    if (null != coreGroupAccessPoint.getEndPointName()) continue;
                    coreGroupAccessPoint.setEndPointName(string);
                    coreGroupAccessPoint.setBridgeInterfaceBridgeEndPoints();
                    coreGroupAccessPoint.pushDownProperties(this.properties);
                }
            }
        }
        this.debug("checkEndPointName end");
    }

    void validateUniqueCells() throws ConfigurationWarning {
        this.debug("validateUniqueCells");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.cgbridgeConfig.getCellName());
        Enumeration enumeration = this.htPeerAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            PeerAccessPoint peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
            String string = peerAccessPoint.getCellname();
            if (hashSet.contains(string)) {
                throw new ConfigurationWarning("Cell names must be unique within access point groups.  The cell name [" + string + "] exists more than once within access point group [" + this.name + "]");
            }
            hashSet.add(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getPeerAcessPoints() {
        return this.htPeerAccessPoints;
    }

    public boolean isInterCell() {
        return !this.htPeerAccessPoints.isEmpty();
    }

    public Hashtable getCoreGroupAccessPoints() {
        return this.htCoreGroupAccessPoints;
    }

    public AccessPointGroupTopology getTopology() {
        return this.topology;
    }

    public boolean isTopologySet() {
        return this.isTopologySet;
    }

    public Vector getAllEndPoints() {
        Vector<CGBridgeEndPoint> vector = new Vector<CGBridgeEndPoint>();
        Enumeration enumeration = this.htPeerAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            PeerAccessPoint peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
            vector.addAll(peerAccessPoint.getEndPoints());
        }
        CGBridgeEndPoint cGBridgeEndPoint = null;
        Enumeration enumeration2 = this.htCoreGroupAccessPoints.elements();
        while (enumeration2.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration2.nextElement();
            Enumeration enumeration3 = coreGroupAccessPoint.getBridgeInterfaces().elements();
            while (enumeration3.hasMoreElements()) {
                BridgeInterface bridgeInterface = (BridgeInterface)enumeration3.nextElement();
                cGBridgeEndPoint = bridgeInterface.getBridgeEndPoint();
                if (null != cGBridgeEndPoint) {
                    vector.addElement(cGBridgeEndPoint);
                }
                cGBridgeEndPoint = null;
            }
        }
        vector.trimToSize();
        return vector;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    private String peerAccessPointsToString() {
        String string = "";
        Enumeration enumeration = this.htPeerAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            PeerAccessPoint peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
            string = string + peerAccessPoint.getKey();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ", ";
        }
        return string;
    }

    private String coreGroupAccessPointsToString() {
        String string = "";
        Enumeration enumeration = this.htCoreGroupAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
            string = string + coreGroupAccessPoint.getKey();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ", ";
        }
        return string;
    }

    private String allEndPointsToString() {
        StringBuffer stringBuffer = new StringBuffer("\n        ");
        Vector vector = this.getAllEndPoints();
        for (int i = 0; i < vector.size(); ++i) {
            if (null != vector.elementAt(i)) {
                stringBuffer.append(vector.elementAt(i).toString() + "\n        ");
                continue;
            }
            stringBuffer.append("null\n        ");
        }
        return new String(stringBuffer);
    }

    public String toString() {
        return "    AccessPointGroup:\n      name..................[" + this.name + "]\n" + "      topology..............[" + this.topology.getName() + "]\n" + "      peerAccessPoints......[" + this.peerAccessPointsToString() + "]\n" + "      coreGroupAccessPoints.[" + this.coreGroupAccessPointsToString() + "]\n" + "      properties............[" + CGBridgeConfig.propertiesToString(this.properties) + "]\n" + "      endPoints............." + this.allEndPointsToString();
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### AccessPointGroup." + string));
        }
    }

    public Set getCoreGroups() {
        return this.coreGroups;
    }
}

