/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.impl.TCPInboundChannelImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.BridgeInterfaceImpl;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.cgbridge.config.CGBridgeConfig;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.CoreGroupAccessPoint;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.runtime.service.EndPointMgr;
import java.util.HashMap;
import java.util.Iterator;

public class BridgeInterface {
    private static final TraceComponent tc = Tr.register((Class)BridgeInterface.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    private String nodeName;
    private String serverName;
    private String key;
    private String chainName;
    private HashMap properties;
    private CoreGroupAccessPoint coreGroupAccessPoint;
    private CGBridgeConfig cgbridgeConfig;
    private CGBridgeEndPoint bridgeEndPt;
    private String hostName;
    private static final String XD_CUSTOM_ENDPOINT = "XD_EndPointName";

    public BridgeInterface(CGBridgeConfig cGBridgeConfig, CoreGroupAccessPoint coreGroupAccessPoint, BridgeInterfaceImpl bridgeInterfaceImpl) throws ConfigurationWarning {
        if (tc.isDebugEnabled()) {
            this.debug("constructor");
        }
        this.cgbridgeConfig = cGBridgeConfig;
        this.coreGroupAccessPoint = coreGroupAccessPoint;
        this.nodeName = bridgeInterfaceImpl.getNode();
        this.serverName = bridgeInterfaceImpl.getServer();
        this.key = this.nodeName + ":" + this.serverName;
        this.chainName = bridgeInterfaceImpl.getChain();
        this.properties = CGBridgeConfig.loadProperties(bridgeInterfaceImpl.getProperties());
        if (this.nodeName.equals(this.cgbridgeConfig.getNodeName()) && this.serverName.equals(this.cgbridgeConfig.getServerName())) {
            this.coreGroupAccessPoint.setEndPointName(this.getEndPointNameFromChain());
            this.cgbridgeConfig.setEnableInterCoreGroupCommunication(true);
        }
        if (tc.isDebugEnabled()) {
            this.debug("nodeName[" + this.nodeName + "] serverName[" + this.serverName + "]");
        }
    }

    private String getEndPointNameFromChain() {
        String string = null;
        Chain chain = null;
        boolean bl = false;
        TransportChannelService transportChannelService = this.cgbridgeConfig.getTransportChannelService();
        if (transportChannelService != null) {
            Iterator iterator = transportChannelService.getChains().iterator();
            while (iterator.hasNext()) {
                chain = (Chain)iterator.next();
                if (!this.chainName.equals(chain.getName())) continue;
                bl = true;
                break;
            }
            if (bl) {
                TCPInboundChannelImpl tCPInboundChannelImpl = (TCPInboundChannelImpl)chain.getTransportChannels().get(0);
                if (tc.isDebugEnabled()) {
                    this.debug("connnectorChannelImpl [" + tCPInboundChannelImpl + "]");
                }
                string = tCPInboundChannelImpl.getEndPointName();
            }
            if (tc.isDebugEnabled()) {
                this.debug("getEndPointNameFromChain endPointName=[" + string + "]");
            }
        } else {
            Property property = (Property)this.properties.get(XD_CUSTOM_ENDPOINT);
            string = property.getValue();
        }
        return string;
    }

    void setBridgeEndPoint(String string) throws ConfigurationWarning {
        EndPointMgr.NodeEndPoints nodeEndPoints = null;
        EndPointMgr.ServerEndPoints serverEndPoints = null;
        EndPoint endPoint = null;
        EndPointMgr endPointMgr = this.cgbridgeConfig.getEndPointMgr();
        try {
            nodeEndPoints = endPointMgr.getNodeEndPoints(this.nodeName);
            this.hostName = endPointMgr.getNodeHostName(this.nodeName);
            if (null != nodeEndPoints) {
                if (tc.isDebugEnabled()) {
                    this.debug("nep=" + nodeEndPoints);
                }
                if (null != (serverEndPoints = nodeEndPoints.getServerEndPoints(this.serverName))) {
                    if (tc.isDebugEnabled()) {
                        this.debug("sep=" + serverEndPoints);
                    }
                    if (null != (endPoint = serverEndPoints.getEndPoint(string)) && tc.isDebugEnabled()) {
                        this.debug("endPoint=" + endPoint);
                    }
                }
            }
        }
        catch (Exception exception) {
            nodeEndPoints = null;
        }
        if (null == nodeEndPoints || null == serverEndPoints || null == endPoint) {
            throw new ConfigurationWarning(" No endPoint found with nodeName[" + this.nodeName + "] serverName[" + this.serverName + "] endPointName[" + string + "] for BridgeInterface in CoreGroupAccessPoint [" + this.coreGroupAccessPoint.getKey() + "]");
        }
        this.bridgeEndPt = new CGBridgeEndPoint(endPoint, this.cgbridgeConfig, this.cgbridgeConfig.getCellName(), this.coreGroupAccessPoint.getCoreGroupName(), this.coreGroupAccessPoint.getName(), this.hostName);
        if (this.nodeName.equals(this.cgbridgeConfig.getNodeName()) && this.serverName.equals(this.cgbridgeConfig.getServerName())) {
            this.bridgeEndPt.setOnLocalServer(true, this.chainName);
            this.cgbridgeConfig.setLocalCGBEndpoint(this.bridgeEndPt);
        }
        if (tc.isDebugEnabled()) {
            this.debug("setBridgeEndPoint.bridgeEndPoint=[" + this.bridgeEndPt + "]");
        }
    }

    public BridgeInterface(CGBridgeConfig cGBridgeConfig, CoreGroupAccessPoint coreGroupAccessPoint, MemberData memberData) throws CGBInternalErrorException {
        this.cgbridgeConfig = cGBridgeConfig;
        this.coreGroupAccessPoint = coreGroupAccessPoint;
        this.bridgeEndPt = new CGBridgeEndPoint(memberData);
        this.nodeName = "UndefMem";
        this.serverName = this.bridgeEndPt.getMemberName();
        this.key = this.nodeName + ":" + this.serverName;
        this.chainName = "UNDEFINED_MEMBER";
        this.debug("new BridgeInterface via undefinedMember key [" + this.key + "]");
    }

    void pushDownProperties(HashMap hashMap) throws CGBInternalErrorException {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.properties.containsKey(string)) continue;
            this.properties.put(string, hashMap.get(string));
        }
        if (null != this.bridgeEndPt) {
            this.bridgeEndPt.setProperties(this.properties);
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getChainName() {
        return this.chainName;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public CGBridgeEndPoint getBridgeEndPoint() {
        return this.bridgeEndPt;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String toString() {
        return "\n      bridgeInterface:\n        node............" + this.nodeName + "\n" + "        server.........." + this.serverName + "\n" + "        chain..........." + this.chainName + "\n" + "        bridgeEndPoint.." + this.bridgeEndPt;
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### BridgeInterface." + string));
        }
    }
}

