/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cgbridge.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeService;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeSettings;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.AccessPointGroupImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.CoreGroupAccessPointImpl;
import com.ibm.websphere.models.config.coregroupbridgeservice.impl.PeerAccessPointImpl;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.websphere.models.config.process.impl.ServerImpl;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.cgbridge.config.AccessPointGroup;
import com.ibm.ws.cgbridge.config.BridgeInterface;
import com.ibm.ws.cgbridge.config.CGBVersion;
import com.ibm.ws.cgbridge.config.CGBridgeEndPoint;
import com.ibm.ws.cgbridge.config.CoreGroupAccessPoint;
import com.ibm.ws.cgbridge.config.MemberData;
import com.ibm.ws.cgbridge.config.PeerAccessPoint;
import com.ibm.ws.cgbridge.core.CGBRemoteScopeNames;
import com.ibm.ws.cgbridge.exception.CGBInternalErrorException;
import com.ibm.ws.cgbridge.util.CGBridgeUtils;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.wsspi.hamanager.HAParameterRejectedException;
import com.ibm.wsspi.hamanager.bboard.BulletinBoard;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardFactory;
import com.ibm.wsspi.hamanager.bboard.BulletinBoardScope;
import com.ibm.wsspi.hamanager.bboard.DuplicatePostException;
import com.ibm.wsspi.hamanager.bboard.SubjectInfo;
import com.ibm.wsspi.hamanager.bboard.SubjectPost;
import com.ibm.wsspi.hamanager.bboard.SubjectPostClosedException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class CGBridgeConfig {
    private static final TraceComponent tc = Tr.register((Class)CGBridgeConfig.class, (String)"Core_Group_Bridge", (String)"com.ibm.ws.cgbridge.resources.cgbridge");
    public static final String CORE_GROUP_BRIDGE_XML = "coregroupbridge.xml";
    public static final String SERVER_XML = "server.xml";
    public static final String HAMANAGER_SERVICE_XML = "hamanagerservice.xml";
    public static final String NODES_PREFIX = "nodes";
    public static final String SERVERS_PREFIX = "servers";
    public boolean xdStyleEndpoints;
    private static final int INITIAL_HASHTABLE_SIZE = 5;
    private String cellName;
    private String serverName;
    private String nodeName;
    private String coreGroupName;
    String fullCoreGroupName;
    String fullServerName;
    private ConfigRoot configRoot;
    private HashMap properties;
    private TransportChannelService transportChannelService;
    String debugSubject;
    String debugBB;
    private boolean enableInterCoreGroupCommunication = false;
    private Hashtable htCoreGroupAccessPoints;
    private Hashtable htAccessPointGroups;
    private Hashtable htPeerAccessPoints;
    private CGBridgeEndPoint localCGBEndpoint;
    private Map cgNameToCGAPGMap;
    private EndPointMgr endPointMgr;
    private BulletinBoardFactory bbf;
    CGBVersion cgbVersion;
    boolean isFilterSubscriptions;
    Set allowedBBNames;
    private SubjectInfo subInfo4PAP = null;
    private SubjectPost subjectPost4PAP = null;
    private SubjectInfo subInfoNumBridges = null;
    private SubjectPost subjectPostNumBridges = null;
    BulletinBoard remoteScopeBB = null;

    public String getCellName() {
        return this.cellName;
    }

    void setLocalCGBEndpoint(CGBridgeEndPoint cGBridgeEndPoint) {
        this.localCGBEndpoint = cGBridgeEndPoint;
    }

    public CGBridgeEndPoint getLocalCGBEndpoint() {
        return this.localCGBEndpoint;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getCoreGroupName() {
        return this.coreGroupName;
    }

    public boolean getEnableInterCoreGroupCommunication() {
        return this.enableInterCoreGroupCommunication;
    }

    void setEnableInterCoreGroupCommunication(boolean bl) {
        this.enableInterCoreGroupCommunication = bl;
    }

    public Hashtable getCoreGroupAccessPoints() {
        return this.htCoreGroupAccessPoints;
    }

    public Map getCGNameToCGAPGsMap() {
        return this.cgNameToCGAPGMap;
    }

    Hashtable getPeerAccessPoints() {
        return this.htPeerAccessPoints;
    }

    public Enumeration getAccessPointGroupsEnum() {
        return this.htAccessPointGroups.elements();
    }

    EndPointMgr getEndPointMgr() {
        return this.endPointMgr;
    }

    ConfigRoot getConfigRoot() {
        return this.configRoot;
    }

    TransportChannelService getTransportChannelService() {
        return this.transportChannelService;
    }

    public CGBridgeConfig(String string, String string2) {
        this.serverName = string;
        this.nodeName = string2;
        this.htCoreGroupAccessPoints = new Hashtable(5);
        this.htAccessPointGroups = new Hashtable(5);
        this.htPeerAccessPoints = new Hashtable(5);
        this.cgNameToCGAPGMap = new HashMap();
        this.allowedBBNames = new HashSet();
        this.debug("constructor");
    }

    public void loadBridgeServiceConfig(Object object, Repository repository, EndPointMgr endPointMgr) throws ConfigurationWarning, CGBInternalErrorException {
        String[] stringArray;
        Resource resource;
        CoreGroupBridgeService coreGroupBridgeService = (CoreGroupBridgeService)object;
        this.properties = CGBridgeConfig.loadProperties(coreGroupBridgeService.getProperties());
        this.endPointMgr = endPointMgr;
        this.cellName = repository.getCellName();
        this.configRoot = repository.getConfigRoot();
        this.fullServerName = CGBridgeUtils.getFullServerName(this.cellName, this.nodeName, this.serverName);
        try {
            this.transportChannelService = this.getTransportChannelService(coreGroupBridgeService);
            this.xdStyleEndpoints = false;
        }
        catch (Exception exception) {
            this.debug("Reverting to XD style configuration");
            this.xdStyleEndpoints = true;
        }
        this.coreGroupName = this.getMyCoreGroupName(this.configRoot);
        this.fullCoreGroupName = CGBridgeUtils.generateCGKey(this.cellName, this.coreGroupName);
        try {
            resource = this.configRoot.getResource(0, CORE_GROUP_BRIDGE_XML);
        }
        catch (Exception exception) {
            throw new ConfigurationWarning("Unable to getResource [coregroupbridge.xml] e=" + exception);
        }
        CoreGroupBridgeSettings coreGroupBridgeSettings = (CoreGroupBridgeSettings)resource.getContents().get(0);
        this.properties.putAll(CGBridgeConfig.loadProperties(coreGroupBridgeSettings.getProperties()));
        this.loadCoreGroupAccessPoints(coreGroupBridgeSettings);
        this.loadPeerAccessPoints(coreGroupBridgeSettings);
        this.loadAccessPointGroups(coreGroupBridgeSettings);
        this.createCGNameToAPGMappings();
        String string = CGBridgeUtils.getCaseInsensitiveCustomProperty(this.properties, "cgb.allowedBBNames");
        if (string != null && (stringArray = string.split(",")) != null) {
            this.isFilterSubscriptions = true;
            for (int i = 0; i < stringArray.length; ++i) {
                this.allowedBBNames.add(stringArray[i]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("allowed bb name: " + stringArray[i]));
            }
        }
        if (tc.isDebugEnabled()) {
            this.debug(this.toString());
        }
        this.validateConfig();
        this.setDebugData();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("local cgb endpoint=" + this.getLocalCGBEndpoint()));
        }
        this.cgbVersion = CGBVersion.DEFAULT;
    }

    private void setDebugData() {
        this.debugBB = this.getProperties().containsKey("cgb.debug.bb") ? (String)this.getProperties().get("cgb.debug.bb") : "CGB";
        this.debugSubject = this.getProperties().containsKey("cgb.debug.subject") ? (String)this.getProperties().get("cgb.debug.subject") : "DEBUGSUBJECT";
    }

    public String getDebugSubject() {
        return this.debugSubject;
    }

    public String getDebugBB() {
        return this.debugBB;
    }

    private void createCGNameToAPGMappings() {
        Enumeration enumeration = this.htAccessPointGroups.elements();
        while (enumeration.hasMoreElements()) {
            AccessPointGroup accessPointGroup = (AccessPointGroup)enumeration.nextElement();
            Enumeration enumeration2 = accessPointGroup.getCoreGroupAccessPoints().elements();
            while (enumeration2.hasMoreElements()) {
                LinkedList linkedList;
                CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration2.nextElement();
                if (this.cgNameToCGAPGMap.containsKey(coreGroupAccessPoint.getCoreGroupName())) {
                    linkedList = (LinkedList)this.cgNameToCGAPGMap.get(coreGroupAccessPoint.getCoreGroupName());
                    linkedList.add(accessPointGroup);
                    continue;
                }
                linkedList = new LinkedList();
                linkedList.add(accessPointGroup);
                this.cgNameToCGAPGMap.put(coreGroupAccessPoint.getCoreGroupName(), linkedList);
            }
        }
    }

    public boolean isBridgeInConfiguredCoregroup() {
        return this.getLocalCGBEndpoint().getCoreGroupName().equals(this.coreGroupName);
    }

    void validateConfig() throws ConfigurationWarning {
        Enumeration enumeration = this.htAccessPointGroups.elements();
        while (enumeration.hasMoreElements()) {
            ((AccessPointGroup)enumeration.nextElement()).validateUniqueCells();
        }
        Enumeration enumeration2 = this.htCoreGroupAccessPoints.elements();
        while (enumeration2.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration2.nextElement();
            this.compareCGAPs(coreGroupAccessPoint);
        }
    }

    private void compareCGAPs(CoreGroupAccessPoint coreGroupAccessPoint) throws ConfigurationWarning {
        Hashtable hashtable = coreGroupAccessPoint.getBridgeInterfaces();
        int n = hashtable.size();
        String string = coreGroupAccessPoint.getCoreGroupName();
        Enumeration enumeration = this.htCoreGroupAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint2 = (CoreGroupAccessPoint)enumeration.nextElement();
            if (coreGroupAccessPoint == coreGroupAccessPoint2 || !string.equals(coreGroupAccessPoint2.getCoreGroupName())) continue;
            this.debug("compareCGAPs, argCGAP [" + coreGroupAccessPoint.getKey() + "] with cgap [" + coreGroupAccessPoint2.getKey() + "]");
            if (coreGroupAccessPoint2.getBridgeInterfaces().size() != n) {
                throw new ConfigurationWarning("Core group access points [" + coreGroupAccessPoint2.getKey() + "] and [" + coreGroupAccessPoint.getKey() + "] must have bridge interfaces on the same set of node/server combinations.");
            }
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                BridgeInterface bridgeInterface = (BridgeInterface)enumeration2.nextElement();
                if (coreGroupAccessPoint2.getBridgeInterfaces().containsKey(bridgeInterface.getKey())) continue;
                throw new ConfigurationWarning("Core group access points [" + coreGroupAccessPoint2.getKey() + "] and [" + coreGroupAccessPoint.getKey() + "] must have bridge interfaces on the same set of node/server combinations.");
            }
        }
    }

    TransportChannelService getTransportChannelService(CoreGroupBridgeService coreGroupBridgeService) throws ConfigurationWarning {
        TransportChannelService transportChannelService = null;
        if (!this.xdStyleEndpoints) {
            ServerImpl serverImpl = (ServerImpl)coreGroupBridgeService.eContainer();
            this.debug("serverImpl econtainer " + serverImpl);
            Iterator iterator = serverImpl.eContents().iterator();
            Object object = null;
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof TransportChannelService)) continue;
                this.debug("found TransportChannelService=" + object.getClass());
                break;
            }
            if (null != object) {
                transportChannelService = (TransportChannelService)object;
                this.debug("transportChannelService=" + transportChannelService);
            }
            if (null == transportChannelService) {
                throw new ConfigurationWarning("Unable to read TransportChannelService");
            }
        }
        return transportChannelService;
    }

    String getMyCoreGroupName(ConfigRoot configRoot) throws ConfigurationWarning {
        Resource resource;
        String string = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer(NODES_PREFIX + string + this.nodeName + string + SERVERS_PREFIX + string + this.serverName + string + HAMANAGER_SERVICE_XML);
        try {
            resource = configRoot.getResource(0, stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new ConfigurationWarning("Unable to getResource at [" + stringBuffer.toString() + "] exception=" + exception);
        }
        HAManagerService hAManagerService = (HAManagerService)resource.getContents().get(0);
        return hAManagerService.getCoreGroupName();
    }

    private void loadPeerAccessPoints(CoreGroupBridgeSettings coreGroupBridgeSettings) throws ConfigurationWarning {
        EList eList = coreGroupBridgeSettings.getPeerAccessPoints();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            PeerAccessPointImpl peerAccessPointImpl = (PeerAccessPointImpl)iterator.next();
            PeerAccessPoint peerAccessPoint = new PeerAccessPoint(peerAccessPointImpl, this);
            if (!this.htPeerAccessPoints.containsKey(peerAccessPoint.getKey())) {
                this.htPeerAccessPoints.put(peerAccessPoint.getKey(), peerAccessPoint);
                continue;
            }
            throw new ConfigurationWarning("Multiple peerAccessPoints with name [" + peerAccessPoint.getKey() + "] defined.");
        }
    }

    private void loadCoreGroupAccessPoints(CoreGroupBridgeSettings coreGroupBridgeSettings) throws ConfigurationWarning {
        EList eList = coreGroupBridgeSettings.getCoreGroupAccessPoints();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CoreGroupAccessPointImpl coreGroupAccessPointImpl = (CoreGroupAccessPointImpl)iterator.next();
            CoreGroupAccessPoint coreGroupAccessPoint = new CoreGroupAccessPoint(this, coreGroupAccessPointImpl, this.endPointMgr);
            if (!this.htCoreGroupAccessPoints.containsKey(coreGroupAccessPoint.getKey())) {
                this.htCoreGroupAccessPoints.put(coreGroupAccessPoint.getKey(), coreGroupAccessPoint);
                continue;
            }
            throw new ConfigurationWarning("Multiple coreGroupAccessPoints with key [" + coreGroupAccessPoint.getKey() + "] defined.");
        }
    }

    private void loadAccessPointGroups(CoreGroupBridgeSettings coreGroupBridgeSettings) throws ConfigurationWarning, CGBInternalErrorException {
        EList eList = coreGroupBridgeSettings.getAccessPointGroups();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            AccessPointGroupImpl accessPointGroupImpl = (AccessPointGroupImpl)iterator.next();
            AccessPointGroup accessPointGroup = new AccessPointGroup(this, accessPointGroupImpl);
            if (!this.htAccessPointGroups.containsKey(accessPointGroup.getName())) {
                this.htAccessPointGroups.put(accessPointGroup.getName(), accessPointGroup);
                continue;
            }
            throw new ConfigurationWarning("Multiple accessPointGroups with name [" + accessPointGroup.getName() + "] defined");
        }
    }

    public synchronized boolean handleNewMember(MemberData memberData, AccessPointGroup accessPointGroup) throws CGBInternalErrorException, ConfigurationWarning {
        boolean bl = false;
        this.debug("handleNewMember, newMemberData=[" + memberData + "],  accessPointGroup=[" + accessPointGroup.getName() + "]");
        if (memberData.cellName.equals(this.cellName)) {
            if (tc.isDebugEnabled()) {
                this.debug("handleNewMember, attempt add new bridgeInterface to cell=[" + this.cellName + "] coreGroup=[" + memberData.coreGroupName + "]");
            }
            CoreGroupAccessPoint coreGroupAccessPoint = null;
            boolean bl2 = false;
            Enumeration enumeration = accessPointGroup.getCoreGroupAccessPoints().elements();
            while (enumeration.hasMoreElements() && !bl2) {
                coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
                this.debug("handleNewMember, found cgap.getName=[" + coreGroupAccessPoint.getName() + "] cgap.getCoreGroupName()=[" + coreGroupAccessPoint.getCoreGroupName() + "]");
                if (!coreGroupAccessPoint.getName().equals(memberData.coreGroupAccessPointName) || !coreGroupAccessPoint.getCoreGroupName().equals(memberData.coreGroupName)) continue;
                bl2 = true;
            }
            if (bl2) {
                if (!coreGroupAccessPoint.containsMember(memberData)) {
                    this.debug("handleNewMember, adding new member to CGAP [" + coreGroupAccessPoint.getKey() + "]");
                    coreGroupAccessPoint.handleNewMember(memberData);
                    bl = true;
                } else {
                    this.debug("handleNewMember, member already exists, not adding");
                }
            } else {
                this.debug("handleNewMember, NOT adding new member. no CGAP found.");
            }
        } else {
            this.debug("addinng new peerAccessPoint and/or peerAccessPoint.endPoint");
            PeerAccessPoint peerAccessPoint = null;
            boolean bl3 = false;
            Enumeration enumeration = accessPointGroup.getPeerAcessPoints().elements();
            while (enumeration.hasMoreElements() && !bl3) {
                peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
                if (!peerAccessPoint.getCellname().equals(memberData.cellName) || !peerAccessPoint.getCoreGroupName().equals(memberData.coreGroupName)) continue;
                bl3 = true;
            }
            if (!bl3) {
                this.debug("HandleNewMember, no PeerAccessPoint found for cell [" + memberData.cellName + "] and core group [" + memberData.coreGroupName + "] constructing a new one");
                peerAccessPoint = new PeerAccessPoint(memberData, this, accessPointGroup);
                if (this.htPeerAccessPoints.containsKey(peerAccessPoint.getKey())) {
                    throw new CGBInternalErrorException("handleNewMember, config already contains peer access point [" + peerAccessPoint.getKey() + "]");
                }
                if (!peerAccessPoint.containsMember(memberData)) {
                    peerAccessPoint.handleNewMember(memberData);
                    peerAccessPoint.setAccessPointGroup(accessPointGroup);
                    accessPointGroup.getPeerAcessPoints().put(peerAccessPoint.getKey(), peerAccessPoint);
                    this.htPeerAccessPoints.put(peerAccessPoint.getKey(), peerAccessPoint);
                    bl = true;
                } else {
                    this.debug("handleNewMember, member already exists, not adding");
                }
            } else if (!peerAccessPoint.containsMember(memberData)) {
                peerAccessPoint.handleNewMember(memberData);
                bl = true;
            } else {
                this.debug("handleNewMember, member already exists, not adding");
            }
            this.debug("handleNewMember found or constructed PAP [" + peerAccessPoint.getName() + "]");
        }
        return bl;
    }

    public Iterator getAccessPointGroupIterator4Me() {
        LinkedList<AccessPointGroup> linkedList = new LinkedList<AccessPointGroup>();
        Enumeration enumeration = this.htAccessPointGroups.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            AccessPointGroup accessPointGroup = (AccessPointGroup)enumeration.nextElement();
            Enumeration enumeration2 = accessPointGroup.getCoreGroupAccessPoints().elements();
            while (enumeration2.hasMoreElements() && !bl) {
                CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration2.nextElement();
                Enumeration enumeration3 = coreGroupAccessPoint.getBridgeInterfaces().elements();
                while (enumeration3.hasMoreElements() && !bl) {
                    BridgeInterface bridgeInterface = (BridgeInterface)enumeration3.nextElement();
                    if (!bridgeInterface.getNodeName().equals(this.nodeName) || !bridgeInterface.getServerName().equals(this.serverName)) continue;
                    linkedList.add(accessPointGroup);
                    bl = true;
                    this.debug("getAccessPointGroupIterator4Me added APG [" + accessPointGroup.getName() + "]");
                }
            }
        }
        return linkedList.iterator();
    }

    Vector getMyCoreGroupAccessPoints() {
        Vector<CoreGroupAccessPoint> vector = new Vector<CoreGroupAccessPoint>();
        Enumeration enumeration = this.htCoreGroupAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
            if (null == coreGroupAccessPoint) continue;
            vector.addElement(coreGroupAccessPoint);
        }
        vector.trimToSize();
        return vector;
    }

    public PeerAccessPoint getPeerAccessPoint4Peer(String string) {
        this.debug("getPeerAccessPoint4Peer peerName=[" + string + "]");
        PeerAccessPoint peerAccessPoint = (PeerAccessPoint)this.htPeerAccessPoints.get(string);
        PeerAccessPoint peerAccessPoint2 = null;
        if (null != peerAccessPoint) {
            this.debug("getPeerAccessPoint4Peer found pap=[" + peerAccessPoint + "]");
            peerAccessPoint2 = peerAccessPoint.getProxyPeer();
            if (null != peerAccessPoint2) {
                peerAccessPoint = peerAccessPoint2;
                this.debug("getPeerAccessPoint4Peer found pap.proxyPeer=[" + peerAccessPoint + "]");
            }
            if (null == peerAccessPoint.getAccessPointGroup()) {
                this.debug("getPeerAccessPoint4Peer pap [" + peerAccessPoint.getName() + "] not in an accessPointGroup");
                peerAccessPoint = null;
            }
        }
        return peerAccessPoint;
    }

    public PeerAccessPoint getPeerAccessPoint4Cell(String string) {
        boolean bl = false;
        PeerAccessPoint peerAccessPoint = null;
        PeerAccessPoint peerAccessPoint2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPeerAccessPoint4Cell", (Object)string);
        }
        Enumeration enumeration = this.htPeerAccessPoints.elements();
        while (enumeration.hasMoreElements() && !bl) {
            peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
            if (peerAccessPoint.getAccessPointGroup() != null) {
                if (tc.isDebugEnabled()) {
                    this.debug("getPeerAccessPoint4Cell examining pap with peername=[" + peerAccessPoint.getName() + "] cellname=[" + peerAccessPoint.getCellname() + "]");
                }
                if (!peerAccessPoint.getCellname().equals(string)) continue;
                bl = true;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("no APG set for PAP: " + peerAccessPoint.getName()));
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                this.debug("getPeerAccessPoint4Cell found pap with getKey=[" + peerAccessPoint.getKey() + "]");
            }
            if (null != (peerAccessPoint2 = peerAccessPoint.getProxyPeer())) {
                peerAccessPoint = peerAccessPoint2;
                if (tc.isDebugEnabled()) {
                    this.debug("getPeerAccessPoint4Cell found pap.proxyPeer=[" + peerAccessPoint + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPeerAccessPoint4Cell");
        }
        return peerAccessPoint;
    }

    public void setBulletinBoardFactory(BulletinBoardFactory bulletinBoardFactory) {
        this.bbf = bulletinBoardFactory;
    }

    public void postBridgeInfo() {
        this.debug("postBridgeInfo");
        try {
            if (null != this.bbf && this.remoteScopeBB == null) {
                this.remoteScopeBB = this.bbf.findBulletinBoard("com.ibm.ws.cgbridge.bridgeInfoBB");
                this.subInfo4PAP = this.remoteScopeBB.createSubject(BulletinBoardScope.getDefault(), "PeerAccessPoints");
                this.subjectPost4PAP = this.remoteScopeBB.createPost(this.subInfo4PAP);
                this.debug("postBridgeInfo created subjectPost4PAP [" + this.subjectPost4PAP + "]");
                this.subInfoNumBridges = this.remoteScopeBB.createSubject(BulletinBoardScope.getDefault(), "NumBridges");
                this.subjectPostNumBridges = this.remoteScopeBB.createPost(this.subInfoNumBridges);
                this.debug("postBridgeInfo created subjectPostNumBrdgs [" + this.subjectPostNumBridges + "]");
            }
            String string = "" + this.getNumBridges();
            this.debug("postBridgeInfo posting sNumBridges=[" + string + "]");
            this.subjectPostNumBridges.updatePost(string.getBytes());
            PeerAccessPoint peerAccessPoint = null;
            if (!this.htPeerAccessPoints.isEmpty()) {
                CGBRemoteScopeNames cGBRemoteScopeNames = new CGBRemoteScopeNames();
                Enumeration enumeration = this.htPeerAccessPoints.elements();
                while (enumeration.hasMoreElements()) {
                    peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
                    if (null == peerAccessPoint.getAccessPointGroup()) continue;
                    cGBRemoteScopeNames.addName(peerAccessPoint.getName(), peerAccessPoint.getCellname());
                }
                if (cGBRemoteScopeNames.getPeerNames() != null) {
                    this.subjectPost4PAP.updatePost(cGBRemoteScopeNames.getByteArray());
                    this.debug("postBridgeInfo posting to PAP subject [" + cGBRemoteScopeNames + "]");
                }
            }
        }
        catch (HAParameterRejectedException hAParameterRejectedException) {
            this.debug("postBridgeInfo got exception " + (Object)((Object)hAParameterRejectedException));
            FFDCFilter.processException((Throwable)hAParameterRejectedException, (String)"CGBridgeConfig(postBridgeInfo)", (String)"101", (Object)"CGBridgeConfig");
        }
        catch (DuplicatePostException duplicatePostException) {
            this.debug("postBridgeInfo got exception " + (Object)((Object)duplicatePostException));
            FFDCFilter.processException((Throwable)duplicatePostException, (String)"CGBridgeConfig(postBridgeInfo)", (String)"102", (Object)"CGBridgeConfig");
        }
        catch (SubjectPostClosedException subjectPostClosedException) {
            this.debug("postBridgeInfo got exception " + (Object)((Object)subjectPostClosedException));
            FFDCFilter.processException((Throwable)subjectPostClosedException, (String)"CGBridgeConfig(postBridgeInfo)", (String)"103", (Object)"CGBridgeConfig");
        }
        catch (IOException iOException) {
            this.debug("postBridgeInfo got exception " + iOException);
            FFDCFilter.processException((Throwable)iOException, (String)"CGBridgeConfig(postBridgeInfo)", (String)"104", (Object)"CGBridgeConfig");
        }
    }

    public Map getPeerAccessPointsMap() {
        this.debug("getPeerAccessPointsMap");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PeerAccessPoint peerAccessPoint = null;
        if (!this.htPeerAccessPoints.isEmpty()) {
            Enumeration enumeration = this.htPeerAccessPoints.elements();
            while (enumeration.hasMoreElements()) {
                peerAccessPoint = (PeerAccessPoint)enumeration.nextElement();
                if (null == peerAccessPoint.getAccessPointGroup()) continue;
                hashMap.put(peerAccessPoint.getName(), peerAccessPoint.getCellname());
            }
        }
        return hashMap;
    }

    public int getNumBridges() {
        int n = 0;
        Enumeration enumeration = this.htCoreGroupAccessPoints.elements();
        while (enumeration.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration.nextElement();
            this.debug("getNumBridges observing cgap [" + coreGroupAccessPoint.getKey() + "]");
            if (!coreGroupAccessPoint.getCoreGroupName().equals(this.coreGroupName)) continue;
            n += coreGroupAccessPoint.getBridgeInterfaces().size();
        }
        this.debug("getNumBridges returned " + n);
        return n;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public String coreGroupAccessPointsToString() {
        String string = "    keys:";
        Enumeration enumeration = this.htCoreGroupAccessPoints.keys();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + "  ";
        }
        string = string + "\n";
        Enumeration enumeration2 = this.htCoreGroupAccessPoints.elements();
        while (enumeration2.hasMoreElements()) {
            CoreGroupAccessPoint coreGroupAccessPoint = (CoreGroupAccessPoint)enumeration2.nextElement();
            string = string + coreGroupAccessPoint.toString();
        }
        return string;
    }

    public String accessPointGroupsToString() {
        String string = "    keys:";
        Enumeration enumeration = this.htAccessPointGroups.keys();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + "  ";
        }
        string = string + "\n";
        Enumeration enumeration2 = this.htAccessPointGroups.elements();
        while (enumeration2.hasMoreElements()) {
            AccessPointGroup accessPointGroup = (AccessPointGroup)enumeration2.nextElement();
            string = string + accessPointGroup.toString();
        }
        return string;
    }

    public String peerAccessPointsToString() {
        String string = "    keys:";
        Enumeration enumeration = this.htPeerAccessPoints.keys();
        while (enumeration.hasMoreElements()) {
            string = string + enumeration.nextElement() + "  ";
        }
        string = string + "\n";
        Enumeration enumeration2 = this.htPeerAccessPoints.elements();
        while (enumeration2.hasMoreElements()) {
            PeerAccessPoint peerAccessPoint = (PeerAccessPoint)enumeration2.nextElement();
            string = string + peerAccessPoint.toString();
        }
        return string;
    }

    public static String propertiesToString(HashMap hashMap) {
        String string = "";
        if (null != hashMap) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string = string + "<" + string2 + "," + hashMap.get(string2) + ">";
            }
        } else {
            string = "<>";
        }
        return string;
    }

    static HashMap loadProperties(EList eList) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                Property property = (Property)eList.get(i);
                hashMap.put(property.getName(), property.getValue());
            }
        }
        return hashMap;
    }

    public String toString() {
        return "CGBridgeConfig:\n  serverName........................[" + this.serverName + "]\n" + "  nodeName..........................[" + this.nodeName + "]\n" + "  coreGroupName.....................[" + this.coreGroupName + "]\n" + "  properties........................[" + this.properties.toString() + "]\n" + "  enableInterCoreGroupCommunication.[" + this.enableInterCoreGroupCommunication + "]\n" + "  coreGroupAccessPoint..............\n" + this.coreGroupAccessPointsToString() + "\n" + "  peerAccessPoints..................\n" + this.peerAccessPointsToString() + "\n" + "  accessPointGroups.................\n" + this.accessPointGroupsToString() + "\n";
    }

    private void debug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("### CGBridgeConfig." + string));
        }
    }

    public void setLocalBridgeCGBVersion(CGBVersion cGBVersion) {
        this.cgbVersion = cGBVersion;
    }

    public CGBVersion getLocalBridgeCGBVersion() {
        return this.cgbVersion;
    }

    public String getFullCoreGroupName() {
        return this.fullCoreGroupName;
    }

    public Set getAllowedBBNames() {
        return this.allowedBBNames;
    }

    public boolean isFilterSubscriptions() {
        return this.isFilterSubscriptions;
    }

    public String getFullServerName() {
        return this.fullServerName;
    }
}

